/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

int file_copy( FileList *src, gchar *dest )
{

	struct stat stat_s;
	struct stat stat_d;
	struct stat stmp;
	gint count = 0;
	gint fcount = 0;
	gchar *strip;
	gchar *dst;
	gchar *dst_str;
	gchar *src_str;
	GList *tmp;
	GString *destination = g_string_new("");
	
	/* 2. Kolla antalet filer i fokuserade kataloger */
	tmp = get_selection(src,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		stat(tmp->data,&stmp);
		if (S_ISDIR (stmp.st_mode))
			fcount += recursive_fcount(tmp->data);
		else
			fcount++;
	}
	
	/* 3. Skapa progressbar dialog */
	create_fileops_window( "Copy" );
	create_fileops_sum_pbar( fcount );


	/* 4. Kopiera filer */
	tmp = get_selection(src,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		stat(tmp->data,&stat_s);
		if (stat(dest,&stat_d) != -1)
		{
			if (S_ISDIR (stat_d.st_mode))
			{
				strip = strrchr(tmp->data,'/');
				g_string_sprintf(destination,"%s/%s",dest,strip+1);	
			}
			else
				g_string_sprintf(destination,"%s",dest);
		}
		else
			g_string_sprintf(destination,"%s",dest);
		
		if (S_ISDIR (stat_s.st_mode))
		{
			if ((dircopy(tmp->data,destination->str)) == -1 )
			{
				GString *msg = g_string_new("");
				gint *button;
				g_string_sprintf(msg,"Copy for directory %s cancelled. Remove dir?",destination->str);
				create_dialog("Delete","",msg->str,120,&button);
				gtk_main();
				if ((int)button == 1)
					del(destination->str);
			}
		}
		else
		{
			if ((filecopy(tmp->data,destination->str)) == -1 )
			{
				GString *msg = g_string_new("");
				gint *button;
				g_string_sprintf(msg,"Copy for file %s cancelled. Remove file?",destination->str);
				create_dialog("Delete","",msg->str,120,&button);
				gtk_main();
				if ((int)button == 1)
					del(destination->str);
			}
		}
	}
	/* Ta bort fnstret */
	refresh_filelist(notfocused,FALSE);
	refresh_filelist(focused,FALSE);
	destroy_fileops_window();
	win.cancel = 0;

}

int filecopy(const char *fn_src, const char *fn_dst )
{
        int   bytesr,fh_src,fh_dst,a;
        char  *buff   = NULL;
        struct stat stat_s;
        struct stat stat_d;
		gfloat new_val;
	    GtkAdjustment *adj;

        buff = (char *) malloc(BUFFSIZE);
		
		if (win.cancel == 1)
			return -1;

		stat(fn_src,&stat_s);
		stat(fn_dst,&stat_d);
		
		if ((fh_src = open(fn_src, O_RDONLY)) == -1 )
		{
			statusbar_print(" Copy failed: %s",strerror(errno));
			return;
		}
       	if ((fh_dst = open(fn_dst, O_WRONLY | O_TRUNC | O_CREAT,stat_s.st_mode )) == -1 )
		{
       		statusbar_print(" Copy failed: %s",strerror(errno));
			return;
		}
		
		create_fileops_pbar(stat_s.st_size / BUFFSIZE,fn_src);

		while ((bytesr = read(fh_src,buff, BUFFSIZE)) > 0)
		{
			if (win.cancel == 1)
				return -1;
           	if(write(fh_dst,buff, bytesr) != bytesr)
                perror("read");

			new_val = gtk_progress_get_value( GTK_PROGRESS(win.pbar)) + 1;
			adj = GTK_PROGRESS (win.pbar)->adjustment;
			if (new_val > adj->upper)
        		new_val = adj->lower;
			gtk_progress_set_value (GTK_PROGRESS (win.pbar), new_val);
			while(gtk_events_pending())
				gtk_main_iteration();
		}
		close(fh_dst);
	    close(fh_src);
		new_val = gtk_progress_get_value( GTK_PROGRESS(win.sumpbar)) + 1;
		adj = GTK_PROGRESS (win.sumpbar)->adjustment;
		if (new_val > adj->upper)
       		new_val = adj->lower;
		gtk_progress_set_value (GTK_PROGRESS (win.sumpbar), new_val);
	    free(buff);
		gtk_widget_destroy(win.pbar);
        return 0;
}

int dircopy(const char *dn_src, const char *dn_dest )
{
	DIR *dirh;
	struct dirent *dirp;
	struct stat tmp;
	gchar *src_full,*dn_full;
	gint counts = 0;

	stat(dn_src,&tmp);
	mkdir(dn_dest,tmp.st_mode);
	if (!(dirh = opendir(dn_src)))
	{
		return;
	}
	
	while ((dirp = readdir(dirh)) != NULL)
		counts++;
	
	rewinddir(dirh);
	while ((dirp = readdir(dirh)) != NULL)
	{
		if (strcmp(dirp->d_name, ".") != 0 && strcmp(dirp->d_name, "..") != 0)
		{
			src_full = malloc(strlen(dn_src) + strlen(dirp->d_name)+2);
			dn_full = malloc(strlen(dn_dest) + strlen(dirp->d_name)+2);
			if (strcmp(dn_src,"/") == 0)
				sprintf(src_full,"/%s",dirp->d_name);
			else
				sprintf(src_full,"%s/%s",dn_src,dirp->d_name);
			if (strcmp(dn_dest,"/") == 0)
				sprintf(dn_full,"/%s",dirp->d_name);
			else
				sprintf(dn_full,"%s/%s",dn_dest,dirp->d_name);
			stat(src_full,&tmp);
			if (S_ISDIR (tmp.st_mode))
				dircopy(src_full,dn_full );
			else
				filecopy(src_full,dn_full );
			if (win.cancel == 1)
				return -1;
		}
	}
	closedir(dirh);
}

