/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

int del( const gchar *name )
{
	struct stat tmp;
	stat(name,&tmp);
	if (S_ISDIR (tmp.st_mode))
		del_dir( strdup(name) );
	else
		del_file ( strdup(name) );
}

int del_file( const gchar *fn )
{
	if (unlink(fn) == -1)
		statusbar_print(" Error deleting %s - %s",fn,strerror(errno));
}

int del_dir ( const gchar *dn) 
{
	DIR *dirh;
	struct dirent *dirp;
	struct stat tmp;
	gchar *path_full;
	
	if (!(dirh = opendir(dn)))
	{
		statusbar_print(" Error opening %s - %s",dn,strerror(errno));
		return; 
	}

	while ((dirp = readdir(dirh)) != NULL)
	{
		if (strcmp(dirp->d_name, ".") != 0 && strcmp(dirp->d_name, "..") != 0)
		{
			path_full = malloc(strlen(dn) + strlen(dirp->d_name)+2);
			if (strcmp(dn,"/") == 0)
				sprintf(path_full,"/%s",dirp->d_name);
			else
				sprintf(path_full,"%s/%s",dn,dirp->d_name);
			stat(path_full,&tmp);
			if (S_ISDIR (tmp.st_mode))
				del_dir(path_full);
			else
				del_file(path_full);
			if (win.cancel == 1)
				return -1;
		}
	}
	closedir(dirh);
	rmdir(dn);
}

