/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"
#define PDA	1

GtkWidget *window;

void close_fileinfo_window(GtkWidget *widget, gpointer data)
{
	gtk_grab_remove (window);
  	gtk_widget_destroy (window);
	gtk_main_quit ();
}

void cb_fileinfo_keypress(GtkWidget *widget, GdkEventKey *event)
{	
	if (event->keyval == GDK_Escape || event->keyval == GDK_Return)
	{
		close_fileinfo_window(widget,NULL);
	}
}

GtkWidget *create_label(gchar *text,GtkWidget *cont)
{
	GtkWidget *label;
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(cont),hbox);
	label = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(hbox),label,0,0,5);
	gtk_widget_show(label);
	gtk_widget_show(hbox);
	return hbox;
}

GtkWidget *create_frame(gchar *text,GtkWidget *box,gint xsize,gint ysize,gint a, gint b, gint c)
{
	GtkWidget *frame;
	frame = gtk_frame_new(text);
	gtk_box_pack_start(GTK_BOX(box),frame,a,b,c);
	gtk_widget_set_usize(GTK_WIDGET(frame),xsize,ysize);
	gtk_widget_show(frame);
	return frame;
}

void create_fileinfo_window(const gchar *filename,gint xsize,gint ysize)
{
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GtkWidget *button;
	gchar *filetype;
	FileInfo file;
	gint policy[3] = { 0,0,0 };
	gchar *perms,*owner,*group;
	gchar *strsize = malloc(20);
	struct passwd *pwd;
	struct group *grp;
	
	stat(filename,&(file.statbuf));
	if (file.statbuf.st_size >= 1024*1024)
		sprintf(strsize,"%.2f Mb",(float)file.statbuf.st_size / 1024 / 1024);
	else  if ( file.statbuf.st_size >= 10240)
		sprintf(strsize,"%.2f Kb",(float)file.statbuf.st_size / 1024);
	else
		sprintf(strsize,"%d Bytes",(int)file.statbuf.st_size);
	perms = get_perms(file.statbuf.st_mode);
	
	if ((pwd = getpwuid(file.statbuf.st_uid)) == NULL)
		owner = "Unavailable";
	else
		owner = pwd->pw_name;
	if ((grp = getgrgid(file.statbuf.st_gid)) == NULL)
		group = "Unavailable";
	else
		group = grp->gr_name; 
	
	filetype  = get_file_type(strdup(filename));
	
#ifdef PDA
	window = create_window((char *)strdup(filename),240,300,policy);
#else
	window = create_window((char *)strdup(filename),400,230,policy);
#endif
	gtk_signal_connect (GTK_OBJECT (window), "key_press_event",cb_fileinfo_keypress,NULL);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event",close_fileinfo_window,NULL);

	gtk_container_set_border_width(GTK_CONTAINER(window),5);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_widget_show(vbox);
	
	/* filename */
#ifdef PDA
	frame = create_frame("Filename",vbox,140,30,0,0,0);
#else
	frame = create_frame("Filename",vbox,350,40,0,0,0);
#endif
	hbox = create_label(strdup(filename),frame);
	
	/* size */
#ifdef PDA
	frame = create_frame("Size",vbox,140,30,0,0,0);
#else
	frame = create_frame("Size",vbox,350,40,0,0,0);
#endif
	hbox = create_label(strsize,frame);
	
	hbox2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox2,0,0,0);
	gtk_widget_show(hbox2);
	
	/* perms */
#ifdef PDA
	frame = create_frame("Permissions",hbox2,80,30,0,0,0);
#else
	frame = create_frame("Permissions",hbox2,100,40,0,0,0);
#endif
	hbox = create_label(perms,frame);
	
	/* owner */
	frame = create_frame("Owner",hbox2,1,1,1,1,5);
	hbox = create_label(owner,frame);

 	/* group */	
	frame = create_frame("Group",hbox2,1,1,1,1,0);
	hbox = create_label(group,frame);

	/* filetype */
	frame = create_frame("Filetype",vbox,1,1,1,1,0);
	hbox = create_label(filetype,frame);

	button = create_button("OK", close_fileinfo_window,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),button,0,0,5);
	gtk_widget_grab_default(GTK_WIDGET(button));

	gtk_widget_show(window);
	free(perms);
	free(strsize);
	free(filetype);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_grab_add(window);
	gtk_window_set_transient_for (GTK_WINDOW (window),GTK_WINDOW (app.main_window));
}

