/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#define STREQ(a,b) (strcmp((a),(b)) == 0)
#define _GNU_SOURCE
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <fnmatch.h>
#include <fcntl.h>
#define BUFFSIZE 4096

typedef struct _FileList FileList;
typedef struct _App App;
typedef struct _FileInfo FileInfo;
typedef struct _Config Config;
typedef struct _ExtFileInfo ExtFileInfo;
typedef struct _FileOpsWindow FileOpsWindow; 
typedef struct _CopyToDialog CopyToDialog;

struct _CopyToDialog
{

	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *entry_src;
	GtkWidget *entry_dst;
	GtkWidget *btn_ok;
	GtkWidget *btn_cancel;
	
};

struct _FileOpsWindow
{
	GtkWidget *window;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *pbar;
	GtkWidget *sumpbar;
	gint cancel;
};

struct _Config
{
	gchar xterm[256];
	gchar startupdir_left[256];
	gchar startupdir_right[256];

	gboolean col1_visible;
	gboolean col2_visible;
	gboolean col3_visible;
	gboolean col4_visible;
	gboolean col5_visible;
	
	gint popup_button;
	gint select_button;
	
	gint col1_width;
	gint col2_width;
	gint col3_width;
	gint col4_width;
	gint col5_width;
	
	gboolean confirmation_del_cmdline;
	gboolean confirmation_del_normal;

	gboolean expand_links;
	gboolean addfilenametopopup;

	gboolean copy_canceled_rm;

	gboolean lynxlike_motion;
	
};

struct _ExtFileInfo
{
	gchar *filename;
	gchar *perms;
	gchar *owner;
	gchar *group;
	off_t size;
};

struct _FileInfo
{
	gchar *filename;
	struct stat statbuf;
};

struct _FileList
{
	FileList *other;
	GtkWidget *clist;
	GtkWidget *cmb_dir;
	GtkWidget *btn_root;
	gchar *selectedfile;
	gchar *workingdir;
	gint selectedrow;
};

struct _App
{
	
	GtkWidget *main_window;
	GtkWidget *cmdline;
	GtkWidget *statusbar;
	GtkWidget *popup_menu;

	FileList left;
	FileList right;

	GList *cmdhistory;
	
};

extern App app;
extern Config config;
extern FileList *focused;
extern FileList *notfocused;

extern GdkColor color_reg;
extern GdkColor color_exe;
extern GdkColor color_dir;
extern GdkColor color_lnk;
extern FileOpsWindow win;

extern gint filecount;

/* Widget creation */
extern GtkWidget *create_window(gchar *title, int xsize,int ysize, gint policy[3]);
extern GtkWidget *create_filelist( FileList *list, FileList *other );
extern GtkWidget *create_popup( GtkWidget  *window);
extern GtkWidget *add_menu_separator (GtkWidget * menu);
extern GtkWidget *add_menu_item (GtkWidget * menu,gchar * label, GtkSignalFunc func, gpointer data);
extern GtkWidget *create_button(gchar *title, GtkSignalFunc func, gpointer data);
extern GtkWidget *create_entry(gchar *text,gint maxlen,GtkSignalFunc func, gpointer data);
extern GtkWidget *create_frame(gchar *text,GtkWidget *box,gint xsize,gint ysize,gint a,gint b, gint c);
extern GtkWidget *create_label(gchar *text,GtkWidget *cont);

extern void create_main_window();
extern void create_menu( GtkWidget *window, GtkWidget **menubar );
extern void create_associations_dialog();
extern void create_perms_window(const gchar *filename, gint xsize, gint ysize);
extern void create_fileinfo_window(const gchar *filename,gint xsize,gint ysize);
extern void create_help_window();

/* Filelists clist callbacks */
extern void cb_clist_grab_focus( GtkWidget *widget, FileList *list );
extern void cb_clist_keypress(GtkWidget *widget, GdkEventKey *event, FileList *list);
extern void cb_clist_select_all();
extern void cb_clist_select_none();
extern void cb_clist_select_invert();
extern void cb_clist_select_row(GtkWidget *clist, gint row,	gint column,GdkEvent *event, FileList *list);
extern void cb_clist_button_press(GtkWidget *clist, GdkEventButton *event,FileList *list);
extern void cb_popup_execute_program(gchar *string);

/* File operations callbacks */
extern void cb_file_move();
extern void cb_file_create_link();
extern void cb_file_copy();
extern void cb_file_delete();
extern void cb_file_mkdir();
extern void cb_file_rename();
extern void cb_pattern_select();
extern void cb_file_execute();
extern void cb_file_execute_in_xterm();
extern void cb_fileinfo();
extern void cb_execute_with_arg(GtkWidget *widget, gchar *program);
extern void cb_associate();
extern void cb_openwith();
extern gint rxvt_exec (gchar * command);

/* Various callbacks */
extern void cb_cmbdir_activate( GtkWidget *widget, FileList *list );
extern void cb_window_resize(GtkWidget *widget, GtkAllocation *allocation,gpointer user_data);
extern void cb_delete_event(GtkWidget *widget);
extern void cb_preferences();
extern void cb_perms();
extern void cb_help();
extern void cb_diskfree();
extern void create_about_window();

/* Functions */
extern void add_commandhistory(const gchar *text);
extern void refresh_filelist(FileList *list, gboolean keep_selection);
extern void update_filelist(const gchar *path, FileList *list);
extern void handle_file(const gchar *filename, FileList *list);
extern void free_clist_row_data (gpointer data);
extern void recreate_filelists();
extern void sort_list (FileList *list, GtkCListCompareFunc compare_func, GtkSortType direction, gint col);
extern void statusbar_print(char *fmt,...);
extern gchar *parsepath(const gchar *path);
extern gchar *expandpath(const gchar *path);
extern gchar *parse_program_string(const gchar *program);
extern gchar *get_doubleclick_action(gchar *extension);
extern gchar *get_perms(mode_t mode);
extern gint name_sort (GtkCList *clist, gconstpointer row1, gconstpointer row2);
extern FileInfo get_fileinfo(const gchar *filename);
extern FileInfo *get_fileinfo2(const gchar *filename);
extern GList *get_selection(FileList *list, gint row);
extern char *substr(const char *str, int index, int len);		
extern int fselect(const struct dirent *bla);

/* Fileinfo */
extern void cb_fileinfo_keypress(GtkWidget *widget, GdkEventKey *event);
extern int IS_DIR(FileInfo *info);
extern ExtFileInfo get_ext_fileinfo(const char *filename);

/* Command line */
void cb_cmdline_keypress(GtkWidget *widget,GdkEventKey *event, gpointer data);
void cb_cmdline_activate(GtkWidget *widget);

/* Configuration */
extern gchar *get_config_filename();
extern gchar *get_config_dir();
extern gchar *get_file_extensions_filename();
extern void read_config();
extern void write_config_file();
extern void set_config_defaults();
extern void create_prefs_window(const gchar *title, gint xsize, gint ysize);
extern void cb_color_dialog_show(GtkWidget *widget, GdkColor *color);
extern void cb_colorsel_color_change(GtkWidget *widget, GtkWidget *button);
extern void cb_color_sel_ok(GtkWidget *widget, GdkColor *color);
extern void cb_color_sel_cancel (GtkWidget * button);
extern int configdir_exists();

/* Dialogs */
extern void create_dialog_with_entry(gchar *title, gchar *entry_title, gchar *entry_txt, gchar ** string);
extern void create_dialog(gchar *title, gchar *frame_title,gchar *text, gint height, gint ** button);
extern void create_dialog_ok_only(gchar *title,gchar *frame_title,gint height, gchar *text);
extern void cb_entry_ok(GtkWidget *widget, gchar ** string);
extern void cb_cancel(GtkWidget * widget, gint ** button);
extern void cb_dialog_keypress(GtkWidget *widget, GdkEventKey *event, gchar ** string);
extern void cb_ok(GtkWidget * widget, gint ** button);
extern void cb_entry_cancel (GtkWidget * widget, gchar ** string);

/* File commands */
extern void cb_create_tar_archive();
extern void file_chmod(const char *filename, const char *user, const char *group,const char *others);
extern void file_chmod(const char *filename, const char *user, const char *group,const char *others);
extern gint execute_cmd(gchar ** args);
extern gint execute (gchar ** args);
extern gint execute_program (const gchar *arg);
extern gint xterm_exec (gchar * command);
extern gchar *get_file_type(const gchar *filename);
extern int IS_DIR(FileInfo *info);
extern int S_ISEXE (mode_t mode);

/* File operations window */
extern void create_fileops_window( gchar *title );
void create_fileops_sum_pbar( int val );
extern void create_fileops_pbar( int val, const gchar *filename );
extern int filecopy(const char *fn_src, const char *fn_dst );
extern int dircopy(const char *dn_src, const char *dn_dest );

extern int del_file( const gchar *fn );
extern int del_dir( const gchar *dn );
extern int make_dir( const gchar *pathname );
extern int del( const gchar *name );

extern void create_copy_dialog(const gchar *title,const gchar *txt1, const gchar *txt2, gchar **str );
extern int filemove( FileList *src, gchar *dest );
extern gint recursive_fcount( gchar *path );
extern void destroy_fileops_window();
extern int file_copy( FileList *src, gchar *dest );

