/*
 * mapdata.c
 * Jean-Pierre Demailly
 * November 2000
 *
 * map_data[] is a big array of short (16-bit) ints, as follows:
 *
 * - the map_data[] info is a sequence of closed curves
 * - the first value in a curve is the number of points in the curve
 * - the second value in a curve indicates land/water (>0 or <0,
 *   respectively; 1/-1 are normal walues, whilst 2/-2 indicate
 *   land/water in snowy area; other powers of 2 might be useable as 
 *   well to indicate other types of land...)
 * - this is followed by the point coordinate values [theta, phi] 
 *   where theta is the longitude (between -180 and 180 degrees)
 *   and phi the latitude (between -90 and 90)
 *   rescaled as short integers in the range -32760 ... 32760
 *
 * - the curves are [must be!] non-self-intersecting and traced in a
 *   counter-clockwise direction
 *
 * the curves are sampled (roughly) at a 30 km resolution.
 *
 * Copyright (C) 2000 by Jean-Pierre Demailly <demailly@ujf-grenoble.fr>
 *
 * Permission to use, copy, modify and freely distribute these data for
 * non-commercial and not-for-profit purposes is hereby granted
 * without fee, provided that both the above copyright notice and this
 * permission notice appear in all copies and in supporting
 * documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <math.h>

#include "sunclock.h"

#define grid(x,y) GRID[x*Earthmap.height+y]

extern struct earthmap Earthmap;
extern struct Color LandColor, WaterColor, ArcticColor;

extern char *ProgName;
extern int invert;

int fill_mode=2;
int free_data=1;
int full;
int which;

short *GRID;
char *line;
int uu, uc, vv;

short int map_data[] = {

/* 0 */
3903, 1,
  5852,  11342,   5798,  11402,   5835,  11426,   5820,  11442,   5779,  11461,
  5720,  11463,   5658,  11482,   5605,  11438,   5586,  11451,   5607,  11478,
  5532,  11448,   5493,  11381,   5431,  11346,   5382,  11281,   5328,  11234,
  5269,  11234,   5216,  11285,   5157,  11309,   5093,  11327,   5042,  11357,
  4985,  11389,   4930,  11430,   4871,  11452,   4810,  11471,   4750,  11497,
  4690,  11500,   4631,  11473,   4580,  11508,   4552,  11610,   4497,  11651,
  4435,  11647,   4374,  11666,   4319,  11708,   4253,  11719,   4210,  11785,
  4191,  11879,   4129,  11922,   4071,  11958,   4013,  11981,   3945,  11981,
  3888,  11936,   3826,  11920,   3770,  11871,   3717,  11816,   3672,  11744,
  3637,  11657,   3627,  11553,   3640,  11449,   3665,  11354,   3655,  11251,
  3622,  11163,   3579,  11087,   3526,  11035,   3466,  11020,   3411,  11060,
  3362,  11122,   3315,  11190,   3260,  11238,   3204,  11279,   3148,  11316,
  3088,  11346,   3029,  11365,   2967,  11368,   2907,  11393,   2854,  11446,
  2819,  11532,   2798,  11630,   2787,  11733,   2742,  11798,   2680,  11817,
  2622,  11854,   2569,  11908,   2508,  11934,   2448,  11958,   2389,  11970,
  2328,  11941,   2265,  11946,   2208,  11984,   2147,  12043,   2096,  12074,
  2046,  12110,   1998,  12215,   1940,  12236,   1880,  12272,   1837,  12350,
  1830,  12453,   1876,  12525,   1927,  12587,   1970,  12664,   2000,  12758,
  2015,  12850,   2000,  12960,   1951,  13029,   1911,  13115,   1914,  13220,
  1964,  13288,   2000,  13378,   1998,  13466,   1930,  13411,   1874,  13402,
  1856,  13515,   1800,  13553,   1747,  13580,   1683,  13548,   1629,  13493,
  1572,  13448,   1507,  13440,   1434,  13429,   1379,  13470,   1319,  13475,
  1255,  13438,   1195,  13475,   1142,  13464,   1087,  13410,   1025,  13384,
   965,  13343,    912,  13393,    849,  13427,    783,  13431,    716,  13430,
   656,  13401,    589,  13385,    528,  13380,    466,  13325,    403,  13323,
   338,  13308,    273,  13299,    209,  13285,    151,  13240,     92,  13196,
    39,  13139,     -1,  13052,    -67,  13049,   -128,  13011,   -188,  12980,
  -228,  12902,   -276,  12838,   -331,  12783,   -394,  12773,   -457,  12782,
  -517,  12806,   -557,  12860,   -627,  12816,   -691,  12828,   -754,  12815,
  -816,  12803,   -877,  12839,   -927,  12907,   -964,  12989,   -992,  13058,
 -1067,  13019,  -1096,  12927,  -1118,  12828,  -1139,  12729,  -1164,  12631,
 -1192,  12538,  -1223,  12446,  -1259,  12362,  -1311,  12302,  -1367,  12251,
 -1423,  12206,  -1481,  12166,  -1536,  12115,  -1578,  12043,  -1620,  11964,
 -1664,  11890,  -1687,  11801,  -1695,  11698,  -1729,  11611,  -1764,  11524,
 -1785,  11426,  -1789,  11320,  -1790,  11214,  -1778,  11129,  -1752,  11036,
 -1766,  10931,  -1797,  10842,  -1832,  10757,  -1865,  10670,  -1904,  10589,
 -1951,  10525,  -2004,  10472,  -2047,  10400,  -2087,  10320,  -2140,  10271,
 -2195,  10229,  -2253,  10203,  -2312,  10186,  -2362,  10142,  -2398,  10057,
 -2420,   9957,  -2443,   9862,  -2462,   9761,  -2502,   9686,  -2553,   9632,
 -2601,   9579,  -2635,   9502,  -2654,   9403,  -2677,   9305,  -2698,   9208,
 -2701,   9103,  -2713,   9000,  -2750,   8923,  -2791,   8849,  -2831,   8771,
 -2876,   8706,  -2890,   8642,  -2916,   8516,  -2942,   8416,  -2961,   8325,
 -2980,   8227,  -3010,   8132,  -3053,   8071,  -3079,   7977,  -3088,   7876,
 -3098,   7770,  -3106,   7666,  -3099,   7619,  -3067,   7656,  -3040,   7561,
 -3001,   7512,  -2968,   7416,  -2953,   7320,  -2961,   7223,  -2984,   7120,
 -2985,   7065,  -2957,   6936,  -2941,   6835,  -2927,   6733,  -2920,   6628,
 -2918,   6523,  -2923,   6418,  -2938,   6316,  -2959,   6218,  -2982,   6124,
 -2998,   6024,  -3008,   5921,  -3009,   5815,  -3019,   5714,  -3048,   5622,
 -3077,   5534,  -3112,   5452,  -3156,   5395,  -3168,   5355,  -3116,   5299,
 -3083,   5216,  -3059,   5121,  -3040,   5095,  -3011,   5121,  -3017,   5028,
 -3011,   4934,  -2977,   4864,  -2925,   4893,  -2869,   4904,  -2818,   4912,
 -2809,   4903,  -2870,   4893,  -2925,   4882,  -2970,   4832,  -3022,   4879,
 -3057,   4850,  -3051,   4747,  -3052,   4640,  -3025,   4613,  -2984,   4592,
 -2922,   4605,  -2869,   4585,  -2831,   4623,  -2819,   4635,  -2866,   4573,
 -2919,   4588,  -2973,   4578,  -3025,   4578,  -3046,   4508,  -2995,   4448,
 -2956,   4447,  -2941,   4338,  -2890,   4363,  -2881,   4349,  -2881,   4297,
 -2828,   4328,  -2778,   4344,  -2746,   4320,  -2818,   4271,  -2792,   4241,
 -2764,   4228,  -2803,   4151,  -2779,   4056,  -2754,   4039,  -2740,   4019,
 -2720,   3970,  -2686,   3973,  -2669,   3910,  -2651,   3915,  -2656,   3818,
 -2622,   3727,  -2568,   3682,  -2530,   3609,  -2487,   3565,  -2471,   3463,
 -2431,   3388,  -2410,   3310,  -2390,   3220,  -2387,   3132,  -2369,   3099,
 -2408,   3050,  -2372,   2982,  -2346,   2892,  -2320,   2823,  -2273,   2790,
 -2249,   2718,  -2203,   2636,  -2154,   2598,  -2109,   2542,  -2072,   2470,
 -2032,   2410,  -1984,   2362,  -1955,   2292,  -1896,   2241,  -1854,   2185,
 -1817,   2114,  -1777,   2041,  -1738,   1972,  -1700,   1894,  -1657,   1833,
 -1611,   1785,  -1565,   1737,  -1518,   1686,  -1468,   1651,  -1420,   1607,
 -1369,   1584,  -1321,   1626,  -1273,   1669,  -1226,   1709,  -1177,   1745,
 -1127,   1782,  -1078,   1822,  -1024,   1847,   -973,   1857,   -945,   1881,
  -868,   1873,   -815,   1888,   -762,   1896,   -751,   1914,   -816,   1900,
  -841,   1911,   -765,   1928,   -714,   1929,   -690,   1910,   -606,   1884,
  -575,   1913,   -549,   1857,   -474,   1811,   -422,   1782,   -373,   1736,
  -323,   1778,   -278,   1831,   -225,   1860,   -176,   1893,   -126,   1925,
   -81,   1975,    -32,   2018,     15,   2063,     63,   2099,    108,   2137,
    78,   2196,    140,   2100,    184,   2147,    220,   2220,    270,   2251,
   322,   2274,    374,   2290,    427,   2303,    480,   2313,    533,   2323,
   587,   2325,    628,   2371,    662,   2362,    730,   2335,    782,   2321,
   830,   2281,    872,   2216,    912,   2130,    948,   2088,    981,   2011,
  1006,   1975,    984,   1894,    992,   1813,   1014,   1707,   1053,   1625,
  1097,   1584,   1140,   1591,   1201,   1601,   1229,   1640,   1235,   1714,
  1269,   1654,   1298,   1667,   1303,   1691,   1343,   1663,   1381,   1665,
  1431,   1648,   1492,   1658,   1512,   1723,   1516,   1765,   1557,   1688,
  1601,   1663,   1633,   1523,   1678,   1457,   1723,   1455,   1759,   1427,
  1765,   1309,   1792,   1218,   1809,   1126,   1797,   1024,   1788,    920,
  1781,    818,   1781,    711,   1760,    597,   1732,    524,   1718,    424,
  1764,    371,   1752,    227,   1732,    218,   1705,    186,   1742,    103,
  1793,     70,   1792,     44,   1739,     51,   1702,     68,   1696,    -84,
  1675,   -177,   1650,   -260,   1620,   -275,   1596,   -266,   1625,   -381,
  1652,   -471,   1698,   -526,   1707,   -585,   1657,   -508,   1648,   -497,
  1680,   -604,   1707,   -677,   1718,   -723,   1757,   -863,   1800,   -901,
  1817,   -927,   1784,   -928,   1825,  -1007,   1866,  -1072,   1905,  -1143,
  1937,  -1227,   1974,  -1301,   2006,  -1383,   2044,  -1456,   2078,  -1533,
  2118,  -1605,   2146,  -1697,   2167,  -1782,   2197,  -1849,   2216,  -1972,
  2213,  -2071,   2250,  -2163,   2288,  -2183,   2333,  -2132,   2366,  -2150,
  2295,  -2197,   2243,  -2236,   2268,  -2359,   2297,  -2446,   2327,  -2531,
  2338,  -2636,   2358,  -2735,   2378,  -2833,   2403,  -2928,   2428,  -3020,
  2435,  -3119,   2412,  -3201,   2376,  -3272,   2385,  -3379,   2402,  -3480,
  2417,  -3575,   2436,  -3668,   2461,  -3767,   2492,  -3854,   2509,  -3946,
  2518,  -4051,   2510,  -4154,   2509,  -4260,   2500,  -4364,   2476,  -4467,
  2447,  -4547,   2404,  -4594,   2361,  -4668,   2341,  -4761,   2304,  -4836,
  2279,  -4924,   2270,  -5037,   2247,  -5132,   2244,  -5235,   2234,  -5340,
  2217,  -5437,   2201,  -5534,   2188,  -5643,   2156,  -5729,   2143,  -5811,
  2147,  -5915,   2150,  -6019,   2147,  -6124,   2140,  -6232,   2135,  -6333,
  2134,  -6438,   2143,  -6543,   2169,  -6635,   2193,  -6728,   2233,  -6804,
  2265,  -6890,   2293,  -6980,   2316,  -7076,   2341,  -7168,   2367,  -7261,
  2396,  -7349,   2414,  -7450,   2434,  -7549,   2457,  -7643,   2487,  -7733,
  2518,  -7820,   2542,  -7916,   2576,  -7999,   2609,  -8084,   2633,  -8178,
  2645,  -8280,   2630,  -8367,   2634,  -8492,   2636,  -8592,   2636,  -8699,
  2637,  -8802,   2656,  -8904,   2679,  -8997,   2698,  -9096,   2697,  -9201,
  2704,  -9305,   2710,  -9407,   2723,  -9510,   2738,  -9604,   2753,  -9701,
  2765,  -9801,   2780,  -9902,   2803,  -9997,   2831, -10090,   2861, -10182,
  2902, -10260,   2943, -10335,   2990, -10408,   3022, -10491,   3053, -10580,
  3077, -10676,   3098, -10776,   3114, -10877,   3133, -10978,   3155, -11075,
  3182, -11169,   3209, -11264,   3239, -11355,   3272, -11443,   3307, -11531,
  3327, -11631,   3336, -11737,   3333, -11842,   3292, -11917,   3254, -11957,
  3277, -12036,   3293, -12098,   3341, -12225,   3355, -12328,   3339, -12422,
  3363, -12453,   3420, -12434,   3459, -12505,   3514, -12561,   3558, -12632,
  3618, -12660,   3668, -12630,   3720, -12564,   3784, -12532,   3840, -12516,
  3902, -12517,   3969, -12505,   4019, -12438,   4074, -12396,   4138, -12381,
  4194, -12403,   4257, -12399,   4319, -12377,   4381, -12395,   4442, -12423,
  4508, -12437,   4555, -12373,   4620, -12381,   4667, -12357,   4707, -12278,
  4770, -12282,   4833, -12279,   4890, -12235,   4945, -12186,   4996, -12123,
  5046, -12061,   5096, -11997,   5141, -11922,   5190, -11857,   5234, -11782,
  5276, -11706,   5315, -11625,   5354, -11544,   5401, -11476,   5449, -11411,
  5489, -11329,   5524, -11243,   5556, -11153,   5586, -11062,   5614, -10967,
  5647, -10878,   5671, -10781,   5705, -10692,   5744, -10614,   5787, -10541,
  5835, -10485,   5881, -10411,   5906, -10320,   5927, -10220,   5935, -10116,
  5948, -10014,   5967,  -9914,   5983,  -9812,   5988,  -9708,   5992,  -9603,
  5976,  -9532,   5930,  -9453,   5964,  -9365,   6003,  -9273,   6054,  -9210,
  6104,  -9169,   6157,  -9127,   6212,  -9092,   6266,  -9054,   6321,  -9017,
  6373,  -8971,   6413,  -8898,   6447,  -8811,   6463,  -8706,   6442,  -8657,
  6453,  -8506,   6465,  -8405,   6468,  -8322,   6462,  -8205,   6466,  -8099,
  6447,  -8088,   6433,  -8132,   6427,  -7993,   6417,  -7888,   6395,  -7789,
  6385,  -7704,   6376,  -7590,   6342,  -7512,   6314,  -7431,   6322,  -7322,
  6318,  -7219,   6314,  -7175,   6370,  -7201,   6413,  -7137,   6453,  -7062,
  6486,  -6982,   6531,  -6906,   6582,  -6863,   6619,  -6813,   6658,  -6727,
  6700,  -6638,   6721,  -6541,   6766,  -6476,   6809,  -6419,   6857,  -6365,
  6906,  -6317,   6947,  -6274,   7010,  -6234,   7056,  -6207,   7114,  -6165,
  7154,  -6101,   7201,  -6048,   7241,  -5977,   7272,  -5902,   7302,  -5819,
  7339,  -5734,   7375,  -5651,   7392,  -5547,   7403,  -5476,   7415,  -5407,
  7415,  -5282,   7404,  -5222,   7392,  -5150,   7386,  -5020,   7382,  -4921,
  7382,  -4824,   7374,  -4710,   7386,  -4610,   7371,  -4497,   7374,  -4397,
  7367,  -4297,   7362,  -4188,   7359,  -4099,   7379,  -3993,   7383,  -3894,
  7361,  -3787,   7318,  -3731,   7275,  -3686,   7236,  -3614,   7227,  -3504,
  7211,  -3410,   7195,  -3305,   7181,  -3221,   7158,  -3106,   7158,  -3006,
  7177,  -2903,   7156,  -2823,   7155,  -2711,   7178,  -2626,   7193,  -2543,
  7154,  -2476,   7123,  -2393,   7086,  -2332,   7064,  -2220,   7070,  -2116,
  7090,  -2016,   7108,  -1916,   7123,  -1810,   7142,  -1713,   7181,  -1649,
  7206,  -1552,   7220,  -1456,   7250,  -1350,   7259,  -1282,   7290,  -1197,
  7311,  -1091,   7317,   -990,   7362,   -930,   7410,   -902,   7442,   -823,
  7456,   -730,   7514,   -704,   7554,   -629,   7587,   -546,   7616,   -449,
  7639,   -358,   7672,   -289,   7709,   -205,   7742,   -131,   7781,    -52,
  7817,     24,   7852,    101,   7888,    177,   7925,    253,   7964,    323,
  8006,    387,   8044,    457,   8084,    526,   8126,    590,   8169,    649,
  8215,    700,   8261,    748,   8307,    802,   8352,    855,   8393,    921,
  8430,    997,   8468,   1068,   8506,   1141,   8542,   1219,   8577,   1297,
  8614,   1373,   8650,   1450,   8684,   1530,   8720,   1608,   8749,   1695,
  8774,   1787,   8805,   1873,   8838,   1956,   8867,   2044,   8895,   2134,
  8921,   2226,   8934,   2327,   8951,   2426,   8975,   2520,   9004,   2607,
  9034,   2693,   9058,   2789,   9072,   2887,   9110,   2967,   9139,   3056,
  9163,   3147,   9186,   3244,   9217,   3327,   9245,   3420,   9250,   3527,
  9260,   3631,   9267,   3738,   9311,   3789,   9327,   3808,   9300,   3836,
  9305,   3939,   9304,   4047,   9301,   4148,   9321,   4246,   9311,   4317,
  9256,   4351,   9207,   4327,   9171,   4247,   9123,   4200,   9072,   4177,
  9019,   4158,   8970,   4120,   8917,   4097,   8865,   4115,   8811,   4106,
  8762,   4063,   8709,   4049,   8657,   4060,   8606,   4050,   8561,   3993,
  8515,   3941,   8466,   3900,   8415,   3916,   8360,   3937,   8314,   3936,
  8266,   3885,   8219,   3839,   8173,   3800,   8117,   3797,   8063,   3805,
  8018,   3866,   7978,   3934,   7943,   4014,   7916,   4110,   7879,   4177,
  7835,   4222,   7776,   4205,   7757,   4219,   7806,   4288,   7853,   4335,
  7896,   4393,   7891,   4504,   7863,   4587,   7826,   4667,   7782,   4711,
  7744,   4794,   7709,   4854,   7681,   4952,   7642,   5022,   7596,   5074,
  7559,   5154,   7528,   5238,   7492,   5316,   7438,   5350,   7401,   5414,
  7357,   5450,   7307,   5473,   7287,   5570,   7249,   5591,   7232,   5524,
  7200,   5640,   7178,   5714,   7150,   5814,   7136,   5917,   7128,   6022,
  7119,   6120,   7103,   6224,   7085,   6323,   7062,   6419,   7035,   6514,
  7008,   6593,   6963,   6640,   6925,   6707,   6879,   6785,   6833,   6827,
  6810,   6922,   6796,   7025,   6781,   7133,   6780,   7230,   6770,   7331,
  6770,   7442,   6762,   7543,   6752,   7649,   6764,   7706,   6726,   7851,
  6711,   7952,   6700,   8050,   6653,   8112,   6613,   8184,   6572,   8250,
  6518,   8305,   6495,   8382,   6467,   8476,   6460,   8578,   6469,   8694,
  6496,   8737,   6448,   8816,   6406,   8910,   6382,   9002,   6359,   9097,
  6332,   9192,   6307,   9286,   6280,   9380,   6250,   9470,   6223,   9565,
  6196,   9661,   6181,   9759,   6166,   9856,   6140,   9945,   6108,  10050,
  6103,  10133,   6066,  10222,   6028,  10304,   5993,  10389,   5964,  10480,
  5941,  10574,   5930,  10675,   5895,  10765,   5912,  10873,   5935,  10874,
  5954,  10753,   5980,  10668,   6020,  10585,   6041,  10492,   6054,  10393,
  6095,  10314,   6132,  10234,   6174,  10161,   6230,  10121,   6266,  10206,
  6267,  10313,   6289,  10409,   6305,  10512,   6316,  10612,   6339,  10707,
  6363,  10706,   6349,  10596,   6338,  10492,   6331,  10388,   6310,  10279,
  6320,  10225,   6387,  10217,   6428,  10142,   6458,  10051,   6488,   9960,
  6517,   9870,   6551,   9786,   6583,   9697,   6612,   9608,   6643,   9516,
  6669,   9436,   6698,   9362,   6731,   9269,   6761,   9179,   6770,   9070,
  6780,   8988,   6814,   8895,   6852,   8833,   6904,   8793,   6952,   8730,
  6993,   8657,   7022,   8565,   7048,   8467,   7069,   8375,   7089,   8300,
  7115,   8173,   7106,   8075,   7098,   7969,   7116,   7877,   7123,   7773,
  7136,   7673,   7170,   7584,   7198,   7504,   7232,   7420,   7278,   7379,
  7330,   7326,   7374,   7259,   7411,   7187,   7439,   7102,   7467,   7002,
  7491,   6906,   7507,   6801,   7538,   6716,   7560,   6622,   7591,   6530,
  7633,   6461,   7674,   6393,   7702,   6307,   7718,   6219,   7755,   6126,
  7779,   6036,   7791,   5934,   7797,   5827,   7778,   5727,   7784,   5626,
  7779,   5542,   7811,   5415,   7825,   5319,   7830,   5240,   7846,   5108,
  7872,   5017,   7874,   4914,   7874,   4811,   7900,   4714,   7928,   4633,
  7987,   4603,   8039,   4598,   8089,   4628,   8138,   4652,   8185,   4658,
  8226,   4730,   8273,   4781,   8313,   4851,   8365,   4876,   8420,   4883,
  8474,   4886,   8526,   4912,   8577,   4944,   8628,   4977,   8671,   5043,
  8719,   5094,   8771,   5098,   8822,   5102,   8875,   5134,   8912,   5213,
  8948,   5291,   8997,   5338,   9047,   5375,   9100,   5398,   9152,   5424,
  9200,   5473,   9253,   5496,   9307,   5520,   9358,   5554,   9406,   5598,
  9453,   5647,   9500,   5707,   9498,   5816,   9518,   5916,   9561,   5983,
  9612,   6022,   9663,   6059,   9715,   6091,   9768,   6115,   9819,   6161,
  9869,   6195,   9924,   6200,   9977,   6179,  10030,   6210,  10058,   6307,
 10062,   6408,  10098,   6490,  10152,   6515,  10207,   6528,  10260,   6550,
 10295,   6631,  10309,   6736,  10340,   6820,  10389,   6867,  10443,   6892,
 10500,   6899,  10519,   6967,  10510,   7070,  10504,   7174,  10521,   7275,
 10536,   7378,  10568,   7464,  10602,   7448,  10647,   7441,  10678,   7549,
 10702,   7631,  10735,   7716,  10780,   7783,  10816,   7860,  10842,   7952,
 10869,   8043,  10889,   8141,  10860,   8205,  10811,   8260,  10778,   8345,
 10742,   8426,  10711,   8514,  10675,   8584,  10619,   8604,  10561,   8633,
 10506,   8653,  10450,   8685,  10398,   8725,  10355,   8797,  10321,   8881,
 10289,   8966,  10266,   9064,  10259,   9166,  10258,   9270,  10250,   9370,
 10265,   9478,  10255,   9550,  10190,   9412,  10149,   9343,  10106,   9281,
 10067,   9196,  10026,   9119,   9978,   9049,   9945,   8978,   9919,   8907,
  9879,   8820,   9827,   8774,   9770,   8757,   9713,   8773,   9661,   8787,
  9599,   8792,   9553,   8773,   9500,   8728,   9443,   8739,   9409,   8827,
  9372,   8846,   9344,   8890,   9349,   8962,   9386,   9086,   9386,   9190,
  9374,   9296,   9384,   9381,   9349,   9475,   9304,   9493,   9273,   9404,
  9256,   9307,   9238,   9208,   9247,   9104,   9236,   9045,   9199,   9157,
  9174,   9265,   9138,   9346,   9114,   9448,   9119,   9513,   9128,   9607,
  9109,   9707,   9079,   9778,   9033,   9845,   8993,   9897,   8958,   9991,
  8903,  10053,   8885,  10127,   8855,  10228,   8830,  10331,   8806,  10427,
  8781,  10517,   8757,  10611,   8724,  10686,   8700,  10729,   8748,  10801,
  8744,  10928,   8823,  10900,   8874,  10930,   8901,  11002,   8919,  11088,
  8940,  11052,   8984,  10977,   9036,  10942,   9100,  10983,   9133,  10896,
  9170,  10807,   9210,  10728,   9228,  10624,   9258,  10542,   9289,  10454,
  9306,  10350,   9333,  10255,   9369,  10174,   9419,  10134,   9477,  10114,
  9530,  10065,   9574,   9991,   9608,   9922,   9657,   9866,   9714,   9824,
  9754,   9750,   9807,   9725,   9866,   9721,   9917,   9676,   9971,   9651,
 10021,   9704,  10075,   9743,  10121,   9797,  10176,   9841,  10229,   9888,
 10287,   9888,  10344,   9854,  10373,   9785,  10389,   9675,  10399,   9572,
 10412,   9474,  10445,   9384,  10507,   9356,  10558,   9328,  10613,   9310,
 10671,   9309,  10725,   9276,  10777,   9253,  10834,   9259,  10892,   9241,
 10952,   9230,  11008,   9229,  11063,   9189,  11121,   9166,  11180,   9146,
 11228,   9156,  11280,   9139,  11331,   9161,  11368,   9175,  11432,   9189,
 11490,   9186,  11550,   9190,  11599,   9236,  11659,   9240,  11715,   9199,
 11769,   9188,  11828,   9214,  11884,   9231,  11941,   9232,  11998,   9251,
 12056,   9266,  12083,   9279,  12141,   9153,  12148,   9051,  12210,   9024,
 12231,   8957,  12247,   8861,  12273,   8757,  12305,   8687,  12368,   8682,
 12406,   8636,  12446,   8612,  12495,   8669,  12502,   8664,  12458,   8579,
 12475,   8494,  12508,   8413,  12558,   8358,  12609,   8312,  12666,   8287,
 12716,   8318,  12772,   8354,  12813,   8351,  12762,   8215,  12705,   8175,
 12655,   8147,  12597,   8133,  12559,   8129,  12590,   8010,  12631,   7941,
 12672,   7865,  12711,   7789,  12748,   7707,  12789,   7635,  12836,   7578,
 12889,   7540,  12942,   7557,  12996,   7599,  13042,   7643,  13096,   7691,
 13129,   7761,  13151,   7866,  13123,   7968,  13151,   8089,  13187,   8111,
 13236,   8082,  13215,   7978,  13224,   7892,  13271,   7884,  13221,   7783,
 13239,   7679,  13265,   7586,  13264,   7480,  13244,   7382,  13230,   7279,
 13231,   7181,  13246,   7090,  13264,   7002,  13272,   6910,  13271,   6812,
 13278,   6702,  13286,   6608,  13299,   6492,  13314,   6392,  13325,   6292,
 13335,   6186,  13344,   6071,  13349,   5993,  13368,   5877,  13390,   5788,
 13421,   5693,  13443,   5612,  13460,   5498,  13492,   5406,  13522,   5318,
 13541,   5246,  13555,   5148,  13578,   5038,  13593,   4949,  13598,   4849,
 13611,   4729,  13628,   4651,  13650,   4532,  13674,   4440,  13706,   4355,
 13738,   4272,  13765,   4181,  13789,   4094,  13808,   3990,  13824,   3893,
 13847,   3794,  13867,   3705,  13884,   3635,  13894,   3539,  13897,   3402,
 13916,   3325,  13942,   3247,  13978,   3134,  14012,   3052,  14053,   2983,
 14104,   2948,  14153,   2984,  14199,   3042,  14221,   3134,  14233,   3223,
 14272,   3308,  14323,   3341,  14374,   3370,  14427,   3363,  14438,   3367,
 14379,   3404,  14370,   3494,  14399,   3583,  14423,   3674,  14455,   3750,
 14502,   3748,  14534,   3792,  14532,   3898,  14533,   4002,  14520,   4119,
 14519,   4200,  14527,   4314,  14549,   4424,  14576,   4500,  14597,   4595,
 14608,   4698,  14618,   4802,  14610,   4889,  14595,   4953,  14597,   5060,
 14581,   5168,  14592,   5273,  14582,   5365,  14571,   5470,  14580,   5575,
 14602,   5671,  14636,   5751,  14689,   5773,  14717,   5768,  14743,   5793,
 14783,   5904,  14824,   5955,  14877,   5946,  14930,   5982,  14975,   6042,
 14984,   6144,  14995,   6231,  15038,   6295,  15088,   6341,  15138,   6397,
 15169,   6462,  15207,   6545,  15255,   6609,  15303,   6660,  15341,   6739,
 15377,   6815,  15411,   6898,  15435,   6973,  15484,   7056,  15528,   7120,
 15535,   7141,  15500,   7134,  15544,   7226,  15575,   7184,  15652,   7217,
 15700,   7282,  15739,   7321,  15786,   7407,  15810,   7489,  15827,   7555,
 15808,   7669,  15821,   7765,  15863,   7833,  15918,   7863,  15972,   7896,
 16014,   7967,  16031,   8062,  16019,   8112,  16048,   8003,  16053,   7897,
 16079,   7887,  16115,   7917,  16141,   8017,  16163,   7881,  16205,   7907,
 16208,   7988,  16260,   7931,  16289,   8021,  16298,   8062,  16317,   7940,
 16353,   8020,  16358,   8128,  16366,   8131,  16381,   8018,  16408,   7957,
 16457,   8045,  16489,   8131,  16475,   8235,  16472,   8331,  16473,   8433,
 16452,   8511,  16406,   8548,  16356,   8615,  16303,   8660,  16285,   8696,
 16337,   8694,  16377,   8613,  16425,   8554,  16481,   8545,  16490,   8418,
 16523,   8338,  16577,   8306,  16636,   8309,  16677,   8221,  16704,   8118,
 16719,   8027,  16733,   7921,  16742,   7821,  16754,   7718,  16781,   7626,
 16795,   7606,  16792,   7650,  16818,   7539,  16852,   7454,  16874,   7432,
 16879,   7477,  16898,   7377,  16918,   7365,  16935,   7392,  16936,   7267,
 16958,   7261,  17006,   7280,  17048,   7210,  17076,   7134,  17092,   7034,
 17038,   7004,  17093,   6912,  17114,   6983,  17131,   6852,  17150,   6784,
 17175,   6666,  17192,   6571,  17203,   6467,  17213,   6375,  17202,   6268,
 17186,   6162,  17171,   6054,  17154,   5966,  17148,   5859,  17175,   5838,
 17214,   5923,  17234,   5953,  17239,   5827,  17273,   5864,  17283,   5775,
 17315,   5836,  17335,   5786,  17350,   5814,  17369,   5734,  17409,   5809,
 17441,   5893,  17487,   5943,  17522,   6007,  17521,   6067,  17582,   6028,
 17619,   6115,  17632,   6205,  17645,   6298,  17690,   6188,  17708,   6075,
 17741,   6014,  17774,   5988,  17764,   5858,  17782,   5764,  17792,   5658,
 17794,   5556,  17800,   5451,  17822,   5355,  17832,   5249,  17850,   5146,
 17853,   5035,  17867,   4985,  17878,   5056,  17901,   4942,  17924,   4849,
 17943,   4746,  17955,   4640,  17954,   4540,  17952,   4440,  17954,   4327,
 17973,   4277,  17977,   4226,  17969,   4123,  17962,   4012,  17936,   3920,
 17925,   3825,  17929,   3721,  17947,   3679,  17963,   3715,  17939,   3596,
 17927,   3505,  17907,   3397,  17899,   3297,  17882,   3195,  17877,   3099,
 17909,   3001,  17957,   3020,  17989,   2926,  18024,   2853,  18057,   2786,
 18094,   2680,  18128,   2631,  18145,   2544,  18170,   2464,  18206,   2386,
 18232,   2297,  18258,   2205,  18267,   2096,  18268,   1997,  18275,   1891,
 18285,   1794,  18310,   1714,  18310,   1612,  18322,   1515,  18342,   1430,
 18375,   1338,  18407,   1253,  18437,   1169,  18443,   1060,  18476,    980,
 18523,    927,  18560,    862,  18605,    801,  18654,    755,  18693,    687,
 18739,    637,  18785,    587,  18823,    520,  18853,    496,  18910,    530,
 18941,    544,  18978,    546,  18960,    653,  18939,    747,  18917,    841,
 18889,    937,  18848,    999,  18826,   1094,  18826,   1201,  18823,   1299,
 18815,   1406,  18824,   1506,  18832,   1608,  18827,   1714,  18809,   1810,
 18784,   1903,  18753,   1988,  18709,   2048,  18670,   2118,  18640,   2202,
 18599,   2262,  18555,   2311,  18517,   2383,  18487,   2472,  18440,   2513,
 18387,   2502,  18340,   2549,  18298,   2605,  18261,   2666,  18232,   2759,
 18252,   2788,  18276,   2701,  18289,   2666,  18271,   2804,  18260,   2906,
 18250,   3009,  18225,   3082,  18191,   3169,  18185,   3275,  18164,   3375,
 18110,   3361,  18068,   3393,  18054,   3498,  18047,   3601,  18052,   3707,
 18061,   3794,  18084,   3893,  18107,   3984,  18119,   4090,  18137,   4192,
 18163,   4287,  18185,   4381,  18200,   4477,  18195,   4583,  18204,   4685,
 18209,   4783,  18208,   4870,  18259,   4909,  18312,   4925,  18369,   4883,
 18367,   4767,  18360,   4663,  18377,   4604,  18437,   4599,  18488,   4605,
 18543,   4590,  18577,   4550,  18616,   4487,  18667,   4418,  18704,   4356,
 18728,   4260,  18750,   4223,  18765,   4086,  18778,   3977,  18824,   4001,
 18855,   4037,  18867,   3932,  18861,   3843,  18911,   3859,  18971,   3834,
 19016,   3779,  19053,   3712,  19104,   3671,  19117,   3600,  19083,   3510,
 19079,   3406,  19076,   3299,  19086,   3185,  19086,   3127,  19146,   3167,
 19179,   3245,  19212,   3322,  19261,   3363,  19314,   3407,  19320,   3492,
 19290,   3579,  19283,   3607,  19332,   3516,  19384,   3506,  19366,   3610,
 19344,   3667,  19398,   3613,  19373,   3681,  19420,   3689,  19407,   3754,
 19434,   3835,  19481,   3842,  19533,   3797,  19587,   3850,  19636,   3894,
 19675,   3958,  19722,   4000,  19769,   4065,  19813,   4115,  19843,   4186,
 19867,   4252,  19876,   4357,  19875,   4469,  19883,   4547,  19910,   4630,
 19907,   4739,  19890,   4838,  19887,   4927,  19886,   5035,  19876,   5149,
 19862,   5246,  19850,   5342,  19829,   5440,  19819,   5541,  19788,   5617,
 19749,   5703,  19721,   5789,  19696,   5866,  19650,   5934,  19603,   5999,
 19568,   6057,  19515,   6143,  19487,   6222,  19444,   6291,  19406,   6368,
 19368,   6445,  19371,   6478,  19365,   6578,  19325,   6639,  19285,   6705,
 19253,   6801,  19230,   6881,  19245,   6983,  19256,   7084,  19270,   7180,
 19303,   7268,  19347,   7320,  19391,   7401,  19404,   7498,  19427,   7578,
 19440,   7631,  19492,   7640,  19540,   7687,  19569,   7758,  19622,   7816,
 19667,   7834,  19722,   7866,  19749,   7902,  19762,   7947,  19806,   7901,
 19860,   7828,  19910,   7812,  19954,   7860,  19994,   7783,  19966,   7677,
 19972,   7573,  19993,   7484,  20017,   7399,  20085,   7390,  20100,   7482,
 20077,   7564,  20058,   7654,  20089,   7746,  20101,   7756,  20143,   7768,
 20202,   7812,  20248,   7824,  20301,   7845,  20348,   7902,  20393,   7940,
 20452,   7945,  20462,   7982,  20507,   7955,  20555,   7994,  20598,   8053,
 20623,   8112,  20611,   8161,  20664,   8111,  20661,   8232,  20636,   8321,
 20666,   8406,  20680,   8381,  20686,   8303,  20727,   8204,  20757,   8144,
 20798,   8163,  20829,   8204,  20850,   8238,  20887,   8260,  20917,   8258,
 20973,   8306,  21020,   8299,  21070,   8313,  21126,   8326,  21179,   8361,
 21225,   8448,  21232,   8487,  21234,   8510,  21278,   8585,  21330,   8610,
 21386,   8676,  21428,   8731,  21468,   8794,  21480,   8863,  21466,   8917,
 21514,   8955,  21575,   8959,  21604,   9044,  21647,   9098,  21667,   9171,
 21701,   9208,  21702,   9286,  21738,   9275,  21762,   9270,  21761,   9379,
 21758,   9457,  21711,   9483,  21781,   9551,  21795,   9617,  21790,   9728,
 21834,   9712,  21837,   9678,  21858,   9760,  21890,   9847,  21907,   9921,
 21955,  10014,  21973,  10110,  21969,  10190,  21965,  10207,  22021,  10224,
 22064,  10290,  22123,  10330,  22090,  10440,  22076,  10468,  22133,  10513,
 22119,  10593,  22151,  10652,  22190,  10662,  22173,  10753,  22126,  10744,
 22198,  10850,  22198,  10884,  22140,  10926,  22098,  11003,  22042,  11017,
 21978,  10962,  21933,  11004,  21898,  11027,  21985,  11055,  22026,  11120,
 22079,  11179,  22132,  11227,  22176,  11273,  22150,  11381,  22100,  11442,
 22055,  11516,  21999,  11562,  21965,  11622,  21902,  11629,  21838,  11634,
 21790,  11715,  21802,  11746,  21848,  11644,  21903,  11651,  21959,  11675,
 22011,  11611,  22070,  11593,  22127,  11559,  22175,  11573,  22134,  11672,
 22096,  11736,  22062,  11819,  22004,  11880,  22000,  11980,  21979,  12081,
 21953,  12176,  21929,  12271,  21909,  12369,  21887,  12470,  21836,  12530,
 21778,  12574,  21724,  12641,  21692,  12691,  21716,  12782,  21751,  12872,
 21796,  12958,  21837,  13018,  21874,  13101,  21889,  13165,  21951,  13157,
 21981,  13247,  22007,  13317,  22088,  13371,  22134,  13399,  22207,  13449,
 22258,  13428,  22294,  13490,  22306,  13598,  22231,  13644,  22177,  13633,
 22110,  13655,  22046,  13705,  21990,  13762,  21923,  13734,  21882,  13681,
 21826,  13595,  21784,  13523,  21718,  13518,  21660,  13570,  21655,  13673,
 21665,  13768,  21632,  13864,  21572,  13873,  21502,  13885,  21446,  13930,
 21405,  14012,  21400,  14112,  21427,  14209,  21477,  14269,  21542,  14230,
 21615,  14260,  21662,  14277,  21704,  14389,  21736,  14476,  21788,  14538,
 21849,  14586,  21913,  14635,  21951,  14714,  22004,  14807,  22045,  14877,
 22111,  14881,  22176,  14876,  22234,  14793,  22243,  14704,  22204,  14617,
 22162,  14542,  22113,  14458,  22092,  14376,  22155,  14307,  22105,  14207,
 22071,  14136,  22161,  14188,  22220,  14244,  22264,  14325,  22322,  14379,
 22384,  14430,  22444,  14472,  22507,  14500,  22581,  14502,  22641,  14542,
 22699,  14447,  22767,  14414,  22820,  14360,  22810,  14251,  22784,  14153,
 22815,  14099,  22835,  14074,  22763,  14038,  22733,  13930,  22726,  13872,
 22780,  13814,  22835,  13763,  22892,  13807,  22960,  13765,  23035,  13764,
 23048,  13705,  23067,  13576,  23079,  13500,  23083,  13435,  23015,  13445,
 22988,  13372,  23030,  13249,  23040,  13147,  23067,  13067,  23036,  12954,
 23004,  12855,  22997,  12758,  23023,  12665,  23010,  12592,  23048,  12521,
 23097,  12565,  23156,  12603,  23190,  12585,  23209,  12651,  23244,  12699,
 23307,  12730,  23371,  12724,  23418,  12782,  23486,  12778,  23536,  12859,
 23558,  12942,  23576,  13055,  23561,  13132,  23554,  13244,  23560,  13349,
 23555,  13455,  23538,  13556,  23507,  13649,  23474,  13740,  23435,  13825,
 23403,  13917,  23376,  14013,  23341,  14100,  23286,  14168,  23237,  14238,
 23199,  14315,  23211,  14419,  23241,  14499,  23297,  14558,  23362,  14586,
 23418,  14651,  23473,  14715,  23520,  14794,  23577,  14852,  23611,  14921,
 23616,  15033,  23604,  15132,  23638,  15226,  23679,  15310,  23730,  15382,
 23792,  15419,  23826,  15514,  23895,  15552,  23929,  15633,  23972,  15723,
 24012,  15732,  24041,  15709,  24082,  15717,  24101,  15612,  24175,  15587,
 24235,  15553,  24317,  15589,  24381,  15625,  24440,  15689,  24503,  15745,
 24560,  15809,  24610,  15889,  24656,  15966,  24686,  16053,  24726,  16140,
 24781,  16210,  24823,  16297,  24869,  16380,  24914,  16464,  24969,  16537,
 25017,  16618,  25067,  16698,  25111,  16783,  25144,  16875,  25179,  16967,
 25205,  17069,  25243,  17158,  25294,  17239,  25327,  17335,  25366,  17427,
 25420,  17506,  25474,  17583,  25512,  17671,  25530,  17776,  25538,  17860,
 25558,  17967,  25576,  18080,  25571,  18180,  25584,  18260,  25569,  18378,
 25573,  18480,  25602,  18578,  25622,  18689,  25653,  18778,  25705,  18862,
 25736,  18955,  25727,  19024,  25699,  19110,  25702,  19215,  25647,  19292,
 25648,  19316,  25719,  19329,  25705,  19414,  25647,  19476,  25568,  19554,
 25526,  19646,  25462,  19724,  25398,  19744,  25311,  19736,  25248,  19721,
 25244,  19606,  25210,  19505,  25176,  19514,  25191,  19600,  25092,  19505,
 25012,  19522,  25050,  19639,  25019,  19706,  25024,  19759,  24967,  19681,
 24940,  19598,  24879,  19620,  24895,  19732,  24899,  19831,  24864,  19884,
 24767,  19872,  24684,  19889,  24613,  19954,  24663,  20051,  24741,  20107,
 24803,  20181,  24869,  20253,  24941,  20316,  25010,  20383,  25075,  20462,
 25136,  20551,  25176,  20641,  25235,  20729,  25300,  20795,  25376,  20870,
 25446,  20943,  25518,  21017,  25577,  21089,  25608,  21190,  25673,  21270,
 25756,  21331,  25817,  21415,  25874,  21500,  25958,  21563,  26056,  21602,
 26155,  21614,  26263,  21617,  26352,  21614,  26466,  21625,  26546,  21591,
 26614,  21557,  26677,  21627,  26784,  21598,  26880,  21584,  26981,  21612,
 27075,  21575,  27106,  21649,  27175,  21741,  27273,  21741,  27370,  21698,
 27441,  21665,  27568,  21666,  27643,  21586,  27672,  21542,  27557,  21527,
 27526,  21461,  27621,  21429,  27719,  21472,  27821,  21464,  27908,  21536,
 27993,  21534,  28096,  21531,  28203,  21545,  28209,  21631,  28108,  21654,
 28067,  21691,  28092,  21792,  28140,  21882,  28203,  21969,  28285,  22038,
 28361,  22112,  28410,  22207,  28491,  22285,  28528,  22384,  28613,  22458,
 28711,  22489,  28816,  22494,  28919,  22520,  29015,  22499,  29079,  22472,
 29169,  22497,  29130,  22368,  29101,  22287,  29145,  22192,  29186,  22096,
 29285,  22157,  29358,  22238,  29431,  22314,  29503,  22382,  29612,  22442,
 29687,  22450,  29682,  22572,  29703,  22680,  29734,  22765,  29847,  22802,
 29955,  22804,  30058,  22756,  30081,  22722,  29948,  22722,  29869,  22645,
 29860,  22538,  29834,  22439,  29830,  22347,  29793,  22256,  29767,  22169,
 29683,  22117,  29575,  22056,  29482,  21990,  29442,  21899,  29369,  21825,
 29306,  21741,  29225,  21675,  29161,  21591,  29090,  21512,  29055,  21414,
 28988,  21319,  28927,  21251,  28851,  21181,  28788,  21113,  28684,  21087,
 28598,  21038,  28551,  20999,  28562,  20890,  28514,  20789,  28454,  20715,
 28401,  20652,  28366,  20534,  28344,  20431,  28328,  20329,  28318,  20224,
 28311,  20120,  28318,  20014,  28330,  19911,  28344,  19804,  28363,  19702,
 28378,  19598,  28389,  19493,  28400,  19388,  28409,  19284,  28425,  19180,
 28457,  19097,  28472,  18980,  28482,  18875,  28481,  18768,  28500,  18667,
 28542,  18574,  28634,  18671,  28687,  18749,  28751,  18822,  28801,  18911,
 28835,  19009,  28846,  19102,  28856,  19197,  28871,  19282,  28982,  19344,
 29067,  19375,  29115,  19381,  29099,  19499,  29096,  19605,  29126,  19704,
 29188,  19779,  29257,  19846,  29343,  19853,  29432,  19854,  29497,  19938,
 29471,  20036,  29437,  20131,  29439,  20237,  29473,  20334,  29515,  20427,
 29574,  20507,  29634,  20531,  29650,  20412,  29722,  20475,  29711,  20584,
 29663,  20655,  29631,  20741,  29624,  20852,  29675,  20937,  29697,  21032,
 29598,  21073,  29537,  21034,  29479,  21135,  29500,  21239,  29545,  21334,
 29613,  21418,  29672,  21502,  29710,  21597,  29721,  21703,  29767,  21797,
 29846,  21831,  29949,  21843,  30035,  21800,  30072,  21890,  30179,  21955,
 30245,  21982,  30238,  21840,  30273,  21800,  30345,  21890,  30415,  21972,
 30504,  22013,  30610,  22048,  30714,  22045,  30814,  22041,  30903,  21946,
 30941,  21860,  31009,  21847,  31047,  21972,  31112,  22031,  31207,  22105,
 31294,  22160,  31354,  22232,  31426,  22297,  31483,  22356,  31580,  22441,
 31676,  22482,  31782,  22530,  31891,  22593,  31970,  22636,  32073,  22685,
 32160,  22750,  32224,  22804,  32259,  22843,  32321,  22777,  32436,  22750,
 32542,  22706,  32610,  22721,  32673,  22810,  32644,  22916,  32618,  23010,
 32556,  23075,  32510,  23142,  32494,  23293,  32462,  23392,  32406,  23406,
 32293,  23471,  32247,  23552,  32111,  23524,  32081,  23542,  32027,  23601,
 31903,  23566,  31836,  23557,  32020,  23612,  32132,  23604,  32210,  23632,
 32148,  23679,  32279,  23625,  32356,  23557,  32490,  23532,  32590,  23570,
 32690,  23625, -32739,  23702, -32677,  23790, -32656,  23889, -32720,  23986,
-32677,  24078, -32591,  24128, -32498,  24118, -32548,  24008, -32493,  23901,
-32429,  23836, -32303,  23846, -32185,  23872, -32063,  23831, -32006,  23744,
-31979,  23642, -31877,  23589, -31752,  23540, -31674,  23466, -31575,  23456,
-31549,  23469, -31495,  23430, -31439,  23501, -31456,  23609, -31358,  23711,
-31375,  23764, -31372,  23846, -31390,  23891, -31269,  23846, -31163,  23886,
-31169,  23932, -31052,  23923, -30978,  24017, -30938,  24077, -31033,  24137,
-31124,  24222, -31212,  24299, -31301,  24372, -31441,  24382, -31551,  24388,
-31711,  24423, -31734,  24397, -31676,  24290, -31670,  24210, -31685,  24154,
-31756,  24187, -31818,  24280, -31826,  24388, -31828,  24502, -31890,  24562,
-31974,  24670, -32088,  24731, -32211,  24796, -32312,  24848, -32408,  24903,
-32521,  24981, -32629,  25057, -32708,  25092,  31966,  25137,  31850,  25215,
 31768,  25260,  31593,  25316,  31453,  25355,  31326,  25416,  31173,  25434,
 31254,  25489,  31103,  25515,  31035,  25485,  31004,  25381,  31039,  25314,
 31102,  25213,  31107,  25117,  31028,  25051,  30860,  25061,  30786,  25156,
 30648,  25211,  30602,  25316,  30515,  25371,  30361,  25306,  30210,  25314,
 30061,  25329,  29917,  25353,  29791,  25375,  29639,  25363,  29506,  25335,
 29398,  25252,  29392,  25152,  29376,  25048,  29323,  24992,  29329,  25144,
 29297,  25246,  29249,  25345,  29109,  25396,  29086,  25501,  29130,  25589,
 29086,  25691,  28989,  25773,  28852,  25828,  28701,  25864,  28537,  25875,
 28366,  25868,  28243,  25853,  28072,  25826,  27921,  25794,  27759,  25788,
 27650,  25847,  27578,  25953,  27424,  25968,  27350,  25989,  27260,  26073,
 27158,  26128,  27291,  26197,  27180,  26277,  27017,  26315,  26838,  26324,
 26715,  26261,  26627,  26168,  26490,  26104,  26411,  26146,  26522,  26224,
 26570,  26254,  26611,  26195,  26670,  26306,  26457,  26306,  26344,  26318,
 26616,  26334,  26656,  26357,  26478,  26403,  26308,  26433,  26137,  26454,
 25959,  26463,  25787,  26487,  25642,  26489,  25599,  26396,  25421,  26380,
 25370,  26286,  25466,  26254,  25410,  26159,  25435,  26031,  25309,  26031,
 25183,  26053,  25122,  25957,  25054,  25929,  24895,  26018,  24764,  26066,
 24613,  26042,  24492,  25976,  24309,  26014,  24199,  26093,  24113,  26135,
 24034,  26000,  24006,  25907,  23933,  25798,  23813,  25790,  23691,  25847,
 23597,  25914,  23519,  26029,  23512,  26108,  23470,  26159,  23345,  26238,
 23237,  26318,  23097,  26318,  23143,  26195,  23155,  26095,  23152,  26049,
 23102,  26191,  23018,  26299,  22873,  26338,  22743,  26412,  22589,  26461,
 22422,  26484,  22248,  26529,  22095,  26555,  21917,  26565,  21820,  26560,
 21581,  26646,  21573,  26753,  21361,  26787,  21179,  26814,  20990,  26819,
 20812,  26784,  20697,  26718,  20666,  26617,  20659,  26470,  20620,  26512,
 20655,  26617,  20622,  26718,  20627,  26819,  20537,  26879,  20343,  26849,
 20228,  26926,  20016,  26919,  20003,  26834,  20119,  26812,  19918,  26743,
 19785,  26694,  19653,  26651,  19442,  26631,  19325,  26584,  19218,  26503,
 19188,  26520,  19280,  26615,  19386,  26689,  19504,  26775,  19666,  26814,
 19780,  26894,  19924,  26972,  20009,  27054,  20155,  27129,  20331,  27192,
 20467,  27268,  20603,  27346,  20676,  27450,  20560,  27531,  20555,  27570,
 20692,  27542,  20671,  27647,  20555,  27728,  20407,  27822,  20258,  27912,
 20050,  27927,  19812,  27930,  19633,  27888,  19434,  27885,  19484,  28015,
 19248,  28046,  19093,  28090,  19253,  28201,  18988,  28275,  18750,  28239,
 18582,  28159,  18441,  28065,  18381,  27972,  18424,  27864,  18475,  27828,
 18201,  27837,  18051,  27804,  18170,  27687,  18114,  27587,  18156,  27437,
 18099,  27495,  18092,  27585,  18118,  27690,  17940,  27728,  17736,  27667,
 17542,  27641,  17455,  27664,  17333,  27713,  17134,  27699,  16990,  27647,
 16798,  27573,  16606,  27537,  16400,  27506,  16222,  27456,  16083,  27382,
 15906,  27317,  15830,  27207,  15742,  27192,  15671,  27178,  15818,  27090,
 15780,  27069,  15692,  27048,  15845,  26957,  15909,  26864,  15788,  26784,
 15648,  26723,  15756,  26631,  15754,  26615,  15633,  26714,  15726,  26804,
 15764,  26881,  15527,  26844,  15344,  26834,  15159,  26814,  14969,  26812,
 14781,  26792,  14654,  26740,  14642,  26639,  14704,  26543,  14691,  26438,
 14773,  26350,  14939,  26304,  15012,  26206,  15154,  26144,  15204,  26046,
 15154,  25944,  15165,  25851,  15218,  25741,  15225,  25637,  15100,  25577,
 15123,  25739,  15059,  25802,  14978,  25684,  14964,  25628,  14982,  25783,
 14977,  25890,  15054,  25976,  15132,  26073,  15018,  26115,  14847,  26113,
 14717,  26206,  14624,  26265,  14479,  26327,  14307,  26347,  14157,  26304,
 14150,  26240,  14164,  26164,  13997,  26211,  13859,  26168,  13895,  26062,
 14019,  25994,  14162,  25957,  14267,  25879,  14296,  25832,  14040,  25899,
 13901,  25920,  13752,  25955,  13725,  26038,  13702,  26148,  13744,  26247,
 13768,  26345,  13743,  26449,  13648,  26482,  13668,  26350,  13631,  26249,
 13498,  26186,  13382,  26117,  13322,  26009,  13394,  25914,  13450,  25813,
 13518,  25716,  13485,  25616,  13421,  25521,  13396,  25414,  13424,  25316,
 13435,  25213,  13504,  25158,  13656,  25162,  13793,  25201,  13936,  25164,
 14056,  25106,  14143,  25034,  14172,  24933,  14184,  24842,  14107,  24749,
 14146,  24659,  14279,  24624,  14319,  24600,  14152,  24602,  14054,  24683,
 14062,  24788,  14060,  24888,  14024,  24977,  13944,  25073,  13824,  25098,
 13687,  25063,  13565,  25003,  13546,  24895,  13599,  24796,  13612,  24690,
 13555,  24598,  13470,  24515,  13444,  24409,  13366,  24329,  13259,  24268,
 13174,  24199,  13105,  24120,  12974,  24152,  12840,  24149,  12717,  24182,
 12602,  24236,  12621,  24317,  12757,  24303,  12863,  24254,  13000,  24285,
 13035,  24372,  13125,  24463,  13189,  24555,  13275,  24639,  13315,  24733,
 13321,  24837,  13383,  24933,  13291,  25023,  13209,  25107,  13205,  25213,
 13210,  25314,  13220,  25422,  13202,  25529,  13222,  25626,  13242,  25728,
 13234,  25834,  13165,  25922,  13092,  26020,  13160,  26117,  13213,  26215,
 13252,  26318,  13245,  26431,  13127,  26503,  12976,  26536,  12793,  26534,
 12640,  26531,  12546,  26419,  12517,  26311,  12484,  26206,  12434,  26106,
 12338,  26020,  12208,  25953,  12150,  25860,  12183,  25773,  12241,  25691,
 12224,  25587,  12213,  25495,  12156,  25388,  12206,  25341,  12370,  25294,
 12406,  25191,  12501,  25102,  12568,  25065,  12522,  24948,  12433,  24867,
 12311,  24958,  12208,  25044,  12084,  25100,  11965,  25156,  11820,  25205,
 11726,  25288,  11594,  25339,  11451,  25375,  11300,  25390,  11150,  25416,
 11033,  25383,  10965,  25308,  11022,  25207,  11074,  25123,  10988,  25015,
 10898,  24965,  10842,  24888,  10755,  24950,  10773,  25055,  10709,  25107,
 10588,  25046,  10454,  24984,  10318,  24969,  10184,  24975,  10050,  24935,
  9957,  24846,   9829,  24842,   9752,  24880,   9793,  24986,   9813,  25078,
  9859,  25111,   9702,  25073,   9584,  25013,   9563,  24948,   9494,  24920,
  9360,  24906,   9228,  24865,   9104,  24785,   9005,  24731,   8890,  24668,
  8770,  24622,   8712,  24553,   8689,  24448,   8642,  24358,   8507,  24324,
  8425,  24327,   8316,  24406,   8235,  24481,   8195,  24566,   8280,  24650,
  8422,  24683,   8488,  24731,   8436,  24822,   8353,  24914,   8220,  24960,
  8076,  24952,   7952,  24946,   8052,  24790,   8035,  24708,   8008,  24608,
  7978,  24483,   8069,  24409,   8092,  24301,   8065,  24206,   8028,  24104,
  8004,  24039,   7913,  24080,   7824,  24175,   7700,  24187,   7587,  24101,
  7488,  24035,   7383,  23979,   7293,  23905,   7232,  23821,   7279,  23724,
  7343,  23633,   7340,  23527,   7215,  23516,   7078,  23565,   6962,  23578,
  6866,  23663,   6746,  23716,   6660,  23627,   6692,  23539,   6772,  23448,
  6888,  23421,   6913,  23299,   6807,  23244,   6687,  23273,   6597,  23333,
  6515,  23408,   6402,  23440,   6346,  23544,   6337,  23643,   6299,  23737,
  6286,  23824,   6335,  23935,   6305,  24025,   6205,  24102,   6107,  24163,
  6036,  24238,   5948,  24322,   5876,  24411,   5862,  24441,   5977,  24402,
  6089,  24310,   6194,  24282,   6295,  24241,   6426,  24187,   6548,  24149,
  6678,  24128,   6800,  24095,   6917,  24056,   7046,  24051,   7172,  24080,
  7287,  24130,   7385,  24198,   7462,  24285,   7518,  24381,   7503,  24477,
  7470,  24582,   7403,  24664,   7319,  24729,   7222,  24790,   7088,  24854,
  6997,  24891,   6873,  24994,   6761,  25059,   6644,  25125,   6524,  25183,
  6387,  25199,   6239,  25227,   6119,  25205,   6057,  25178,   6009,  25266,
  5882,  25306,   5877,  25357,   5982,  25379,   5819,  25424,   5712,  25369,
  5551,  25400,   5463,  25388,   5385,  25420,   5319,  25489,   5268,  25525,
  5483,  25517,   5615,  25587,   5570,  25659,   5456,  25712,   5306,  25766,
  5188,  25710,   5154,  25624,   5128,  25566,   5103,  25689,   5124,  25779,
  5125,  25853,   4992,  25826,   4943,  25720,   4855,  25674,   4810,  25781,
  4695,  25668,   4629,  25575,   4566,  25554,   4593,  25672,   4668,  25788,
  4549,  25807,   4454,  25745,   4375,  25657,   4262,  25568,   4209,  25493,
  4083,  25548,   3942,  25568,   3921,  25525,   4000,  25470,   3975,  25422,
  3839,  25438,   3749,  25369,   3731,  25292,   3666,  25264,   3707,  25390,
  3658,  25426,   3610,  25322,   3575,  25310,   3526,  25386,   3481,  25292,
  3498,  25236,   3405,  25260,   3333,  25232,   3212,  25135,   3191,  25038,
  3057,  24979,   3070,  24918,   3181,  24893,   3114,  24861,   2993,  24852,
  2993,  24792,   2965,  24736,   2863,  24799,   2829,  24736,   2740,  24666,
  2824,  24620,   2780,  24551,   2684,  24537,   2676,  24481,   2757,  24454,
  2604,  24407,   2501,  24335,   2450,  24248,   2417,  24146,   2496,  24102,
  2355,  24042,   2327,  23971,   2287,  23867,   2287,  23759,   2213,  23678,
  2107,  23637,   2089,  23601,   2152,  23607,   2102,  23501,   2023,  23466,
  1929,  23435,   1853,  23350,   1813,  23265,   1784,  23191,   1855,  23128,
  1962,  23187,   1985,  23258,   2056,  23282,   2036,  23200,   1962,  23123,
  1852,  23066,   1796,  23098,   1720,  23136,   1659,  23080,   1555,  22996,
  1536,  22930,   1534,  22900,   1466,  22926,   1489,  22871,   1351,  22919,
  1292,  22866,   1397,  22837,   1430,  22828,   1342,  22781,   1214,  22789,
  1180,  22745,   1278,  22692,   1287,  22648,   1188,  22692,   1165,  22660,
  1103,  22633,   1092,  22603,   1004,  22610,    948,  22588,    981,  22538,
  1080,  22525,   1143,  22505,    993,  22514,    944,  22435,    966,  22345,
   950,  22258,   1070,  22262,   1173,  22275,   1234,  22288,   1322,  22295,
  1358,  22310,   1299,  22207,   1219,  22229,   1101,  22238,   1001,  22223,
   945,  22167,    970,  22089,   1003,  22015,    955,  21944,   1008,  21932,
  1029,  21923,   1066,  21881,   1140,  21984,   1236,  22004,   1157,  21923,
  1066,  21819,   1077,  21770,   1100,  21757,   1007,  21703,    969,  21619,
  1035,  21613,   1099,  21646,   1148,  21668,   1121,  21575,   1107,  21476,
  1140,  21457,   1029,  21450,   1013,  21343,   1083,  21268,   1187,  21214,
  1244,  21156,   1320,  21121,   1413,  21136,   1494,  21178,   1578,  21253,
  1652,  21352,   1709,  21419,   1777,  21484,   1870,  21515,   1897,  21623,
  1896,  21705,   1936,  21759,   1943,  21619,   1999,  21537,   2049,  21480,
  2044,  21358,   2079,  21249,   2139,  21197,   2137,  21063,   2157,  20974,
  2193,  20876,   2230,  20780,   2279,  20688,   2331,  20584,   2301,  20484,
  2313,  20388,   2358,  20291,   2359,  20179,   2450,  20151,   2540,  20169,
  2602,  20215,   2593,  20318,   2661,  20400,   2729,  20442,   2820,  20445,
  2899,  20454,   2943,  20572,   2984,  20661,   3002,  20770,   3015,  20875,
  3023,  20974,   3022,  21072,   3044,  21165,   3041,  21268,   2999,  21336,
  2989,  21347,   3103,  21362,   3182,  21421,   3239,  21479,   3336,  21546,
  3349,  21605,   3221,  21572,   3131,  21597,   3039,  21638,   2983,  21661,
  3107,  21677,   3192,  21677,   3205,  21720,   3284,  21619,   3354,  21658,
  3433,  21745,   3436,  21832,   3362,  21921,   3297,  22000,   3215,  22051,
  3145,  22110,   3127,  22217,   3126,  22324,   3135,  22433,   3164,  22505,
  3188,  22624,   3187,  22727,   3269,  22796,   3290,  22883,   3366,  22945,
  3448,  23018,   3547,  23101,   3644,  23158,   3725,  23206,   3803,  23303,
  3863,  23398,   3905,  23485,   3856,  23574,   3908,  23676,   3924,  23780,
  4001,  23856,   4014,  23888,   4062,  23906,   4127,  23959,   4246,  23945,
  4379,  23948,   4486,  23937,   4593,  23842,   4603,  23737,   4598,  23630,
  4482,  23583,   4419,  23487,   4350,  23400,   4280,  23314,   4203,  23235,
  4127,  23170,   4062,  23084,   3988,  23009,   3919,  22962,   3864,  22863,
  3846,  22763,   3876,  22674,   3881,  22561,   3920,  22458,   3920,  22374,
  3903,  22249,   3891,  22153,   3928,  22054,   4008,  22008,   4109,  21948,
  4184,  21909,   4217,  21819,   4213,  21783,   4293,  21836,   4417,  21849,
  4500,  21888,   4590,  21917,   4705,  21961,   4789,  21997,   4869,  22017,
  4986,  22025,   5083,  22035,   5200,  22052,   5255,  21945,   5347,  21904,
  5440,  21877,   5459,  21814,   5313,  21826,   5229,  21774,   5134,  21739,
  5082,  21647,   4977,  21636,   4874,  21658,   4775,  21687,   4674,  21695,
  4579,  21662,   4486,  21650,   4389,  21605,   4296,  21549,   4279,  21460,
  4300,  21368,   4328,  21251,   4431,  21218,   4440,  21111,   4428,  21008,
  4439,  20903,   4416,  20808,   4333,  20747,   4246,  20784,   4201,  20877,
  4133,  20956,   4073,  21003,   3970,  20955,   3912,  20872,   3891,  20770,
  3841,  20679,   3827,  20561,   3821,  20470,   3832,  20366,   3847,  20264,
  3866,  20157,   3861,  20062,   3823,  19989,   3767,  20035,   3826,  20141,
  3834,  20205,   3771,  20059,   3698,  20005,   3631,  19961,   3598,  19858,
  3527,  19796,   3436,  19787,   3376,  19855,   3373,  19924,   3241,  19949,
  3153,  19924,   3072,  19876,   2993,  19830,   2941,  19763,   2842,  19725,
  2756,  19696,   2672,  19658,   2589,  19640,   2537,  19651,   2641,  19582,
  2613,  19546,   2536,  19594,   2490,  19690,   2416,  19735,   2341,  19796,
  2283,  19791,   2188,  19715,   2104,  19670,   2046,  19644,   1986,  19687,
  1992,  19784,   1873,  19799,   1818,  19865,   1773,  19947,   1748,  19995,
  1746,  20103,   1760,  20215,   1796,  20293,   1859,  20368,   1908,  20452,
  1979,  20516,   1926,  20573,   1866,  20614,   1855,  20752,   1913,  20844,
  1907,  20952,   1893,  20989,   1798,  20932,   1742,  20840,   1659,  20798,
  1566,  20771,   1509,  20671,   1551,  20640,   1622,  20748,   1687,  20759,
  1744,  20747,   1684,  20628,   1670,  20607,   1615,  20644,   1539,  20590,
  1486,  20543,   1487,  20475,   1495,  20363,   1485,  20242,   1532,  20194,
  1563,  20073,   1577,  19972,   1613,  19881,   1600,  19804,   1605,  19747,
  1633,  19653,   1707,  19585,   1736,  19533,   1619,  19601,   1554,  19570,
  1529,  19473,   1471,  19500,   1399,  19546,   1310,  19514,   1304,  19421,
  1276,  19408,   1205,  19453,   1118,  19439,   1033,  19407,    974,  19334,
   897,  19271,    851,  19215,    835,  19110,    804,  19014,    749,  18925,
   707,  18852,    714,  18802,    738,  18761,    672,  18738,    742,  18696,
   613,  18700,    537,  18654,    464,  18600,    384,  18570,    306,  18525,
   287,  18423,    289,  18316,    268,  18251,    201,  18181,    123,  18150,
    50,  18099,     43,  18003,    -38,  17947,   -117,  17963,   -200,  17979,
  -247,  18069,   -334,  18062,   -304,  17940,   -286,  17843,   -279,  17723,
  -363,  17696,   -433,  17701,   -506,  17690,   -567,  17768,   -646,  17749,
  -717,  17722,   -801,  17705,   -836,  17628,   -803,  17562,   -827,  17472,
  -753,  17420,   -682,  17400,   -596,  17367,   -543,  17321,   -481,  17301,
  -433,  17224,   -364,  17186,   -377,  17067,   -341,  16971,   -297,  16906,
  -223,  16844,   -200,  16740,   -203,  16646,   -151,  16558,   -125,  16460,
  -113,  16403,   -171,  16544,   -206,  16541,   -216,  16433,   -224,  16328,
  -216,  16251,   -235,  16119,   -247,  16015,   -261,  15913,   -295,  15818,
  -361,  15778,   -431,  15778,   -500,  15809,   -568,  15794,   -641,  15827,
  -708,  15824,   -789,  15803,   -859,  15811,   -930,  15834,   -997,  15856,
 -1070,  15878,  -1146,  15866,  -1217,  15862,  -1288,  15857,  -1359,  15905,
 -1422,  15920,  -1487,  15879,  -1512,  15804,  -1611,  15761,  -1666,  15707,
 -1675,  15624,  -1632,  15539,  -1602,  15467,  -1596,  15380,  -1609,  15262,
 -1604,  15167,  -1595,  15060,  -1579,  14960,  -1584,  14854,  -1584,  14805,
 -1612,  14635,  -1627,  14546,  -1651,  14448,  -1682,  14356,  -1707,  14281,
 -1719,  14174,  -1705,  14091,  -1651,  14138,  -1626,  14173,  -1674,  14056,
 -1649,  14000,  -1599,  13991,  -1608,  13857,  -1602,  13750,  -1605,  13650,
 -1620,  13548,  -1609,  13489,  -1535,  13502,  -1467,  13481,  -1408,  13486,
 -1348,  13533,  -1280,  13544,  -1242,  13528,  -1186,  13453,  -1153,  13395,
 -1135,  13278,  -1097,  13179,  -1040,  13124,   -985,  13153,   -948,  13240,
  -889,  13283,   -830,  13317,   -778,  13365,   -713,  13375,   -647,  13368,
  -583,  13377,   -517,  13366,   -459,  13397,   -390,  13394,   -345,  13476,
  -316,  13574,   -267,  13642,   -205,  13673,   -147,  13705,   -130,  13807,
  -105,  13912,    -66,  13990,     -8,  14047,     20,  14124,    -35,  14215,
   -54,  14315,    -49,  14415,    -16,  14507,     24,  14591,     66,  14674,
   103,  14765,    139,  14820,    180,  14932,    242,  14970,    311,  15001,
   378,  15030,    430,  15101,    492,  15153,    551,  15208,    587,  15292,
   590,  15396,    566,  15502,    558,  15608,    576,  15695,    636,  15764,
   695,  15831,    745,  15852,    824,  15806,    880,  15813,    935,  15808,
   993,  15738,   1064,  15694,   1131,  15688,   1203,  15740,   1247,  15816,
  1305,  15882,   1366,  15930,   1439,  15960,   1492,  16027,   1537,  16108,
  1600,  16164,   1672,  16139,   1734,  16090,   1796,  16041,   1855,  15983,
  1872,  15882,   1898,  15787,   1916,  15686,   1943,  15615,   1995,  15544,
  2036,  15450,   2100,  15409,   2148,  15325,   2202,  15260,   2244,  15178,
  2297,  15101,   2356,  15047,   2411,  15021,   2480,  15007,   2533,  14943,
  2574,  14862,   2629,  14797,   2700,  14775,   2723,  14669,   2768,  14596,
  2829,  14572,   2871,  14501,   2891,  14401,   2919,  14306,   2935,  14204,
  2936,  14111,   2892,  14042,   2870,  13941,   2848,  13853,   2895,  13804,
  2940,  13861,   2981,  13944,   3015,  14024,   3026,  14124,   3091,  14167,
  3121,  14225,   3111,  14334,   3060,  14405,   3009,  14469,   3026,  14575,
  3056,  14669,   3106,  14738,   3152,  14708,   3225,  14667,   3271,  14602,
  3301,  14518,   3349,  14529,   3359,  14636,   3317,  14721,   3268,  14793,
  3206,  14845,   3150,  14905,   3090,  14959,   3026,  14998,   2964,  15043,
  2905,  15117,   2927,  15233,   2846,  15258,   2776,  15259,   2712,  15297,
  2660,  15362,   2607,  15434,   2560,  15514,   2532,  15609,   2513,  15711,
  2487,  15810,   2445,  15881,   2384,  15944,   2325,  16005,   2270,  16071,
  2240,  16166,   2232,  16272,   2259,  16361,   2227,  16476,   2267,  16561,
  2335,  16591,   2397,  16642,   2470,  16639,   2481,  16571,   2474,  16468,
  2499,  16379,   2547,  16343,   2586,  16429,   2635,  16487,   2695,  16414,
  2711,  16317,   2735,  16222,   2787,  16147,   2781,  16098,   2824,  15980,
  2882,  15910,   2926,  15840,   3000,  15836,   3071,  15789,   3125,  15721,
  3183,  15650,   3194,  15620,   3136,  15640,   3233,  15578,   3294,  15526,
  3355,  15457,   3402,  15424,   3462,  15339,   3505,  15258,   3562,  15186,
  3543,  15097,   3544,  14993,   3539,  14892,   3529,  14770,   3532,  14687,
  3587,  14598,   3631,  14525,   3656,  14431,   3687,  14352,   3736,  14267,
  3791,  14208,   3819,  14172,   3797,  14102,   3837,  14004,   3874,  13970,
  3931,  13954,   4010,  13969,   4077,  13967,   4135,  13941,   4180,  13866,
  4074,  13887,   4015,  13931,   3958,  13924,   3894,  13881,   3859,  13784,
  3898,  13694,   3942,  13604,   3934,  13493,   3979,  13415,   4036,  13444,
  4069,  13349,   4092,  13307,   4144,  13373,   4188,  13293,   4207,  13304,
  4196,  13406,   4175,  13511,   4147,  13607,   4167,  13658,   4222,  13603,
  4255,  13666,   4210,  13744,   4211,  13808,   4283,  13827,   4334,  13765,
  4375,  13757,   4373,  13886,   4327,  13954,   4271,  14012,   4222,  14068,
  4157,  14117,   4134,  14154,   4177,  14229,   4186,  14305,   4221,  14271,
  4181,  14408,   4147,  14501,   4111,  14592,   4118,  14706,   4160,  14751,
  4211,  14666,   4251,  14582,   4285,  14567,   4282,  14649,   4336,  14577,
  4358,  14587,   4341,  14674,   4396,  14668,   4332,  14774,   4349,  14834,
  4416,  14855,   4471,  14891,   4535,  14896,   4591,  14908,   4661,  14875,
  4731,  14849,   4775,  14779,   4849,  14789,   4855,  14752,   4790,  14690,
  4794,  14624,   4864,  14726,   4926,  14778,   4979,  14842,   5024,  14918,
  5094,  14930,   5163,  14941,   5218,  14924,   5281,  14981,   5221,  15047,
  5158,  15095,   5111,  15168,   5096,  15266,   5064,  15365,   5021,  15446,
  5035,  15517,   5076,  15589,   5084,  15703,   5127,  15788,   5192,  15828,
  5205,  15945,   5215,  16052,   5224,  16149,   5251,  16242,   5286,  16324,
  5377,  16329,   5400,  16435,   5405,  16538,   5411,  16632,   5459,  16657,
  5537,  16757,   5580,  16847,   5615,  16936,   5691,  16969,   5746,  17001,
  5807,  17026,   5802,  17118,   5798,  17144,   5819,  17030,   5860,  16958,
  5896,  16942,   5787,  16938,   5769,  16924,   5815,  16858,   5886,  16791,
  5963,  16786,   6041,  16796,   6110,  16763,   6116,  16697,   6042,  16652,
  5976,  16597,   5944,  16519,   6032,  16463,   6097,  16419,   6110,  16319,
  6098,  16217,   6166,  16160,   6232,  16203,   6282,  16280,   6353,  16312,
  6415,  16352,   6473,  16407,   6552,  16385,   6620,  16416,   6634,  16523,
  6540,  16530,   6472,  16497,   6412,  16552,   6372,  16641,   6345,  16739,
  6360,  16829,   6411,  16849,   6494,  16939,   6567,  16980,   6627,  17000,
  6700,  17013,   6779,  17075,   6841,  17128,   6924,  17135,   6993,  17166,
  7047,  17180,   7144,  17171,   7113,  17107,   7042,  17063,   6991,  17005,
  6906,  16977,   6881,  16938,   6929,  16874,   6993,  16805,   6984,  16772,
  6936,  16730,   6908,  16711,   6852,  16576,   6842,  16501,   6763,  16490,
  6698,  16498,   6687,  16424,   6766,  16371,   6808,  16287,   6879,  16256,
  6934,  16194,   6997,  16143,   7062,  16100,   7117,  16031,   7169,  15957,
  7218,  15878,   7271,  15807,   7329,  15738,   7388,  15690,   7454,  15649,
  7504,  15578,   7553,  15509,   7571,  15406,   7592,  15305,   7595,  15199,
  7556,  15112,   7507,  15043,   7444,  14995,   7382,  14945,   7314,  14906,
  7245,  14919,   7177,  14949,   7108,  14942,   7039,  14911,   6973,  14898,
  6902,  14925,   6845,  14954,   6775,  14974,   6721,  15032,   6654,  15036,
  6596,  15059,   6553,  15165,   6490,  15161,   6424,  15190,   6391,  15284,
  6342,  15289,   6273,  15270,   6202,  15277,   6131,  15283,   6060,  15285,
  5993,  15249,   5925,  15216,   5866,  15168,   5806,  15110,   5745,  15058,
  5701,  14985,   5632,  14953,   5565,  14973,   5498,  14985,   5427,  14980,
  5359,  14997,   5297,  14978,   5310,  14886,   5362,  14843,   5403,  14823,
  5303,  14797,   5267,  14727,   5195,  14700,   5128,  14702,   5066,  14715,
  4988,  14691,   4932,  14715,   4865,  14692,   4812,  14622,   4769,  14540,
  4757,  14436,   4775,  14370,   4848,  14394,   4885,  14362,   4864,  14277,
  4901,  14163,   4881,  14063,   4883,  13987,   4811,  14021,   4811,  13918,
  4890,  13869,   4950,  13813,   4941,  13708,   4966,  13612,   4998,  13536,
  4983,  13468,   5052,  13469,   5117,  13479,   5124,  13449,   5081,  13397,
  5032,  13368,   5120,  13360,   5193,  13393,   5259,  13348,   5294,  13300,
  5329,  13209,   5390,  13169,   5446,  13178,   5513,  13201,   5551,  13248,
  5564,  13351,   5599,  13415,   5666,  13407,   5727,  13375,   5786,  13325,
  5842,  13274,   5882,  13190,   5934,  13130,   5999,  13131,   6060,  13153,
  6123,  13165,   6181,  13210,   6227,  13293,   6277,  13363,   6337,  13386,
  6395,  13338,   6458,  13317,   6494,  13367,   6569,  13410,   6573,  13311,
  6525,  13229,   6540,  13123,   6522,  13025,   6517,  12929,   6539,  12825,
  6532,  12723,   6545,  12619,   6522,  12536,   6489,  12453,   6470,  12350,
  6445,  12255,   6419,  12160,   6397,  12066,   6375,  11962,   6354,  11868,
  6341,  11765,   6324,  11664,   6300,  11568,   6268,  11479,   6226,  11402,
  6173,  11350,   6113,  11329,   6049,  11323,   6001,  11320,   5957,  11314,
  5886,  11332,   5884,  11196,   5884,  11107,

/* 1 */
2737, 1,
-23322,  19199, -23345,  19079, -23308,  19107, -23282,  19072, -23227,  19050,
-23128,  19176, -23145,  19106, -23082,  19009, -23113,  19017, -23198,  18976,
-23243,  18923, -23241,  18789, -23123,  18824, -23166,  18801, -23230,  18719,
-23175,  18684, -23218,  18644, -23159,  18537, -23100,  18533, -23011,  18535,
-22953,  18473, -22864,  18529, -22871,  18479, -22952,  18419, -22916,  18379,
-22843,  18400, -22770,  18382, -22732,  18491, -22723,  18479, -22745,  18352,
-22668,  18357, -22675,  18331, -22698,  18221, -22665,  18140, -22583,  18137,
-22554,  18229, -22542,  18208, -22524,  18095, -22542,  18066, -22545,  18016,
-22450,  18034, -22394,  17970, -22409,  17909, -22369,  17839, -22320,  17755,
-22306,  17655, -22283,  17545, -22255,  17467, -22271,  17352, -22277,  17242,
-22362,  17161, -22340,  17221, -22310,  17301, -22304,  17397, -22328,  17390,
-22385,  17272, -22387,  17314, -22346,  17397, -22352,  17496, -22420,  17523,
-22500,  17530, -22578,  17550, -22669,  17595, -22691,  17508, -22660,  17413,
-22630,  17316, -22611,  17218, -22575,  17098, -22557,  16966, -22574,  16886,
-22476,  16830, -22531,  16814, -22556,  16748, -22554,  16643, -22553,  16546,
-22562,  16435, -22573,  16332, -22575,  16219, -22585,  16123, -22590,  16017,
-22595,  15914, -22614,  15800, -22641,  15710, -22659,  15604, -22642,  15503,
-22640,  15398, -22613,  15300, -22599,  15199, -22579,  15097, -22588,  14989,
-22593,  14873, -22617,  14803, -22629,  14688, -22589,  14601, -22547,  14520,
-22525,  14419, -22526,  14312, -22511,  14207, -22482,  14120, -22438,  14038,
-22377,  13924, -22371,  13856, -22316,  13793, -22280,  13843, -22209,  13867,
-22138,  13860, -22145,  13852, -22215,  13852, -22262,  13806, -22227,  13687,
-22271,  13711, -22279,  13622, -22261,  13522, -22208,  13459, -22165,  13395,
-22185,  13304, -22165,  13199, -22120,  13119, -22085,  13031, -22043,  12957,
-21998,  12873, -21965,  12790, -21953,  12687, -21940,  12581, -21882,  12548,
-21819,  12534, -21757,  12519, -21700,  12451, -21652,  12401, -21590,  12390,
-21548,  12314, -21503,  12281, -21445,  12218, -21397,  12152, -21359,  12069,
-21342,  11968, -21326,  11883, -21301,  11772, -21269,  11679, -21234,  11582,
-21226,  11486, -21189,  11400, -21167,  11299, -21131,  11217, -21112,  11095,
-21083,  11031, -21071,  10920, -21045,  10826, -20999,  10761, -20947,  10708,
-20897,  10647, -20857,  10566, -20817,  10494, -20777,  10419, -20771,  10316,
-20777,  10208, -20774,  10111, -20797,  10108, -20845,  10116, -20915,  10129,
-20912,  10076, -20866,  10009, -20830,   9924, -20781,   9874, -20730,   9820,
-20676,   9755, -20610,   9765, -20575,   9689, -20527,   9620, -20476,   9572,
-20440,   9499, -20405,   9358, -20397,   9304, -20399,   9202, -20407,   9090,
-20385,   9024, -20338,   8941, -20288,   8867, -20246,   8815, -20199,   8756,
-20158,   8684, -20114,   8617, -20072,   8551, -20046,   8458, -20026,   8353,
-19977,   8358, -19932,   8427, -19916,   8525, -19950,   8607, -19979,   8699,
-20009,   8769, -20070,   8819, -20118,   8829, -20149,   8910, -20146,   9014,
-20162,   9109, -20191,   9197, -20217,   9292, -20252,   9379, -20264,   9478,
-20278,   9581, -20297,   9674, -20341,   9729, -20372,   9773, -20394,   9866,
-20431,   9945, -20463,  10038, -20507,  10105, -20523,  10204, -20540,  10309,
-20578,  10375, -20610,  10476, -20652,  10540, -20682,  10636, -20719,  10718,
-20764,  10789, -20810,  10855, -20849,  10937, -20865,  11035, -20869,  11140,
-20881,  11246, -20905,  11337, -20904,  11444, -20912,  11583, -20878,  11573,
-20825,  11520, -20758,  11486, -20710,  11489, -20670,  11413, -20607,  11373,
-20579,  11309, -20583,  11207, -20558,  11112, -20532,  11020, -20516,  10914,
-20489,  10822, -20458,  10730, -20430,  10653, -20406,  10549, -20366,  10468,
-20331,  10379, -20284,  10313, -20249,  10226, -20193,  10164, -20140,  10146,
-20128,  10065, -20110,   9954, -20067,   9886, -20010,   9834, -19981,   9737,
-19927,   9718, -19881,   9621, -19877,   9556, -19913,   9452, -19895,   9346,
-19833,   9346, -19835,   9314, -19817,   9282, -19776,   9232, -19699,   9142,
-19675,   9074, -19658,   9020, -19601,   8916, -19585,   8874, -19539,   8811,
-19494,   8745, -19455,   8669, -19423,   8583, -19385,   8502, -19353,   8421,
-19308,   8338, -19271,   8270, -19241,   8186, -19227,   8083, -19219,   7981,
-19191,   7887, -19153,   7808, -19154,   7694, -19190,   7598, -19169,   7521,
-19209,   7454, -19221,   7381, -19201,   7283, -19169,   7194, -19132,   7115,
-19094,   7032, -19050,   6983, -18996,   6943, -18949,   6892, -18903,   6837,
-18865,   6761, -18830,   6677, -18779,   6634, -18727,   6599, -18675,   6568,
-18622,   6541, -18568,   6538, -18520,   6491, -18481,   6416, -18436,   6358,
-18391,   6298, -18342,   6252, -18290,   6218, -18239,   6179, -18185,   6136,
-18141,   6084, -18086,   6064, -18033,   6043, -17980,   6014, -17936,   5946,
-17872,   5904, -17830,   5861, -17786,   5812, -17731,   5800, -17678,   5781,
-17628,   5733, -17574,   5704, -17520,   5710, -17470,   5748, -17419,   5787,
-17367,   5824, -17321,   5882, -17273,   5922, -17235,   5927, -17190,   5888,
-17127,   5845, -17160,   5890, -17129,   5887, -17086,   5828, -17042,   5759,
-17000,   5693, -16959,   5625, -16901,   5533, -16881,   5481, -16844,   5405,
-16807,   5330, -16766,   5261, -16724,   5195, -16679,   5137, -16631,   5091,
-16579,   5067, -16524,   5069, -16471,   5059, -16421,   5021, -16372,   4976,
-16328,   4925, -16272,   4911, -16221,   4879, -16136,   4818, -16110,   4820,
-16073,   4797, -16010,   4796, -15973,   4867, -15923,   4858, -15897,   4740,
-15936,   4730, -15931,   4662, -15897,   4598, -15859,   4533, -15814,   4467,
-15780,   4390, -15750,   4304, -15712,   4231, -15671,   4165, -15631,   4096,
-15613,   3990, -15596,   3900, -15609,   3821, -15622,   3729, -15597,   3631,
-15552,   3586, -15502,   3518, -15461,   3568, -15504,   3679, -15476,   3681,
-15431,   3623, -15406,   3530, -15375,   3467, -15323,   3432, -15276,   3382,
-15235,   3317, -15217,   3218, -15228,   3123, -15176,   3063, -15176,   3139,
-15143,   3136, -15125,   3053, -15093,   2962, -15079,   2979, -15039,   3022,
-14990,   3026, -14947,   2994, -14886,   2964, -14857,   2891, -14830,   2809,
-14768,   2828, -14735,   2744, -14716,   2644, -14661,   2635, -14616,   2687,
-14570,   2739, -14596,   2837, -14633,   2915, -14631,   3005, -14580,   3042,
-14531,   3113, -14509,   3200, -14471,   3256, -14399,   3299, -14375,   3257,
-14326,   3194, -14280,   3095, -14235,   3081, -14179,   3000, -14226,   3016,
-14263,   2925, -14249,   2821, -14223,   2736, -14188,   2656, -14148,   2581,
-14130,   2496, -14093,   2418, -14087,   2306, -14089,   2216, -14065,   2125,
-14093,   2030, -14084,   1949, -14081,   1841, -14070,   1728, -14075,   1630,
-14077,   1500, -14050,   1432, -14041,   1359, -14070,   1265, -14098,   1187,
-14133,   1082, -14150,   1005, -14181,    940, -14230,    916, -14284,    889,
-14314,    809, -14310,    691, -14369,    621, -14350,    510, -14377,    432,
-14426,    396, -14486,    350, -14526,    332, -14570,    268, -14565,    149,
-14571,     49, -14600,    -38, -14638,   -114, -14633,   -219, -14668,   -315,
-14716,   -371, -14704,   -478, -14710,   -583, -14697,   -690, -14722,   -787,
-14714,   -850, -14669,   -903, -14619,   -969, -14565,   -901, -14538,   -887,
-14534,   -773, -14530,   -782, -14522,   -891, -14521,   -985, -14538,  -1085,
-14564,  -1176, -14611,  -1224, -14653,  -1286, -14696,  -1350, -14730,  -1428,
-14765,  -1506, -14795,  -1591, -14800,  -1697, -14770,  -1803, -14771,  -1900,
-14735,  -1984, -14721,  -2084, -14762,  -2144, -14749,  -2234, -14704,  -2292,
-14657,  -2341, -14610,  -2390, -14566,  -2449, -14534,  -2532, -14503,  -2616,
-14482,  -2713, -14458,  -2807, -14429,  -2894, -14391,  -2965, -14364,  -3057,
-14337,  -3147, -14321,  -3249, -14299,  -3343, -14274,  -3432, -14253,  -3532,
-14236,  -3630, -14217,  -3726, -14190,  -3816, -14161,  -3905, -14137,  -3998,
-14125,  -4100, -14083,  -4172, -14052,  -4258, -14040,  -4367, -14012,  -4448,
-13977,  -4531, -13951,  -4622, -13925,  -4712, -13898,  -4801, -13870,  -4890,
-13879,  -5006, -13891,  -5075, -13869,  -5172, -13838,  -5258, -13809,  -5345,
-13764,  -5406, -13727,  -5481, -13690,  -5561, -13654,  -5629, -13606,  -5678,
-13558,  -5729, -13512,  -5781, -13467,  -5835, -13421,  -5894, -13369,  -5928,
-13322,  -5976, -13271,  -6024, -13221,  -6064, -13171,  -6107, -13131,  -6177,
-13085,  -6234, -13034,  -6280, -12996,  -6347, -12977,  -6444, -12930,  -6508,
-12887,  -6573, -12843,  -6636, -12803,  -6712, -12802,  -6820, -12795,  -6925,
-12788,  -7029, -12775,  -7131, -12766,  -7234, -12766,  -7340, -12773,  -7442,
-12775,  -7551, -12766,  -7654, -12754,  -7757, -12760,  -7857, -12770,  -7962,
-12779,  -8065, -12786,  -8171, -12793,  -8274, -12814,  -8377, -12844,  -8436,
-12838,  -8541, -12820,  -8625, -12832,  -8725, -12836,  -8832, -12843,  -8936,
-12838,  -9040, -12825,  -9141, -12831,  -9244, -12860,  -9329, -12863,  -9435,
-12860,  -9541, -12866,  -9640, -12881,  -9744, -12896,  -9849, -12911,  -9940,
-12913, -10047, -12940, -10138, -12950, -10239, -12960, -10343, -12982, -10438,
-13011, -10536, -13001, -10639, -12980, -10738, -12979, -10842, -12992, -10941,
-13028, -11021, -13049, -11116, -13047, -11222, -13041, -11327, -13032, -11432,
-13021, -11538, -13016, -11639, -13011, -11745, -13003, -11843, -13017, -11943,
-13045, -12041, -13047, -12145, -13044, -12249, -13078, -12339, -13102, -12437,
-13110, -12539, -13122, -12644, -13141, -12744, -13174, -12832, -13206, -12924,
-13218, -13025, -13248, -13119, -13259, -13224, -13290, -13330, -13314, -13401,
-13325, -13514, -13387, -13550, -13402, -13646, -13398, -13748, -13373, -13846,
-13380, -13952, -13371, -14073, -13353, -14155, -13331, -14261, -13332, -14360,
-13354, -14460, -13386, -14530, -13416, -14630, -13427, -14736, -13448, -14838,
-13462, -14937, -13446, -15044, -13412, -15129, -13401, -15172, -13342, -15208,
-13297, -15143, -13246, -15129, -13176, -15122, -13183, -15171, -13248, -15239,
-13204, -15304, -13186, -15402, -13220, -15391, -13227, -15453, -13242, -15495,
-13251, -15601, -13259, -15685, -13298, -15786, -13274, -15904, -13294, -15970,
-13317, -16076, -13244, -16165, -13221, -16200, -13249, -16293, -13311, -16354,
-13354, -16419, -13303, -16512, -13346, -16518, -13364, -16622, -13390, -16699,
-13405, -16811, -13376, -16790, -13377, -16817, -13432, -16921, -13453, -16843,
-13523, -16830, -13495, -16793, -13494, -16713, -13559, -16703, -13607, -16774,
-13656, -16839, -13709, -16897, -13748, -17022, -13738, -16992, -13666, -16945,
-13653, -16971, -13584, -17043, -13520, -17041, -13480, -17165, -13538, -17226,
-13510, -17332, -13560, -17339, -13560, -17386, -13488, -17400, -13424, -17350,
-13407, -17376, -13364, -17451, -13373, -17457, -13367, -17517, -13424, -17506,
-13501, -17504, -13548, -17485, -13556, -17514, -13489, -17602, -13503, -17692,
-13530, -17763, -13544, -17866, -13529, -17987, -13475, -17893, -13471, -17959,
-13437, -18069, -13461, -18056, -13509, -18091, -13482, -18167, -13487, -18242,
-13553, -18246, -13554, -18303, -13492, -18372, -13485, -18469, -13411, -18411,
-13417, -18470, -13479, -18546, -13444, -18632, -13419, -18733, -13411, -18815,
-13374, -18917, -13347, -18858, -13333, -18911, -13306, -18851, -13247, -18843,
-13290, -18760, -13247, -18775, -13201, -18876, -13210, -18964, -13223, -19073,
-13223, -19043, -13230, -18943, -13260, -18968, -13297, -18989, -13387, -18976,
-13399, -19020, -13394, -19141, -13321, -19128, -13311, -19147, -13350, -19242,
-13323, -19315, -13279, -19256, -13255, -19158, -13185, -19132, -13061, -19141,
-13116, -19171, -13208, -19219, -13269, -19256, -13270, -19363, -13219, -19449,
-13178, -19359, -13140, -19320, -13067, -19278, -12989, -19220, -12962, -19282,
-13024, -19354, -13075, -19458, -13073, -19432, -13121, -19411, -13175, -19443,
-13118, -19535, -13046, -19581, -12956, -19599, -12914, -19513, -12916, -19408,
-12895, -19301, -12869, -19197, -12794, -19161, -12714, -19117, -12652, -19064,
-12589, -19013, -12479, -19038, -12497, -18942, -12535, -18847, -12615, -18790,
-12588, -18774, -12561, -18712, -12596, -18592, -12600, -18543, -12580, -18441,
-12547, -18346, -12472, -18271, -12515, -18201, -12503, -18159, -12483, -18151,
-12430, -18231, -12355, -18189, -12327, -18093, -12321, -17969, -12309, -17889,
-12266, -17801, -12215, -17722, -12152, -17660, -12086, -17597, -12024, -17523,
-12021, -17431, -12003, -17380, -11968, -17290, -11975, -17185, -12035, -17138,
-12112, -17127, -12176, -17075, -12228, -17000, -12280, -16923, -12303, -16823,
-12290, -16724, -12255, -16633, -12216, -16542, -12167, -16466, -12103, -16425,
-12031, -16376, -11957, -16378, -11949, -16293, -11899, -16201, -11880, -16104,
-11876, -16003, -11885, -15898, -11848, -15806, -11804, -15725, -11729, -15670,
-11749, -15629, -11811, -15555, -11752, -15480, -11695, -15524, -11657, -15600,
-11588, -15565, -11573, -15462, -11590, -15358, -11668, -15365, -11682, -15438,
-11746, -15413, -11802, -15355, -11839, -15271, -11832, -15167, -11843, -15066,
-11859, -14963, -11836, -14853, -11796, -14848, -11730, -14891, -11665, -14933,
-11604, -14979, -11533, -14981, -11465, -14969, -11402, -14925, -11338, -14836,
-11345, -14759, -11360, -14650, -11344, -14545, -11311, -14477, -11308, -14341,
-11336, -14277, -11339, -14157, -11282, -14174, -11213, -14195, -11145, -14193,
-11079, -14186, -11011, -14170, -10945, -14151, -10878, -14132, -10813, -14105,
-10747, -14081, -10684, -14046, -10620, -14012, -10560, -13967, -10504, -13913,
-10470, -13829, -10444, -13734, -10400, -13655, -10366, -13564, -10331, -13475,
-10314, -13377, -10323, -13257, -10372, -13223, -10423, -13151, -10442, -13051,
-10416, -12955, -10408, -12863, -10449, -12781, -10500, -12719, -10556, -12668,
-10612, -12615, -10646, -12530, -10635, -12450, -10639, -12348, -10654, -12246,
-10641, -12141, -10615, -12051, -10585, -11977, -10594, -11863, -10584, -11875,
-10571, -11978, -10603, -12058, -10626, -12149, -10635, -12251, -10623, -12353,
-10583, -12435, -10540, -12515, -10491, -12544, -10428, -12539, -10374, -12582,
-10322, -12638, -10263, -12680, -10206, -12700, -10141, -12664, -10076, -12681,
-10014, -12712,  -9955, -12692,  -9887, -12619,  -9845, -12593,  -9796, -12518,
 -9762, -12429,  -9735, -12337,  -9696, -12257,  -9650, -12186,  -9605, -12112,
 -9571, -12025,  -9548, -11927,  -9530, -11827,  -9494, -11716,  -9498, -11643,
 -9481, -11522,  -9458, -11437,  -9412, -11373,  -9372, -11296,  -9342, -11192,
 -9323, -11092,  -9326, -10994,  -9304, -11007,  -9232, -11045,  -9225, -11120,
 -9243, -11216,  -9283, -11299,  -9312, -11374,  -9342, -11463,  -9380, -11522,
 -9458, -11628,  -9424, -11607,  -9372, -11551,  -9325, -11482,  -9282, -11407,
 -9243, -11327,  -9209, -11239,  -9178, -11150,  -9149, -11057,  -9130, -10958,
 -9107, -10859,  -9080, -10765,  -9048, -10677,  -9012, -10592,  -8971, -10517,
 -8925, -10452,  -8884, -10362,  -8857, -10283,  -8845, -10177,  -8847, -10074,
 -8845,  -9970,  -8837,  -9877,  -8850,  -9758,  -8854,  -9655,  -8867,  -9541,
 -8850,  -9424,  -8818,  -9343,  -8848,  -9279,  -8825,  -9239,  -8782,  -9221,
 -8732,  -9154,  -8722,  -9095,  -8672,  -9018,  -8622,  -8970,  -8572,  -8906,
 -8536,  -8832,  -8486,  -8776,  -8426,  -8718,  -8385,  -8676,  -8329,  -8655,
 -8272,  -8647,  -8228,  -8572,  -8184,  -8522,  -8125,  -8497,  -8125,  -8451,
 -8103,  -8377,  -8056,  -8371,  -7983,  -8373,  -7938,  -8390,  -7877,  -8371,
 -7860,  -8293,  -7838,  -8323,  -7791,  -8361,  -7735,  -8351,  -7666,  -8354,
 -7635,  -8287,  -7626,  -8187,  -7584,  -8115,  -7531,  -8075,  -7479,  -8033,
 -7461,  -7951,  -7468,  -7845,  -7454,  -7743,  -7430,  -7647,  -7396,  -7572,
 -7357,  -7497,  -7335,  -7391,  -7309,  -7300,  -7286,  -7210,  -7246,  -7137,
 -7226,  -7038,  -7230,  -6933,  -7233,  -6827,  -7227,  -6724,  -7210,  -6623,
 -7177,  -6537,  -7135,  -6465,  -7133,  -6363,  -7134,  -6257,  -7124,  -6155,
 -7114,  -6051,  -7101,  -5948,  -7086,  -5848,  -7079,  -5744,  -7091,  -5640,
 -7098,  -5535,  -7102,  -5424,  -7107,  -5326,  -7098,  -5220,  -7096,  -5111,
 -7106,  -5018,  -7108,  -4926,  -7085,  -4827,  -7068,  -4678,  -7042,  -4619,
 -7005,  -4698,  -6963,  -4684,  -6928,  -4604,  -6899,  -4517,  -6868,  -4431,
 -6842,  -4339,  -6815,  -4215,  -6800,  -4125,  -6769,  -4046,  -6737,  -3980,
 -6702,  -3902,  -6656,  -3845,  -6614,  -3787,  -6582,  -3704,  -6547,  -3627,
 -6521,  -3526,  -6477,  -3466,  -6443,  -3387,  -6412,  -3300,  -6391,  -3205,
 -6372,  -3107,  -6357,  -3007,  -6344,  -2908,  -6345,  -2791,  -6338,  -2713,
 -6343,  -2583,  -6352,  -2500,  -6363,  -2396,  -6382,  -2281,  -6391,  -2195,
 -6404,  -2093,  -6421,  -1993,  -6448,  -1902,  -6495,  -1857,  -6548,  -1844,
 -6601,  -1856,  -6654,  -1855,  -6702,  -1824,  -6752,  -1791,  -6791,  -1723,
 -6838,  -1679,  -6878,  -1610,  -6919,  -1544,  -6955,  -1465,  -6993,  -1382,
 -7035,  -1334,  -7078,  -1272,  -7121,  -1214,  -7167,  -1162,  -7216,  -1111,
 -7260,  -1060,  -7308,  -1031,  -7362,  -1022,  -7415,  -1038,  -7468,  -1050,
 -7517,  -1069,  -7571,  -1050,  -7625,  -1009,  -7675,  -1022,  -7726,   -993,
 -7771,   -945,  -7818,   -902,  -7870,   -870,  -7918,   -903,  -7967,   -927,
 -8038,  -1003,  -8022,   -915,  -8056,   -912,  -8076,   -979,  -8093,  -1082,
 -8135,  -1167,  -8136,  -1142,  -8129,  -1044,  -8115,   -940,  -8090,   -843,
 -8131,   -844,  -8128,   -804,  -8108,   -709,  -8144,   -630,  -8182,   -560,
 -8240,   -583,  -8271,   -511,  -8316,   -462,  -8355,   -438,  -8400,   -395,
 -8441,   -380,  -8494,   -336,  -8540,   -292,  -8589,   -252,  -8636,   -250,
 -8692,   -253,  -8746,   -273,  -8777,   -378,  -8799,   -454,  -8816,   -551,
 -8853,   -553,  -8896,   -620,  -8936,   -681,  -8970,   -756,  -8991,   -853,
 -9020,   -952,  -9023,   -921,  -9006,   -819,  -9009,   -693,  -9068,   -716,
 -9113,   -676,  -9168,   -722,  -9212,   -670,  -9230,   -585,  -9249,   -489,
 -9258,   -393,  -9277,   -351,  -9319,   -421,  -9360,   -473,  -9411,   -524,
 -9457,   -577,  -9508,   -588,  -9570,   -574,  -9560,   -546,  -9511,   -503,
 -9460,   -485,  -9428,   -398,  -9411,   -305,  -9384,   -210,  -9354,   -135,
 -9329,    -39,  -9285,     22,  -9241,     78,  -9205,    156,  -9176,    245,
 -9140,    322,  -9101,    390,  -9081,    477,  -9088,    580,  -9128,    643,
 -9180,    669,  -9225,    763,  -9232,    853,  -9250,    944,  -9268,   1047,
 -9286,   1149,  -9294,   1253,  -9305,   1372,  -9316,   1460,  -9363,   1559,
 -9369,   1479,  -9386,   1493,  -9407,   1563,  -9446,   1635,  -9474,   1712,
 -9519,   1767,  -9557,   1840,  -9598,   1910,  -9638,   1980,  -9689,   2008,
 -9740,   2037,  -9789,   2086,  -9838,   2007,  -9834,   2059,  -9855,   2131,
 -9907,   2153,  -9959,   2172, -10016,   2179, -10010,   2142, -10017,   2132,
-10062,   2158, -10115,   2174, -10169,   2122, -10208,   2123, -10259,   2153,
-10311,   2168, -10366,   2174, -10404,   2054, -10404,   2104, -10405,   2206,
-10446,   2288, -10481,   2331, -10519,   2404, -10562,   2472, -10614,   2499,
-10662,   2384, -10666,   2448, -10649,   2548, -10643,   2653, -10674,   2750,
-10707,   2819, -10745,   2892, -10786,   2955, -10845,   3009, -10883,   3041,
-10924,   3109, -10977,   3137, -11026,   3115, -11082,   3120, -11122,   3080,
-11193,   3106, -11161,   3130, -11130,   3194, -11109,   3307, -11076,   3377,
-11091,   3458, -11139,   3492, -11196,   3570, -11242,   3544, -11306,   3591,
-11338,   3587, -11372,   3679, -11434,   3667, -11409,   3697, -11449,   3786,
-11424,   3841, -11370,   3838, -11292,   3883, -11329,   3895, -11383,   3907,
-11436,   3903, -11491,   3898, -11542,   3882, -11600,   3880, -11674,   3862,
-11624,   3830, -11655,   3806, -11712,   3772, -11752,   3726, -11792,   3686,
-11850,   3666, -11901,   3690, -11965,   3728, -11998,   3756, -12032,   3839,
-12079,   3868, -12134,   3867, -12187,   3860, -12240,   3841, -12293,   3830,
-12348,   3814, -12401,   3827, -12430,   3916, -12434,   3992, -12464,   4085,
-12512,   4143, -12564,   4171, -12616,   4189, -12671,   4190, -12701,   4277,
-12713,   4380, -12753,   4424, -12787,   4350, -12775,   4255, -12711,   4220,
-12749,   4183, -12785,   4137, -12835,   4100, -12889,   4079, -12937,   4034,
-12994,   3985, -13017,   3904, -13007,   3799, -12979,   3709, -12949,   3619,
-12933,   3523, -12939,   3412, -12973,   3330, -13023,   3296, -13059,   3356,
-13081,   3433, -13103,   3488, -13117,   3596, -13089,   3689, -13056,   3773,
-13032,   3861, -13048,   3979, -13061,   4046, -13090,   4133, -13083,   4225,
-13028,   4258, -12984,   4306, -12950,   4393, -12975,   4489, -13039,   4523,
-13083,   4470, -13125,   4438, -13150,   4339, -13196,   4287, -13246,   4247,
-13290,   4186, -13333,   4124, -13385,   4103, -13439,   4109, -13491,   4119,
-13513,   4026, -13555,   3932, -13550,   3980, -13553,   4002, -13607,   4035,
-13649,   3996, -13692,   3922, -13736,   3842, -13757,   3741, -13756,   3661,
-13768,   3549, -13779,   3442, -13824,   3420, -13861,   3353, -13891,   3263,
-13933,   3198, -13985,   3125, -13972,   3026, -13971,   2915, -13994,   2941,
-14021,   3019, -14060,   3097, -14099,   3166, -14138,   3231, -14174,   3310,
-14219,   3368, -14269,   3406, -14319,   3431, -14376,   3449, -14421,   3474,
-14478,   3487, -14523,   3424, -14562,   3381, -14613,   3333, -14664,   3301,
-14709,   3245, -14758,   3206, -14811,   3198, -14884,   3289, -14911,   3256,
-14961,   3300, -14981,   3370, -15011,   3458, -15057,   3517, -15094,   3586,
-15128,   3659, -15164,   3742, -15193,   3830, -15215,   3924, -15242,   4004,
-15262,   4107, -15240,   4199, -15239,   4295, -15239,   4390, -15229,   4479,
-15223,   4605, -15216,   4553, -15200,   4547, -15200,   4664, -15205,   4767,
-15207,   4872, -15197,   4975, -15183,   5076, -15153,   5164, -15145,   5261,
-15167,   5368, -15156,   5416, -15153,   5487, -15208,   5558, -15261,   5569,
-15289,   5624, -15298,   5693, -15362,   5762, -15395,   5761, -15448,   5809,
-15500,   5796, -15554,   5788, -15604,   5815, -15650,   5808, -15707,   5755,
-15760,   5749, -15814,   5741, -15869,   5755, -15929,   5769, -15982,   5783,
-16027,   5731, -16074,   5746, -16122,   5763, -16172,   5808, -16136,   5909,
-16089,   6006, -16074,   6058, -16061,   6158, -16068,   6260, -16060,   6370,
-16056,   6469, -16038,   6568, -16047,   6669, -16074,   6705, -16043,   6819,
-16023,   6768, -15997,   6669, -15978,   6686, -15964,   6788, -15947,   6892,
-15939,   7009, -15935,   7113, -15928,   7216, -15917,   7273, -15906,   7374,
-15874,   7460, -15834,   7535, -15805,   7625, -15797,   7720, -15817,   7814,
-15877,   7841, -15916,   7816, -15969,   7836, -16036,   7859, -16082,   7849,
-16136,   7821, -16188,   7788, -16244,   7770, -16300,   7757, -16355,   7736,
-16406,   7692, -16448,   7608, -16463,   7523, -16468,   7418, -16468,   7311,
-16487,   7223, -16509,   7131, -16523,   7030, -16565,   6958, -16625,   6881,
-16616,   6806, -16650,   6730, -16714,   6729, -16739,   6778, -16796,   6801,
-16859,   6758, -16898,   6731, -16951,   6701, -17040,   6692, -17064,   6662,
-17112,   6642, -17165,   6614, -17215,   6634, -17250,   6721, -17298,   6771,
-17347,   6809, -17407,   6816, -17446,   6847, -17480,   6949, -17516,   7027,
-17537,   7121, -17555,   7225, -17587,   7311, -17623,   7391, -17660,   7470,
-17689,   7558, -17712,   7654, -17734,   7751, -17759,   7839, -17786,   7979,
-17768,   7946, -17730,   7813, -17727,   7875, -17766,   7954, -17791,   8048,
-17803,   8152, -17808,   8251, -17791,   8349, -17793,   8466, -17789,   8599,
-17790,   8671, -17783,   8782, -17776,   8888, -17764,   8991, -17750,   9093,
-17728,   9191, -17701,   9285, -17684,   9386, -17693,   9480, -17720,   9579,
-17735,   9669, -17750,   9779, -17740,   9872, -17777,   9944, -17753,   9951,
-17717,  10008, -17724,  10111, -17708,  10140, -17674,  10212, -17641,  10260,
-17592,  10339, -17563,  10423, -17504,  10415, -17454,  10426, -17421,  10461,
-17367,  10507, -17322,  10589, -17278,  10677, -17289,  10768, -17265,  10819,
-17229,  10767, -17229,  10725, -17225,  10717, -17170,  10764, -17108,  10801,
-17090,  10873, -17070,  10849, -17002,  10838, -16943,  10829, -16887,  10789,
-16829,  10761, -16769,  10795, -16726,  10841, -16675,  10797, -16625,  10753,
-16601,  10688, -16586,  10637, -16531,  10610, -16478,  10651, -16423,  10625,
-16397,  10710, -16348,  10704, -16300,  10652, -16254,  10579, -16213,  10617,
-16257,  10688, -16311,  10741, -16300,  10812, -16269,  10890, -16292,  10918,
-16332,  10940, -16374,  10950, -16441,  10957, -16423,  11043, -16366,  11020,
-16309,  10986, -16256,  11033, -16191,  11065, -16139,  11054, -16078,  11053,
-16023,  11122, -15994,  11038, -15979,  11006, -15919,  11047, -15872,  11083,
-15841,  11089, -15782,  11072, -15711,  11078, -15668,  11030, -15588,  10984,
-15566,  10922, -15533,  10835, -15464,  10826, -15414,  10854, -15360,  10908,
-15312,  10952, -15253,  10914, -15210,  10841, -15175,  10759, -15135,  10677,
-15087,  10614, -15052,  10537, -15042,  10448, -15051,  10331, -15066,  10234,
-15070,  10129, -15047,  10138, -15011,  10139, -15038,  10022, -15026,   9945,
-15002,   9842, -14954,   9795, -14916,   9699, -14908,   9632, -14888,   9523,
-14861,   9441, -14807,   9384, -14779,   9294, -14754,   9195, -14719,   9154,
-14656,   9174, -14626,   9226, -14612,   9328, -14585,   9414, -14578,   9523,
-14570,   9633, -14567,   9735, -14579,   9833, -14605,   9918, -14624,  10032,
-14645,  10130, -14669,  10225, -14692,  10323, -14708,  10430, -14692,  10430,
-14670,  10349, -14665,  10248, -14658,  10204, -14664,  10354, -14682,  10450,
-14714,  10544, -14741,  10635, -14764,  10732, -14785,  10832, -14800,  10931,
-14813,  11035, -14826,  11136, -14831,  11264, -14815,  11338, -14799,  11435,
-14777,  11526, -14745,  11607, -14705,  11698, -14705,  11791, -14686,  11787,
-14657,  11804, -14611,  11845, -14550,  11913, -14501,  11962, -14456,  12028,
-14420,  12111, -14388,  12196, -14346,  12276, -14290,  12333, -14229,  12342,
-14183,  12392, -14153,  12476, -14101,  12558, -14072,  12615, -14012,  12636,
-13924,  12695, -13990,  12745, -13959,  12752, -13937,  12828, -13999,  12901,
-13992,  12908, -13925,  12901, -13861,  12879, -13809,  12947, -13790,  13040,
-13830,  13027, -13843,  13054, -13886,  13089, -13936,  13123, -13957,  13143,
-13878,  13167, -13820,  13177, -13814,  13223, -13827,  13304, -13810,  13303,
-13794,  13202, -13766,  13083, -13767,  13108, -13791,  13205, -13807,  13307,
-13830,  13412, -13898,  13433, -13948,  13499, -14025,  13568, -13994,  13564,
-13912,  13502, -13944,  13600, -13909,  13592, -13887,  13648, -13932,  13715,
-14002,  13844, -13971,  13798, -13914,  13720, -13886,  13781, -13935,  13860,
-13999,  13916, -14055,  13973, -14035,  14096, -14040,  14014, -13988,  13949,
-13914,  13886, -13930,  13990, -13924,  14051, -13924,  14171, -13921,  14247,
-13897,  14316, -13829,  14381, -13828,  14337, -13864,  14242, -13877,  14145,
-13856,  14079, -13871,  14019, -13833,  13947, -13806,  13898, -13788,  13814,
-13801,  13721, -13821,  13581, -13788,  13635, -13754,  13705, -13728,  13803,
-13695,  13898, -13665,  13991, -13672,  14079, -13707,  14187, -13727,  14288,
-13753,  14389, -13726,  14473, -13693,  14515, -13742,  14379, -13694,  14295,
-13630,  14219, -13575,  14295, -13539,  14367, -13490,  14507, -13476,  14543,
-13465,  14645, -13487,  14723, -13490,  14807, -13455,  14959, -13457,  14871,
-13432,  14876, -13380,  14940, -13314,  14986, -13253,  15021, -13176,  15032,
-13110,  15042, -13037,  15054, -12991,  15164, -12942,  15144, -12868,  15157,
-12801,  15150, -12755,  15215, -12749,  15254, -12815,  15205, -12856,  15298,
-12908,  15402, -12875,  15501, -12886,  15579, -12864,  15688, -12823,  15787,
-12787,  15872, -12731,  15947, -12706,  15980, -12677,  15987, -12612,  16016,
-12567,  16079, -12536,  16184, -12503,  16155, -12452,  16180, -12385,  16183,
-12327,  16221, -12262,  16257, -12209,  16330, -12217,  16422, -12192,  16431,
-12125,  16415, -12042,  16478, -11996,  16470, -11926,  16508, -11862,  16563,
-11794,  16615, -11769,  16722, -11739,  16687, -11713,  16658, -11790,  16537,
-11737,  16522, -11662,  16523, -11572,  16514, -11592,  16492, -11668,  16424,
-11714,  16461, -11776,  16447, -11841,  16395, -11927,  16302, -11956,  16258,
-12016,  16200, -12038,  16107, -12043,  16008, -12010,  15931, -11954,  15857,
-11891,  15888, -11831,  15935, -11781,  16007, -11731,  16094, -11701,  16155,
-11663,  16225, -11612,  16201, -11559,  16240, -11486,  16278, -11410,  16302,
-11351,  16343, -11276,  16389, -11216,  16427, -11129,  16470, -11158,  16527,
-11200,  16611, -11262,  16654, -11304,  16665, -11372,  16619, -11423,  16641,
-11519,  16667, -11586,  16694, -11635,  16765, -11684,  16816, -11755,  16863,
-11785,  16974, -11805,  17064, -11850,  17145, -11816,  17256, -11791,  17363,
-11837,  17404, -11920,  17361, -11964,  17403, -12028,  17455, -12119,  17480,
-12103,  17500, -12028,  17522, -11960,  17509, -11885,  17482, -11812,  17534,
-11755,  17602, -11693,  17672, -11712,  17772, -11740,  17859, -11812,  17907,
-11891,  17926, -11971,  17922, -12051,  17908, -12126,  17876, -12199,  17831,
-12274,  17791, -12345,  17745, -12416,  17697, -12481,  17637, -12546,  17579,
-12603,  17503, -12656,  17427, -12701,  17341, -12750,  17261, -12796,  17177,
-12851,  17103, -12941,  17046, -12929,  17092, -12870,  17158, -12826,  17252,
-12771,  17323, -12723,  17408, -12707,  17510, -12773,  17570, -12885,  17615,
-12845,  17612, -12769,  17580, -12692,  17542, -12628,  17607, -12587,  17697,
-12539,  17778, -12467,  17859, -12412,  17903, -12339,  17944, -12261,  17973,
-12231,  18071, -12198,  18159, -12125,  18244, -12070,  18280, -11995,  18294,
-11906,  18308, -11824,  18303, -11742,  18307, -11660,  18305, -11578,  18298,
-11499,  18297, -11419,  18305, -11342,  18295, -11242,  18260, -11188,  18257,
-11100,  18279, -11024,  18284, -10948,  18292, -10883,  18342, -10820,  18421,
-10755,  18492, -10716,  18575, -10656,  18653, -10577,  18680, -10492,  18725,
-10412,  18729, -10342,  18752, -10276,  18824, -10207,  18879, -10150,  18972,
-10167,  19068, -10239,  19129, -10193,  19152, -10188,  19239, -10183,  19317,
-10169,  19404, -10221,  19493, -10301,  19549, -10421,  19505, -10405,  19587,
-10433,  19678, -10497,  19725, -10594,  19731, -10566,  19694, -10586,  19681,
-10673,  19649, -10739,  19580, -10799,  19525, -10885,  19472, -10951,  19403,
-10962,  19431, -11034,  19545, -10952,  19529, -10883,  19588, -10796,  19614,
-10684,  19687, -10782,  19674, -10731,  19700, -10647,  19732, -10576,  19779,
-10470,  19837, -10526,  19909, -10614,  19936, -10701,  19969, -10767,  20056,
-10864,  19985, -10840,  20044, -10882,  20092, -10981,  20079, -10986,  20180,
-11018,  20274, -11094,  20322, -11167,  20399, -11241,  20480, -11275,  20573,
-11341,  20668, -11321,  20644, -11246,  20646, -11181,  20750, -11246,  20831,
-11330,  20912, -11291,  20965, -11319,  21072, -11370,  21125, -11463,  21140,
-11438,  21173, -11419,  21245, -11516,  21258, -11533,  21284, -11463,  21383,
-11509,  21465, -11588,  21487, -11584,  21538, -11619,  21616, -11645,  21694,
-11688,  21808, -11735,  21842, -11752,  21870, -11759,  21938, -11832,  21879,
-11867,  21783, -11883,  21662, -11924,  21597, -11936,  21518, -11945,  21480,
-12002,  21425, -12006,  21294, -12015,  21330, -12089,  21385, -12158,  21290,
-12239,  21234, -12312,  21138, -12346,  21200, -12367,  21279, -12411,  21251,
-12442,  21151, -12569,  21071, -12526,  21105, -12446,  21161, -12419,  21274,
-12441,  21367, -12515,  21434, -12613,  21425, -12721,  21371, -12703,  21440,
-12642,  21483, -12642,  21578, -12675,  21679, -12676,  21781, -12754,  21826,
-12875,  21846, -12855,  21846, -12755,  21843, -12683,  21884, -12695,  21998,
-12666,  22096, -12639,  22190, -12712,  22167, -12800,  22219, -12905,  22236,
-13011,  22274, -13056,  22365, -13101,  22435, -13172,  22510, -13229,  22561,
-13293,  22639, -13381,  22713, -13477,  22704, -13585,  22639, -13684,  22669,
-13790,  22661, -13902,  22721, -14008,  22759, -14114,  22762, -14206,  22689,
-14219,  22585, -14188,  22479, -14131,  22393, -14150,  22284, -14195,  22192,
-14162,  22123, -14128,  22024, -14113,  21910, -14076,  21833, -14110,  21721,
-14159,  21638, -14195,  21559, -14260,  21471, -14291,  21382, -14256,  21314,
-14177,  21242, -14096,  21175, -14031,  21096, -13987,  21003, -13956,  20903,
-13934,  20800, -13927,  20694, -13927,  20589, -13935,  20485, -13967,  20386,
-14028,  20291, -14075,  20215, -14143,  20140, -14215,  20075, -14291,  20018,
-14373,  19971, -14481,  19913, -14476,  19842, -14430,  19736, -14396,  19661,
-14383,  19559, -14379,  19466, -14366,  19346, -14342,  19248, -14324,  19146,
-14288,  19043, -14315,  18951, -14364,  18866, -14354,  18709, -14407,  18756,
-14463,  18768, -14504,  18678, -14466,  18530, -14496,  18578, -14557,  18649,
-14638,  18672, -14715,  18597, -14712,  18617, -14652,  18701, -14667,  18804,
-14716,  18888, -14778,  18951, -14866,  19007, -14854,  19058, -14896,  19163,
-14948,  19249, -14970,  19343, -14952,  19439, -14956,  19542, -14961,  19646,
-14997,  19737, -14988,  19846, -14967,  19952, -14990,  20056, -15083,  20082,
-15192,  20102, -15240,  20111, -15332,  20123, -15424,  20115, -15522,  20070,
-15513,  20120, -15565,  20205, -15639,  20265, -15726,  20303, -15813,  20347,
-15911,  20383, -15962,  20449, -16017,  20538, -16094,  20602, -16168,  20675,
-16255,  20711, -16348,  20741, -16434,  20795, -16521,  20835, -16615,  20825,
-16704,  20785, -16831,  20745, -16827,  20837, -16838,  20938, -16874,  21038,
-16896,  21140, -16928,  21238, -16963,  21355, -17053,  21390, -17139,  21356,
-17159,  21241, -17166,  21247, -17154,  21354, -17197,  21405, -17256,  21489,
-17242,  21591, -17251,  21694, -17252,  21804, -17236,  21904, -17226,  22017,
-17183,  22110, -17133,  22212, -17105,  22310, -17074,  22404, -17006,  22495,
-16972,  22564, -16924,  22648, -16876,  22658, -16859,  22734, -16781,  22775,
-16790,  22825, -16766,  22872, -16643,  22866, -16537,  22918, -16506,  23002,
-16548,  23083, -16650,  23137, -16782,  23161, -16856,  23222, -16984,  23252,
-17047,  23309, -17009,  23314, -16902,  23258, -16774,  23217, -16670,  23194,
-16568,  23151, -16462,  23165, -16390,  23258, -16365,  23336, -16275,  23312,
-16175,  23298, -16070,  23334, -16005,  23411, -15948,  23508, -15892,  23589,
-15837,  23696, -15914,  23759, -16033,  23760, -16161,  23775, -16255,  23837,
-16334,  23918, -16445,  23969, -16587,  23982, -16567,  24001, -16406,  23982,
-16310,  23988, -16166,  23911, -16110,  23862, -16016,  23792, -15884,  23795,
-15801,  23871, -15730,  23960, -15658,  24052, -15748,  24178, -15616,  24217,
-15523,  24165, -15402,  24123, -15296,  24111, -15253,  24137, -15315,  24243,
-15424,  24356, -15330,  24322, -15276,  24273, -15213,  24178, -15114,  24203,
-15005,  24262, -14935,  24342, -14839,  24407, -14798,  24519, -14831,  24613,
-14915,  24696, -14950,  24801, -15012,  24891, -14954,  24927, -14831,  24963,
-14856,  25067, -14826,  25154, -14948,  25227, -15084,  25298, -15035,  25324,
-15051,  25361, -15201,  25371, -15342,  25416, -15515,  25412, -15557,  25337,
-15548,  25244, -15458,  25142, -15487,  25050, -15590,  24990, -15610,  24880,
-15648,  24773, -15715,  24686, -15752,  24557, -15871,  24474, -15948,  24542,
-16030,  24629, -16077,  24729, -16049,  24842, -15987,  24908, -16011,  25015,
-16084,  25104, -16208,  25187, -16313,  25129, -16336,  25013, -16405,  24893,
-16476,  24950, -16473,  25055, -16564,  25201, -16489,  25266, -16587,  25318,
-16689,  25324, -16837,  25359, -16815,  25426, -16752,  25544, -16762,  25628,
-16824,  25716, -16910,  25804, -16910,  25922, -16977,  26014, -17110,  26104,
-17199,  26153, -17287,  26164, -17404,  26064, -17421,  25979, -17549,  25914,
-17568,  25821, -17492,  25710, -17552,  25622, -17559,  25521, -17471,  25422,
-17354,  25363, -17226,  25331, -17072,  25288, -17030,  25229, -17063,  25227,
-17098,  25248, -17147,  25166, -17204,  25065, -17090,  25080, -17036,  24986,
-17110,  24910, -17188,  24824, -17316,  24773, -17390,  24705, -17377,  24611,
-17344,  24508, -17344,  24398, -17422,  24359, -17436,  24287, -17493,  24368,
-17376,  24407, -17440,  24488, -17524,  24577, -17507,  24668, -17479,  24807,
-17566,  24785, -17599,  24833, -17756,  24916, -17866,  24882, -17928,  24839,
-17874,  24731, -17753,  24731, -17700,  24639, -17823,  24650, -17918,  24749,
-17944,  24696, -18055,  24659, -18188,  24686, -18340,  24681, -18465,  24651,
-18599,  24661, -18731,  24708, -18840,  24777, -18998,  24775, -19093,  24852,
-19185,  24922, -19216,  25025, -19328,  25078, -19461,  25036, -19595,  24994,
-19724,  24952, -19746,  24837, -19620,  24837, -19492,  24873, -19328,  24927,
-19351,  24863, -19433,  24811, -19600,  24762, -19642,  24666, -19595,  24557,
-19548,  24450, -19562,  24361, -19561,  24222, -19612,  24262, -19711,  24382,
-19653,  24438, -19753,  24555, -19828,  24564, -19912,  24650, -20015,  24714,
-20124,  24714, -20255,  24670, -20390,  24651, -20528,  24633, -20664,  24642,
-20805,  24659, -20964,  24705, -20935,  24811, -20815,  24842, -20755,  24903,
-20830,  24992, -20937,  25063, -21103,  25090, -21208,  25069, -21336,  25090,
-21485,  25129, -21604,  25191, -21743,  25229, -21883,  25264, -21991,  25335,
-22117,  25394, -22267,  25410, -22391,  25386, -22455,  25280, -22598,  25266,
-22621,  25379, -22649,  25489, -22715,  25491, -22765,  25390, -22816,  25284,
-22945,  25286, -23036,  25371, -23085,  25470, -23143,  25568, -23263,  25661,
-23282,  25587, -23358,  25491, -23471,  25416, -23608,  25404, -23731,  25345,
-23816,  25227, -23874,  25274, -24006,  25238, -24101,  25176, -24144,  25080,
-24231,  25044, -24206,  25133, -24115,  25209, -24016,  25292, -23882,  25331,
-23771,  25379, -23617,  25507, -23751,  25521, -23872,  25456, -24038,  25392,
-24128,  25361, -24235,  25284, -24364,  25230, -24469,  25150, -24458,  25044,
-24507,  25053, -24637,  25042, -24755,  25063, -24897,  25082, -25031,  25123,
-25173,  25197, -25269,  25250, -25393,  25320, -25525,  25337, -25682,  25353,
-25806,  25398, -25927,  25458, -26067,  25511, -26211,  25501, -26359,  25476,
-26495,  25511, -26643,  25546, -26793,  25548, -26939,  25589, -27076,  25628,
-27225,  25661, -27384,  25649, -27532,  25637, -27689,  25678, -27762,  25775,
-27899,  25809, -28064,  25781, -28203,  25856, -28345,  25794, -28365,  25864,
-28469,  25955, -28589,  25901, -28687,  25819, -28831,  25777, -28985,  25771,
-29079,  25699, -29076,  25616, -29132,  25649, -29264,  25618, -29443,  25564,
-29527,  25533, -29604,  25448, -29671,  25355, -29703,  25250, -29779,  25164,
-29893,  25098, -30037,  25075, -30186,  25069, -30251,  25013, -30305,  24899,
-30270,  24856, -30160,  24790, -30045,  24729, -29952,  24664, -29850,  24578,
-29809,  24477, -29730,  24413, -29582,  24407, -29447,  24375, -29430,  24257,
-29326,  24247, -29188,  24224, -29271,  24173, -29388,  24203, -29535,  24313,
-29501,  24254, -29384,  24132, -29453,  24049, -29585,  24044, -29708,  24054,
-29835,  24094, -29819,  24220, -29945,  24229, -30057,  24180, -30156,  24111,
-30228,  24075, -30351,  24034, -30451,  23971, -30556,  23916, -30552,  23859,
-30402,  23799, -30283,  23774, -30347,  23729, -30324,  23653, -30290,  23576,
-30214,  23503, -30095,  23475, -29992,  23475, -29877,  23505, -29717,  23492,
-29642,  23464, -29577,  23485, -29474,  23561, -29357,  23607, -29278,  23570,
-29348,  23469, -29305,  23382, -29275,  23280, -29282,  23181, -29366,  23109,
-29498,  23105, -29576,  23056, -29654,  22979, -29773,  22961, -29855,  23019,
-29936,  22959, -29987,  22846, -29978,  22751, -30068,  22733, -30133,  22643,
-30166,  22532, -30219,  22454, -30200,  22377, -30134,  22269, -30082,  22308,
-30015,  22395, -30015,  22384, -30065,  22291, -30027,  22213, -29938,  22162,
-29814,  22175, -29784,  22115, -29875,  22088, -29977,  22153, -30061,  22066,
-30031,  21990, -29953,  21921, -29882,  21828, -29811,  21770, -29708,  21783,
-29612,  21829, -29584,  21920, -29523,  22048, -29545,  21987, -29532,  21906,
-29497,  21799, -29454,  21701, -29473,  21602, -29457,  21522, -29439,  21475,
-29459,  21360, -29391,  21344, -29322,  21410, -29211,  21469, -29119,  21427,
-29040,  21422, -28937,  21299, -28904,  21415, -28813,  21481, -28834,  21458,
-28811,  21360, -28722,  21367, -28631,  21414, -28560,  21485, -28555,  21477,
-28586,  21381, -28652,  21295, -28647,  21189, -28689,  21090, -28681,  20965,
-28687,  20934, -28775,  20889, -28845,  20816, -28903,  20696, -28972,  20652,
-29045,  20606, -29127,  20544, -29190,  20466, -29194,  20347, -29258,  20318,
-29330,  20373, -29416,  20353, -29494,  20298, -29569,  20206, -29612,  20135,
-29681,  20086, -29723,  20000, -29690,  20023, -29596,  20056, -29515,  20053,
-29464,  20117, -29416,  20219, -29362,  20192, -29269,  20199, -29202,  20232,
-29122,  20296, -29062,  20271, -29034,  20295, -28973,  20344, -28871,  20405,
-28825,  20461, -28819,  20540, -28746,  20590, -28661,  20651, -28579,  20703,
-28506,  20759, -28469,  20848, -28406,  20928, -28338,  20982, -28263,  21045,
-28184,  21118, -28103,  21159, -28061,  21230, -28003,  21319, -27918,  21401,
-27944,  21475, -28049,  21521, -28016,  21625, -27942,  21714, -27872,  21757,
-27799,  21821, -27824,  21923, -27785,  21937, -27711,  22017, -27640,  22107,
-27585,  22192, -27495,  22252, -27399,  22307, -27242,  22352, -27283,  22292,
-27191,  22187, -27267,  22183, -27373,  22197, -27471,  22149, -27542,  22079,
-27546,  21969, -27591,  21875, -27632,  21775, -27538,  21728, -27553,  21665,
-27641,  21604, -27587,  21550, -27493,  21574, -27383,  21672, -27322,  21697,
-27253,  21767, -27168,  21838, -27052,  21828, -26987,  21906, -26954,  22000,
-26998,  22022, -27017,  22041, -27020,  22106, -26996,  22186, -26925,  22256,
-26924,  22217, -26862,  22189, -26773,  22195, -26668,  22242, -26681,  22203,
-26635,  22122, -26548,  22063, -26479,  21989, -26365,  22054, -26363,  21989,
-26293,  21914, -26217,  21857, -26104,  21858, -25998,  21874, -25893,  21861,
-25750,  21842, -25702,  21779, -25604,  21739, -25504,  21748, -25416,  21819,
-25326,  21797, -25360,  21761, -25416,  21698, -25378,  21624, -25307,  21580,
-25209,  21525, -25129,  21458, -25055,  21360, -25003,  21296, -24896,  21229,
-24825,  21242, -24774,  21292, -24835,  21367, -24909,  21425, -24908,  21462,
-24801,  21434, -24742,  21414, -24706,  21279, -24627,  21221, -24586,  21254,
-24609,  21359, -24642,  21503, -24643,  21589, -24628,  21567, -24601,  21464,
-24566,  21375, -24521,  21267, -24402,  21247, -24371,  21153, -24306,  21076,
-24273,  20973, -24266,  20886, -24259,  20822, -24184,  20750, -24120,  20661,
-24083,  20584, -23990,  20476, -24019,  20398, -24037,  20264, -23990,  20309,
-23890,  20388, -23846,  20324, -23820,  20228, -23799,  20107, -23812,  20048,
-23797,  19965, -23727,  19991, -23681,  20086, -23675,  20180, -23677,  20281,
-23676,  20307, -23664,  20177, -23675,  20068, -23650,  20073, -23625,  20185,
-23598,  20175, -23631,  20044, -23661,  19989, -23685,  19899, -23674,  19817,
-23717,  19831, -23708,  19760, -23610,  19735, -23631,  19693, -23669,  19639,
-23622,  19555, -23555,  19465, -23513,  19518, -23454,  19608, -23416,  19590,
-23420,  19485, -23314,  19431, -23350,  19442, -23433,  19474, -23456,  19438,
-23405,  19347, -23346,  19247,

/* 2 */
855, 2,
 13771, -25324,  13659, -25351,  13536, -25388,  13395, -25430,  13275, -25495,
 13241, -25595,  13197, -25682,  13084, -25756,  13010, -25856,  12978, -25963,
 12968, -26064,  12899, -26164,  12772, -26236,  12662, -26313,  12506, -26354,
 12349, -26302,  12281, -26215,  12328, -26097,  12349, -26014,  12442, -25929,
 12546, -25849,  12595, -25749,  12592, -25634,  12480, -25701,  12384, -25653,
 12326, -25568,  12382, -25466,  12509, -25466,  12592, -25390,  12548, -25300,
 12632, -25246,  12662, -25185,  12661, -25092,  12697, -24996,  12741, -24910,
 12688, -24811,  12673, -24694,  12566, -24692,  12427, -24699,  12289, -24681,
 12152, -24668,  12013, -24651,  11875, -24629,  11740, -24609,  11608, -24580,
 11475, -24598,  11351, -24604,  11207, -24577,  11087, -24549,  10957, -24526,
 10819, -24529,  10726, -24486,  10609, -24434,  10486, -24397,  10359, -24359,
 10375, -24289,  10404, -24219,  10281, -24166,  10186, -24101,  10101, -24020,
  9979, -23984,   9849, -23979,   9722, -23977,   9595, -23999,   9467, -24018,
  9364, -24083,   9263, -24146,   9160, -24206,   9145, -24310,   9202, -24406,
  9185, -24454,   9058, -24413,   8940, -24379,   8812, -24427,   8891, -24513,
  8853, -24575,   8735, -24626,   8610, -24628,   8590, -24535,   8473, -24495,
  8422, -24586,   8311, -24646,   8179, -24670,   8070, -24738,   7936, -24766,
  7797, -24792,   7701, -24871,   7572, -24920,   7453, -24975,   7337, -25038,
  7244, -25111,   7233, -25230,   7206, -25328,   7065, -25426,   7025, -25343,
  6962, -25406,   6823, -25359,   6885, -25266,   6801, -25246,   6699, -25343,
  6603, -25288,   6579, -25209,   6456, -25150,   6359, -25069,   6310, -24967,
  6184, -24937,   6078, -25007,   6051, -25107,   5987, -25207,   5880, -25282,
  5755, -25339,   5629, -25400,   5476, -25414,   5328, -25434,   5192, -25482,
  5048, -25523,   4897, -25538,   4751, -25575,   4602, -25603,   4454, -25637,
  4303, -25668,   4146, -25674,   3997, -25634,   3842, -25622,   3695, -25585,
  3551, -25544,   3401, -25513,   3256, -25480,   3103, -25519,   2959, -25558,
  2808, -25583,   2656, -25564,   2514, -25556,   2358, -25585,   2256, -25657,
  2158, -25735,   1991, -25726,   1879, -25655,   1774, -25579,   1643, -25513,
  1619, -25566,   1554, -25634,   1418, -25556,   1308, -25620,   1205, -25691,
  1047, -25703,    889, -25718,    737, -25745,    586, -25779,    436, -25813,
   298, -25868,    150, -25914,     33, -25985,    -76, -26064,   -173, -25985,
  -312, -25996,   -414, -25953,   -540, -25942,   -701, -25959,   -865, -25961,
 -1032, -25992,  -1113, -25931,  -1037, -25841,  -1045, -25752,  -1183, -25779,
 -1289, -25858,  -1365, -25953,  -1372, -26068,  -1532, -26115,  -1599, -26007,
 -1653, -25907,  -1763, -25830,  -1861, -25871,  -1913, -25970,  -2016, -26064,
 -2147, -25981,  -2218, -26053,  -2116, -26135,  -2065, -26233,  -2130, -26329,
 -2241, -26410,  -2381, -26477,  -2556, -26498,  -2552, -26557,  -2592, -26634,
 -2768, -26651,  -2926, -26709,  -3005, -26834,  -3014, -26904,  -2965, -26957,
 -2781, -26934,  -2599, -26896,  -2595, -26967,  -2750, -27025,  -2878, -27103,
 -3022, -27173,  -3133, -27258,  -3199, -27357,  -3299, -27448,  -3300, -27559,
 -3520, -27587,  -3699, -27616,  -3890, -27644,  -4092, -27656,  -4300, -27679,
 -4511, -27708,  -4712, -27766,  -4873, -27813,  -5079, -27858,  -5261, -27921,
 -5419, -27997,  -5603, -28062,  -5765, -28140,  -5979, -28191,  -6146, -28269,
 -6279, -28357,  -6417, -28444,  -6533, -28540,  -6597, -28642,  -6560, -28746,
 -6342, -28812,  -6151, -28886,  -5892, -28913,  -5636, -28864,  -5391, -28812,
 -5059, -28775,  -5099, -28827,  -5283, -28905,  -5422, -29005,  -5184, -29087,
 -5123, -29184,  -5317, -29258,  -5621, -29300,  -5887, -29355,  -6193, -29393,
 -6483, -29441,  -6791, -29481,  -7071, -29544,  -7373, -29594,  -7637, -29664,
 -7762, -29764,  -8087, -29798,  -8451, -29779,  -8816, -29793,  -9167, -29823,
 -9508, -29868,  -9842, -29919, -10111, -29996, -10301, -30087, -10569, -30193,
-10730, -30137, -10791, -30033, -11079, -29960, -11372, -29888, -11643, -29818,
-11909, -29745, -12164, -29668, -12431, -29599, -12715, -29539, -13031, -29499,
-13313, -29441, -13568, -29372, -13715, -29283, -13887, -29192, -14359, -29135,
-14152, -29127, -13924, -29063, -13858, -28966, -13976, -28875, -14240, -28856,
-14531, -28849, -14650, -28932, -14749, -28913, -14893, -28819, -15090, -28753,
-15177, -28649, -15267, -28544, -15115, -28513, -14948, -28603, -14746, -28670,
-14481, -28692, -14225, -28659, -14119, -28571, -14263, -28485, -14498, -28441,
-14742, -28381, -14748, -28301, -14548, -28304, -14313, -28344, -14069, -28367,
-13830, -28397, -13593, -28434, -13384, -28371, -13286, -28269, -13461, -28207,
-13709, -28204, -13876, -28134, -14008, -28046, -14119, -27954, -14219, -27861,
-14276, -27766, -14158, -27667, -13960, -27690, -13867, -27781, -13729, -27858,
-13508, -27882, -13282, -27897, -13054, -27906, -12818, -27909, -12703, -27819,
-12534, -27763, -12335, -27722, -12130, -27682, -11948, -27627, -11779, -27562,
-11609, -27497, -11612, -27412, -11565, -27322, -11494, -27213, -11379, -27258,
-11274, -27223, -11248, -27121, -11184, -27028, -11172, -26946, -11140, -26904,
-11057, -26826, -11165, -26753, -11222, -26663, -11081, -26672, -10958, -26651,
-10950, -26557, -11062, -26466, -11176, -26405, -11102, -26334, -11125, -26240,
-11334, -26215, -11293, -26171, -11129, -26137, -11190, -26068, -11181, -26014,
-11117, -25935, -11153, -25826, -11269, -25777, -11243, -25707, -11322, -25626,
-11296, -25536, -11372, -25434, -11371, -25326, -11451, -25244, -11543, -25168,
-11562, -25051, -11609, -24971, -11491, -24903, -11551, -24882, -11688, -24931,
-11667, -25015, -11725, -25023, -11864, -25005, -11895, -24914, -11828, -24820,
-11900, -24779, -11915, -24662, -11924, -24567, -11830, -24499, -11789, -24398,
-11657, -24326, -11637, -24219, -11569, -24128, -11415, -24233, -11399, -24128,
-11255, -24140, -11147, -24108, -11049, -24040, -11130, -24017, -11251, -24059,
-11351, -23984, -11279, -23874, -11294, -23799, -11231, -23722, -11125, -23653,
-11046, -23574, -10964, -23498, -10852, -23451, -10742, -23466, -10707, -23410,
-10677, -23304, -10610, -23222, -10510, -23159, -10386, -23131, -10379, -23039,
-10483, -23027, -10580, -23081, -10695, -23128, -10783, -23203, -10876, -23243,
-10976, -23277, -11082, -23331, -11138, -23426, -11223, -23490, -11343, -23553,
-11416, -23607, -11497, -23679, -11629, -23694, -11640, -23805, -11666, -23878,
-11738, -23954, -11796, -24018, -11897, -24059, -11980, -24133, -12048, -24222,
-12096, -24310, -12172, -24379, -12274, -24429, -12289, -24553, -12148, -24578,
-12157, -24648, -12201, -24738, -12177, -24841, -12204, -24935, -12232, -25042,
-12170, -25119, -12224, -25219, -12367, -25238, -12477, -25268, -12446, -25373,
-12455, -25476, -12387, -25570, -12339, -25670, -12302, -25771, -12272, -25873,
-12286, -25979, -12247, -26082, -12183, -26177, -12180, -26283, -12196, -26382,
-12280, -26477, -12404, -26548, -12550, -26612, -12715, -26658, -12893, -26677,
-13060, -26714, -13243, -26743, -13402, -26794, -13584, -26824, -13760, -26841,
-13947, -26874, -13974, -26814, -14078, -26770, -14275, -26807, -14357, -26745,
-14468, -26660, -14615, -26603, -14672, -26651, -14734, -26723, -14769, -26821,
-14870, -26894, -15031, -26881, -15201, -26834, -15378, -26817, -15556, -26777,
-15624, -26646, -15753, -26672, -15912, -26660, -16075, -26636, -16179, -26503,
-16269, -26584, -16410, -26636, -16572, -26675, -16760, -26643, -16937, -26641,
-17107, -26670, -17287, -26658, -17470, -26675, -17647, -26665, -17821, -26617,
-17954, -26569, -18136, -26581, -18313, -26591, -18513, -26588, -18640, -26548,
-18748, -26482, -18840, -26550, -18792, -26655, -18637, -26694, -18456, -26699,
-18271, -26711, -18114, -26780, -18184, -26829, -18372, -26836, -18546, -26797,
-18716, -26814, -18652, -26906, -18514, -26964, -18458, -27077, -18293, -27113,
-18282, -27207, -18211, -27268, -18133, -27346, -18297, -27393, -18499, -27393,
-18648, -27325, -18867, -27314, -19071, -27325, -19269, -27360, -19447, -27412,
-19647, -27398, -19840, -27357, -20091, -27374, -20111, -27271, -20024, -27176,
-20048, -27061, -20213, -27010, -20301, -27077, -20300, -27181, -20415, -27242,
-20559, -27197, -20613, -27116, -20629, -27015, -20710, -26926, -20861, -26949,
-20881, -27066, -21041, -27108, -21228, -27131, -21414, -27085, -21554, -27118,
-21711, -27163, -21907, -27184, -22107, -27199, -22305, -27186, -22499, -27199,
-22700, -27184, -22899, -27176, -23098, -27173, -23291, -27192, -23476, -27229,
-23674, -27237, -23874, -27221, -24072, -27207, -24273, -27234, -24437, -27165,
-24626, -27157, -24818, -27207, -24936, -27290, -25126, -27328, -25336, -27344,
-25460, -27431, -25630, -27481, -25840, -27481, -26013, -27514, -26221, -27559,
-26364, -27621, -26576, -27650, -26539, -27781, -26732, -27772, -26940, -27716,
-27142, -27781, -27022, -27834, -26807, -27825, -26627, -27882, -26519, -27966,
-26549, -28046, -26581, -28147, -26751, -28147, -26971, -28204, -27153, -28265,
-27333, -28269, -27509, -28191, -27713, -28178, -27870, -28162, -28039, -28093,
-28262, -28065, -28428, -28115, -28641, -28102, -28713, -28188, -28757, -28288,
-28736, -28387, -28522, -28472, -28275, -28451, -28039, -28458, -28053, -28561,
-28305, -28610, -28291, -28684, -28109, -28764, -27862, -28808, -27623, -28856,
-27398, -28924, -27141, -28974, -26893, -29028, -26678, -29103, -26557, -29200,
-26504, -29304, -26667, -29393, -26855, -29477, -27005, -29580, -27282, -29612,
-27572, -29553, -27881, -29517, -28210, -29490, -28508, -29544, -28368, -29612,
-28089, -29687, -28149, -29788, -28041, -29893, -27813, -29981, -27647, -30076,
-27767, -30176, -27847, -30279, -27838, -30387, -27864, -30487, -27823, -30592,
-27610, -30688, -27251, -30766, -26768, -30818, -26230, -30863, -25678, -30894,
-25297, -30957, -25636, -31023, -26255, -30990, -26901, -30982, -27331, -31074,
-27927, -31065, -28606, -31082, -29235, -31057, -29729, -30990, -30213, -30925,
-30600, -30863, -31080, -30795, -31583, -30752, -32141, -30744, -32587, -30709,
 32534, -30639,  32099, -30585,  31674, -30526,  31340, -30474,  31122, -30393,
 30678, -30356,  30605, -30309,  30551, -30216,  30362, -30142,  30142, -30055,
 29913, -29975,  29783, -29893,  29619, -29793,  29349, -29692,  29415, -29589,
 29241, -29503,  29228, -29406,  29209, -29312,  28948, -29279,  28865, -29212,
 29103, -29119,  29108, -29028,  29213, -28924,  29179, -28823,  29342, -28753,
 29583, -28710,  29798, -28645,  30021, -28603,  30349, -28603,  30280, -28561,
 30107, -28458,  29959, -28414,  29898, -28291,  29802, -28226,  29765, -28121,
 29636, -28034,  29624, -27969,  29637, -27873,  29613, -27763,  29632, -27667,
 29665, -27576,  29635, -27475,  29588, -27368,  29731, -27306,  29830, -27210,
 29993, -27181,  30063, -27108,  30015, -27002,  30175, -26969,  30191, -26906,
 30334, -26826,  30477, -26750,  30600, -26765,  30730, -26745,  30793, -26648,
 30886, -26567,  30956, -26456,  30975, -26352,  30952, -26263,  31055, -26195,
 31093, -26106,  30996, -26020,  30832, -25998,  30713, -25927,  30577, -25856,
 30514, -25766,  30348, -25735,  30206, -25718,  30061, -25687,  29904, -25661,
 29759, -25689,  29638, -25616,  29490, -25591,  29349, -25564,  29220, -25511,
 29145, -25430,  29042, -25353,  28919, -25296,  28810, -25229,  28644, -25158,
 28527, -25181,  28391, -25189,  28248, -25158,  28121, -25086,  28129, -24994,
 28017, -24908,  27991, -24977,  27955, -25078,  27809, -25057,  27680, -25057,
 27518, -25073,  27484, -24937,  27349, -24916,  27220, -24876,  27069, -24865,
 27015, -24771,  26935, -24712,  26794, -24771,  26752, -24725,  26656, -24640,
 26500, -24602,  26517, -24502,  26490, -24422,  26353, -24441,  26235, -24406,
 26119, -24354,  25976, -24381,  25864, -24324,  25728, -24310,  25599, -24290,
 25477, -24262,  25351, -24226,  25220, -24212,  25096, -24175,  24973, -24144,
 24844, -24140,  24720, -24095,  24593, -24046,  24588, -23955,  24617, -23851,
 24587, -23749,  24527, -23671,  24430, -23674,  24412, -23782,  24421, -23888,
 24459, -23988,  24412, -24073,  24273, -24052,  24147, -24077,  24022, -24095,
 23894, -24108,  23762, -24102,  23649, -24154,  23572, -24241,  23535, -24340,
 23470, -24423,  23338, -24404,  23212, -24372,  23110, -24308,  23087, -24199,
 22973, -24139,  22850, -24194,  22774, -24280,  22681, -24248,  22571, -24227,
 22453, -24278,  22358, -24266,  22220, -24234,  22095, -24278,  21978, -24322,
 21842, -24335,  21715, -24359,  21575, -24361,  21447, -24375,  21318, -24338,
 21247, -24252,  21160, -24173,  21032, -24161,  20898, -24196,  20834, -24114,
 20754, -24030,  20667, -23948,  20558, -23942,  20440, -23981,  20313, -23999,
 20197, -24046,  20155, -24140,  20094, -24224,  19980, -24273,  19830, -24305,
 19723, -24254,  19619, -24184,  19484, -24175,  19359, -24149,  19235, -24120,
 19112, -24080,  18993, -24042,  18868, -24023,  18745, -23998,  18617, -23999,
 18494, -24029,  18374, -24063,  18292, -24147,  18191, -24213,  18094, -24308,
 18011, -24268,  17911, -24219,  17775, -24257,  17652, -24238,  17518, -24259,
 17380, -24264,  17253, -24233,  17123, -24257,  16992, -24241,  16857, -24248,
 16729, -24224,  16595, -24227,  16469, -24257,  16340, -24280,  16195, -24289,
 16154, -24199,  16097, -24077,  16049, -24120,  16031, -24231,  15961, -24317,
 15851, -24379,  15723, -24404,  15604, -24445,  15467, -24443,  15333, -24441,
 15197, -24445,  15074, -24499,  14953, -24492,  14879, -24587,  14836, -24642,
 14718, -24701,  14583, -24729,  14454, -24771,  14341, -24831,  14247, -24912,
 14188, -25003,  14178, -25107,  14088, -25179,  13956, -25230,  13843, -25282,

/* 3 */
533, 1,
 27126,  -7621,  27085,  -7573,  27080,  -7466,  27070,  -7376,  27024,  -7330,
 26982,  -7286,  26931,  -7238,  26883,  -7192,  26842,  -7076,  26797,  -7065,
 26752,  -7015,  26697,  -6983,  26649,  -6927,  26625,  -6838,  26620,  -6738,
 26584,  -6658,  26582,  -6558,  26592,  -6457,  26585,  -6357,  26564,  -6258,
 26543,  -6162,  26504,  -6083,  26472,  -5997,  26471,  -5898,  26460,  -5794,
 26448,  -5691,  26442,  -5582,  26440,  -5487,  26427,  -5415,  26382,  -5355,
 26337,  -5295,  26312,  -5203,  26268,  -5195,  26230,  -5238,  26183,  -5261,
 26155,  -5169,  26138,  -5071,  26127,  -4970,  26127,  -4869,  26118,  -4764,
 26105,  -4671,  26088,  -4571,  26052,  -4485,  26055,  -4377,  26016,  -4322,
 25998,  -4220,  25994,  -4117,  25976,  -4010,  25944,  -3939,  25910,  -3946,
 25873,  -4016,  25866,  -4128,  25851,  -4231,  25839,  -4337,  25823,  -4386,
 25795,  -4469,  25811,  -4599,  25794,  -4668,  25774,  -4753,  25780,  -4856,
 25757,  -4955,  25750,  -5060,  25769,  -5159,  25760,  -5265,  25766,  -5369,
 25778,  -5474,  25763,  -5573,  25744,  -5674,  25735,  -5780,  25732,  -5882,
 25715,  -5988,  25693,  -6083,  25663,  -6170,  25647,  -6269,  25622,  -6359,
 25575,  -6414,  25522,  -6443,  25470,  -6427,  25420,  -6382,  25372,  -6328,
 25331,  -6268,  25308,  -6174,  25256,  -6131,  25203,  -6107,  25151,  -6077,
 25108,  -6011,  25071,  -5932,  25023,  -5884,  24976,  -5833,  24925,  -5792,
 24878,  -5768,  24834,  -5701,  24795,  -5629,  24753,  -5565,  24707,  -5504,
 24661,  -5449,  24651,  -5355,  24682,  -5265,  24718,  -5182,  24740,  -5092,
 24747,  -4991,  24734,  -4897,  24756,  -4823,  24805,  -4797,  24841,  -4793,
 24854,  -4690,  24884,  -4579,  24917,  -4509,  24887,  -4450,  24853,  -4370,
 24817,  -4378,  24803,  -4454,  24778,  -4531,  24753,  -4451,  24723,  -4444,
 24701,  -4429,  24725,  -4344,  24718,  -4319,  24674,  -4385,  24622,  -4442,
 24580,  -4448,  24533,  -4379,  24487,  -4386,  24430,  -4368,  24381,  -4313,
 24341,  -4285,  24289,  -4286,  24242,  -4253,  24196,  -4156,  24147,  -4169,
 24102,  -4093,  24064,  -4097,  24040,  -4094,  24004,  -4103,  24044,  -4177,
 24105,  -4180,  24138,  -4259,  24146,  -4383,  24109,  -4450,  24070,  -4446,
 24016,  -4466,  23962,  -4472,  23904,  -4432,  23862,  -4446,  23825,  -4544,
 23793,  -4540,  23764,  -4598,  23725,  -4649,  23690,  -4727,  23702,  -4838,
 23661,  -4909,  23626,  -4960,  23614,  -5055,  23579,  -5122,  23551,  -5223,
 23594,  -5306,  23632,  -5378,  23618,  -5403,  23598,  -5495,  23575,  -5469,
 23522,  -5476,  23498,  -5439,  23446,  -5399,  23385,  -5388,  23357,  -5460,
 23326,  -5577,  23309,  -5542,  23319,  -5432,  23322,  -5347,  23277,  -5273,
 23245,  -5192,  23204,  -5118,  23159,  -5071,  23120,  -5033,  23082,  -5043,
 23056,  -5128,  23025,  -5114,  22991,  -5142,  22959,  -5100,  22944,  -5124,
 22936,  -5248,  22892,  -5288,  22871,  -5217,  22858,  -5244,  22828,  -5299,
 22789,  -5349,  22801,  -5439,  22803,  -5496,  22755,  -5483,  22750,  -5576,
 22715,  -5578,  22686,  -5608,  22643,  -5678,  22666,  -5775,  22669,  -5842,
 22646,  -5914,  22706,  -5961,  22693,  -5969,  22637,  -5966,  22590,  -5933,
 22527,  -5926,  22492,  -5990,  22487,  -6043,  22537,  -6133,  22523,  -6220,
 22491,  -6341,  22460,  -6303,  22434,  -6209,  22408,  -6108,  22387,  -6013,
 22362,  -6007,  22334,  -6096,  22294,  -6165,  22251,  -6240,  22231,  -6336,
 22237,  -6438,  22251,  -6538,  22251,  -6618,  22210,  -6686,  22166,  -6752,
 22138,  -6838,  22115,  -6942,  22085,  -7030,  22045,  -7104,  21998,  -7158,
 21947,  -7200,  21894,  -7238,  21839,  -7257,  21785,  -7283,  21733,  -7285,
 21678,  -7277,  21636,  -7349,  21589,  -7396,  21531,  -7409,  21481,  -7442,
 21438,  -7507,  21386,  -7535,  21328,  -7522,  21268,  -7509,  21226,  -7536,
 21176,  -7584,  21133,  -7631,  21088,  -7697,  21046,  -7765,  21004,  -7836,
 20951,  -7881,  20899,  -7918,  20854,  -7991,  20834,  -8073,  20797,  -8175,
 20770,  -8115,  20769,  -7977,  20736,  -8004,  20716,  -8102,  20692,  -8199,
 20699,  -8294,  20709,  -8397,  20706,  -8501,  20684,  -8594,  20656,  -8686,
 20641,  -8788,  20640,  -8894,  20668,  -8985,  20683,  -9083,  20711,  -9175,
 20738,  -9269,  20768,  -9360,  20789,  -9452,  20768,  -9582,  20718,  -9500,
 20695,  -9438,  20661,  -9329,  20648,  -9393,  20671,  -9489,  20710,  -9568,
 20706,  -9672,  20667,  -9634,  20625,  -9533,  20617,  -9592,  20653,  -9676,
 20689,  -9758,  20720,  -9847,  20748,  -9940,  20769, -10039,  20768, -10144,
 20786, -10245,  20822, -10329,  20851, -10420,  20867, -10518,  20902, -10607,
 20921, -10709,  20920, -10813,  20922, -10920,  20931, -11022,  20944, -11125,
 20967, -11224,  20995, -11317,  21020, -11414,  21048, -11508,  21063, -11610,
 21062, -11722,  21057, -11864,  21042, -11919,  21052, -12024,  21050, -12117,
 21011, -12219,  20954, -12231,  20926, -12259,  20924, -12365,  20944, -12474,
 21005, -12505,  21057, -12564,  21100, -12647,  21159, -12696,  21201, -12730,
 21270, -12752,  21334, -12752,  21399, -12770,  21461, -12763,  21522, -12719,
 21569, -12641,  21621, -12572,  21680, -12553,  21736, -12522,  21768, -12427,
 21820, -12365,  21882, -12357,  21943, -12347,  22007, -12328,  22068, -12318,
 22132, -12322,  22200, -12337,  22249, -12369,  22309, -12347,  22372, -12333,
 22430, -12359,  22497, -12326,  22541, -12241,  22569, -12151,  22594, -12053,
 22644, -11994,  22706, -11969,  22759, -11913,  22814, -11864,  22868, -11814,
 22921, -11758,  22982, -11744,  23045, -11760,  23107, -11758,  23168, -11746,
 23226, -11712,  23287, -11683,  23345, -11647,  23401, -11602,  23455, -11553,
 23516, -11526,  23577, -11513,  23639, -11504,  23701, -11497,  23763, -11502,
 23824, -11495,  23882, -11468,  23941, -11509,  23994, -11563,  24043, -11629,
 24100, -11650,  24157, -11635,  24212, -11691,  24277, -11713,  24329, -11712,
 24372, -11808,  24426, -11844,  24416, -11943,  24439, -12051,  24503, -12086,
 24539, -12168,  24558, -12264,  24603, -12346,  24623, -12441,  24626, -12572,
 24642, -12632,  24724, -12693,  24736, -12606,  24774, -12534,  24811, -12436,
 24853, -12360,  24912, -12292,  24963, -12258,  24997, -12168,  25020, -12071,
 25064, -11995,  25075, -11891,  25091, -11895,  25108, -11997,  25101, -12084,
 25100, -12192,  25073, -12277,  25040, -12364,  25022, -12460,  25019, -12563,
 25014, -12686,  24957, -12712,  24923, -12809,  24985, -12806,  25052, -12786,
 25083, -12693,  25096, -12591,  25126, -12472,  25163, -12527,  25201, -12630,
 25206, -12724,  25198, -12830,  25159, -12947,  25222, -12962,  25282, -12924,
 25343, -12878,  25340, -12951,  25331, -12994,  25373, -13070,  25399, -13116,
 25313, -12980,  25325, -13002,  25372, -13075,  25409, -13160,  25435, -13257,
 25453, -13357,  25434, -13459,  25444, -13561,  25487, -13651,  25528, -13729,
 25565, -13814,  25625, -13855,  25688, -13883,  25741, -13964,  25792, -13947,
 25863, -13963,  25928, -13976,  25986, -14032,  26046, -14081,  26108, -14125,
 26167, -14092,  26216, -14020,  26271, -13959,  26310, -13891,  26360, -13806,
 26404, -13859,  26363, -13956,  26388, -14000,  26445, -13937,  26475, -13991,
 26517, -14071,  26563, -14136,  26633, -14206,  26635, -14134,  26671, -14087,
 26735, -14060,  26784, -13981,  26831, -13906,  26881, -13839,  26940, -13792,
 27005, -13767,  27072, -13763,  27141, -13757,  27204, -13747,  27257, -13678,
 27295, -13604,  27291, -13511,  27290, -13414,  27308, -13309,  27322, -13207,
 27325, -13109,  27347, -13007,  27378, -12910,  27412, -12819,  27439, -12748,
 27451, -12644,  27460, -12558,  27492, -12452,  27520, -12369,  27535, -12246,
 27569, -12153,  27596, -12077,  27627, -11987,  27685, -11918,  27723, -11852,
 27761, -11775,  27766, -11670,  27803, -11578,  27828, -11479,  27842, -11378,
 27856, -11272,  27848, -11169,  27862, -11066,  27881, -10966,  27896, -10865,
 27907, -10761,  27914, -10657,  27935, -10557,  27956, -10459,  27950, -10355,
 27942, -10255,  27923, -10155,  27904, -10058,  27873,  -9964,  27869,  -9870,
 27872,  -9757,  27867,  -9657,  27863,  -9556,  27863,  -9438,  27833,  -9351,
 27829,  -9245,  27782,  -9172,  27756,  -9083,  27726,  -9003,  27681,  -8936,
 27654,  -8833,  27609,  -8757,  27565,  -8734,  27521,  -8661,  27474,  -8578,
 27450,  -8499,  27440,  -8394,  27446,  -8293,  27419,  -8187,  27364,  -8175,
 27317,  -8095,  27296,  -8181,  27260,  -8170,  27227,  -8096,  27208,  -7994,
 27200,  -7880,  27176,  -7801,  27157,  -7702,

/* 4 */
521, 2,
 -6494,  24104,  -6481,  24149,  -6367,  24144,  -6286,  24212,  -6224,  24280,
 -6152,  24391,  -6095,  24493,  -6050,  24586,  -5979,  24653,  -5862,  24721,
 -5858,  24820,  -5905,  24920,  -5873,  24929,  -5786,  24841,  -5711,  24786,
 -5564,  24803,  -5479,  24835,  -5406,  24865,  -5304,  24867,  -5162,  24912,
 -5045,  24942,  -4909,  24981,  -4774,  25021,  -4666,  25098,  -4590,  25170,
 -4484,  25240,  -4373,  25310,  -4272,  25390,  -4168,  25446,  -4093,  25509,
 -4310,  25525,  -4449,  25566,  -4590,  25605,  -4735,  25577,  -4890,  25556,
 -5005,  25487,  -5112,  25517,  -4912,  25583,  -4859,  25634,  -5052,  25628,
 -5190,  25645,  -5256,  25655,  -5121,  25726,  -5094,  25830,  -5028,  25858,
 -4878,  25826,  -4738,  25868,  -4653,  25946,  -4749,  26022,  -4927,  26035,
 -5067,  26055,  -5104,  26060,  -5018,  26119,  -5131,  26188,  -5149,  26222,
 -5002,  26148,  -4874,  26064,  -4720,  26046,  -4583,  25979,  -4469,  25931,
 -4407,  25824,  -4368,  25722,  -4251,  25649,  -4122,  25674,  -4089,  25724,
 -3962,  25666,  -3951,  25762,  -3978,  25864,  -4000,  25981,  -4071,  26042,
 -4081,  26095,  -4170,  26117,  -4165,  26202,  -4311,  26272,  -4430,  26334,
 -4576,  26331,  -4637,  26329,  -4507,  26424,  -4645,  26494,  -4817,  26468,
 -4883,  26508,  -4657,  26527,  -4600,  26595,  -4784,  26634,  -4936,  26624,
 -4909,  26714,  -4684,  26684,  -4550,  26772,  -4597,  26851,  -4436,  26819,
 -4308,  26841,  -4132,  26792,  -4130,  26784,  -4303,  26782,  -4124,  26680,
 -3968,  26704,  -3833,  26738,  -3725,  26787,  -3741,  26886,  -3945,  26914,
 -3977,  26861,  -4045,  26977,  -4016,  27072,  -3946,  27118,  -3731,  27087,
 -3577,  27033,  -3492,  27118,  -3598,  27168,  -3779,  27199,  -3839,  27309,
 -3975,  27328,  -3798,  27387,  -3984,  27467,  -3986,  27497,  -3812,  27434,
 -3602,  27390,  -3533,  27492,  -3569,  27587,  -3742,  27644,  -3868,  27659,
 -3644,  27728,  -3844,  27757,  -4023,  27852,  -4026,  27933,  -3839,  27982,
 -3657,  28009,  -3407,  27963,  -3304,  28034,  -3410,  28134,  -3607,  28159,
 -3740,  28217,  -3651,  28278,  -3524,  28288,  -3802,  28357,  -3944,  28301,
 -3908,  28448,  -3859,  28557,  -3836,  28652,  -3663,  28738,  -3548,  28841,
 -3578,  28955,  -3429,  29032,  -3225,  29099,  -3328,  29163,  -3608,  29119,
 -3709,  29091,  -3551,  29208,  -3218,  29204,  -3007,  29266,  -3114,  29333,
 -3431,  29329,  -3633,  29342,  -3168,  29393,  -2840,  29420,  -2680,  29508,
 -2458,  29589,  -2277,  29687,  -2454,  29774,  -2796,  29818,  -3144,  29779,
 -3337,  29683,  -3696,  29683,  -3944,  29594,  -4119,  29503,  -4286,  29415,
 -4389,  29376,  -4238,  29512,  -4115,  29608,  -4017,  29711,  -4014,  29818,
 -4251,  29863,  -4423,  29769,  -4680,  29697,  -4895,  29673,  -4621,  29813,
 -4940,  29853,  -5338,  29828,  -5654,  29798,  -5883,  29784,  -5532,  29903,
 -5075,  29913,  -4686,  29903,  -4335,  29944,  -4030,  30002,  -3966,  30093,
 -4314,  30148,  -4583,  30176,  -4735,  30250,  -5155,  30244,  -5572,  30238,
 -5929,  30198,  -6239,  30181,  -5861,  30244,  -5445,  30267,  -4990,  30267,
 -4769,  30332,  -5207,  30387,  -5641,  30424,  -6144,  30418,  -6583,  30393,
 -6851,  30369,  -7019,  30309,  -6921,  30233,  -7150,  30170,  -7597,  30267,
 -7915,  30279,  -8228,  30216,  -8319,  30170,  -7900,  30153,  -7491,  30131,
 -7264,  30060,  -7321,  30028,  -7619,  30087,  -8075,  30131,  -8227,  30087,
 -7997,  29996,  -7946,  29934,  -8113,  29818,  -8259,  29793,  -8489,  29883,
 -8766,  29955,  -9058,  30028,  -9267,  29986,  -9153,  29883,  -9157,  29798,
 -9168,  29745,  -9567,  29823,  -9754,  29745,  -9790,  29919, -10061,  29944,
-10368,  29913, -10714,  29848, -10573,  29740, -10373,  29654, -10388,  29645,
-10626,  29725, -10855,  29808, -11143,  29759, -11106,  29650, -11220,  29544,
-11514,  29517, -11571,  29468, -11902,  29393, -12110,  29321, -12256,  29221,
-12088,  29143, -11791,  29159, -11710,  29163, -11831,  29060, -11818,  28955,
-11927,  28856, -12129,  28801, -12375,  28782, -12585,  28710, -12829,  28645,
-13055,  28606, -13221,  28530, -13228,  28438, -13039,  28347, -12855,  28321,
-12752,  28282, -12677,  28210, -12464,  28230, -12226,  28252, -12077,  28246,
-12113,  28156, -12377,  28162, -12460,  28115, -12166,  28090, -12144,  28081,
-12401,  28093, -12638,  28106, -12873,  28093, -12930,  28009, -12788,  27975,
-12709,  27982, -12550,  27909, -12455,  27879, -12612,  27787, -12450,  27705,
-12233,  27661, -12164,  27676, -12131,  27734, -11971,  27728, -11841,  27711,
-11680,  27751, -11449,  27769, -11250,  27740, -11050,  27690, -10874,  27627,
-10714,  27568, -10617,  27484, -10617,  27412, -10523,  27311, -10374,  27221,
-10276,  27121, -10281,  27046, -10301,  26990, -10174,  26901, -10158,  26812,
-10063,  26697, -10057,  26600,  -9957,  26494,  -9978,  26403, -10052,  26357,
-10002,  26306, -10000,  26218, -10118,  26106, -10062,  26005,  -9919,  25979,
 -9821,  26049,  -9776,  26115,  -9765,  26231,  -9774,  26288,  -9657,  26155,
 -9561,  26082,  -9478,  26066,  -9560,  25994,  -9436,  25996,  -9485,  25933,
 -9437,  25927,  -9432,  25886,  -9356,  25847,  -9284,  25754,  -9260,  25670,
 -9273,  25612,  -9417,  25657,  -9541,  25726,  -9693,  25758,  -9854,  25768,
 -9904,  25699,  -9794,  25622,  -9646,  25587,  -9527,  25515,  -9383,  25482,
 -9267,  25485,  -9169,  25452,  -9209,  25363,  -9221,  25284,  -9203,  25189,
 -9211,  25127,  -9284,  25050,  -9309,  24971,  -9459,  24952,  -9574,  24922,
 -9619,  24854,  -9450,  24839,  -9348,  24888,  -9295,  24882,  -9281,  24788,
 -9207,  24734,  -9386,  24771,  -9516,  24796,  -9605,  24803,  -9673,  24794,
 -9631,  24731,  -9744,  24661,  -9727,  24598,  -9602,  24673,  -9477,  24716,
 -9388,  24694,  -9242,  24696,  -9209,  24679,  -9267,  24635,  -9170,  24606,
 -9280,  24600,  -9404,  24628,  -9539,  24657,  -9639,  24629,  -9768,  24549,
 -9746,  24486,  -9603,  24508,  -9473,  24524,  -9347,  24510,  -9247,  24456,
 -9229,  24450,  -9356,  24475,  -9473,  24513,  -9604,  24493,  -9736,  24465,
 -9768,  24413,  -9696,  24366,  -9564,  24340,  -9647,  24275,  -9630,  24215,
 -9755,  24180,  -9717,  24095,  -9590,  24149,  -9493,  24220,  -9404,  24297,
 -9299,  24363,  -9178,  24397,  -9166,  24382,  -9249,  24338,  -9387,  24283,
 -9481,  24206,  -9584,  24139,  -9679,  24070,  -9678,  24010,  -9555,  24008,
 -9481,  24008,  -9652,  23948,  -9605,  23901,  -9548,  23847,  -9439,  23894,
 -9320,  23943,  -9263,  23925,  -9428,  23883,  -9514,  23812,  -9514,  23747,
 -9484,  23627,  -9435,  23619,  -9386,  23632,  -9477,  23522,  -9436,  23421,
 -9341,  23540,  -9263,  23583,  -9245,  23688,  -9134,  23571,  -9080,  23469,
 -9078,  23445,  -9189,  23534,  -9217,  23490,  -9203,  23445,  -9311,  23377,
 -9370,  23349,  -9231,  23373,  -9167,  23368,  -9329,  23317,  -9351,  23265,
 -9316,  23239,  -9357,  23165,  -9284,  23155,  -9257,  23145,  -9281,  23081,
 -9231,  23063,  -9252,  23007,  -9168,  22961,  -9137,  22897,  -9094,  22921,
 -9123,  22846,  -9131,  22721,  -9052,  22670,  -9008,  22618,  -8986,  22576,
 -8937,  22587,  -8958,  22511,  -8909,  22526,  -8914,  22428,  -8824,  22403,
 -8830,  22387,  -8855,  22329,  -8790,  22279,  -8736,  22265,  -8743,  22196,
 -8729,  22143,  -8649,  22162,  -8523,  22169,  -8423,  22219,  -8333,  22251,
 -8268,  22226,  -8344,  22146,  -8279,  22142,  -8306,  22063,  -8246,  22063,
 -8225,  22038,  -8162,  22035,  -8186,  21928,  -8126,  21976,  -8157,  21870,
 -8030,  21931,  -7917,  21888,  -7858,  21920,  -7912,  21990,  -7971,  22054,
 -7838,  22041,  -7826,  22093,  -7856,  22155,  -7799,  22216,  -7862,  22246,
 -7805,  22264,  -7804,  22277,  -7792,  22301,  -7802,  22323,  -7754,  22377,
 -7768,  22416,  -7735,  22461,  -7750,  22483,  -7705,  22553,  -7710,  22657,
 -7743,  22740,  -7772,  22840,  -7677,  22880,  -7606,  22916,  -7617,  22978,
 -7573,  23029,  -7570,  23091,  -7529,  23094,  -7483,  23109,  -7444,  23155,
 -7500,  23205,  -7392,  23231,  -7428,  23325,  -7516,  23400,  -7381,  23451,
 -7429,  23578,  -7454,  23671,  -7342,  23683,  -7268,  23737,  -7263,  23849,
 -7160,  23888,  -7034,  23889,  -6960,  23937,  -6945,  24022,  -6900,  24126,
 -6840,  24154,  -6809,  24106,  -6862,  24008,  -6750,  23988,  -6621,  24020,
 -6531,  24047,

/* 5 */
321, 1,
-12215,  24865, -12293,  24863, -12228,  24901, -12321,  24929, -12471,  24965,
-12443,  24988, -12543,  25040, -12421,  25055, -12398,  25115, -12519,  25158,
-12458,  25197, -12533,  25227, -12479,  25232, -12342,  25195, -12195,  25176,
-12169,  25242, -12299,  25286, -12439,  25310, -12650,  25314, -12580,  25324,
-12436,  25361, -12273,  25392, -12251,  25474, -12345,  25568, -12437,  25529,
-12528,  25460, -12688,  25386, -12672,  25414, -12542,  25515, -12644,  25533,
-12754,  25454, -12753,  25478, -12669,  25552, -12511,  25612, -12457,  25676,
-12593,  25749, -12761,  25726, -12892,  25714, -12978,  25562, -12966,  25624,
-13037,  25641, -13036,  25672, -12914,  25731, -12857,  25839, -12961,  25824,
-13159,  25760, -13129,  25845, -12994,  25899, -12998,  26003, -13140,  26062,
-13244,  26022, -13355,  25907, -13397,  25998, -13475,  25963, -13491,  25983,
-13426,  26088, -13505,  26084, -13616,  25972, -13640,  26040, -13655,  26097,
-13518,  26168, -13602,  26243, -13775,  26148, -13742,  26213, -13858,  26197,
-13849,  26218, -13701,  26267, -13676,  26357, -13823,  26407, -13966,  26459,
-14137,  26470, -14274,  26403, -14123,  26283, -14278,  26304, -14215,  26171,
-14330,  26209, -14380,  26274, -14486,  26331, -14555,  26299, -14661,  26240,
-14720,  26327, -14708,  26387, -14635,  26482, -14671,  26586, -14757,  26675,
-14798,  26780, -14924,  26836, -15108,  26819, -15252,  26735, -15406,  26692,
-15348,  26605, -15499,  26605, -15398,  26529, -15518,  26546, -15593,  26468,
-15511,  26370, -15385,  26277, -15497,  26290, -15605,  26224, -15557,  26133,
-15431,  26071, -15417,  25972, -15435,  25860, -15478,  25883, -15701,  25860,
-15641,  25899, -15497,  25950, -15559,  26038, -15663,  26126, -15724,  26224,
-15715,  26329, -15753,  26428, -15761,  26527, -15694,  26622, -15615,  26721,
-15491,  26802, -15529,  26866, -15717,  26879, -15899,  26851, -16048,  26787,
-16160,  26692, -16234,  26607, -16273,  26498, -16334,  26403, -16348,  26299,
-16371,  26211, -16366,  26104, -16363,  25996, -16225,  25946, -16054,  25931,
-15917,  25856, -16071,  25836, -16241,  25851, -16241,  25758, -16155,  25666,
-16030,  25599, -15898,  25599, -15783,  25630, -15743,  25610, -15688,  25517,
-15565,  25499, -15413,  25493, -15252,  25468, -15102,  25466, -14942,  25426,
-15018,  25540, -14932,  25507, -14773,  25420, -14817,  25491, -14749,  25507,
-14595,  25476, -14466,  25436, -14332,  25476, -14396,  25653, -14298,  25601,
-14186,  25552, -14136,  25436, -14086,  25424, -14014,  25404, -13943,  25343,
-13870,  25262, -13774,  25176, -13892,  25125, -13915,  25032, -13767,  25082,
-13639,  25104, -13596,  25036, -13483,  24973, -13431,  24956, -13375,  24867,
-13293,  24816, -13250,  24708, -13201,  24608, -13163,  24504, -13204,  24420,
-13271,  24327, -13173,  24282, -13027,  24262, -12936,  24368, -12840,  24320,
-12735,  24273, -12638,  24203, -12669,  24114, -12814,  24114, -12933,  24049,
-12952,  24113, -12990,  24212, -13109,  24262, -13241,  24276, -13353,  24248,
-13439,  24168, -13531,  24087, -13483,  23989, -13403,  23874, -13496,  23837,
-13615,  23797, -13760,  23764, -13727,  23698, -13720,  23614, -13744,  23632,
-13779,  23722, -13883,  23777, -14031,  23817, -14093,  23754, -14182,  23676,
-14225,  23578, -14201,  23477, -14117,  23416, -14009,  23385, -13912,  23405,
-13801,  23461, -13725,  23482, -13595,  23466, -13608,  23578, -13575,  23578,
-13486,  23495, -13372,  23509, -13345,  23437, -13281,  23352, -13203,  23266,
-13119,  23208, -13016,  23165, -13070,  23087, -13046,  23012, -12936,  22952,
-12866,  22892, -12734,  22848, -12646,  22811, -12582,  22728, -12491,  22673,
-12374,  22642, -12268,  22612, -12165,  22569, -12055,  22526, -12024,  22604,
-12069,  22688, -12127,  22781, -12208,  22845, -12297,  22924, -12373,  22979,
-12449,  23066, -12527,  23164, -12461,  23186, -12363,  23109, -12344,  23159,
-12318,  23153, -12231,  23063, -12156,  22987, -12130,  23005, -12118,  23005,
-12037,  22939, -11944,  22898, -11873,  22822, -11841,  22848, -11818,  22918,
-11827,  23016, -11851,  23155, -11772,  23074, -11749,  23155, -11795,  23257,
-11850,  23320, -11889,  23426, -11933,  23496, -12001,  23574, -12116,  23628,
-12180,  23706, -12240,  23809, -12320,  23876, -12371,  23932, -12436,  24056,
-12379,  24035, -12294,  23993, -12251,  24047, -12340,  24165, -12275,  24152,
-12265,  24201, -12194,  24226, -12109,  24144, -11980,  24111, -11978,  24052,
-11905,  24023, -11771,  24109, -11791,  24054, -11889,  23977, -11849,  23896,
-11828,  23849, -11761,  23775, -11678,  23719, -11600,  23663, -11546,  23678,
-11545,  23782, -11553,  23906, -11464,  23899, -11406,  23937, -11410,  24030,
-11325,  24040, -11389,  24130, -11263,  24151, -11255,  24212, -11210,  24261,
-11259,  24356, -11353,  24350, -11429,  24306, -11446,  24336, -11546,  24324,
-11555,  24350, -11495,  24466, -11580,  24438, -11732,  24425, -11729,  24477,
-11676,  24537, -11713,  24639, -11811,  24659, -11832,  24718, -11902,  24668,
-11924,  24701, -11991,  24683, -12002,  24753, -12057,  24720, -12110,  24757,
-12223,  24820,

/* 6 */
232, 1,
 25682,  -3349,  25731,  -3339,  25784,  -3356,  25837,  -3350,  25890,  -3345,
 25941,  -3382,  25990,  -3368,  26036,  -3314,  26087,  -3270,  26088,  -3170,
 26051,  -3095,  26001,  -3054,  25950,  -3036,  25895,  -2998,  25911,  -2998,
 25958,  -3019,  26010,  -3025,  26062,  -3016,  26123,  -2991,  26111,  -2907,
 26117,  -2899,  26181,  -2899,  26162,  -2756,  26182,  -2779,  26231,  -2825,
 26275,  -2798,  26309,  -2767,  26360,  -2795,  26405,  -2844,  26455,  -2875,
 26510,  -2892,  26548,  -2917,  26594,  -2974,  26623,  -3063,  26655,  -3151,
 26677,  -3236,  26729,  -3306,  26745,  -3385,  26782,  -3453,  26825,  -3512,
 26854,  -3604,  26900,  -3664,  26950,  -3685,  27000,  -3700,  27060,  -3703,
 27107,  -3732,  27160,  -3740,  27210,  -3764,  27283,  -3804,  27300,  -3857,
 27350,  -3886,  27402,  -3864,  27389,  -3788,  27432,  -3747,  27415,  -3729,
 27364,  -3707,  27314,  -3672,  27269,  -3625,  27285,  -3543,  27258,  -3501,
 27205,  -3489,  27160,  -3427,  27164,  -3303,  27108,  -3297,  27054,  -3303,
 27026,  -3222,  26998,  -3139,  26975,  -3055,  26957,  -2951,  26912,  -2899,
 26870,  -2839,  26835,  -2767,  26792,  -2705,  26770,  -2596,  26748,  -2500,
 26785,  -2451,  26839,  -2456,  26896,  -2435,  26907,  -2343,  26879,  -2260,
 26842,  -2184,  26791,  -2167,  26741,  -2137,  26694,  -2093,  26647,  -2041,
 26596,  -2014,  26541,  -1988,  26532,  -1891,  26532,  -1784,  26500,  -1703,
 26465,  -1626,  26417,  -1591,  26376,  -1524,  26334,  -1467,  26295,  -1403,
 26242,  -1393,  26194,  -1356,  26150,  -1298,  26105,  -1244,  26052,  -1225,
 26001,  -1204,  25950,  -1173,  25901,  -1137,  25853,  -1097,  25804,  -1056,
 25756,  -1010,  25709,   -967,  25658,   -949,  25610,   -928,  25559,   -885,
 25510,   -863,  25458,   -862,  25409,   -827,  25361,   -781,  25313,   -736,
 25265,   -696,  25219,   -644,  25169,   -612,  25121,   -570,  25073,   -547,
 25024,   -590,  24977,   -640,  24966,   -719,  24940,   -776,  24890,   -812,
 24837,   -812,  24807,   -888,  24774,   -968,  24742,  -1045,  24710,  -1124,
 24671,  -1195,  24624,  -1228,  24570,  -1205,  24542,  -1134,  24523,  -1061,
 24501,   -937,  24476,   -988,  24453,   -951,  24425,   -864,  24413,   -763,
 24409,   -658,  24423,   -566,  24428,   -464,  24405,   -353,  24392,   -283,
 24342,   -270,  24289,   -265,  24242,   -209,  24194,   -167,  24144,   -135,
 24091,   -135,  24043,   -176,  24002,   -242,  23948,   -275,  23898,   -305,
 23883,   -405,  23847,   -480,  23860,   -535,  23907,   -528,  23966,   -556,
 24007,   -586,  24018,   -674,  24042,   -755,  24090,   -815,  24143,   -820,
 24196,   -825,  24249,   -809,  24304,   -810,  24353,   -782,  24371,   -832,
 24346,   -926,  24292,   -939,  24268,   -914,  24221,   -899,  24184,   -974,
 24141,  -1006,  24093,   -985,  24034,  -1017,  24059,  -1072,  24109,  -1112,
 24147,  -1190,  24180,  -1258,  24168,  -1343,  24177,  -1448,  24219,  -1486,
 24266,  -1450,  24287,  -1361,  24308,  -1259,  24349,  -1124,  24337,  -1175,
 24340,  -1309,  24378,  -1373,  24429,  -1418,  24479,  -1444,  24539,  -1433,
 24521,  -1469,  24548,  -1556,  24595,  -1609,  24646,  -1619,  24699,  -1634,
 24750,  -1656,  24798,  -1699,  24847,  -1736,  24896,  -1780,  24945,  -1797,
 24991,  -1829,  25042,  -1884,  25086,  -1940,  25125,  -2006,  25162,  -2100,
 25175,  -2197,  25193,  -2295,  25240,  -2404,  25256,  -2463,  25309,  -2514,
 25302,  -2514,  25241,  -2521,  25304,  -2616,  25261,  -2622,  25264,  -2660,
 25301,  -2743,  25296,  -2844,  25281,  -2967,  25331,  -2932,  25351,  -2960,
 25401,  -2969,  25480,  -2921,  25487,  -2999,  25530,  -3072,  25569,  -3143,
 25602,  -3225,  25641,  -3296,

/* 7 */
154, 1,
 21416,   1571,  21475,   1549,  21528,   1575,  21572,   1630,  21524,   1717,
 21519,   1802,  21569,   1809,  21621,   1814,  21672,   1848,  21705,   1921,
 21670,   1973,  21628,   1998,  21583,   2049,  21538,   2111,  21486,   2084,
 21484,   2141,  21455,   2176,  21408,   2148,  21403,   2170,  21416,   2268,
 21413,   2361,  21368,   2404,  21338,   2498,  21306,   2517,  21268,   2454,
 21241,   2516,  21217,   2411,  21182,   2330,  21152,   2265,  21128,   2174,
 21098,   2079,  21052,   2022,  21015,   1991,  21017,   1911,  21021,   1832,
 20972,   1787,  20933,   1801,  20881,   1774,  20839,   1709,  20790,   1673,
 20747,   1638,  20728,   1531,  20695,   1448,  20655,   1377,  20624,   1294,
 20590,   1212,  20554,   1141,  20504,   1110,  20453,   1085,  20402,   1059,
 20350,   1044,  20302,   1006,  20283,    914,  20261,    862,  20248,    777,
 20226,    669,  20223,    583,  20234,    512,  20154,    554,  20106,    608,
 20065,    626,  20007,    628,  19965,    693,  19936,    728,  19896,    662,
 19865,    578,  19858,    473,  19830,    391,  19818,    283,  19825,    173,
 19845,     95,  19876,      8,  19861,    -94,  19872,   -195,  19905,   -252,
 19914,   -320,  19965,   -344,  20003,   -420,  20029,   -510,  20018,   -620,
 20023,   -696,  20041,   -793,  20057,   -909,  20059,   -997,  20080,  -1074,
 20136,  -1085,  20178,  -1087,  20231,  -1095,  20282,  -1075,  20324,  -1060,
 20340,  -1045,  20352,  -1157,  20369,  -1267,  20429,  -1214,  20483,  -1241,
 20531,  -1200,  20564,  -1130,  20588,  -1107,  20631,  -1171,  20678,  -1192,
 20704,  -1260,  20752,  -1216,  20790,  -1205,  20834,  -1256,  20856,  -1349,
 20860,  -1456,  20883,  -1508,  20933,  -1459,  20981,  -1418,  21031,  -1380,
 21079,  -1333,  21114,  -1267,  21141,  -1176,  21142,  -1099,  21160,  -1052,
 21183,   -933,  21217,   -853,  21197,   -795,  21183,   -752,  21179,   -638,
 21218,   -540,  21249,   -454,  21258,   -425,  21305,   -412,  21343,   -325,
 21388,   -281,  21392,   -180,  21379,    -79,  21384,     32,  21397,    132,
 21420,    227,  21458,    293,  21472,    346,  21475,    373,  21524,    311,
 21574,    301,  21626,    308,  21644,    381,  21604,    456,  21559,    521,
 21516,    581,  21476,    647,  21449,    739,  21483,    834,  21456,    927,
 21423,   1024,  21402,   1093,  21361,   1181,  21352,   1262,  21333,   1320,
 21396,   1339,  21429,   1376,  21397,   1445,  21377,   1506,

/* 8 */
165, 2,
-13865,  30060, -14033,  30148, -14336,  30176, -14479,  30126, -14577,  30109,
-14813,  30087, -14964,  30012, -14806,  29913, -14520,  29828, -14593,  29833,
-14985,  29898, -15155,  29929, -15429,  30002, -15627,  29960, -15537,  29843,
-15801,  29848, -16122,  29858, -16501,  29754, -16425,  29678, -16107,  29673,
-16252,  29636, -16335,  29548, -16123,  29503, -15635,  29553, -15746,  29499,
-16153,  29459, -16002,  29368, -15788,  29415, -15579,  29494, -15162,  29535,
-15245,  29512, -15555,  29472, -15742,  29376, -15600,  29321, -15242,  29368,
-15036,  29372, -14782,  29350, -14521,  29415, -14403,  29521, -14123,  29612,
-14166,  29580, -14328,  29481, -14071,  29446, -14127,  29420, -14432,  29372,
-14343,  29338, -14388,  29321, -14681,  29291, -15014,  29254, -15035,  29176,
-14864,  29087, -14668,  29005, -14749,  28978, -14911,  29028, -15064,  29119,
-15264,  29200, -15569,  29229, -15756,  29184, -15661,  29091, -15568,  29005,
-15413,  28917, -15302,  28801, -15289,  28742, -14931,  28735, -15036,  28659,
-15240,  28688, -15507,  28713, -15766,  28667, -15872,  28578, -15892,  28461,
-15661,  28461, -15455,  28540, -15409,  28492, -15419,  28431, -15483,  28347,
-15429,  28259, -15241,  28230, -15063,  28367, -15064,  28318, -15192,  28210,
-15320,  28159, -15542,  28178, -15639,  28262, -15796,  28341, -16027,  28314,
-15980,  28214, -15849,  28131, -15891,  28081, -16115,  28049, -16270,  27963,
-16267,  27855, -16131,  27876, -15995,  27834, -15774,  27840, -15601,  27787,
-15425,  27816, -15230,  27870, -15010,  27879, -14838,  27849, -14718,  27754,
-14539,  27760, -14347,  27834, -14197,  27888, -14173,  27988, -14338,  27997,
-14414,  28068, -14601,  28093, -14852,  28112, -14865,  28194, -14785,  28188,
-14580,  28137, -14339,  28150, -14190,  28233, -14204,  28351, -13935,  28377,
-13870,  28441, -13755,  28485, -13832,  28564, -13691,  28592, -13652,  28688,
-13882,  28735, -14173,  28717, -14230,  28753, -14078,  28801, -13909,  28819,
-13633,  28790, -13704,  28841, -14059,  28864, -13966,  28913, -13695,  28913,
-13423,  28939, -13464,  29044, -13321,  29044, -13015,  29040, -13021,  29155,
-12809,  29254, -12597,  29295, -12440,  29385, -12238,  29463, -12025,  29548,
-11782,  29631, -11937,  29664, -12249,  29617, -12643,  29548, -12576,  29580,
-12249,  29645, -12456,  29702, -12344,  29702, -11970,  29730, -11669,  29774,
-11366,  29848, -11164,  29934, -11367,  30023, -11540,  30098, -11815,  30148,
-12279,  30104, -12185,  30148, -12364,  30198, -12811,  30227, -13072,  30221,
-13305,  30159, -13488,  30193, -13864,  30221, -13954,  30165, -13814,  30066,

/* 9 */
141, -1,
-15697,  15663, -15709,  15731, -15737,  15823, -15740,  15924, -15738,  16031,
-15709,  16130, -15697,  16236, -15665,  16324, -15599,  16412, -15573,  16345,
-15544,  16376, -15530,  16480, -15478,  16550, -15448,  16653, -15374,  16632,
-15309,  16582, -15244,  16534, -15183,  16477, -15173,  16384, -15161,  16271,
-15169,  16163, -15206,  16081, -15257,  16000, -15263,  15903, -15203,  15906,
-15162,  15989, -15090,  16027, -15043,  15952, -15029,  15848, -15017,  15743,
-14979,  15674, -14914,  15734, -14873,  15816, -14873,  15923, -14872,  16031,
-14846,  16130, -14803,  16216, -14800,  16321, -14845,  16435, -14802,  16445,
-14758,  16350, -14727,  16276, -14662,  16247, -14586,  16206, -14537,  16304,
-14542,  16367, -14575,  16471, -14623,  16549, -14664,  16624, -14707,  16710,
-14782,  16736, -14856,  16758, -14932,  16787, -15009,  16809, -15079,  16812,
-15153,  16821, -15228,  16845, -15295,  16885, -15363,  16940, -15373,  17030,
-15409,  17105, -15407,  17219, -15456,  17310, -15456,  17422, -15519,  17454,
-15597,  17453, -15655,  17516, -15688,  17613, -15718,  17720, -15784,  17752,
-15863,  17757, -15943,  17789, -16030,  17825, -16082,  17712, -16153,  17649,
-16214,  17649, -16247,  17559, -16294,  17484, -16362,  17425, -16434,  17385,
-16506,  17343, -16568,  17278, -16621,  17199, -16677,  17127, -16742,  17044,
-16703,  17005, -16625,  17042, -16555,  17079, -16538,  17008, -16503,  16976,
-16427,  16973, -16360,  17025, -16287,  17054, -16218,  17100, -16144,  17162,
-16102,  17075, -16062,  17070, -15988,  17069, -15934,  17007, -15878,  16937,
-15797,  16917, -15732,  16946, -15664,  16992, -15586,  16996, -15496,  17018,
-15461,  16936, -15385,  16915, -15331,  16868, -15296,  16773, -15337,  16741,
-15408,  16730, -15470,  16741, -15543,  16776, -15615,  16735, -15691,  16720,
-15747,  16643, -15765,  16655, -15809,  16673, -15848,  16660, -15885,  16569,
-15922,  16478, -15958,  16386, -16006,  16265, -15930,  16296, -15924,  16186,
-15936,  16082, -15964,  15982, -15970,  15879, -15992,  15780, -15994,  15677,
-15979,  15573, -15981,  15467, -15977,  15362, -15950,  15267, -15916,  15174,
-15851,  15165, -15790,  15218, -15750,  15303, -15716,  15396, -15697,  15497,
-15692,  15601,

/* 10 */
132, 1,
 21861,  -2035,  21906,  -2019,  21901,  -1921,  21894,  -1822,  21912,  -1726,
 21910,  -1619,  21907,  -1515,  21909,  -1411,  21916,  -1311,  21911,  -1201,
 21887,  -1102,  21921,  -1024,  21964,   -967,  22015,   -972,  22031,  -1043,
 22028,  -1160,  22004,  -1260,  22034,  -1347,  22072,  -1414,  22121,  -1474,
 22122,  -1561,  22112,  -1672,  22145,  -1746,  22205,  -1748,  22231,  -1647,
 22282,  -1616,  22335,  -1605,  22361,  -1526,  22324,  -1471,  22301,  -1398,
 22255,  -1323,  22264,  -1219,  22274,  -1137,  22246,  -1047,  22208,   -967,
 22182,   -873,  22146,   -800,  22095,   -698,  22136,   -692,  22178,   -621,
 22228,   -584,  22274,   -534,  22310,   -456,  22342,   -375,  22384,   -323,
 22434,   -355,  22462,   -269,  22419,   -209,  22362,   -246,  22326,   -282,
 22275,   -277,  22227,   -314,  22178,   -345,  22128,   -315,  22083,   -386,
 22052,   -471,  22011,   -508,  21960,   -481,  21936,   -383,  21894,   -326,
 21859,   -246,  21846,   -145,  21846,    -40,  21864,     58,  21894,    144,
 21940,    190,  21991,    167,  22042,    160,  22097,    175,  22145,    183,
 22195,    163,  22246,    175,  22303,    179,  22349,    177,  22403,    165,
 22449,    113,  22502,    107,  22555,    120,  22606,    138,  22655,    181,
 22682,    264,  22719,    341,  22753,    421,  22780,    518,  22768,    606,
 22726,    574,  22682,    495,  22655,    432,  22614,    368,  22565,    319,
 22514,    311,  22463,    328,  22414,    343,  22361,    318,  22311,    350,
 22259,    370,  22207,    384,  22156,    391,  22107,    431,  22065,    460,
 22010,    483,  21985,    407,  21953,    322,  21903,    325,  21867,    284,
 21839,    200,  21810,    106,  21797,     -9,  21800,    -99,  21802,   -250,
 21767,   -292,  21739,   -387,  21716,   -478,  21715,   -583,  21716,   -693,
 21688,   -785,  21677,   -887,  21637,   -960,  21625,  -1040,  21624,  -1141,
 21642,  -1266,  21690,  -1268,  21740,  -1284,  21750,  -1389,  21769,  -1479,
 21769,  -1594,  21756,  -1697,  21748,  -1801,  21728,  -1898,  21737,  -2008,
 21775,  -2060,  21828,  -2039,

/* 11 */
133, 1,
 17330,   2011,  17334,   1932,  17351,   1836,  17376,   1738,  17411,   1664,
 17450,   1587,  17490,   1518,  17528,   1447,  17566,   1373,  17619,   1350,
 17656,   1274,  17688,   1189,  17717,   1102,  17758,   1035,  17772,    933,
 17791,    839,  17839,    809,  17886,    750,  17931,    699,  17972,    612,
 17980,    517,  17999,    419,  18015,    318,  18032,    219,  18047,    112,
 18092,     67,  18138,     16,  18161,    -74,  18192,   -156,  18226,   -236,
 18259,   -320,  18274,   -422,  18304,   -510,  18325,   -604,  18353,   -695,
 18358,   -798,  18383,   -894,  18420,   -967,  18453,  -1044,  18480,  -1135,
 18516,  -1210,  18559,  -1271,  18602,  -1336,  18621,  -1433,  18658,  -1507,
 18700,  -1570,  18740,  -1638,  18784,  -1697,  18823,  -1762,  18872,  -1811,
 18911,  -1881,  18941,  -1963,  18981,  -2039,  19033,  -2130,  19035,  -2040,
 19066,  -2029,  19124,  -2090,  19151,  -2030,  19187,  -2038,  19231,  -2112,
 19259,  -2052,  19263,  -1947,  19269,  -1843,  19270,  -1738,  19271,  -1633,
 19260,  -1531,  19276,  -1423,  19263,  -1327,  19282,  -1224,  19303,  -1138,
 19271,  -1065,  19242,   -981,  19213,   -888,  19158,   -861,  19104,   -852,
 19050,   -942,  19055,   -873,  19081,   -773,  19039,   -713,  19021,   -640,
 19011,   -535,  19002,   -432,  18971,   -382,  18914,   -371,  18869,   -346,
 18826,   -277,  18829,   -184,  18821,   -112,  18829,    -63,  18870,     -8,
 18881,     86,  18844,    150,  18795,    178,  18749,    123,  18675,     78,
 18700,    101,  18749,    161,  18731,    248,  18679,    268,  18633,    309,
 18602,    391,  18585,    489,  18545,    560,  18500,    605,  18454,    645,
 18432,    743,  18392,    815,  18359,    743,  18324,    766,  18282,    824,
 18242,    941,  18204,    972,  18190,   1069,  18154,   1146,  18110,   1202,
 18069,   1268,  18025,   1323,  17976,   1371,  17940,   1445,  17888,   1497,
 17883,   1564,  17854,   1650,  17829,   1733,  17797,   1812,  17756,   1886,
 17704,   1887,  17654,   1914,  17602,   1908,  17550,   1900,  17498,   1924,
 17456,   1984,  17411,   2038,  17359,   2043,

/* 12 */
129, -1,
  8963,  14277,   8926,  14215,   8893,  14110,   8896,  13999,   8898,  13894,
  8911,  13791,   8941,  13700,   8999,  13649,   9071,  13636,   9128,  13602,
  9167,  13515,   9218,  13449,   9274,  13394,   9335,  13358,   9399,  13334,
  9464,  13319,   9528,  13346,   9592,  13369,   9656,  13397,   9720,  13422,
  9786,  13433,   9806,  13435,   9812,  13592,   9800,  13696,   9793,  13802,
  9801,  13907,   9799,  14013,   9813,  14115,   9795,  14205,   9760,  14275,
  9688,  14305,   9676,  14379,   9706,  14398,   9748,  14415,   9726,  14526,
  9644,  14521,   9603,  14597,   9595,  14700,   9616,  14804,   9649,  14889,
  9723,  14849,   9770,  14831,   9820,  14801,   9883,  14838,   9942,  14889,
  9946,  14975,   9887,  15046,   9839,  15122,   9821,  15226,   9791,  15321,
  9716,  15325,   9651,  15294,   9618,  15189,   9620,  15092,   9609,  15018,
  9561,  15166,   9548,  15267,   9553,  15364,   9582,  15460,   9578,  15546,
  9503,  15595,   9436,  15624,   9388,  15706,   9337,  15749,   9322,  15860,
  9286,  15950,   9258,  16045,   9211,  16114,   9149,  16160,   9168,  16241,
  9247,  16238,   9318,  16205,   9354,  16234,   9287,  16345,   9329,  16426,
  9377,  16509,   9446,  16525,   9525,  16525,   9598,  16508,   9651,  16526,
  9613,  16635,   9652,  16727,   9671,  16828,   9661,  16933,   9665,  17032,
  9606,  17088,   9526,  17074,   9462,  17064,   9400,  17107,   9326,  17140,
  9250,  17102,   9188,  17056,   9126,  17002,   9050,  16944,   8983,  16923,
  8945,  16840,   8883,  16778,   8844,  16705,   8762,  16650,   8679,  16624,
  8641,  16593,   8620,  16469,   8586,  16372,   8550,  16310,   8502,  16216,
  8545,  16144,   8597,  16073,   8634,  15968,   8647,  15900,   8648,  15763,
  8647,  15659,   8683,  15568,   8717,  15480,   8759,  15394,   8795,  15303,
  8841,  15229,   8887,  15148,   8927,  15063,   8951,  14964,   8990,  14877,
  9029,  14794,   9100,  14764,   9156,  14707,   9143,  14672,   9070,  14671,
  9009,  14602,   8994,  14500,   8977,  14395,   8988,  14316,

/* 13 */
124, 1,
  7876,  -8007,   7876,  -8099,   7883,  -8212,   7898,  -8314,   7932,  -8399,
  7950,  -8499,   7958,  -8588,   7950,  -8696,   7952,  -8801,   7968,  -8897,
  8000,  -8982,   8021,  -9083,   8072,  -9161,   8111,  -9199,   8167,  -9229,
  8216,  -9293,   8271,  -9302,   8324,  -9262,   8374,  -9207,   8428,  -9168,
  8487,  -9157,   8541,  -9120,   8581,  -9056,   8602,  -8951,   8621,  -8850,
  8642,  -8753,   8664,  -8655,   8676,  -8551,   8693,  -8451,   8707,  -8349,
  8716,  -8245,   8731,  -8142,   8748,  -8042,   8769,  -7946,   8787,  -7845,
  8803,  -7745,   8817,  -7642,   8831,  -7539,   8846,  -7437,   8867,  -7340,
  8883,  -7248,   8898,  -7139,   8917,  -7040,   8933,  -6939,   8954,  -6842,
  8974,  -6743,   8990,  -6642,   8999,  -6541,   9011,  -6438,   9000,  -6336,
  9012,  -6233,   9043,  -6150,   9062,  -6088,   9073,  -5976,   9062,  -5878,
  9048,  -5778,   9038,  -5673,   9076,  -5637,   9100,  -5734,   9139,  -5794,
  9171,  -5705,   9188,  -5603,   9178,  -5505,   9153,  -5411,   9139,  -5309,
  9135,  -5203,   9129,  -5098,   9121,  -4993,   9105,  -4889,   9091,  -4792,
  9073,  -4695,   9038,  -4630,   9016,  -4527,   8968,  -4420,   8933,  -4467,
  8891,  -4541,   8904,  -4647,   8894,  -4747,   8879,  -4852,   8831,  -4898,
  8792,  -4982,   8749,  -4942,   8719,  -4978,   8733,  -5134,   8711,  -5179,
  8712,  -5315,   8677,  -5366,   8648,  -5464,   8634,  -5396,   8608,  -5430,
  8571,  -5591,   8540,  -5554,   8491,  -5609,   8451,  -5671,   8443,  -5763,
  8433,  -5788,   8387,  -5749,   8337,  -5749,   8297,  -5809,   8245,  -5830,
  8191,  -5869,   8144,  -5897,   8093,  -5926,   8090,  -6039,   8068,  -6136,
  8039,  -6228,   8012,  -6316,   8005,  -6417,   8015,  -6516,   8018,  -6620,
  8028,  -6722,   8052,  -6817,   8056,  -6915,   8076,  -7018,   8094,  -7113,
  8091,  -7217,   8084,  -7311,   8056,  -7403,   8028,  -7486,   7997,  -7581,
  7980,  -7683,   7940,  -7749,   7913,  -7818,   7898,  -7927,

/* 14 */
122, 1,
 25660,  15101,  25628,  15017,  25685,  14997,  25695,  14909,  25628,  14891,
 25574,  14986,  25539,  14932,  25507,  14839,  25465,  14766,  25481,  14659,
 25451,  14539,  25491,  14449,  25484,  14343,  25460,  14247,  25442,  14145,
 25407,  14055,  25382,  13956,  25359,  13859,  25304,  13801,  25261,  13726,
 25229,  13634,  25183,  13561,  25126,  13512,  25065,  13468,  25010,  13416,
 24952,  13398,  24929,  13506,  24981,  13611,  24942,  13627,  24888,  13572,
 24887,  13475,  24878,  13369,  24842,  13282,  24795,  13205,  24756,  13118,
 24759,  13007,  24710,  12939,  24648,  12926,  24608,  12974,  24538,  12975,
 24473,  12966,  24413,  12931,  24348,  12920,  24273,  12923,  24218,  12937,
 24155,  12894,  24114,  12816,  24067,  12745,  24020,  12674,  23966,  12614,
 23919,  12546,  23862,  12521,  23823,  12457,  23841,  12371,  23908,  12369,
 23971,  12380,  24031,  12326,  24056,  12369,  24076,  12473,  24126,  12471,
 24205,  12490,  24251,  12501,  24300,  12544,  24373,  12565,  24427,  12617,
 24483,  12652,  24544,  12630,  24603,  12617,  24645,  12586,  24600,  12485,
 24592,  12380,  24621,  12289,  24655,  12215,  24715,  12190,  24752,  12264,
 24791,  12367,  24825,  12444,  24887,  12479,  24910,  12527,  24859,  12603,
 24869,  12703,  24914,  12697,  24963,  12630,  24998,  12607,  25061,  12613,
 25134,  12605,  25174,  12672,  25239,  12752,  25272,  12636,  25318,  12709,
 25329,  12809,  25406,  12827,  25455,  12936,  25457,  12853,  25450,  12739,
 25488,  12748,  25543,  12807,  25562,  12913,  25609,  12983,  25623,  13037,
 25592,  13131,  25589,  13233,  25606,  13336,  25636,  13429,  25662,  13521,
 25668,  13626,  25662,  13729,  25649,  13832,  25675,  13938,  25732,  13960,
 25755,  13991,  25758,  14086,  25789,  14180,  25827,  14270,  25845,  14374,
 25841,  14474,  25824,  14579,  25803,  14675,  25759,  14760,  25737,  14858,
 25736,  14964,  25725,  15055,

/* 15 */
125, 1,
  -914,  21320,   -922,  21245,   -962,  21173,   -954,  21093,   -977,  21072,
 -1040,  21032,  -1037,  20921,  -1015,  20846,  -1037,  20748,  -1073,  20646,
 -1046,  20582,   -964,  20642,   -955,  20620,   -986,  20546,  -1020,  20419,
 -1018,  20329,  -1034,  20180,   -999,  20231,   -981,  20330,   -941,  20436,
  -906,  20378,   -888,  20301,   -855,  20205,   -892,  20101,   -926,  20002,
  -888,  19931,   -789,  19946,   -707,  19958,   -600,  20005,   -604,  19972,
  -650,  19869,   -623,  19772,   -558,  19713,   -535,  19638,   -545,  19541,
  -542,  19423,   -599,  19403,   -690,  19399,   -769,  19351,   -837,  19253,
  -792,  19238,   -738,  19161,   -750,  19066,   -808,  18992,   -886,  18945,
  -944,  18867,   -898,  18807,   -785,  18815,   -737,  18773,   -671,  18742,
  -594,  18714,   -483,  18796,   -511,  18732,   -560,  18652,   -643,  18639,
  -730,  18639,   -790,  18577,   -835,  18493,   -888,  18412,   -937,  18334,
 -1013,  18258,   -980,  18223,   -921,  18242,   -865,  18302,   -777,  18324,
  -698,  18294,   -642,  18348,   -607,  18434,   -517,  18455,   -441,  18414,
  -359,  18441,   -271,  18489,   -201,  18497,   -141,  18483,    -48,  18495,
    36,  18482,    115,  18519,    185,  18564,    248,  18663,    132,  18721,
   162,  18816,    226,  18895,    282,  18964,    310,  19064,    312,  19167,
   259,  19246,    177,  19276,     91,  19252,     28,  19260,     59,  19368,
    20,  19465,    -80,  19539,    -12,  19534,    -25,  19620,    -43,  19717,
   -97,  19812,   -178,  19870,   -228,  19926,   -260,  20029,   -283,  20130,
  -310,  20233,   -368,  20313,   -441,  20374,   -522,  20386,   -628,  20385,
  -604,  20403,   -508,  20465,   -547,  20525,   -545,  20544,   -466,  20593,
  -419,  20679,   -382,  20779,   -346,  20876,   -342,  20965,   -432,  20991,
  -529,  20995,   -628,  20998,   -755,  20965,   -728,  21038,   -691,  21126,
  -618,  21198,   -575,  21312,   -663,  21330,   -776,  21306,   -860,  21311,

/* 16 */
107, 1,
-20846,  26431, -20788,  26482, -20749,  26584, -20805,  26684, -20969,  26670,
-21126,  26619, -21281,  26562, -21410,  26496, -21529,  26419, -21538,  26315,
-21626,  26224, -21659,  26102, -21515,  26075, -21471,  26031, -21371,  25998,
-21196,  26018, -21022,  26033, -21066,  26007, -21166,  25968, -21319,  25927,
-21473,  25886, -21522,  25804, -21404,  25718, -21254,  25703, -21103,  25697,
-20940,  25701, -20784,  25726, -20633,  25714, -20488,  25674, -20338,  25610,
-20402,  25579, -20533,  25564, -20695,  25581, -20847,  25591, -21003,  25575,
-21154,  25550, -21302,  25517, -21354,  25436, -21268,  25339, -21189,  25266,
-21049,  25217, -20904,  25211, -20729,  25199, -20679,  25129, -20666,  25026,
-20589,  24935, -20448,  24937, -20285,  24950, -20169,  24965, -20024,  24979,
-19883,  25007, -19761,  25073, -19627,  25100, -19506,  25156, -19430,  25258,
-19348,  25209, -19235,  25168, -19123,  25115, -18994,  25078, -18847,  25051,
-18705,  25061, -18562,  25142, -18602,  25250, -18746,  25207, -18759,  25248,
-18807,  25328, -18716,  25345, -18603,  25410, -18453,  25386, -18366,  25438,
-18427,  25531, -18545,  25587, -18720,  25676, -18820,  25695, -18925,  25773,
-19014,  25866, -18999,  25974, -19011,  26077, -19075,  26175, -19116,  26277,
-19154,  26380, -19185,  26482, -19266,  26576, -19398,  26653, -19579,  26670,
-19685,  26607, -19668,  26491, -19636,  26389, -19611,  26288, -19552,  26179,
-19598,  26099, -19687,  26121, -19723,  26222, -19767,  26327, -19816,  26426,
-19925,  26505, -20068,  26567, -20053,  26489, -20040,  26400, -20194,  26366,
-20303,  26327, -20331,  26336, -20261,  26440, -20363,  26517, -20538,  26562,
-20663,  26475, -20778,  26431,

/* 17 */
87, 1,
-15447,   7952, -15390,   7961, -15347,   7955, -15292,   8005, -15253,   8070,
-15196,   8081, -15150,   8125, -15106,   8194, -15057,   8251, -15000,   8257,
-14942,   8253, -14877,   8219, -14926,   8157, -14907,   8100, -14857,   8078,
-14791,   8060, -14759,   8057, -14706,   8027, -14646,   8039, -14601,   7962,
-14549,   7910, -14492,   7885, -14440,   7852, -14384,   7855, -14328,   7857,
-14296,   7763, -14281,   7664, -14240,   7593, -14194,   7541, -14137,   7532,
-14074,   7523, -14043,   7436, -14081,   7355, -14128,   7260, -14079,   7234,
-14027,   7240, -13972,   7256, -13914,   7263, -13859,   7271, -13804,   7264,
-13749,   7241, -13681,   7262, -13642,   7263, -13589,   7297, -13517,   7341,
-13556,   7411, -13598,   7484, -13652,   7526, -13708,   7535, -13767,   7563,
-13773,   7641, -13826,   7679, -13872,   7715, -13931,   7734, -13974,   7768,
-14026,   7833, -14057,   7860, -14101,   7951, -14093,   7918, -14102,   7913,
-14162,   7965, -14202,   8019, -14250,   8073, -14299,   8120, -14344,   8144,
-14409,   8149, -14459,   8189, -14497,   8266, -14542,   8326, -14598,   8346,
-14660,   8389, -14704,   8402, -14767,   8414, -14820,   8410, -14867,   8428,
-14925,   8436, -14983,   8430, -15036,   8392, -15096,   8374, -15146,   8359,
-15201,   8318, -15256,   8282, -15306,   8239, -15347,   8161, -15352,   8054,
-15372,   8016, -15433,   7982,

/* 18 */
90, 1,
-10149,  18761, -10207,  18762, -10281,  18711, -10335,  18637, -10371,  18553,
-10421,  18445, -10458,  18364, -10486,  18265, -10518,  18167, -10534,  18034,
-10591,  17977, -10558,  17880, -10614,  17860, -10692,  17726, -10752,  17687,
-10658,  17650, -10693,  17579, -10751,  17507, -10799,  17424, -10768,  17327,
-10680,  17332, -10613,  17358, -10536,  17348, -10457,  17333, -10383,  17317,
-10314,  17324, -10228,  17364, -10167,  17413, -10156,  17378, -10184,  17309,
-10147,  17289, -10087,  17326, -10031,  17348,  -9993,  17333, -10048,  17256,
-10095,  17171, -10166,  17122, -10142,  17064, -10068,  17089, -10023,  17166,
 -9948,  17262,  -9910,  17276,  -9875,  17390,  -9835,  17394,  -9808,  17280,
 -9826,  17197,  -9857,  17091,  -9824,  17057,  -9768,  17143,  -9749,  17120,
 -9742,  17021,  -9671,  16997,  -9627,  17098,  -9612,  17191,  -9594,  17330,
 -9657,  17287,  -9683,  17330,  -9647,  17478,  -9706,  17448,  -9755,  17337,
 -9793,  17399,  -9790,  17499,  -9740,  17559,  -9669,  17656,  -9725,  17663,
 -9798,  17633,  -9790,  17681,  -9815,  17749,  -9786,  17836,  -9749,  17928,
 -9827,  17994,  -9901,  17985,  -9968,  17968, -10045,  17942, -10094,  17988,
-10169,  18009, -10192,  18062, -10138,  18158, -10205,  18212, -10266,  18172,
-10325,  18081, -10339,  18112, -10320,  18209, -10276,  18316, -10237,  18397,
-10204,  18493, -10154,  18576, -10186,  18650, -10162,  18689, -10103,  18745,

/* 19 */
80, 1,
 32202, -14433,  32201, -14362,  32231, -14272,  32292, -14227,  32360, -14249,
 32383, -14241,  32388, -14121,  32432, -14054,  32456, -13959,  32462, -13854,
 32484, -13739,  32427, -13674,  32364, -13708,  32321, -13784,  32253, -13829,
 32196, -13805,  32135, -13761,  32055, -13697,  32033, -13629,  32014, -13523,
 31996, -13415,  31952, -13332,  31939, -13398,  31947, -13524,  31900, -13479,
 31821, -13420,  31809, -13343,  31810, -13248,  31787, -13151,  31754, -13041,
 31762, -12960,  31722, -12858,  31681, -12808,  31630, -12751,  31565, -12713,
 31515, -12670,  31475, -12562,  31465, -12613,  31503, -12698,  31515, -12801,
 31565, -12878,  31571, -12967,  31610, -13059,  31674, -13194,  31658, -13107,
 31665, -13124,  31728, -13181,  31733, -13279,  31723, -13336,  31754, -13443,
 31809, -13466,  31799, -13520,  31804, -13603,  31827, -13735,  31821, -13837,
 31804, -13902,  31785, -14019,  31773, -14123,  31723, -14187,  31661, -14229,
 31627, -14310,  31666, -14390,  31728, -14432,  31782, -14498,  31847, -14540,
 31895, -14634,  31890, -14707,  31873, -14814,  31837, -14909,  31798, -14997,
 31826, -15045,  31888, -15115,  31947, -15106,  32003, -15042,  32046, -14961,
 32078, -14870,  32114, -14776,  32154, -14686,  32190, -14601,  32217, -14471,

/* 20 */
78, 1,
 22241,   6725,  22206,   6670,  22148,   6674,  22102,   6720,  22053,   6771,
 21997,   6769,  21950,   6719,  21932,   6609,  21918,   6506,  21907,   6404,
 21916,   6299,  21916,   6192,  21897,   6088,  21897,   5990,  21906,   5882,
 21871,   5850,  21819,   5928,  21799,   5831,  21821,   5744,  21826,   5641,
 21841,   5542,  21851,   5434,  21881,   5378,  21922,   5275,  21948,   5375,
 22001,   5350,  22003,   5262,  21957,   5182,  21952,   5088,  21977,   5047,
 22021,   4990,  22078,   4962,  22112,   5029,  22164,   5065,  22215,   5014,
 22255,   4945,  22306,   4841,  22314,   4921,  22294,   5041,  22336,   5025,
 22368,   4949,  22415,   4882,  22438,   4789,  22469,   4729,  22535,   4691,
 22552,   4597,  22586,   4600,  22591,   4725,  22540,   4768,  22527,   4840,
 22491,   4942,  22536,   4998,  22517,   5050,  22462,   5089,  22426,   5055,
 22390,   5121,  22345,   5201,  22296,   5210,  22254,   5144,  22230,   5078,
 22176,   5122,  22152,   5210,  22139,   5323,  22135,   5404,  22112,   5501,
 22099,   5594,  22128,   5699,  22132,   5796,  22201,   5877,  22225,   5880,
 22245,   5969,  22269,   6071,  22289,   6168,  22283,   6266,  22251,   6338,
 22232,   6444,  22236,   6550,  22256,   6647,

/* 21 */
83, 1,
 31686, -15127,  31695, -15021,  31680, -14962,  31639, -14966,  31634, -14921,
 31565, -14983,  31504, -15002,  31483, -14882,  31433, -14809,  31430, -14762,
 31352, -14842,  31324, -14930,  31320, -15039,  31287, -15135,  31229, -15203,
 31197, -15283,  31177, -15386,  31194, -15432,  31218, -15418,  31148, -15492,
 31129, -15592,  31097, -15612,  31031, -15673,  30987, -15732,  30918, -15823,
 30859, -15884,  30800, -15926,  30767, -15988,  30676, -16020,  30617, -16088,
 30573, -16158,  30537, -16250,  30485, -16327,  30431, -16395,  30419, -16477,
 30400, -16519,  30370, -16560,  30358, -16647,  30326, -16725,  30356, -16775,
 30426, -16837,  30505, -16824,  30572, -16879,  30634, -16920,  30672, -16956,
 30755, -16976,  30827, -16971,  30895, -16923,  30948, -16841,  30994, -16760,
 31062, -16685,  31079, -16592,  31105, -16492,  31127, -16378,  31084, -16328,
 31158, -16278,  31169, -16174,  31143, -16100,  31148, -16091,  31207, -16066,
 31274, -16027,  31320, -15956,  31263, -15870,  31214, -15793,  31183, -15743,
 31263, -15862,  31322, -15928,  31380, -15943,  31422, -15956,  31487, -15935,
 31443, -15861,  31374, -15826,  31339, -15799,  31413, -15771,  31392, -15745,
 31455, -15718,  31516, -15657,  31556, -15575,  31589, -15476,  31632, -15399,
 31660, -15320,  31708, -15213,  31687, -15167,

/* 22 */
75, 1,
 20026,  -2874,  20074,  -2920,  20122,  -2962,  20174,  -2988,  20226,  -3005,
 20279,  -3017,  20331,  -3028,  20382,  -3021,  20436,  -3036,  20488,  -3063,
 20539,  -3054,  20589,  -3018,  20640,  -3045,  20688,  -3087,  20736,  -3124,
 20788,  -3141,  20831,  -3137,  20820,  -2991,  20830,  -2885,  20801,  -2816,
 20750,  -2788,  20697,  -2808,  20645,  -2817,  20597,  -2813,  20548,  -2771,
 20528,  -2696,  20507,  -2611,  20482,  -2520,  20427,  -2510,  20378,  -2485,
 20328,  -2453,  20280,  -2431,  20229,  -2419,  20192,  -2343,  20145,  -2381,
 20125,  -2481,  20083,  -2529,  20033,  -2514,  19979,  -2507,  19927,  -2493,
 19874,  -2497,  19824,  -2481,  19772,  -2456,  19747,  -2362,  19704,  -2295,
 19653,  -2287,  19605,  -2265,  19557,  -2220,  19513,  -2171,  19471,  -2192,
 19421,  -2203,  19370,  -2186,  19317,  -2166,  19278,  -2199,  19261,  -2298,
 19233,  -2375,  19192,  -2451,  19174,  -2483,  19240,  -2494,  19293,  -2492,
 19343,  -2536,  19378,  -2584,  19379,  -2682,  19434,  -2704,  19487,  -2712,
 19541,  -2729,  19590,  -2765,  19638,  -2807,  19690,  -2832,  19742,  -2826,
 19794,  -2792,  19844,  -2804,  19899,  -2811,  19948,  -2833,  19989,  -2851,

/* 23 */
73, 1,
 25824,  19297,  25816,  19187,  25796,  19089,  25783,  18990,  25792,  18885,
 25815,  18801,  25866,  18699,  25887,  18596,  25864,  18494,  25857,  18388,
 25872,  18284,  25872,  18179,  25871,  18075,  25860,  17971,  25850,  17866,
 25828,  17764,  25841,  17665,  25870,  17567,  25873,  17461,  25847,  17361,
 25838,  17255,  25852,  17152,  25834,  17049,  25813,  16946,  25824,  16842,
 25864,  16762,  25906,  16899,  25958,  16986,  26033,  16959,  26087,  16916,
 26116,  16833,  26120,  16996,  26068,  17032,  26034,  17143,  26005,  17238,
 25963,  17312,  25943,  17417,  25952,  17519,  25975,  17622,  26000,  17722,
 26021,  17823,  26053,  17914,  26116,  17957,  26208,  17927,  26268,  17857,
 26316,  17773,  26331,  17755,  26280,  17864,  26253,  17964,  26237,  18067,
 26215,  18168,  26186,  18266,  26162,  18365,  26149,  18469,  26132,  18571,
 26113,  18671,  26085,  18774,  26065,  18879,  26051,  18976,  26058,  19076,
 26077,  19125,  26083,  19291,  26064,  19402,  26035,  19495,  26014,  19585,
 26019,  19699,  25959,  19769,  25922,  19724,  25967,  19614,  25962,  19531,
 25898,  19450,  25819,  19429,  25814,  19361,

/* 24 */
68, 1,
 22827,   3554,  22827,   3485,  22842,   3383,  22833,   3284,  22780,   3256,
 22722,   3250,  22705,   3130,  22672,   3104,  22629,   3095,  22604,   2998,
 22534,   2935,  22541,   2984,  22533,   3092,  22492,   3146,  22453,   3138,
 22402,   3089,  22378,   2995,  22329,   2955,  22279,   2929,  22237,   2868,
 22224,   2769,  22207,   2668,  22189,   2570,  22230,   2535,  22256,   2637,
 22281,   2734,  22311,   2816,  22353,   2760,  22401,   2761,  22452,   2726,
 22479,   2828,  22530,   2816,  22576,   2766,  22604,   2675,  22576,   2582,
 22568,   2481,  22577,   2378,  22598,   2285,  22640,   2225,  22687,   2176,
 22737,   2139,  22777,   2190,  22794,   2162,  22799,   2067,  22833,   2060,
 22864,   2148,  22875,   2248,  22856,   2349,  22825,   2427,  22842,   2535,
 22886,   2636,  22922,   2561,  22944,   2467,  22958,   2336,  22972,   2369,
 22978,   2489,  23009,   2553,  23037,   2645,  23038,   2748,  23015,   2837,
 23010,   2952,  22999,   3042,  22973,   3125,  22987,   3226,  22965,   3346,
 22926,   3416,  22893,   3476,  22852,   3540,

/* 25 */
68, 1,
 -2698,  24159,  -2803,  24108,  -2883,  24175,  -2984,  24192,  -3036,  24082,
 -3162,  24046,  -3270,  24047,  -3295,  23950,  -3312,  23950,  -3375,  24040,
 -3460,  24073,  -3546,  23971,  -3660,  24025,  -3695,  23932,  -3752,  23871,
 -3830,  23784,  -3866,  23797,  -3915,  23894,  -3895,  23989,  -3952,  24066,
 -4049,  24151,  -4169,  24178,  -4130,  24137,  -4122,  24030,  -4229,  24061,
 -4290,  24010,  -4280,  23942,  -4311,  23913,  -4392,  23871,  -4388,  23829,
 -4271,  23834,  -4148,  23867,  -4030,  23837,  -4074,  23751,  -4002,  23706,
 -4050,  23674,  -4170,  23661,  -4313,  23615,  -4258,  23588,  -4115,  23583,
 -4060,  23522,  -3974,  23508,  -3959,  23456,  -3977,  23365,  -4092,  23284,
 -4006,  23241,  -3872,  23255,  -3749,  23211,  -3688,  23148,  -3581,  23119,
 -3461,  23083,  -3329,  23106,  -3258,  23162,  -3190,  23208,  -3073,  23238,
 -2969,  23292,  -2876,  23360,  -2770,  23408,  -2653,  23467,  -2611,  23550,
 -2534,  23625,  -2514,  23671,  -2499,  23732,  -2500,  23799,  -2583,  23876,
 -2663,  23942,  -2711,  24044,  -2703,  24128,

/* 26 */
58, 1,
-13125,   7183, -13170,   7197, -13226,   7246, -13281,   7251, -13335,   7233,
-13353,   7168, -13292,   7133, -13241,   7070, -13244,   6974, -13226,   6887,
-13182,   6814, -13188,   6753, -13245,   6717, -13301,   6721, -13356,   6735,
-13408,   6750, -13465,   6768, -13520,   6788, -13549,   6713, -13512,   6656,
-13451,   6591, -13404,   6633, -13351,   6639, -13297,   6619, -13242,   6611,
-13191,   6628, -13132,   6634, -13080,   6598, -13044,   6515, -13017,   6446,
-12984,   6457, -12952,   6542, -12926,   6641, -12874,   6690, -12834,   6646,
-12775,   6644, -12730,   6708, -12674,   6710, -12618,   6709, -12564,   6699,
-12516,   6651, -12477,   6672, -12445,   6761, -12478,   6844, -12523,   6907,
-12576,   6921, -12648,   6959, -12607,   7004, -12627,   7034, -12684,   7029,
-12718,   7102, -12752,   7153, -12806,   7174, -12859,   7203, -12912,   7245,
-12965,   7225, -13026,   7239, -13072,   7178,

/* 27 */
56, 1,
 25832,  16566,  25795,  16529,  25773,  16436,  25798,  16335,  25804,  16230,
 25787,  16128,  25781,  16023,  25740,  15936,  25733,  15836,  25723,  15739,
 25660,  15721,  25572,  15753,  25564,  15657,  25520,  15572,  25460,  15508,
 25446,  15395,  25488,  15311,  25497,  15215,  25491,  15103,  25549,  15121,
 25598,  15200,  25666,  15196,  25668,  15250,  25612,  15318,  25549,  15365,
 25546,  15457,  25605,  15487,  25664,  15424,  25735,  15486,  25804,  15503,
 25866,  15450,  25925,  15391,  25988,  15341,  26065,  15301,  26094,  15413,
 26131,  15504,  26180,  15581,  26240,  15638,  26318,  15632,  26387,  15662,
 26488,  15747,  26449,  15773,  26421,  15879,  26413,  15977,  26447,  16089,
 26419,  16085,  26366,  16009,  26297,  15993,  26236,  16045,  26162,  16073,
 26102,  16133,  26045,  16201,  25993,  16276,  25950,  16362,  25906,  16447,
 25858,  16526,

/* 28 */
49, 2,
-20514,  27740, -20692,  27754, -20844,  27831, -20999,  27763, -21100,  27731,
-21222,  27661, -21008,  27621, -21068,  27602, -21287,  27556, -21070,  27523,
-21191,  27475, -21376,  27439, -21323,  27360, -21116,  27333, -20941,  27322,
-20757,  27417, -20706,  27352, -20503,  27363, -20285,  27371, -20276,  27328,
-20455,  27298, -20630,  27252, -20789,  27184, -20667,  27097, -20476,  27090,
-20295,  27131, -20135,  27205, -19986,  27250, -19793,  27295, -19609,  27295,
-19407,  27295, -19281,  27363, -19227,  27467, -19189,  27568, -19278,  27661,
-19445,  27602, -19586,  27621, -19694,  27713, -19738,  27822, -19783,  27933,
-19934,  27912, -20041,  27819, -19969,  27734, -19957,  27633, -19837,  27528,
-19974,  27492, -20200,  27503, -20342,  27596, -20426,  27679,

/* 29 */
50, 1,
 -1335,  20134,  -1387,  20076,  -1457,  20079,  -1524,  20002,  -1560,  19934,
 -1520,  19872,  -1555,  19778,  -1596,  19749,  -1681,  19750,  -1808,  19732,
 -1788,  19638,  -1766,  19579,  -1832,  19483,  -1785,  19424,  -1675,  19368,
 -1710,  19279,  -1765,  19168,  -1718,  19153,  -1634,  19180,  -1636,  19158,
 -1723,  19134,  -1784,  19066,  -1841,  18989,  -1867,  18880,  -1787,  18863,
 -1814,  18817,  -1756,  18814,  -1765,  18771,  -1740,  18747,  -1661,  18757,
 -1576,  18790,  -1509,  18859,  -1436,  18893,  -1371,  18954,  -1277,  18991,
 -1194,  19009,  -1150,  19085,  -1123,  19189,  -1099,  19290,  -1114,  19406,
 -1118,  19498,  -1146,  19600,  -1121,  19670,  -1049,  19734,  -1015,  19816,
 -1044,  19915,  -1075,  20000,  -1122,  20085,  -1263,  20074,  -1302,  20132,

/* 30 */
50, 2,
-13176, -26468, -13066, -26452, -12888, -26452, -12719, -26433, -12585, -26375,
-12470, -26292, -12428, -26191, -12398, -26086, -12413, -25981, -12421, -25875,
-12439, -25771, -12469, -25668, -12539, -25570, -12587, -25472, -12621, -25369,
-12666, -25268, -12743, -25183, -12774, -25071, -12895, -25053, -13028, -25096,
-13129, -25174, -13091, -25274, -13048, -25367, -13063, -25472, -13033, -25579,
-13156, -25657, -13094, -25731, -12948, -25768, -12909, -25873, -13084, -25901,
-13241, -25888, -13233, -25959, -13328, -25979, -13392, -26024, -13493, -26042,
-13612, -26075, -13716, -26115, -13680, -26206, -13530, -26258, -13421, -26193,
-13321, -26177, -13198, -26115, -13107, -26137, -12984, -26204, -13035, -26263,
-12908, -26299, -12896, -26338, -13066, -26350, -13252, -26336, -13253, -26421,

/* 31 */
48, 1,
-12474, -19958, -12384, -19965, -12294, -19977, -12202, -19989, -12112, -20024,
-12021, -20001, -11934, -19993, -11872, -19936, -11908, -19891, -11996, -19883,
-12077, -19834, -12144, -19763, -12217, -19702, -12285, -19632, -12338, -19554,
-12386, -19465, -12443, -19351, -12436, -19263, -12485, -19175, -12548, -19156,
-12624, -19125, -12676, -19162, -12770, -19223, -12803, -19302, -12819, -19408,
-12753, -19444, -12647, -19437, -12692, -19520, -12762, -19581, -12743, -19684,
-12669, -19740, -12587, -19793, -12600, -19858, -12619, -19837, -12692, -19805,
-12765, -19780, -12877, -19728, -12818, -19814, -12877, -19819, -12987, -19816,
-13068, -19841, -13044, -19884, -12971, -19881, -12882, -19918, -12794, -19944,
-12709, -19935, -12625, -19979, -12533, -19973,

/* 32 */
48, -1,
-20883,  22173, -20778,  22197, -20693,  22246, -20657,  22340, -20563,  22363,
-20465,  22398, -20389,  22479, -20317,  22570, -20267,  22649, -20171,  22704,
-20072,  22719, -20049,  22754, -20107,  22757, -20028,  22825, -20131,  22822,
-20250,  22781, -20290,  22759, -20156,  22851, -20055,  22866, -19938,  22842,
-19872,  22837, -20016,  22907, -20133,  22904, -20238,  22857, -20303,  22775,
-20362,  22686, -20446,  22613, -20555,  22582, -20661,  22582, -20742,  22651,
-20832,  22704, -20942,  22753, -21044,  22810, -21088,  22798, -20997,  22718,
-20948,  22627, -20883,  22525, -20971,  22479, -21048,  22431, -21095,  22333,
-21147,  22292, -21251,  22297, -21346,  22279, -21378,  22279, -21272,  22217,
-21177,  22185, -21074,  22149, -20976,  22152,

/* 33 */
47, 2,
-16759,  27894, -16955,  27855, -16974,  27915, -17109,  27994, -17320,  28034,
-17561,  28018, -17576,  27936, -17438,  27846, -17291,  27772, -17037,  27775,
-16888,  27728, -16804,  27633, -16765,  27528, -16821,  27428, -16776,  27333,
-16723,  27215, -16567,  27199, -16390,  27144, -16169,  27207, -16051,  27123,
-15845,  27118, -15703,  27131, -15530,  27147, -15412,  27134, -15180,  27202,
-15051,  27139, -14875,  27118, -14663,  27150, -14555,  27258, -14578,  27328,
-14481,  27423, -14595,  27497, -14776,  27559, -14970,  27599, -15196,  27585,
-15389,  27548, -15584,  27492, -15716,  27450, -15911,  27495, -16125,  27497,
-16274,  27523, -16324,  27619, -16493,  27641, -16554,  27699, -16376,  27740,
-16536,  27834, -16629,  27906,

/* 34 */
48, 2,
  1981,  28901,   2129,  28827,   2171,  28724,   2201,  28617,   2327,  28554,
  2495,  28478,   2637,  28551,   2714,  28642,   2802,  28645,   2902,  28585,
  3017,  28599,   2989,  28516,   2715,  28444,   2538,  28391,   2600,  28308,
  2866,  28337,   3008,  28324,   2790,  28252,   2861,  28214,   2595,  28204,
  2657,  28096,   2858,  28040,   2914,  27991,   3054,  27909,   3146,  28043,
  3195,  28150,   3308,  28233,   3354,  28344,   3435,  28434,   3488,  28544,
  3668,  28620,   3854,  28677,   3625,  28782,   3446,  28849,   3286,  28947,
  3226,  29060,   2984,  29099,   2863,  29009,   2900,  28905,   2953,  28804,
  2918,  28779,   2818,  28894,   2747,  28997,   2599,  29001,   2458,  28947,
  2380,  29052,   2150,  29024,   1995,  28970,

/* 35 */
44, -1,
  5311,  -1531,   5319,  -1568,   5305,  -1663,   5296,  -1771,   5302,  -1877,
  5325,  -1973,   5341,  -2068,   5318,  -2164,   5332,  -2254,   5356,  -2354,
  5375,  -2449,   5408,  -2532,   5450,  -2590,   5487,  -2661,   5499,  -2763,
  5518,  -2861,   5555,  -2941,   5559,  -3078,   5602,  -3121,   5653,  -3184,
  5672,  -3120,   5650,  -3030,   5627,  -2941,   5601,  -2844,   5574,  -2750,
  5564,  -2645,   5556,  -2551,   5527,  -2449,   5490,  -2369,   5442,  -2343,
  5411,  -2251,   5437,  -2166,   5441,  -2074,   5419,  -1977,   5424,  -1872,
  5394,  -1781,   5393,  -1679,   5387,  -1579,   5364,  -1483,   5343,  -1385,
  5328,  -1251,   5304,  -1311,   5298,  -1413,   5294,  -1520,

/* 36 */
44, -1,
 19918,  20272,  19880,  20208,  19870,  20102,  19834,  20006,  19801,  19908,
 19759,  19815,  19722,  19718,  19684,  19622,  19619,  19549,  19569,  19463,
 19503,  19393,  19447,  19307,  19410,  19217,  19348,  19148,  19278,  19086,
 19230,  18999,  19172,  18924,  19094,  18880,  19015,  18851,  18912,  18826,
 18939,  18768,  19020,  18739,  19100,  18755,  19180,  18787,  19261,  18827,
 19317,  18905,  19342,  19005,  19404,  19056,  19468,  19097,  19538,  19157,
 19620,  19195,  19686,  19262,  19730,  19346,  19805,  19407,  19799,  19486,
 19820,  19560,  19873,  19558,  19914,  19654,  19931,  19753,  19934,  19859,
 19960,  19958,  19976,  20061,  19990,  20165,  19978,  20282,

/* 37 */
44, 2,
 10272,  27186,  10156,  27131,  10087,  27038,  10070,  26984,   9919,  26919,
  9863,  26829,   9983,  26809,   9908,  26723,  10155,  26704,  10317,  26682,
 10379,  26765,  10409,  26844,  10527,  26886,  10546,  26974,  10669,  27041,
 10703,  27131,  10852,  27192,  10980,  27274,  11058,  27338,  11209,  27415,
 11392,  27484,  11583,  27539,  11775,  27582,  11963,  27633,  12150,  27685,
 12335,  27745,  12463,  27810,  12537,  27915,  12443,  28006,  12221,  28012,
 12034,  27942,  11928,  27861,  11719,  27801,  11499,  27760,  11314,  27754,
 11115,  27731,  10990,  27679,  10768,  27619,  10599,  27542,  10476,  27453,
 10340,  27395,  10233,  27319,  10250,  27215,  10368,  27189,

/* 38 */
42, -1,
-22431,  23696, -22317,  23671, -22186,  23666, -22126,  23759, -22054,  23839,
-21931,  23854, -21955,  23749, -22064,  23640, -21994,  23643, -21888,  23711,
-21788,  23795, -21811,  23899, -21714,  23948, -21524,  23928, -21478,  24029,
-21428,  24106, -21422,  24215, -21514,  24194, -21614,  24144, -21764,  24144,
-21888,  24178, -21847,  24254, -21715,  24324, -21772,  24382, -21895,  24375,
-22023,  24336, -22131,  24283, -22267,  24236, -22389,  24208, -22505,  24170,
-22696,  24080, -22597,  24075, -22450,  24068, -22365,  24102, -22228,  24118,
-22110,  24068, -22123,  24005, -22280,  24018, -22266,  23974, -22289,  23888,
-22352,  23815, -22421,  23739,

/* 39 */
42, -1,
  5765,   -747,   5769,   -842,   5796,   -972,   5835,   -914,   5872,   -851,
  5922,   -900,   5962,   -921,   5969,  -1038,   5992,  -1027,   5987,   -917,
  6026,   -886,   6077,   -912,   6131,   -816,   6066,   -773,   6080,   -709,
  6114,   -631,   6148,   -546,   6172,   -472,   6200,   -374,   6205,   -284,
  6216,   -185,   6265,   -163,   6321,   -113,   6310,    -49,   6253,    -99,
  6214,    -57,   6187,     13,   6156,     81,   6112,     88,   6073,    131,
  6029,     94,   5988,     48,   5939,     56,   5889,     12,   5841,    -22,
  5819,    -90,   5795,   -189,   5777,   -290,   5792,   -384,   5791,   -500,
  5776,   -592,   5761,   -696,

/* 40 */
41, -1,
  5724,  18135,   5751,  18083,   5815,  18020,   5880,  17959,   5949,  17895,
  6021,  17847,   6096,  17835,   6159,  17778,   6228,  17724,   6294,  17667,
  6372,  17628,   6392,  17526,   6389,  17423,   6369,  17326,   6287,  17317,
  6211,  17309,   6177,  17230,   6132,  17133,   6093,  17052,   5986,  17005,
  6020,  17015,   6103,  17041,   6143,  17102,   6201,  17217,   6232,  17267,
  6308,  17290,   6387,  17263,   6418,  17326,   6396,  17429,   6398,  17528,
  6404,  17652,   6376,  17655,   6298,  17681,   6232,  17751,   6180,  17801,
  6098,  17847,   6030,  17899,   5961,  17993,   5895,  18000,   5818,  18041,
  5748,  18093,

/* 41 */
41, 1,
 27687,  -1525,  27652,  -1552,  27590,  -1544,  27595,  -1647,  27602,  -1764,
 27561,  -1797,  27516,  -1845,  27488,  -1931,  27452,  -1994,  27405,  -2002,
 27355,  -2013,  27316,  -1972,  27322,  -1869,  27304,  -1866,  27288,  -1971,
 27245,  -2012,  27194,  -2030,  27144,  -2019,  27092,  -2005,  27039,  -2002,
 26999,  -2030,  27024,  -2112,  27076,  -2146,  27121,  -2206,  27159,  -2220,
 27209,  -2243,  27251,  -2292,  27305,  -2290,  27356,  -2288,  27407,  -2255,
 27452,  -2209,  27504,  -2177,  27547,  -2114,  27579,  -2035,  27633,  -2025,
 27680,  -1969,  27664,  -1860,  27698,  -1811,  27733,  -1735,  27734,  -1626,
 27707,  -1554,

/* 42 */
42, -1,
    42,   3263,     31,   3196,     22,   3086,     28,   2993,      6,   2882,
   -41,   2955,    -64,   2992,   -107,   3013,   -138,   3102,   -152,   3151,
  -201,   3255,   -203,   3196,   -272,   3172,   -251,   3172,   -202,   3141,
  -158,   3093,   -131,   2993,   -104,   2943,    -62,   2920,    -31,   2836,
   -89,   2768,    -33,   2762,    -12,   2722,     18,   2638,     15,   2542,
    -7,   2463,    -54,   2453,   -104,   2473,   -102,   2446,    -53,   2400,
    -2,   2341,     16,   2283,     20,   2292,     43,   2415,     45,   2501,
    51,   2600,     50,   2720,     45,   2836,     31,   2910,     39,   3019,
    25,   3110,     38,   3210,

/* 43 */
38, -1,
  6174,  -3583,   6193,  -3684,   6225,  -3774,   6225,  -3874,   6232,  -3982,
  6232,  -4086,   6241,  -4190,   6232,  -4286,   6205,  -4376,   6199,  -4481,
  6222,  -4567,   6240,  -4673,   6250,  -4771,   6251,  -4876,   6286,  -4959,
  6292,  -5053,   6300,  -5153,   6335,  -5159,   6361,  -5133,   6405,  -5176,
  6378,  -5016,   6344,  -4950,   6337,  -4844,   6330,  -4738,   6333,  -4634,
  6319,  -4532,   6324,  -4428,   6353,  -4342,   6363,  -4240,   6345,  -4146,
  6313,  -4073,   6303,  -3974,   6302,  -3870,   6293,  -3767,   6283,  -3662,
  6256,  -3572,   6220,  -3496,   6184,  -3482,

/* 44 */
38, -1,
 11214,  16315,  11251,  16400,  11205,  16462,  11156,  16566,  11112,  16641,
 11110,  16746,  11154,  16837,  11188,  16922,  11195,  17019,  11103,  16961,
 11027,  17001,  10975,  16991,  10905,  16926,  10904,  16827,  10833,  16831,
 10826,  16714,  10790,  16723,  10712,  16725,  10671,  16642,  10649,  16543,
 10620,  16445,  10594,  16344,  10599,  16239,  10601,  16133,  10624,  16037,
 10633,  15916,  10713,  15946,  10754,  15938,  10820,  15926,  10869,  15861,
 10909,  15820,  10977,  15860,  11045,  15872,  11094,  15922,  11068,  16009,
 11114,  16109,  11131,  16210,  11162,  16260,

/* 45 */
36, 1,
-21788,  26997, -21909,  27051, -22067,  27118, -22255,  27113, -22449,  27092,
-22652,  27054, -22633,  26944, -22559,  26846, -22617,  26740, -22690,  26641,
-22710,  26543, -22757,  26435, -22831,  26338, -22889,  26231, -22783,  26188,
-22652,  26124, -22535,  26053, -22474,  25955, -22368,  25890, -22221,  25953,
-22099,  25996, -21945,  26040, -21914,  26142, -21879,  26261, -21765,  26315,
-21690,  26412, -21576,  26489, -21436,  26555, -21292,  26617, -21144,  26677,
-21016,  26753, -21104,  26846, -21222,  26929, -21355,  27007, -21542,  27025,
-21696,  26974,

/* 46 */
37, 1,
-15137,  23642, -15200,  23704, -15308,  23754, -15422,  23787, -15497,  23859,
-15534,  23957, -15616,  23965, -15664,  23869, -15678,  23765, -15686,  23658,
-15705,  23561, -15721,  23456, -15706,  23347, -15798,  23274, -15856,  23172,
-15761,  23161, -15633,  23187, -15583,  23126, -15579,  23018, -15495,  22989,
-15399,  23052, -15337,  23144, -15242,  23213, -15204,  23314, -15112,  23319,
-15012,  23246, -14960,  23176, -14847,  23142, -14735,  23117, -14632,  23192,
-14655,  23260, -14737,  23317, -14858,  23307, -14877,  23349, -14886,  23459,
-14955,  23547, -15059,  23592,

/* 47 */
37, 1,
 14524,   2718,  14530,   2609,  14534,   2505,  14549,   2401,  14563,   2302,
 14590,   2211,  14637,   2168,  14688,   2174,  14738,   2215,  14786,   2248,
 14833,   2303,  14872,   2374,  14893,   2470,  14902,   2573,  14894,   2691,
 14872,   2776,  14855,   2849,  14822,   2958,  14805,   3064,  14778,   3125,
 14749,   3234,  14723,   3300,  14700,   3388,  14659,   3465,  14619,   3535,
 14606,   3544,  14618,   3516,  14578,   3524,  14629,   3458,  14580,   3443,
 14577,   3337,  14552,   3242,  14545,   3134,  14530,   3033,  14515,   2958,
 14519,   2827,  14522,   2770,

/* 48 */
36, 1,
 23450,     99,  23420,    164,  23380,    222,  23348,    296,  23397,    364,
 23425,    438,  23420,    546,  23373,    551,  23327,    476,  23307,    401,
 23273,    316,  23239,    353,  23278,    436,  23299,    524,  23290,    627,
 23286,    752,  23253,    727,  23222,    638,  23209,    541,  23191,    425,
 23211,    336,  23214,    245,  23226,    146,  23240,     58,  23238,    -47,
 23262,   -131,  23292,   -218,  23346,   -303,  23337,   -255,  23309,   -166,
 23289,    -70,  23278,     32,  23285,    144,  23336,    152,  23387,    129,
 23437,     95,

/* 49 */
37, 1,
 26928, -14842,  26887, -14875,  26824, -14913,  26745, -14945,  26696, -14971,
 26627, -14981,  26560, -14946,  26499, -14891,  26435, -14848,  26358, -14821,
 26330, -14879,  26331, -14976,  26351, -15076,  26378, -15173,  26417, -15259,
 26456, -15396,  26435, -15466,  26458, -15556,  26495, -15649,  26545, -15737,
 26588, -15795,  26644, -15840,  26706, -15870,  26748, -15815,  26773, -15730,
 26810, -15631,  26844, -15627,  26901, -15681,  26924, -15624,  26923, -15523,
 26936, -15427,  26976, -15330,  26991, -15269,  26989, -15165,  26990, -15050,
 26989, -14952,  26965, -14863,

/* 50 */
35, -1,
 13473,  16863,  13430,  16809,  13402,  16720,  13373,  16631,  13410,  16534,
 13473,  16418,  13490,  16494,  13504,  16595,  13518,  16669,  13546,  16748,
 13605,  16794,  13655,  16893,  13716,  16930,  13756,  16950,  13838,  16935,
 13905,  16943,  13988,  16922,  14061,  16916,  14142,  16894,  14214,  16868,
 14281,  16872,  14363,  16891,  14399,  17001,  14338,  17001,  14260,  16958,
 14181,  16973,  14111,  16976,  14016,  16966,  13952,  16976,  13888,  17009,
 13816,  17033,  13738,  17014,  13658,  17033,  13585,  17010,  13533,  16932,

/* 51 */
41, 2,
-17128,  29503, -17282,  29463, -17183,  29363, -17339,  29329, -17487,  29254,
-17289,  29171, -17516,  29143, -17532,  29063, -17271,  29009, -17299,  28970,
-17342,  28890, -17052,  28894, -16762,  28879, -16583,  28841, -16577,  28830,
-16861,  28812, -17086,  28768, -17021,  28674, -16839,  28589, -16787,  28495,
-16554,  28448, -16375,  28519, -16236,  28489, -16135,  28509, -16073,  28599,
-16026,  28735, -15986,  28681, -15839,  28728, -15684,  28786, -15550,  28909,
-15775,  28962, -15862,  29044, -15920,  29131, -15955,  29225, -16110,  29204,
-16228,  29254, -16397,  29321, -16582,  29411, -16700,  29512, -16886,  29599,
-17058,  29562,

/* 52 */
36, -1,
-17953,  19285, -17989,  19216, -17939,  19128, -17889,  19042, -17849,  18952,
-17799,  18920, -17749,  18940, -17700,  18868, -17676,  18780, -17614,  18761,
-17620,  18662, -17642,  18555, -17648,  18446, -17601,  18376, -17546,  18462,
-17538,  18597, -17542,  18682, -17582,  18773, -17614,  18867, -17649,  18966,
-17664,  19060, -17692,  19167, -17723,  19268, -17743,  19366, -17779,  19461,
-17811,  19560, -17831,  19657, -17828,  19754, -17854,  19766, -17884,  19655,
-17866,  19581, -17998,  19588, -18032,  19476, -18053,  19373, -17992,  19314,
-17927,  19312,

/* 53 */
35, 1,
 23975,  11854,  24016,  11946,  24014,  12023,  23981,  12094,  23953,  12148,
 23951,  12236,  23882,  12228,  23842,  12302,  23815,  12345,  23756,  12314,
 23717,  12241,  23658,  12194,  23612,  12138,  23605,  12060,  23625,  11985,
 23640,  11895,  23701,  11934,  23714,  12047,  23760,  11927,  23763,  11846,
 23736,  11739,  23698,  11654,  23706,  11546,  23702,  11436,  23728,  11370,
 23768,  11383,  23763,  11496,  23790,  11503,  23802,  11393,  23810,  11320,
 23869,  11421,  23916,  11481,  23927,  11584,  23938,  11687,  23955,  11776,

/* 54 */
34, -1,
-14871,  15450, -14905,  15396, -14971,  15351, -15027,  15289, -15107,  15302,
-15104,  15395, -15022,  15410, -15025,  15485, -15069,  15506, -15106,  15413,
-15141,  15317, -15173,  15216, -15094,  15122, -15066,  15090, -15007,  15077,
-14936,  15103, -14867,  15117, -14809,  15181, -14747,  15228, -14680,  15267,
-14603,  15320, -14553,  15356, -14491,  15409, -14434,  15472, -14382,  15541,
-14359,  15631, -14384,  15638, -14456,  15604, -14526,  15592, -14604,  15526,
-14630,  15495, -14699,  15517, -14769,  15530, -14835,  15497,

/* 55 */
35, -1,
 18605,  20459,  18547,  20455,  18485,  20384,  18501,  20322,  18539,  20208,
 18592,  20190,  18608,  20087,  18622,  20097,  18624,  20199,  18569,  20271,
 18559,  20366,  18630,  20416,  18709,  20422,  18751,  20328,  18778,  20228,
 18800,  20126,  18785,  20027,  18766,  19931,  18778,  19822,  18748,  19731,
 18760,  19601,  18777,  19555,  18814,  19409,  18854,  19488,  18819,  19555,
 18777,  19652,  18796,  19746,  18799,  19829,  18775,  19926,  18793,  20027,
 18806,  20129,  18788,  20232,  18763,  20328,  18734,  20449,  18650,  20486,

/* 56 */
34, 1,
-23228,  18489, -23310,  18508, -23354,  18444, -23292,  18376, -23240,  18374,
-23230,  18249, -23152,  18215, -23088,  18166, -23027,  18108, -22998,  18057,
-22999,  17986, -22920,  17958, -22883,  17885, -22819,  17826, -22746,  17843,
-22724,  17864, -22758,  17746, -22671,  17677, -22606,  17639, -22529,  17600,
-22461,  17622, -22477,  17709, -22516,  17811, -22553,  17896, -22613,  17949,
-22694,  17997, -22735,  18082, -22778,  18172, -22816,  18264, -22869,  18330,
-22948,  18358, -23030,  18380, -23107,  18407, -23179,  18450,

/* 57 */
31, 1,
 22790,  -3419,  22836,  -3366,  22887,  -3337,  22937,  -3302,  22986,  -3267,
 23033,  -3225,  23082,  -3184,  23129,  -3136,  23148,  -3055,  23088,  -3049,
 23036,  -3078,  22984,  -3083,  22932,  -3095,  22879,  -3102,  22827,  -3121,
 22777,  -3160,  22744,  -3245,  22699,  -3301,  22653,  -3344,  22602,  -3375,
 22555,  -3427,  22516,  -3501,  22499,  -3601,  22500,  -3687,  22495,  -3769,
 22553,  -3756,  22600,  -3709,  22653,  -3683,  22693,  -3611,  22731,  -3535,
 22755,  -3466,

/* 58 */
32, -1,
  8911,  19912,   8925,  19975,   8997,  20045,   9066,  20108,   9154,  20147,
  9241,  20175,   9326,  20179,   9418,  20248,   9381,  20282,   9347,  20216,
  9250,  20190,   9160,  20181,   9073,  20163,   8969,  20165,   8953,  20092,
  8897,  20002,   8864,  19903,   8810,  19829,   8819,  19717,   8883,  19644,
  8895,  19549,   8932,  19446,   8896,  19406,   8904,  19394,   9022,  19446,
  8963,  19474,   8958,  19561,   9009,  19687,   8948,  19664,   8881,  19686,
  8834,  19774,   8904,  19855,

/* 59 */
29, 2,
 -9592, -29455,  -9369, -29437,  -9059, -29402,  -8751, -29368,  -8448, -29333,
 -8180, -29274,  -8063, -29188,  -7943, -29111,  -7890, -28997,  -8018, -28890,
 -7973, -28793,  -8186, -28702,  -8022, -28620,  -8018, -28509,  -8179, -28427,
 -8400, -28374,  -8645, -28377,  -8850, -28441,  -9014, -28523,  -9122, -28617,
 -9185, -28720,  -9214, -28827,  -9217, -28932,  -9315, -29032,  -9469, -29127,
 -9682, -29196,  -9889, -29270,  -9978, -29372,  -9803, -29450,

/* 60 */
30, 1,
-18210,  26889, -18316,  26844, -18381,  26757, -18277,  26675, -18258,  26581,
-18303,  26494, -18448,  26496, -18576,  26579, -18688,  26503, -18609,  26410,
-18497,  26329, -18355,  26281, -18250,  26202, -18149,  26117, -18080,  26018,
-17967,  25963, -17885,  26095, -17746,  26079, -17604,  26155, -17580,  26238,
-17573,  26336, -17607,  26447, -17692,  26512, -17861,  26567, -17826,  26648,
-17726,  26738, -17663,  26829, -17793,  26886, -17994,  26844, -18136,  26884,

/* 61 */
29, 1,
  9358,  26119,   9397,  26049,   9544,  26031,   9713,  26000,   9803,  25896,
  9765,  25790,   9923,  25745,  10095,  25720,  10241,  25714,  10371,  25710,
 10452,  25754,  10329,  25836,  10232,  25922,  10166,  26018,  10113,  26119,
 10080,  26213,  10081,  26340,  10115,  26421,  10171,  26517,  10234,  26607,
 10112,  26689,   9941,  26706,   9771,  26665,   9691,  26572,   9587,  26512,
  9618,  26426,   9571,  26315,   9480,  26247,   9364,  26179,

/* 62 */
29, -1,
  8109,  17711,   8150,  17809,   8187,  17903,   8209,  18004,   8247,  18097,
  8268,  18203,   8327,  18273,   8409,  18285,   8423,  18310,   8352,  18346,
  8339,  18459,   8379,  18547,   8354,  18648,   8387,  18743,   8447,  18817,
  8496,  18856,   8405,  18795,   8352,  18711,   8343,  18613,   8362,  18521,
  8314,  18436,   8329,  18332,   8278,  18244,   8249,  18146,   8207,  18042,
  8186,  17952,   8159,  17856,   8119,  17766,   8094,  17685,

/* 63 */
28, 1,
 21746,   4148,  21735,   4082,  21721,   3968,  21713,   3905,  21690,   3809,
 21654,   3752,  21617,   3674,  21584,   3592,  21546,   3514,  21511,   3434,
 21471,   3369,  21427,   3309,  21389,   3236,  21345,   3102,  21387,   3115,
 21430,   3169,  21473,   3234,  21507,   3317,  21554,   3370,  21588,   3451,
 21610,   3543,  21634,   3624,  21687,   3662,  21719,   3747,  21771,   3804,
 21769,   3900,  21754,   4000,  21756,   4103,

/* 64 */
32, -1,
  5078,  22242,   5129,  22235,   5200,  22317,   5225,  22413,   5300,  22431,
  5386,  22495,   5404,  22600,   5389,  22731,   5325,  22657,   5240,  22652,
  5132,  22663,   5077,  22784,   5184,  22743,   5156,  22802,   5134,  22913,
  5044,  22938,   4973,  22998,   4944,  23101,   4939,  23086,   4953,  22978,
  5018,  22881,   5004,  22768,   5011,  22731,   5075,  22672,   5144,  22596,
  5223,  22538,   5188,  22491,   5130,  22419,   5082,  22433,   5011,  22436,
  4972,  22365,   5062,  22284,

/* 65 */
26, 1,
 22058,   9136,  22021,   9087,  21991,   8995,  21956,   8914,  21928,   8822,
 21900,   8730,  21871,   8636,  21864,   8528,  21856,   8415,  21873,   8328,
 21894,   8220,  21933,   8155,  21977,   8024,  22001,   8109,  22018,   8210,
 22051,   8294,  22082,   8383,  22101,   8478,  22115,   8582,  22128,   8686,
 22141,   8788,  22167,   8886,  22173,   8980,  22186,   9100,  22144,   9172,
 22097,   9168,

/* 66 */
30, -1,
-11722,  19919, -11719,  19839, -11724,  19734, -11809,  19728, -11860,  19853,
-11864,  19815, -11832,  19691, -11890,  19661, -11970,  19730, -12048,  19833,
-12069,  19897, -12096,  20006, -12107,  19970, -12117,  19872, -12093,  19759,
-12080,  19797, -12039,  19788, -11972,  19704, -11911,  19636, -11885,  19499,
-11872,  19548, -11838,  19605, -11758,  19673, -11679,  19639, -11585,  19625,
-11517,  19668, -11552,  19694, -11620,  19711, -11677,  19788, -11708,  19884,

/* 67 */
28, 2,
 25545,  27244,  25738,  27279,  25907,  27266,  26066,  27298,  25906,  27404,
 25874,  27517,  25981,  27525,  25966,  27404,  26092,  27333,  26283,  27336,
 26355,  27431,  26389,  27523,  26174,  27596,  25976,  27613,  25816,  27690,
 25712,  27682,  25649,  27576,  25571,  27559,  25441,  27639,  25251,  27716,
 25098,  27679,  25009,  27585,  24964,  27495,  24948,  27401,  25057,  27293,
 25181,  27213,  25367,  27218,  25447,  27271,

/* 68 */
26, 1,
 30008,  -7507,  29965,  -7437,  29914,  -7383,  29869,  -7346,  29856,  -7363,
 29882,  -7451,  29915,  -7544,  29956,  -7620,  29991,  -7686,  30032,  -7771,
 30073,  -7836,  30121,  -7886,  30169,  -7934,  30223,  -7995,  30260,  -8062,
 30307,  -8106,  30368,  -8138,  30391,  -8075,  30347,  -8003,  30306,  -7940,
 30265,  -7876,  30212,  -7814,  30174,  -7770,  30128,  -7703,  30092,  -7617,
 30054,  -7553,

/* 69 */
26, -1,
-13818,  16169, -13877,  16131, -13944,  16096, -14048,  16067, -14013,  16031,
-14053,  15986, -14124,  16016, -14192,  16010, -14263,  15991, -14335,  15973,
-14401,  15938, -14462,  15878, -14506,  15788, -14468,  15727, -14399,  15746,
-14331,  15777, -14259,  15792, -14187,  15786, -14117,  15755, -14040,  15757,
-13977,  15772, -13915,  15831, -13871,  15892, -13868,  16009, -13872,  16086,
-13809,  16156,

/* 70 */
27, 1,
 -8817,    -95,  -8854,    -86,  -8906,    -70,  -8958,    -56,  -9004,    -84,
 -9060,    -76,  -9112,    -54,  -9164,    -48,  -9211,    -90,  -9223,   -214,
 -9241,   -289,  -9215,   -384,  -9225,   -419,  -9243,   -516,  -9214,   -610,
 -9179,   -663,  -9152,   -609,  -9140,   -609,  -9097,   -631,  -9048,   -624,
 -9003,   -570,  -8951,   -555,  -8903,   -507,  -8885,   -437,  -8847,   -355,
 -8829,   -255,  -8810,   -147,

/* 71 */
25, 1,
 23325,  -1048,  23308,  -1100,  23280,  -1221,  23314,  -1166,  23349,  -1189,
 23395,  -1251,  23451,  -1193,  23497,  -1226,  23549,  -1249,  23586,  -1218,
 23645,  -1232,  23689,  -1290,  23737,  -1331,  23791,  -1389,  23814,  -1321,
 23790,  -1235,  23761,  -1144,  23716,  -1090,  23661,  -1084,  23615,  -1046,
 23562,  -1022,  23507,  -1059,  23461,  -1036,  23408,  -1038,  23355,  -1041,

/* 72 */
25, 1,
 21889,  -3010,  21864,  -3042,  21820,  -3087,  21816,  -3196,  21869,  -3203,
 21920,  -3205,  21975,  -3219,  22024,  -3249,  22081,  -3230,  22131,  -3221,
 22180,  -3220,  22231,  -3185,  22285,  -3176,  22341,  -3131,  22366,  -3003,
 22353,  -3026,  22305,  -3081,  22265,  -3137,  22216,  -3095,  22168,  -3092,
 22120,  -3112,  22069,  -3087,  22020,  -3047,  21965,  -3019,  21917,  -3009,

/* 73 */
25, 1,
  2837,  13934,   2786,  13915,   2729,  13889,   2666,  13868,   2601,  13840,
  2536,  13836,   2472,  13849,   2408,  13890,   2336,  13867,   2284,  13838,
  2273,  13738,   2325,  13676,   2388,  13644,   2443,  13584,   2499,  13531,
  2560,  13503,   2615,  13452,   2659,  13380,   2724,  13356,   2754,  13405,
  2777,  13508,   2755,  13597,   2763,  13699,   2790,  13792,   2827,  13884,

/* 74 */
26, -1,
  6284,  22893,   6334,  22790,   6395,  22780,   6466,  22697,   6404,  22622,
  6311,  22704,   6309,  22633,   6266,  22627,   6208,  22725,   6199,  22707,
  6252,  22613,   6274,  22510,   6325,  22422,   6416,  22366,   6475,  22258,
  6380,  22258,   6381,  22219,   6506,  22176,   6589,  22235,   6626,  22316,
  6582,  22410,   6534,  22510,   6503,  22606,   6516,  22718,   6453,  22793,
  6355,  22855,

/* 75 */
24, 1,
 27449,   -974,  27466,  -1014,  27514,  -1056,  27558,  -1115,  27601,  -1174,
 27643,  -1240,  27692,  -1276,  27730,  -1344,  27763,  -1426,  27786,  -1522,
 27790,  -1627,  27816,  -1729,  27852,  -1693,  27864,  -1593,  27850,  -1500,
 27814,  -1430,  27769,  -1376,  27734,  -1306,  27692,  -1234,  27652,  -1171,
 27607,  -1121,  27561,  -1065,  27514,  -1024,  27470,   -965,

/* 76 */
25, 1,
 21332,  -3050,  21308,  -3069,  21263,  -3131,  21254,  -3244,  21288,  -3304,
 21339,  -3294,  21392,  -3278,  21443,  -3249,  21493,  -3225,  21537,  -3169,
 21554,  -3190,  21617,  -3204,  21668,  -3158,  21660,  -3059,  21611,  -3061,
 21589,  -3028,  21535,  -3027,  21492,  -2962,  21438,  -2977,  21462,  -3065,
 21510,  -3109,  21501,  -3154,  21448,  -3163,  21406,  -3092,  21361,  -3069,

/* 77 */
23, 1,
 19937,   7247,  19911,   7234,  19878,   7189,  19833,   7113,  19787,   7049,
 19773,   6964,  19775,   6856,  19788,   6750,  19837,   6692,  19886,   6661,
 19948,   6637,  20003,   6698,  20036,   6729,  20085,   6801,  20110,   6867,
 20123,   6975,  20162,   7098,  20196,   7152,  20188,   7258,  20133,   7294,
 20086,   7286,  20027,   7269,  19975,   7270,

/* 78 */
23, 1,
-17339,  26921, -17288,  26854, -17346,  26829, -17406,  26755, -17399,  26639,
-17409,  26534, -17364,  26440, -17323,  26340, -17292,  26236, -17129,  26231,
-17044,  26343, -17093,  26461, -16965,  26491, -16783,  26482, -16680,  26572,
-16627,  26665, -16541,  26765, -16447,  26866, -16525,  26924, -16720,  26934,
-16854,  26962, -17044,  26987, -17221,  26967,

/* 79 */
24, -1,
  5978,   8677,   5962,   8589,   5970,   8546,   5971,   8470,   5938,   8371,
  5913,   8281,   5867,   8272,   5817,   8258,   5776,   8198,   5737,   8105,
  5706,   8023,   5679,   7928,   5673,   7884,   5713,   8008,   5752,   8096,
  5792,   8151,   5825,   8230,   5877,   8230,   5926,   8291,   5960,   8363,
  5995,   8385,   6000,   8495,   5999,   8595,   5988,   8696,

/* 80 */
24, 2,
-18302,  27879, -18265,  27795, -18186,  27685, -18303,  27702, -18490,  27795,
-18526,  27731, -18446,  27621, -18511,  27602, -18639,  27556, -18625,  27497,
-18402,  27520, -18124,  27548, -18190,  27500, -18279,  27420, -18241,  27319,
-18054,  27309, -17848,  27338, -17807,  27437, -17726,  27497, -17777,  27590,
-17757,  27708, -17791,  27813, -17973,  27867, -18154,  27882,

/* 81 */
22, 1,
  1670,  15001,   1631,  14946,   1577,  14882,   1503,  14875,   1495,  14781,
  1532,  14690,   1535,  14587,   1545,  14487,   1533,  14381,   1532,  14263,
  1545,  14199,   1599,  14161,   1648,  14254,   1705,  14257,   1745,  14290,
  1755,  14394,   1763,  14501,   1761,  14601,   1771,  14698,   1775,  14793,
  1749,  14897,   1714,  14980,

/* 82 */
22, 1,
 24500,  12442,  24456,  12468,  24403,  12506,  24338,  12472,  24314,  12406,
 24259,  12359,  24194,  12389,  24152,  12305,  24113,  12227,  24054,  12162,
 24070,  12162,  24105,  12106,  24115,  12009,  24172,  11933,  24211,  11991,
 24245,  12079,  24277,  12156,  24337,  12195,  24408,  12141,  24451,  12218,
 24499,  12285,  24508,  12347,

/* 83 */
23, -1,
  4655,  22965,   4701,  22915,   4690,  22813,   4708,  22716,   4667,  22618,
  4625,  22529,   4606,  22439,   4606,  22334,   4633,  22240,   4735,  22268,
  4687,  22304,   4663,  22390,   4671,  22495,   4700,  22590,   4778,  22709,
  4866,  22747,   4908,  22831,   4883,  22906,   4835,  22837,   4773,  22757,
  4725,  22750,   4752,  22833,   4740,  22919,

/* 84 */
21, -1,
-20197,  21323, -20106,  21356, -20044,  21446, -19954,  21494, -19857,  21515,
-19754,  21523, -19649,  21550, -19571,  21589, -19459,  21575, -19345,  21571,
-19369,  21579, -19466,  21594, -19567,  21616, -19671,  21638, -19768,  21627,
-19831,  21657, -19927,  21686, -19996,  21614, -20075,  21538, -20146,  21469,
-20223,  21390,

/* 85 */
22, 2,
-21640,  28150, -21750,  28093, -21872,  28006, -22005,  27921, -22141,  27837,
-22320,  27772, -22309,  27687, -22040,  27679, -21935,  27644, -21810,  27630,
-21734,  27734, -21607,  27825, -21515,  27921, -21458,  27891, -21416,  27787,
-21275,  27840, -21126,  27921, -21131,  28018, -21077,  28118, -21125,  28201,
-21285,  28175, -21471,  28159,

/* 86 */
21, -1,
 15342,  17371,  15362,  17424,  15313,  17495,  15240,  17578,  15222,  17639,
 15195,  17746,  15241,  17822,  15334,  17883,  15301,  17956,  15257,  18049,
 15211,  18057,  15232,  18002,  15299,  17943,  15290,  17869,  15215,  17823,
 15184,  17732,  15191,  17626,  15140,  17559,  15160,  17500,  15233,  17461,
 15299,  17403,

/* 87 */
20, 1,
-10997,  17080, -11036,  17091, -11093,  16996, -11121,  16913, -11165,  16822,
-11195,  16730, -11177,  16625, -11123,  16592, -11051,  16598, -10976,  16631,
-10920,  16698, -10903,  16785, -10987,  16815, -11026,  16734, -11052,  16650,
-11100,  16663, -11088,  16737, -11022,  16822, -11004,  16902, -10983,  16998,

/* 88 */
20, -1,
  2750,   4752,   2714,   4778,   2666,   4822,   2614,   4805,   2582,   4861,
  2547,   4869,   2511,   4907,   2517,   5012,   2475,   5079,   2422,   5034,
  2433,   4924,   2459,   4834,   2500,   4772,   2518,   4722,   2521,   4634,
  2564,   4553,   2600,   4599,   2644,   4662,   2689,   4692,   2745,   4712,

/* 89 */
19, 1,
  4786,  12850,   4755,  12821,   4690,  12820,   4637,  12855,   4572,  12872,
  4512,  12890,   4443,  12875,   4391,  12928,   4318,  12950,   4288,  12898,
  4309,  12829,   4376,  12816,   4439,  12801,   4498,  12749,   4552,  12718,
  4615,  12732,   4679,  12742,   4744,  12747,   4784,  12805,

/* 90 */
20, 2,
  4459,  29237,   4306,  29200,   4175,  29254,   4072,  29167,   3912,  29196,
  3692,  29262,   3585,  29254,   3463,  29196,   3347,  29131,   3419,  29036,
  3873,  29036,   3720,  28978,   3769,  28909,   4073,  28890,   4311,  28834,
  4560,  28886,   4723,  28962,   4887,  29052,   4906,  29155,   4621,  29204,

/* 91 */
20, -1,
-18340,  16995, -18313,  16935, -18311,  16828, -18301,  16733, -18288,  16630,
-18286,  16536, -18284,  16501, -18268,  16415, -18307,  16330, -18381,  16302,
-18375,  16287, -18306,  16213, -18303,  16259, -18268,  16356, -18249,  16441,
-18262,  16550, -18263,  16645, -18285,  16735, -18302,  16837, -18305,  16949,

/* 92 */
18, 1,
 22480,   3971,  22449,   3988,  22398,   3975,  22376,   3893,  22358,   3797,
 22356,   3683,  22311,   3631,  22280,   3557,  22301,   3466,  22346,   3405,
 22379,   3317,  22425,   3321,  22436,   3415,  22415,   3505,  22422,   3616,
 22444,   3714,  22463,   3811,  22485,   3910,

/* 93 */
20, -1,
 18771,  27144,  18949,  27186,  19147,  27221,  19159,  27247,  18964,  27282,
 18801,  27184,  18613,  27168,  18418,  27176,  18304,  27258,  18255,  27303,
 18276,  27155,  18156,  27087,  18135,  27066,  18322,  27038,  18390,  26936,
 18450,  26909,  18408,  27033,  18419,  27085,  18572,  27064,  18660,  27121,

/* 94 */
19, 1,
 19268,   -546,  19248,   -603,  19225,   -596,  19182,   -607,  19149,   -713,
 19180,   -770,  19233,   -773,  19262,   -855,  19277,   -946,  19300,  -1030,
 19351,  -1068,  19396,  -1119,  19414,  -1082,  19425,   -962,  19397,   -916,
 19349,   -876,  19327,   -777,  19317,   -672,  19291,   -578,

/* 95 */
19, -1,
-22712,  20640, -22674,  20568, -22630,  20437, -22599,  20383, -22544,  20313,
-22477,  20237, -22427,  20125, -22422,  20151, -22466,  20238, -22518,  20327,
-22487,  20389, -22392,  20394, -22283,  20410, -22305,  20431, -22397,  20404,
-22482,  20395, -22572,  20444, -22631,  20510, -22677,  20601,

/* 96 */
20, 2,
-18611, -26281, -18481, -26297, -18314, -26315, -18125, -26350, -17987, -26393,
-17803, -26396, -17638, -26412, -17491, -26380, -17491, -26302, -17608, -26281,
-17582, -26224, -17645, -26164, -17735, -26231, -17851, -26229, -17949, -26159,
-18029, -26206, -18121, -26229, -18256, -26206, -18423, -26197, -18609, -26231,

/* 97 */
17, -1,
  6559,   1674,   6537,   1589,   6533,   1483,   6524,   1381,   6536,   1280,
  6560,   1187,   6584,   1098,   6622,   1021,   6656,    908,   6679,    981,
  6658,   1056,   6619,   1127,   6596,   1219,   6593,   1327,   6590,   1430,
  6592,   1536,   6588,   1643,

/* 98 */
17, -1,
  5602,  22466,   5534,  22388,   5463,  22297,   5497,  22217,   5551,  22129,
  5591,  22031,   5634,  21938,   5688,  21831,   5759,  21896,   5856,  21909,
  5933,  21945,   5965,  22035,   5967,  22139,   5921,  22232,   5835,  22304,
  5753,  22368,   5677,  22438,

/* 99 */
18, 2,
-18895,  28886, -19070,  28875, -19208,  28808, -19028,  28728, -18878,  28652,
-18938,  28589, -19085,  28540, -18896,  28495, -18668,  28502, -18421,  28458,
-18314,  28364, -18102,  28337, -18048,  28434, -18148,  28533, -18181,  28631,
-18371,  28706, -18623,  28757, -18770,  28849,

/* 100 */
18, -1,
  7944,  17979,   7979,  17898,   7963,  17815,   7914,  17733,   7852,  17651,
  7817,  17556,   7796,  17471,   7723,  17439,   7682,  17367,   7731,  17336,
  7816,  17386,   7844,  17438,   7858,  17534,   7907,  17634,   7936,  17716,
  7966,  17806,   7991,  17894,   7948,  17974,

/* 101 */
17, 1,
  6295,  12989,   6264,  12968,   6208,  12922,   6148,  12883,   6085,  12862,
  6012,  12866,   5966,  12804,   5897,  12769,   5889,  12690,   5934,  12623,
  5999,  12604,   6063,  12640,   6115,  12689,   6176,  12730,   6179,  12808,
  6217,  12889,   6270,  12952,

/* 102 */
17, 1,
 22621,   4576,  22627,   4518,  22649,   4424,  22695,   4361,  22733,   4295,
 22738,   4219,  22741,   4155,  22781,   4078,  22857,   4051,  22856,   4136,
 22837,   4247,  22836,   4346,  22832,   4446,  22803,   4526,  22753,   4572,
 22704,   4557,  22649,   4564,

/* 103 */
16, -1,
  4933,  -6520,   4963,  -6442,   5005,  -6376,   5037,  -6282,   5083,  -6221,
  5115,  -6163,   5168,  -6120,   5243,  -6069,   5200,  -6015,   5146,  -6047,
  5104,  -6115,   5054,  -6162,   5022,  -6232,   4985,  -6328,   4962,  -6409,
  4931,  -6496,

/* 104 */
17, -1,
 10230,  21561,  10185,  21475,  10207,  21397,  10123,  21331,  10125,  21324,
 10208,  21306,  10250,  21201,  10327,  21072,  10343,  21159,  10293,  21202,
 10240,  21314,  10275,  21423,  10243,  21522,  10307,  21602,  10303,  21703,
 10296,  21749,  10282,  21612,

/* 105 */
17, -1,
-18790,  20490, -18747,  20535, -18663,  20599, -18618,  20675, -18567,  20771,
-18564,  20876, -18511,  21034, -18546,  21118, -18600,  21097, -18671,  21006,
-18721,  20894, -18693,  20809, -18689,  20665, -18739,  20599, -18760,  20655,
-18776,  20621, -18796,  20546,

/* 106 */
16, 1,
-14249,   6630, -14205,   6605, -14164,   6533, -14115,   6498, -14053,   6472,
-13995,   6519, -13951,   6517, -13891,   6509, -13886,   6574, -13930,   6626,
-13980,   6669, -14031,   6702, -14086,   6721, -14140,   6732, -14194,   6722,
-14246,   6691,

/* 107 */
16, 1,
 22190,   4319,  22209,   4260,  22216,   4158,  22213,   4053,  22198,   3949,
 22197,   3841,  22218,   3830,  22264,   3879,  22315,   3909,  22352,   3981,
 22392,   4048,  22412,   4169,  22373,   4188,  22325,   4209,  22278,   4254,
 22231,   4303,

/* 108 */
15, 1,
 21655,  -3479,  21692,  -3544,  21744,  -3556,  21792,  -3590,  21836,  -3649,
 21875,  -3719,  21928,  -3737,  21978,  -3694,  21972,  -3611,  21935,  -3531,
 21888,  -3488,  21843,  -3414,  21796,  -3409,  21743,  -3410,  21690,  -3419,

/* 109 */
16, 2,
 18141,  28894,  18174,  29005,  18115,  29103,  17910,  29103,  17778,  29071,
 17647,  29167,  17343,  29143,  17172,  29067,  16985,  28962,  17083,  28928,
 17260,  28801,  17495,  28760,  17737,  28702,  17986,  28684,  18160,  28757,
 18074,  28841,

/* 110 */
16, -1,
 16554,  19890,  16602,  19810,  16641,  19711,  16643,  19609,  16672,  19619,
 16671,  19673,  16652,  19787,  16582,  19873,  16561,  19971,  16620,  20035,
 16705,  20058,  16816,  20139,  16770,  20126,  16693,  20079,  16606,  20047,
 16551,  19977,

/* 111 */
16, 1,
-17831,  25438, -17881,  25386, -17901,  25292, -17965,  25199, -18092,  25137,
-18013,  25069, -17886,  25028, -17732,  24960, -17610,  24933, -17484,  24960,
-17385,  25021, -17406,  25075, -17491,  25164, -17552,  25254, -17680,  25333,
-17755,  25394,

/* 112 */
15, 1,
 16925,   4931,  16903,   4863,  16895,   4760,  16884,   4651,  16875,   4554,
 16876,   4450,  16852,   4339,  16861,   4230,  16879,   4254,  16884,   4364,
 16904,   4471,  16918,   4554,  16915,   4685,  16926,   4762,  16933,   4866,

/* 113 */
15, 2,
 18219,  28391,  18437,  28451,  18685,  28468,  18948,  28502,  19138,  28557,
 19112,  28670,  18983,  28738,  18813,  28790,  18678,  28749,  18609,  28875,
 18418,  28779,  18342,  28684,  18235,  28592,  18164,  28492,  18090,  28407,

/* 114 */
15, 1,
 22579,   4096,  22561,   4051,  22548,   3951,  22523,   3857,  22499,   3763,
 22471,   3669,  22455,   3580,  22446,   3470,  22467,   3467,  22489,   3563,
 22509,   3662,  22547,   3741,  22574,   3820,  22575,   3926,  22575,   4030,

/* 115 */
15, -1,
-18299,  19346, -18363,  19330, -18379,  19261, -18318,  19248, -18251,  19204,
-18205,  19139, -18226,  19039, -18207,  18897, -18166,  18816, -18150,  18860,
-18164,  18963, -18154,  19060, -18140,  19163, -18159,  19260, -18240,  19321,

/* 116 */
14, 1,
 28162,  -2023,  28161,  -2124,  28189,  -2210,  28227,  -2279,  28249,  -2362,
 28273,  -2447,  28321,  -2495,  28373,  -2460,  28369,  -2357,  28330,  -2275,
 28291,  -2220,  28255,  -2136,  28224,  -2042,  28179,  -2002,

/* 117 */
15, 1,
-24315,  20511, -24296,  20461, -24246,  20368, -24241,  20263, -24219,  20157,
-24170,  20100, -24115,  20022, -24067,  19938, -24025,  19984, -24042,  20075,
-24094,  20189, -24095,  20256, -24138,  20352, -24209,  20422, -24263,  20497,

/* 118 */
14, 1,
 22363,  26538,  22526,  26498,  22680,  26449,  22817,  26382,  22962,  26357,
 22990,  26480,  23033,  26579,  23015,  26689,  22913,  26748,  22760,  26807,
 22580,  26831,  22459,  26770,  22474,  26636,  22372,  26565,

/* 119 */
15, 1,
-11667,  17102, -11711,  17020, -11676,  16949, -11621,  16881, -11566,  16823,
-11489,  16825, -11447,  16766, -11381,  16784, -11330,  16875, -11387,  16911,
-11453,  16900, -11532,  16916, -11603,  16927, -11633,  16974, -11651,  17066,

/* 120 */
16, -1,
 -8289,  -7824,  -8326,  -7780,  -8350,  -7682,  -8381,  -7584,  -8348,  -7551,
 -8298,  -7632,  -8250,  -7669,  -8265,  -7642,  -8301,  -7541,  -8332,  -7512,
 -8394,  -7524,  -8399,  -7581,  -8382,  -7669,  -8385,  -7763,  -8362,  -7780,
 -8315,  -7816,

/* 121 */
15, -1,
-18049,  18850, -18083,  18822, -18084,  18773, -18022,  18674, -18000,  18596,
-17980,  18506, -17947,  18407, -17926,  18299, -17853,  18295, -17838,  18379,
-17885,  18466, -17953,  18532, -17955,  18620, -17992,  18750, -18029,  18801,

/* 122 */
13, 1,
-11593,  18150, -11699,  18160, -11676,  18105, -11605,  18051, -11554,  17974,
-11480,  17922, -11403,  17890, -11325,  17865, -11246,  17897, -11302,  17980,
-11370,  18037, -11440,  18090, -11517,  18128,

/* 123 */
15, 1,
 12775, -18055,  12713, -18001,  12769, -17972,  12819, -17965,  12802, -17876,
 12706, -17923,  12649, -17883,  12592, -17861,  12563, -17768,  12525, -17841,
 12530, -17936,  12526, -18055,  12585, -18049,  12670, -18049,  12718, -18072,

/* 124 */
14, 1,
 21899,   4902,  21923,   4854,  21962,   4777,  21982,   4677,  22004,   4589,
 22034,   4491,  22076,   4470,  22105,   4543,  22114,   4644,  22112,   4757,
 22084,   4839,  22035,   4892,  21988,   4909,  21933,   4917,

/* 125 */
14, 1,
-14708,  26824, -14713,  26743, -14633,  26655, -14575,  26562, -14459,  26489,
-14287,  26520, -14113,  26527, -13931,  26510, -13881,  26576, -13968,  26670,
-14071,  26755, -14238,  26807, -14427,  26807, -14606,  26839,

/* 126 */
14, 1,
-13430, -15787, -13408, -15713, -13392, -15629, -13410, -15539, -13417, -15462,
-13369, -15372, -13384, -15256, -13449, -15230, -13478, -15299, -13499, -15401,
-13500, -15505, -13506, -15613, -13530, -15717, -13483, -15779,

/* 127 */
13, 2,
-11209, -29415, -11026, -29338, -10966, -29237, -10956, -29131, -10968, -29020,
-11160, -29013, -11234, -29119, -11371, -29204, -11679, -29225, -12086, -29188,
-12016, -29283, -11708, -29295, -11476, -29376,

/* 128 */
17, 1,
-27892,  21049, -27956,  21029, -27987,  20937, -28045,  20965, -28130,  20937,
-28151,  20848, -28105,  20738, -28077,  20756, -28033,  20777, -28013,  20716,
-27964,  20744, -27894,  20827, -27819,  20892, -27749,  20917, -27734,  20998,
-27787,  21055, -27841,  21081,

/* 129 */
14, -1,
-18781,  17521, -18853,  17510, -18856,  17492, -18778,  17508, -18702,  17501,
-18666,  17416, -18619,  17328, -18540,  17286, -18438,  17313, -18473,  17324,
-18547,  17313, -18614,  17406, -18668,  17440, -18707,  17523,

/* 130 */
14, 1,
 32531,  -6190,  32565,  -6152,  32606,  -6099,  32652,  -6111,  32731,  -6064,
 32688,  -6077,  32687,  -6032,  32742,  -5914,  32699,  -5908,  32653,  -5951,
 32602,  -5982,  32552,  -6027,  32501,  -6073,  32509,  -6138,

/* 131 */
14, 1,
 25215,  -2688,  25183,  -2701,  25136,  -2748,  25103,  -2829,  25078,  -2922,
 25056,  -3024,  25080,  -3054,  25133,  -3054,  25186,  -3055,  25231,  -2993,
 25272,  -2927,  25294,  -2832,  25291,  -2743,  25244,  -2684,

/* 132 */
13, 1,
-28369,   7366, -28366,   7288, -28392,   7189, -28377,   7082, -28373,   6975,
-28332,   6914, -28288,   6980, -28239,   7023, -28187,   7082, -28208,   7169,
-28237,   7255, -28285,   7311, -28336,   7352,

/* 133 */
13, 1,
  1706,  15651,   1691,  15573,   1629,  15521,   1573,  15447,   1572,  15346,
  1584,  15240,   1608,  15152,   1672,  15095,   1706,  15186,   1723,  15293,
  1738,  15396,   1727,  15503,   1723,  15605,

/* 134 */
14, 1,
-23966,  19704, -24028,  19661, -24069,  19585, -24093,  19539, -24102,  19666,
-24175,  19708, -24222,  19659, -24205,  19549, -24148,  19452, -24131,  19383,
-24058,  19366, -24010,  19449, -24003,  19552, -23972,  19649,

/* 135 */
14, -1,
-12657,  -5597, -12688,  -5568, -12714,  -5656, -12738,  -5724, -12707,  -5779,
-12660,  -5822, -12632,  -5893, -12579,  -5883, -12551,  -5964, -12502,  -5943,
-12527,  -5859, -12554,  -5784, -12594,  -5708, -12632,  -5638,

/* 136 */
13, 1,
 22628,   4165,  22641,   4073,  22661,   3985,  22706,   3939,  22707,   3837,
 22732,   3700,  22773,   3744,  22785,   3825,  22759,   3922,  22758,   4029,
 22743,   4126,  22697,   4127,  22653,   4163,

/* 137 */
12, 1,
-12230,   6642, -12216,   6547, -12157,   6540, -12101,   6540, -12047,   6532,
-11992,   6558, -11953,   6653, -12006,   6714, -12050,   6720, -12107,   6729,
-12164,   6730, -12219,   6721,

/* 138 */
13, 1,
 32409,  -6645,  32444,  -6616,  32494,  -6594,  32512,  -6524,  32495,  -6424,
 32452,  -6348,  32413,  -6317,  32353,  -6341,  32308,  -6382,  32282,  -6466,
 32269,  -6563,  32315,  -6614,  32370,  -6642,

/* 139 */
13, -1,
  5602,  -5699,   5632,  -5713,   5684,  -5737,   5739,  -5721,   5794,  -5721,
  5848,  -5708,   5919,  -5676,   5895,  -5658,   5841,  -5674,   5789,  -5682,
  5732,  -5685,   5680,  -5703,   5626,  -5695,

/* 140 */
13, 1,
-13596, -18212, -13561, -18167, -13561, -18077, -13551, -17961, -13557, -17848,
-13585, -17751, -13640, -17792, -13636, -17911, -13700, -17972, -13677, -18099,
-13625, -18018, -13618, -18066, -13614, -18170,

/* 141 */
13, 1,
 27060,  16563,  27012,  16507,  26939,  16498,  26900,  16456,  26846,  16386,
 26787,  16301,  26744,  16213,  26768,  16200,  26821,  16272,  26874,  16351,
 26939,  16403,  27000,  16464,  27074,  16516,

/* 142 */
13, -1,
   753,   4135,    785,   4080,    831,   4028,    853,   3935,    823,   3856,
   808,   3762,    825,   3647,    837,   3673,    848,   3771,    852,   3867,
   856,   3974,    820,   4056,    773,   4103,

/* 143 */
14, -1,
-18249,  19735, -18262,  19639, -18266,  19553, -18327,  19474, -18288,  19394,
-18216,  19335, -18129,  19335, -18090,  19371, -18142,  19395, -18189,  19429,
-18216,  19532, -18150,  19620, -18196,  19621, -18207,  19700,

/* 144 */
15, -1,
-13287,  18686, -13344,  18661, -13409,  18590, -13450,  18521, -13466,  18380,
-13467,  18266, -13437,  18318, -13431,  18399, -13397,  18493, -13337,  18589,
-13347,  18532, -13315,  18556, -13255,  18628, -13269,  18639, -13277,  18658,

/* 145 */
12, 1,
-24558,  21231, -24532,  21152, -24517,  21041, -24474,  20916, -24478,  20808,
-24400,  20861, -24382,  20933, -24429,  21089, -24379,  21012, -24378,  21055,
-24426,  21151, -24514,  21196,

/* 146 */
13, 1,
 -9927,  25583,  -9940,  25485,  -9962,  25394,  -9930,  25328,  -9776,  25306,
 -9817,  25270,  -9778,  25215,  -9637,  25240,  -9504,  25288,  -9458,  25373,
 -9577,  25450,  -9673,  25531,  -9810,  25581,

/* 147 */
12, -1,
-15624,   4399, -15636,   4329, -15626,   4233, -15601,   4133, -15558,   4075,
-15507,   4042, -15452,   4024, -15436,   4099, -15465,   4183, -15501,   4263,
-15544,   4326, -15586,   4386,

/* 148 */
12, -1,
  5570,    387,   5600,    461,   5634,    544,   5679,    596,   5709,    681,
  5717,    820,   5692,    795,   5653,    725,   5611,    662,   5573,    589,
  5541,    505,   5548,    422,

/* 149 */
13, 2,
 17301,  29557,  17010,  29486,  16905,  29398,  16804,  29287,  16764,  29233,
 16870,  29188,  17171,  29147,  17447,  29192,  17688,  29241,  17734,  29359,
 17709,  29437,  17534,  29526,  17431,  29585,

/* 150 */
12, -1,
  6940,  21518,   6849,  21484,   6901,  21423,   6896,  21339,   6791,  21374,
  6802,  21335,   6874,  21249,   6960,  21164,   7034,  21168,   7090,  21257,
  7031,  21334,   6967,  21417,

/* 151 */
12, 1,
 28852,  -2780,  28887,  -2859,  28928,  -2923,  28975,  -2975,  29022,  -3022,
 29079,  -3086,  29083,  -3042,  29045,  -2965,  29001,  -2908,  28953,  -2867,
 28910,  -2803,  28867,  -2758,

/* 152 */
12, 1,
-13654,  24809, -13711,  24844, -13849,  24869, -13970,  24826, -14035,  24731,
-14065,  24629, -14042,  24528, -13944,  24474, -13807,  24490, -13696,  24548,
-13661,  24648, -13666,  24753,

/* 153 */
12, -1,
 -9740, -12224,  -9729, -12175,  -9712, -12063,  -9675, -11988,  -9640, -11956,
 -9592, -11935,  -9590, -11780,  -9637, -11830,  -9687, -11908,  -9716, -11987,
 -9756, -12066,  -9749, -12175,

/* 154 */
12, -1,
-17216,  18194, -17219,  18132, -17273,  18044, -17286,  17953, -17331,  17872,
-17311,  17809, -17232,  17798, -17149,  17881, -17216,  17957, -17142,  17970,
-17164,  18051, -17198,  18135,

/* 155 */
11, 2,
-28886, -29044, -28917, -28947, -29063, -28856, -29233, -28771, -29391, -28684,
-29634, -28681, -29781, -28779, -29774, -28883, -29615, -28970, -29388, -29036,
-29109, -29067,

/* 156 */
11, 2,
-21611, -26884, -21781, -26859, -21968, -26849, -22147, -26817, -22351, -26809,
-22311, -26899, -22300, -27010, -22205, -27069, -22019, -27041, -21837, -27010,
-21668, -26967,

/* 157 */
14, 1,
-24721,  21205, -24788,  21168, -24800,  21088, -24774,  20995, -24719,  20915,
-24693,  20977, -24666,  20989, -24577,  20926, -24549,  20983, -24663,  21058,
-24606,  21042, -24575,  21090, -24651,  21135, -24689,  21140,

/* 158 */
11, 1,
-16653,    -10, -16623,   -106, -16594,   -214, -16639,   -287, -16631,   -362,
-16578,   -365, -16535,   -305, -16550,   -211, -16574,   -122, -16600,    -35,
-16628,     39,

/* 159 */
11, 1,
 22939,  -1162,  22948,  -1260,  22985,  -1329,  23033,  -1376,  23083,  -1381,
 23131,  -1340,  23157,  -1262,  23128,  -1191,  23085,  -1127,  23032,  -1117,
 22979,  -1139,

/* 160 */
11, 1,
 32612,  25794, -32751,  25828, -32595,  25824, -32432,  25853, -32325,  25927,
-32430,  26016, -32581,  26053, -32746,  26040,  32641,  25976,  32535,  25894,
 32530,  25807,

/* 161 */
11, 1,
  4192,  14161,   4247,  14102,   4294,  14021,   4351,  13973,   4395,  13913,
  4449,  13841,   4438,  13896,   4406,  13984,   4377,  14069,   4310,  14104,
  4261,  14170,

/* 162 */
11, 1,
-13102,  14942, -13175,  14935, -13232,  14919, -13303,  14908, -13367,  14896,
-13439,  14814, -13392,  14788, -13316,  14822, -13243,  14846, -13184,  14876,
-13118,  14920,

/* 163 */
12, 1,
-30854,  22950, -30761,  23007, -30800,  23056, -30898,  23092, -30976,  23158,
-31102,  23156, -31213,  23176, -31270,  23134, -31207,  23063, -31067,  23070,
-30987,  23026, -30909,  22961,

/* 164 */
12, 1,
 -6555, -19975,  -6540, -19931,  -6566, -19833,  -6635, -19756,  -6700, -19698,
 -6785, -19672,  -6883, -19657,  -6865, -19690,  -6794, -19731,  -6718, -19790,
 -6648, -19852,  -6593, -19941,

/* 165 */
12, 1,
-10825, -19009, -10764, -18965, -10697, -18914, -10611, -18866, -10537, -18823,
-10543, -18754, -10600, -18754, -10636, -18721, -10707, -18682, -10748, -18785,
-10795, -18848, -10843, -18927,

/* 166 */
11, -1,
-17745,   9259, -17774,   9206, -17780,   9097, -17780,   9005, -17794,   8907,
-17790,   8742, -17786,   8792, -17778,   8898, -17766,   9001, -17752,   9103,
-17735,   9206,

/* 167 */
10, -1,
 14183,  15548,  14128,  15535,  14057,  15526,  13988,  15502,  13901,  15441,
 13960,  15379,  14025,  15349,  14099,  15352,  14162,  15409,  14224,  15514,

/* 168 */
12, 1,
 22389,  -1603,  22363,  -1667,  22356,  -1773,  22345,  -1874,  22320,  -1970,
 22332,  -2056,  22366,  -2012,  22404,  -1958,  22400,  -1891,  22382,  -1833,
 22410,  -1737,  22412,  -1647,

/* 169 */
11, 2,
-13042, -28970, -12867, -28974, -12703, -28883, -12583, -28786, -12427, -28699,
-12284, -28596, -12450, -28578, -12662, -28645, -12863, -28717, -13020, -28804,
-13072, -28905,

/* 170 */
11, 1,
  2261,  20416,   2188,  20335,   2121,  20333,   2023,  20281,   2028,  20179,
  2062,  20102,   2153,  20042,   2214,  20085,   2235,  20174,   2272,  20256,
  2284,  20359,

/* 171 */
12, 1,
-12465, -20000, -12532, -20010, -12632, -20038, -12698, -20089, -12631, -20172,
-12622, -20115, -12576, -20096, -12529, -20162, -12420, -20222, -12453, -20136,
-12520, -20065, -12470, -20051,

/* 172 */
11, 2,
 26627,  27467,  26636,  27365,  26809,  27295,  26970,  27234,  27170,  27215,
 27362,  27255,  27401,  27346,  27198,  27393,  27026,  27415,  26829,  27442,
 26699,  27470,

/* 173 */
11, 1,
 23059,  26398,  23201,  26468,  23349,  26524,  23464,  26610,  23346,  26687,
 23221,  26750,  23073,  26726,  23061,  26619,  23007,  26520,  22997,  26412,
 23019,  26357,

/* 174 */
10, 1,
 20833,  -2976,  20862,  -3047,  20913,  -3083,  20960,  -3183,  21000,  -3131,
 21046,  -3061,  21016,  -2974,  20964,  -2945,  20913,  -2979,  20860,  -2958,

/* 175 */
11, -1,
 14785,  19620,  14805,  19649,  14874,  19735,  14946,  19794,  15021,  19853,
 15118,  19919,  15088,  19947,  15007,  19881,  14940,  19805,  14870,  19746,
 14804,  19671,

/* 176 */
11, 1,
 29239,  -3037,  29242,  -3104,  29251,  -3205,  29271,  -3305,  29307,  -3380,
 29355,  -3466,  29357,  -3415,  29343,  -3327,  29315,  -3241,  29295,  -3152,
 29270,  -3060,

/* 177 */
11, -1,
  2521,  21601,   2427,  21604,   2391,  21499,   2303,  21462,   2274,  21391,
  2265,  21291,   2296,  21264,   2384,  21316,   2481,  21359,   2541,  21436,
  2554,  21523,

/* 178 */
10, 2,
-22531, -26962, -22590, -26861, -22733, -26814, -22852, -26726, -22995, -26663,
-23154, -26701, -23115, -26794, -22971, -26856, -22842, -26934, -22676, -26984,

/* 179 */
10, 1,
 29053,  -3387,  29052,  -3464,  29082,  -3547,  29134,  -3575,  29188,  -3586,
 29250,  -3590,  29234,  -3499,  29188,  -3439,  29134,  -3432,  29088,  -3397,

/* 180 */
11, 1,
 20549,  -2511,  20520,  -2560,  20545,  -2614,  20594,  -2622,  20656,  -2625,
 20700,  -2591,  20745,  -2558,  20740,  -2507,  20687,  -2508,  20634,  -2508,
 20581,  -2507,

/* 181 */
11, -1,
-13251, -17081, -13197, -17008, -13136, -16949, -13061, -16932, -12982, -16955,
-12980, -16908, -13062, -16867, -13125, -16920, -13205, -16949, -13231, -16972,
-13258, -17064,

/* 182 */
10, 1,
-11076, -18971, -11018, -18988, -10942, -18925, -10874, -18866, -10814, -18740,
-10900, -18718, -10997, -18723, -10984, -18814, -11000, -18884, -11066, -18929,

/* 183 */
10, 2,
-17310,  27523, -17441,  27459, -17512,  27385, -17520,  27287, -17376,  27221,
-17207,  27170, -17027,  27202, -17016,  27311, -17051,  27415, -17171,  27503,

/* 184 */
10, 1,
 23847,  -4326,  23886,  -4274,  23927,  -4192,  23908,  -4099,  23865,  -4124,
 23805,  -4138,  23755,  -4110,  23738,  -4165,  23764,  -4256,  23809,  -4314,

/* 185 */
11, -1,
  9872,  20706,   9960,  20758,  10032,  20830,  10107,  20875,  10089,  20990,
 10067,  21011,  10076,  20892,  10006,  20844,   9947,  20781,   9860,  20730,
  9845,  20675,

/* 186 */
10, -1,
  6150,  16794,   6206,  16754,   6275,  16707,   6324,  16665,   6405,  16526,
  6388,  16589,   6348,  16681,   6298,  16772,   6231,  16810,   6170,  16817,

/* 187 */
10, 1,
-11117,   3939, -11147,   3931, -11198,   3892, -11190,   3764, -11243,   3688,
-11223,   3665, -11169,   3666, -11115,   3688, -11104,   3784, -11100,   3910,

/* 188 */
10, 1,
-24600,  20911, -24653,  20908, -24645,  20821, -24620,  20719, -24576,  20628,
-24530,  20494, -24503,  20567, -24505,  20664, -24527,  20767, -24559,  20863,

/* 189 */
11, -1,
-12455,  18851, -12518,  18815, -12584,  18841, -12597,  18798, -12585,  18693,
-12541,  18607, -12511,  18503, -12502,  18512, -12459,  18603, -12420,  18688,
-12420,  18790,

/* 190 */
9, 1,
 24656,   -597,  24696,   -623,  24746,   -654,  24797,   -683,  24877,   -665,
 24842,   -629,  24791,   -609,  24739,   -598,  24686,   -589,

/* 191 */
9, -1,
  8215,  13906,   8212,  13835,   8226,  13747,   8242,  13644,   8271,  13536,
  8331,  13590,   8326,  13693,   8281,  13760,   8276,  13867,

/* 192 */
10, 1,
-14165,   9789, -14110,   9761, -14069,   9690, -14052,   9614, -14064,   9479,
-14046,   9514, -14024,   9607, -14061,   9700, -14104,   9771, -14159,   9797,

/* 193 */
10, 2,
-12594, -24604, -12515, -24650, -12403, -24571, -12360, -24481, -12350, -24393,
-12327, -24289, -12371, -24268, -12452, -24352, -12503, -24448, -12562, -24542,

/* 194 */
9, 1,
 25640,  26849,  25547,  26755,  25502,  26721,  25722,  26704,  25892,  26670,
 26083,  26672,  26082,  26777,  25957,  26859,  25785,  26896,

/* 195 */
10, 1,
-24009,  19372, -24086,  19344, -24077,  19287, -24034,  19208, -23988,  19126,
-23893,  19018, -23905,  19068, -23962,  19146, -23988,  19239, -23983,  19315,

/* 196 */
9, 1,
-15005,  22915, -15116,  22890, -15199,  22854, -15253,  22759, -15229,  22655,
-15118,  22651, -15029,  22715, -14954,  22792, -14917,  22887,

/* 197 */
10, -1,
-19649,  17290, -19589,  17328, -19510,  17348, -19440,  17359, -19359,  17368,
-19363,  17436, -19440,  17394, -19505,  17363, -19578,  17352, -19640,  17311,

/* 198 */
9, 2,
-17883,  28652, -17870,  28557, -17737,  28448, -17683,  28354, -17534,  28347,
-17311,  28414, -17310,  28526, -17494,  28599, -17703,  28670,

/* 199 */
10, -1,
 -1008,   2939,  -1034,   2863,  -1043,   2779,  -1051,   2668,  -1001,   2575,
  -983,   2688,  -1008,   2680,  -1025,   2706,  -1016,   2815,  -1009,   2896,

/* 200 */
9, 1,
 25028, -13126,  25097, -13052,  25055, -12997,  25011, -12959,  24948, -12981,
 24883, -13008,  24864, -13085,  24917, -13120,  24983, -13110,

/* 201 */
8, 2,
  4187,  28451,   3887,  28448,   3902,  28354,   3856,  28223,   4105,  28182,
  4307,  28198,   4460,  28301,   4312,  28357,

/* 202 */
10, -1,
  7703,  14008,   7740,  14007,   7805,  13986,   7861,  13970,   7863,  14062,
  7915,  14155,   7868,  14171,   7833,  14125,   7764,  14115,   7719,  14054,

/* 203 */
9, -1,
-20088,  13796, -20104,  13751, -20147,  13659, -20174,  13576, -20258,  13494,
-20226,  13489, -20160,  13546, -20136,  13647, -20098,  13740,

/* 204 */
9, 1,
 28475,  -2422,  28493,  -2480,  28531,  -2552,  28568,  -2631,  28638,  -2678,
 28621,  -2628,  28591,  -2543,  28549,  -2481,  28504,  -2425,

/* 205 */
9, 1,
 17814,    378,  17776,    446,  17735,    533,  17689,    519,  17687,    479,
 17718,    389,  17750,    321,  17789,    225,  17817,    289,

/* 206 */
9, 1,
 29355,  -3734,  29382,  -3779,  29413,  -3857,  29457,  -3911,  29528,  -3937,
 29523,  -3859,  29483,  -3806,  29432,  -3778,  29384,  -3727,

/* 207 */
9, 1,
-29777,  20034, -29852,  20016, -29930,  19973, -29996,  19885, -29979,  19810,
-29899,  19851, -29817,  19884, -29715,  19908, -29733,  19962,

/* 208 */
9, 1,
 22432,   4541,  22427,   4404,  22466,   4425,  22511,   4373,  22560,   4304,
 22573,   4351,  22541,   4436,  22501,   4500,  22454,   4551,

/* 209 */
9, 2,
-20027,  28431, -20203,  28421, -20438,  28391, -20603,  28318, -20550,  28207,
-20349,  28159, -20112,  28204, -20097,  28304, -20009,  28381,

/* 210 */
9, -1,
 18874,   4816,  18883,   4743,  18918,   4674,  18956,   4617,  19020,   4541,
 19014,   4588,  18973,   4656,  18944,   4749,  18905,   4813,

/* 211 */
9, 1,
 30346,  -5409,  30315,  -5378,  30325,  -5511,  30332,  -5619,  30369,  -5682,
 30425,  -5640,  30419,  -5536,  30384,  -5477,  30352,  -5463,

/* 212 */
9, 1,
  9709,   4556,   9737,   4516,   9787,   4483,   9841,   4494,   9903,   4548,
  9879,   4599,   9828,   4608,   9777,   4605,   9727,   4598,

/* 213 */
9, -1,
-28008,  21763, -28061,  21763, -28166,  21748, -28260,  21710, -28356,  21675,
-28332,  21599, -28226,  21628, -28138,  21666, -28053,  21731,

/* 214 */
9, 1,
-24717,  25113, -24608,  25092, -24481,  25046, -24483,  25073, -24467,  25164,
-24375,  25278, -24458,  25326, -24601,  25256, -24698,  25195,

/* 215 */
9, -1,
-20523,  15170, -20550,  15132, -20541,  15029, -20503,  14939, -20456,  14850,
-20413,  14899, -20416,  14958, -20468,  15026, -20514,  15112,

/* 216 */
9, 1,
  3104,  20874,   3079,  20813,   3040,  20716,   2998,  20623,   2987,  20509,
  3016,  20524,   3041,  20623,   3072,  20725,   3102,  20823,

/* 217 */
8, 1,
  8782,  25100,   8859,  25028,   8999,  25053,   9113,  25135,   9124,  25207,
  9010,  25276,   8874,  25284,   8790,  25197,

/* 218 */
8, 1,
-19031,  26784, -19141,  26834, -19331,  26834, -19440,  26760, -19323,  26670,
-19195,  26560, -19090,  26612, -19033,  26714,

/* 219 */
8, 1,
 21160,  -3007,  21129,  -3073,  21107,  -3187,  21128,  -3234,  21195,  -3235,
 21221,  -3162,  21239,  -3059,  21200,  -2998,

/* 220 */
9, -1,
-16083,  18274, -16146,  18274, -16190,  18162, -16196,  18080, -16146,  18032,
-16081,  18000, -16042,  18053, -16038,  18173, -16057,  18258,

/* 221 */
9, -1,
-20815,  13285, -20862,  13160, -20816,  13133, -20753,  13142, -20698,  13080,
-20697,  13090, -20752,  13159, -20805,  13152, -20810,  13258,

/* 222 */
8, 2,
-13859, -25911, -13708, -25881, -13554, -25849, -13421, -25785, -13497, -25720,
-13627, -25756, -13789, -25800, -13922, -25856,

/* 223 */
8, 1,
 -9405,   -389,  -9436,   -486,  -9391,   -479,  -9350,   -401,  -9325,   -324,
 -9334,   -218,  -9376,   -230,  -9402,   -320,

/* 224 */
8, 1,
 18064,   -612,  18046,   -529,  18024,   -437,  17994,   -352,  17952,   -392,
 17959,   -489,  17988,   -578,  18029,   -643,

/* 225 */
8, 1,
 -4698,  25862,  -4800,  25821,  -4948,  25781,  -5078,  25680,  -4959,  25657,
 -4799,  25678,  -4646,  25720,  -4642,  25815,

/* 226 */
8, -1,
 18239,  13536,  18183,  13537,  18152,  13452,  18174,  13369,  18236,  13336,
 18305,  13323,  18321,  13406,  18274,  13491,

/* 227 */
9, -1,
-21422,  22343, -21495,  22393, -21568,  22339, -21670,  22295, -21788,  22311,
-21778,  22298, -21671,  22285, -21566,  22320, -21470,  22347,

/* 228 */
8, 1,
 19595,   -942,  19584,  -1027,  19587,  -1134,  19635,  -1143,  19681,  -1147,
 19703,  -1046,  19676,   -962,  19628,   -932,

/* 229 */
9, -1,
-18584,  22942, -18546,  22890, -18454,  22848, -18382,  22881, -18384,  22996,
-18328,  23078, -18383,  23106, -18477,  23078, -18570,  22984,

/* 230 */
9, 1,
-30275,  19645, -30325,  19632, -30381,  19570, -30412,  19495, -30500,  19425,
-30471,  19406, -30384,  19453, -30310,  19521, -30278,  19602,

/* 231 */
10, -1,
 21497,  11988,  21536,  11989,  21592,  12054,  21592,  12178,  21537,  12137,
 21546,  12048,  21517,  12054,  21481,  12057,  21459,  12053,  21504,  12011,

/* 232 */
8, -1,
 18275,  18727,  18258,  18662,  18250,  18549,  18239,  18417,  18280,  18429,
 18310,  18529,  18335,  18631,  18316,  18748,

/* 233 */
9, -1,
-12820,  23522, -12830,  23586, -12892,  23686, -13013,  23770, -13033,  23716,
-13066,  23617, -13039,  23532, -12938,  23555, -12858,  23535,

/* 234 */
9, 1,
 23808,     -3,  23782,    -17,  23724,    -56,  23748,   -117,  23795,    -99,
 23826,   -110,  23881,   -124,  23884,    -55,  23837,    -15,

/* 235 */
9, -1,
-18082,  16006, -18091,  15941, -18081,  15853, -18034,  15774, -17972,  15695,
-17976,  15711, -18031,  15780, -18076,  15859, -18085,  15947,

/* 236 */
8, 1,
 24478,  -1994,  24450,  -2070,  24448,  -2169,  24451,  -2257,  24503,  -2299,
 24516,  -2199,  24521,  -2109,  24505,  -2009,

/* 237 */
8, 1,
-30244,  21984, -30315,  21962, -30429,  21903, -30385,  21828, -30265,  21777,
-30181,  21800, -30148,  21861, -30188,  21956,

/* 238 */
9, 1,
-13592, -19210, -13552, -19283, -13486, -19321, -13406, -19367, -13345, -19415,
-13354, -19376, -13409, -19328, -13489, -19280, -13556, -19232,

/* 239 */
8, 1,
-14866,  16707, -14904,  16698, -14993,  16712, -15091,  16707, -15057,  16665,
-14986,  16626, -14907,  16598, -14862,  16654,

/* 240 */
8, 1,
 22638,   -615,  22636,   -694,  22681,   -722,  22733,   -699,  22793,   -672,
 22775,   -633,  22722,   -613,  22669,   -598,

/* 241 */
8, 1,
 23942,  -2612,  23911,  -2686,  23878,  -2779,  23865,  -2853,  23893,  -2903,
 23929,  -2829,  23961,  -2741,  23965,  -2632,

/* 242 */
10, 1,
-13141, -19574, -13190, -19531, -13257, -19493, -13309, -19459, -13342, -19528,
-13330, -19628, -13272, -19611, -13259, -19667, -13210, -19677, -13162, -19619,

/* 243 */
8, 1,
-14230,   9143, -14234,   9059, -14250,   8965, -14216,   8879, -14170,   8880,
-14149,   8964, -14176,   9058, -14204,   9149,

/* 244 */
8, -1,
 24166,  16451,  24131,  16485,  24058,  16494,  24030,  16417,  24039,  16313,
 24081,  16236,  24139,  16297,  24171,  16396,

/* 245 */
8, 1,
 23143,  26366,  23289,  26322,  23424,  26252,  23550,  26281,  23494,  26370,
 23333,  26414,  23172,  26424,  23063,  26384,

/* 246 */
8, 2,
  8732,  29155,   8877,  29200,   9032,  29274,   9318,  29342,   9134,  29411,
  8927,  29329,   8687,  29266,   8624,  29196,

/* 247 */
8, 1,
 10747,  25442,  10835,  25406,  10957,  25375,  10987,  25458,  10879,  25536,
 10770,  25624,  10667,  25581,  10683,  25489,

/* 248 */
7, 1,
 24649,   -265,  24695,   -313,  24723,   -396,  24789,   -419,  24770,   -341,
 24728,   -273,  24680,   -252,

/* 249 */
7, -1,
  2717,  21418,   2669,  21362,   2624,  21270,   2588,  21107,   2648,  21171,
  2692,  21268,   2715,  21356,

/* 250 */
8, 1,
-13958,   9264, -13904,   9212, -13866,   9130, -13874,   9028, -13861,   9024,
-13858,   9131, -13897,   9212, -13947,   9273,

/* 251 */
7, 1,
  3428,  21071,   3364,  21036,   3307,  20943,   3321,  20781,   3388,  20834,
  3426,  20920,   3446,  21028,

/* 252 */
7, 1,
 22907,  -2867,  22958,  -2877,  23013,  -2881,  23064,  -2823,  23053,  -2774,
 23004,  -2785,  22952,  -2802,

/* 253 */
8, 1,
 27864,  -9344,  27882,  -9241,  27905,  -9143,  27899,  -9041,  27883,  -9042,
 27867,  -9149,  27852,  -9236,  27843,  -9339,

/* 254 */
7, 1,
   573,  14545,    533,  14525,    459,  14422,    509,  14352,    573,  14325,
   620,  14425,    584,  14501,

/* 255 */
7, 1,
 22631,   3690,  22587,   3662,  22544,   3590,  22554,   3511,  22609,   3496,
 22661,   3544,  22668,   3633,

/* 256 */
7, 1,
 -4238,  26512,  -4374,  26520,  -4429,  26442,  -4337,  26370,  -4101,  26290,
 -4062,  26370,  -4152,  26459,

/* 257 */
8, -1,
  7794,  20883,   7829,  20793,   7855,  20688,   7877,  20655,   7864,  20779,
  7880,  20889,   7890,  20948,   7798,  20910,

/* 258 */
7, 2,
-13543, -26541, -13711, -26536, -13805, -26624, -13770, -26721, -13598, -26787,
-13546, -26718, -13518, -26615,

/* 259 */
7, 2,
-14337, -26617, -14178, -26548, -14109, -26466, -14178, -26400, -14381, -26377,
-14377, -26454, -14419, -26557,

/* 260 */
7, 1,
-14522,  22709, -14591,  22642, -14609,  22535, -14551,  22445, -14484,  22479,
-14442,  22573, -14443,  22676,

/* 261 */
7, 1,
-17724,   9899, -17726,   9838, -17719,   9733, -17694,   9574, -17700,   9637,
-17716,   9738, -17723,   9842,

/* 262 */
8, 1,
 22322,  -1687,  22287,  -1725,  22271,  -1809,  22260,  -1913,  22289,  -1952,
 22318,  -1919,  22333,  -1824,  22339,  -1731,

/* 263 */
7, 1,
 -4516,  26723,  -4639,  26660,  -4525,  26600,  -4271,  26610,  -4446,  26670,
 -4318,  26665,  -4359,  26706,

/* 264 */
7, -1,
 16901,  18443,  16856,  18401,  16799,  18335,  16827,  18229,  16898,  18214,
 16967,  18306,  16925,  18402,

/* 265 */
8, -1,
  5952,    497,   5985,    501,   6044,    471,   6048,    520,   6072,    601,
  6043,    599,   5990,    568,   5940,    548,

/* 266 */
7, 1,
 26587,  16183,  26558,  16113,  26494,  15964,  26537,  16009,  26586,  16092,
 26651,  16144,  26636,  16178,

/* 267 */
8, 1,
-14451,  20526, -14483,  20480, -14514,  20370, -14431,  20388, -14390,  20467,
-14402,  20391, -14388,  20426, -14374,  20524,

/* 268 */
8, -1,
  6247,  23236,   6250,  23167,   6308,  23083,   6348,  22949,   6360,  22982,
  6387,  23080,   6381,  23125,   6308,  23213,

/* 269 */
7, 1,
 29772,  21320,  29867,  21397,  29958,  21454,  29925,  21533,  29815,  21472,
 29781,  21367,  29744,  21320,

/* 270 */
7, 1,
-30557,  19484, -30618,  19477, -30665,  19394, -30742,  19276, -30697,  19284,
-30632,  19361, -30562,  19429,

/* 271 */
7, -1,
   939,  19223,    930,  19139,    939,  19049,   1026,  19053,   1053,  19138,
  1010,  19232,    983,  19300,

/* 272 */
8, -1,
 21413,  17954,  21369,  17892,  21314,  17810,  21309,  17720,  21344,  17705,
 21393,  17783,  21450,  17851,  21440,  17893,

/* 273 */
7, 1,
  4158,  21332,   4075,  21318,   3996,  21258,   4018,  21131,   4050,  21148,
  4122,  21201,   4211,  21276,

/* 274 */
7, -1,
  6798,   4230,   6815,   4279,   6836,   4371,   6812,   4464,   6756,   4446,
  6740,   4339,   6781,   4278,

/* 275 */
7, 2,
 30522, -28272,  30756, -28252,  30749, -28178,  30498, -28159,  30323, -28131,
 30313, -28262,  30364, -28321,

/* 276 */
7, -1,
-13275, -18430, -13266, -18356, -13158, -18289, -13214, -18265, -13312, -18228,
-13311, -18291, -13286, -18387,

/* 277 */
7, 2,
-20161,  28659, -20329,  28606, -20569,  28537, -20440,  28509, -20201,  28509,
-19932,  28530, -19999,  28628,

/* 278 */
7, 1,
-14371,   9709, -14337,   9659, -14281,   9675, -14203,   9709, -14229,   9723,
-14295,   9727, -14344,   9688,

/* 279 */
7, 1,
 10244,   9815,  10212,   9820,  10154,   9784,  10086,   9700,  10116,   9696,
 10173,   9724,  10221,   9779,

/* 280 */
7, -1,
-24248,  22001, -24218,  21952, -24145,  21878, -24068,  21749, -24075,  21797,
-24133,  21882, -24210,  21956,

/* 281 */
7, 1,
 17558,    873,  17536,    921,  17494,    982,  17442,   1043,  17437,    976,
 17485,    930,  17532,    870,

/* 282 */
6, 1,
-14791,  19368, -14872,  19361, -14909,  19293, -14820,  19241, -14713,  19212,
-14731,  19317,

/* 283 */
7, -1,
-16062,  13463, -16045,  13398, -16030,  13295, -16019,  13167, -16007,  13207,
-16022,  13309, -16040,  13409,

/* 284 */
7, -1,
  -709,   5812,   -739,   5788,   -778,   5729,   -779,   5640,   -759,   5581,
  -774,   5733,   -735,   5784,

/* 285 */
7, 1,
 22820,   -674,  22854,   -702,  22908,   -698,  22970,   -679,  22956,   -657,
 22903,   -655,  22849,   -657,

/* 286 */
8, 1,
  2742,  24850,   2836,  24895,   2940,  24933,   2986,  25034,   2911,  24994,
  2875,  25042,   2818,  24992,   2764,  24906,

/* 287 */
7, 1,
 24406,  -2252,  24413,  -2335,  24402,  -2421,  24423,  -2500,  24464,  -2440,
 24468,  -2358,  24430,  -2283,

/* 288 */
8, 1,
 24813,  -5176,  24841,  -5181,  24897,  -5198,  24904,  -5154,  24904,  -5061,
 24887,  -5008,  24848,  -5022,  24827,  -5121,

/* 289 */
7, 1,
 27232,  16610,  27300,  16681,  27353,  16755,  27362,  16804,  27281,  16729,
 27227,  16658,  27206,  16604,

/* 290 */
7, 1,
 26828,   -730,  26798,   -731,  26747,   -714,  26685,   -757,  26710,   -787,
 26767,   -795,  26817,   -752,

/* 291 */
7, 1,
 30474,  -6013,  30506,  -6020,  30534,  -5969,  30489,  -5888,  30451,  -5809,
 30434,  -5859,  30464,  -5938,

/* 292 */
7, 1,
 23339,   9767,  23303,   9713,  23273,   9659,  23242,   9540,  23266,   9573,
 23301,   9649,  23346,   9723,

/* 293 */
8, -1,
-13274, -17794, -13193, -17852, -13184, -17800, -13211, -17678, -13220, -17729,
-13260, -17659, -13272, -17712, -13294, -17768,

/* 294 */
7, -1,
  8694,  18951,   8755,  18999,   8772,  19086,   8817,  19192,   8799,  19187,
  8763,  19093,   8722,  19000,

/* 295 */
6, 1,
 28288,  18228,  28361,  18289,  28408,  18382,  28382,  18440,  28315,  18342,
 28255,  18279,

/* 296 */
6, 1,
  1907,  20216,   1790,  20192,   1821,  20089,   1880,  20042,   1958,  20082,
  1951,  20181,

/* 297 */
8, 1,
-23898,  20366, -23946,  20311, -23971,  20219, -23924,  20181, -23906,  20158,
-23873,  20131, -23835,  20226, -23860,  20323,

/* 298 */
7, 1,
-24422,  20710, -24439,  20647, -24415,  20551, -24413,  20449, -24373,  20485,
-24357,  20582, -24370,  20658,

/* 299 */
6, 1,
 22472,   -459,  22430,   -462,  22381,   -433,  22362,   -535,  22416,   -540,
 22466,   -527,

/* 300 */
6, 1,
-12221, -20023, -12297, -19993, -12403, -19994, -12398, -20068, -12319, -20102,
-12229, -20107,

/* 301 */
7, -1,
-17600,  19999, -17650,  19987, -17735,  19943, -17820,  19900, -17801,  19878,
-17722,  19920, -17648,  19970,

/* 302 */
6, 1,
 28654,  -2910,  28625,  -2990,  28668,  -3031,  28718,  -3104,  28713,  -3015,
 28683,  -2943,

/* 303 */
6, 1,
 -2982,  10377,  -3035,  10331,  -3065,  10283,  -3021,  10207,  -2980,  10290,
 -2946,  10377,

/* 304 */
6, 1,
 23193,   -518,  23189,   -583,  23231,   -624,  23301,   -599,  23271,   -521,
 23221,   -501,

/* 305 */
6, 1,
 -1131,  21282,  -1187,  21251,  -1257,  21185,  -1266,  21070,  -1191,  21114,
 -1138,  21200,

/* 306 */
6, 1,
-24249,  20739, -24345,  20761, -24344,  20687, -24306,  20569, -24236,  20622,
-24201,  20692,

/* 307 */
7, -1,
 -8196,  -6859,  -8220,  -6793,  -8240,  -6681,  -8260,  -6740,  -8240,  -6834,
 -8250,  -6895,  -8231,  -6901,

/* 308 */
6, -1,
 21827,  11337,  21868,  11266,  21926,  11287,  21919,  11331,  21891,  11441,
 21839,  11429,

/* 309 */
6, 1,
 -2577,  10327,  -2611,  10243,  -2611,  10223,  -2551,  10273,  -2521,  10356,
 -2539,  10433,

/* 310 */
6, 1,
 22649,  -2972,  22649,  -3037,  22701,  -3061,  22761,  -3022,  22733,  -2972,
 22679,  -2972,

/* 311 */
6, 1,
 -4031,  26555,  -4180,  26586,  -4398,  26565,  -4330,  26534,  -4156,  26494,
 -4018,  26484,

/* 312 */
6, 1,
 23351,    732,  23388,    759,  23415,    849,  23396,    935,  23351,    878,
 23340,    786,

/* 313 */
6, 2,
-17013,  28301, -17189,  28308, -17434,  28295, -17443,  28210, -17180,  28198,
-17002,  28230,

/* 314 */
6, 1,
 10119,  -7609,  10065,  -7624,  10067,  -7716,  10112,  -7771,  10158,  -7730,
 10145,  -7658,

/* 315 */
6, 2,
-10537, -23456, -10458, -23430, -10413, -23341, -10509, -23271, -10600, -23307,
-10576, -23413,

/* 316 */
6, -1,
  4929,  25078,   5005,  25038,   5118,  25065,   5178,  25205,   5107,  25191,
  4989,  25115,

/* 317 */
6, 2,
-11691, -23555, -11619, -23581, -11485, -23522, -11499, -23435, -11581, -23427,
-11657, -23503,

/* 318 */
6, 1,
 23721,   -612,  23692,   -629,  23631,   -676,  23663,   -736,  23717,   -731,
 23730,   -668,

/* 319 */
6, 1,
-15121,   7942, -15117,   7866, -15102,   7810, -15041,   7842, -15045,   7936,
-15096,   7977,

/* 320 */
6, 1,
  1613,   1365,   1580,   1343,   1547,   1251,   1559,   1178,   1597,   1218,
  1623,   1315,

/* 321 */
6, 1,
-31711,  19072, -31739,  19014, -31848,  18948, -31804,  18939, -31732,  18960,
-31684,  19028,

/* 322 */
6, 1,
-13702,   8579, -13674,   8473, -13665,   8409, -13632,   8371, -13668,   8474,
-13691,   8570,

/* 323 */
6, 1,
 23208,   -114,  23181,   -152,  23198,   -262,  23252,   -299,  23242,   -247,
 23228,   -157,

/* 324 */
6, -1,
-11404, -11246, -11356, -11226, -11328, -11165, -11374, -11119, -11440, -11153,
-11437, -11221,

/* 325 */
6, 1,
 25020,  19942,  25088,  19918,  25121,  20024,  25056,  20073,  24994,  19995,
 24975,  19941,

/* 326 */
6, 2,
-10255, -23091, -10184, -23060, -10069, -23058, -10052, -23005, -10161, -22981,
-10266, -23038,

/* 327 */
6, 1,
-23477,  19399, -23482,  19310, -23486,  19239, -23427,  19202, -23393,  19263,
-23424,  19356,

/* 328 */
6, 1,
 18751,    302,  18722,    344,  18673,    387,  18648,    343,  18676,    287,
 18735,    275,

/* 329 */
5, 2,
 -6851, -28628,  -7019, -28606,  -7449, -28596,  -7271, -28617,  -7013, -28628,

/* 330 */
5, 1,
 16501,   8293,  16488,   8232,  16507,   8076,  16537,   8140,  16525,   8239,

/* 331 */
5, 2,
 -3676, -27250,  -3671, -27192,  -3732, -27043,  -3864, -27105,  -3739, -27205,

/* 332 */
5, -1,
-21677,  19193, -21651,  19147, -21560,  19003, -21595,  19067, -21645,  19153,

/* 333 */
5, 1,
 -9100,     95,  -9152,     75,  -9150,     19,  -9092,     -6,  -9058,     74,

/* 334 */
6, 1,
-27698,  21249, -27757,  21261, -27834,  21210, -27860,  21144, -27774,  21150,
-27692,  21198,

/* 335 */
5, 1,
 30796,  25436,  30639,  25474,  30568,  25406,  30695,  25337,  30806,  25359,

/* 336 */
5, 2,
 -3459,  27939,  -3459,  27879,  -3410,  27708,  -3397,  27781,  -3407,  27888,

/* 337 */
5, -1,
-10024,   1813, -10050,   1743, -10058,   1658, -10003,   1672,  -9987,   1762,

/* 338 */
6, 1,
-13331, -16356, -13291, -16320, -13257, -16237, -13290, -16175, -13334, -16222,
-13349, -16305,

/* 339 */
4, 1,
 31265,   2567,  31151,   2584,  31209,   2573,  31247,   2545,

/* 340 */
5, 2,
 10844,  29291,  11097,  29291,  11285,  29393,  10994,  29420,  10806,  29368,

/* 341 */
5, 1,
-13410,   7631, -13366,   7622, -13304,   7696, -13342,   7708, -13396,   7687,

/* 342 */
5, 1,
-23705,  19613, -23670,  19536, -23597,  19437, -23599,  19509, -23659,  19589,

/* 343 */
6, -1,
 21688,  11905,  21720,  11932,  21715,  12043,  21660,  12044,  21691,  12041,
 21690,  11970,

/* 344 */
5, 1,
 23685,  -4302,  23748,  -4280,  23731,  -4172,  23700,  -4161,  23680,  -4258,

/* 345 */
5, 1,
 23083,  12210,  23049,  12205,  22982,  12136,  23032,  12099,  23091,  12160,

/* 346 */
5, 1,
 12765,  26588,  12972,  26643,  12939,  26714,  12789,  26733,  12737,  26636,

/* 347 */
5, 2,
-21444,  27696, -21554,  27644, -21652,  27523, -21487,  27553, -21407,  27659,

/* 348 */
5, 1,
 10483,  -7301,  10443,  -7387,  10455,  -7459,  10508,  -7417,  10514,  -7345,

/* 349 */
5, 1,
  7134,  -2215,   7159,  -2297,   7189,  -2285,   7168,  -2176,   7149,  -2120,

/* 350 */
5, 2,
 -8177,  29898,  -8142,  29996,  -8485,  30076,  -8552,  30002,  -8308,  29919,

/* 351 */
5, 1,
 30209,  20140,  30204,  20092,  30251,  20000,  30307,  19966,  30257,  20101,

/* 352 */
5, 1,
-12514,  18790, -12567,  18723, -12535,  18640, -12466,  18680, -12454,  18751,

/* 353 */
5, 1,
 22362,  -3957,  22410,  -3939,  22453,  -3856,  22428,  -3844,  22385,  -3901,

/* 354 */
5, 2,
-19281,  28291, -19245,  28207, -19115,  28102, -19057,  28166, -19159,  28259,

/* 355 */
5, -1,
-13130, -18104, -13173, -18050, -13256, -18009, -13268, -18066, -13185, -18095,

/* 356 */
5, 2,
 20582,  27015,  20585,  27105,  20385,  27100,  20338,  27025,  20475,  26977,

/* 357 */
5, 1,
-13683, -17720, -13672, -17649, -13719, -17521, -13731, -17589, -13702, -17680,

/* 358 */
4, 1,
-28491,   7616, -28464,   7515, -28408,   7527, -28417,   7597,

/* 359 */
5, 2,
-10723, -22646, -10641, -22625, -10528, -22570, -10604, -22547, -10698, -22599,

/* 360 */
5, -1,
  6104,  14008,   6124,  14063,   6087,  14174,   6042,  14127,   6077,  14040,

/* 361 */
5, 1,
-13386,  24751, -13485,  24777, -13579,  24770, -13543,  24683, -13387,  24686,

/* 362 */
5, 1,
  3520,  19753,   3560,  19778,   3659,  19878,   3608,  19863,   3533,  19790,

/* 363 */
5, 1,
  4784,  14328,   4723,  14290,   4756,  14238,   4818,  14205,   4819,  14270,

/* 364 */
5, 1,
-31392,  -5025, -31352,  -5008, -31358,  -4919, -31422,  -4921, -31416,  -4987,

/* 365 */
5, -1,
-14708,   9895, -14740,   9841, -14737,   9767, -14690,   9742, -14680,   9851,

/* 366 */
4, 1,
 30546, -17015,  30516, -17160,  30597, -17140,  30590, -17068,

/* 367 */
5, 1,
  5121,  13257,   5079,  13221,   5051,  13117,   5099,  13127,   5130,  13219,

/* 368 */
5, 1,
-20410,   9201, -20415,   9147, -20417,   9046, -20415,   8995, -20411,   9151,

/* 369 */
5, 1,
 26976, -14647,  26987, -14593,  26945, -14492,  26909, -14514,  26936, -14612,

/* 370 */
5, 1,
 27381,  -3413,  27391,  -3487,  27446,  -3520,  27458,  -3473,  27417,  -3422,

/* 371 */
5, 1,
  3149,  25154,   3256,  25203,   3233,  25302,   3130,  25262,   3093,  25174,

/* 372 */
5, 1,
 20602,  -9506,  20591,  -9441,  20566,  -9321,  20556,  -9359,  20580,  -9454,

/* 373 */
5, 1,
 23822,   -325,  23792,   -357,  23801,   -449,  23841,   -464,  23845,   -353,

/* 374 */
5, 1,
-26764,  21958, -26805,  21923, -26887,  21807, -26837,  21817, -26777,  21904,

/* 375 */
5, 1,
-12845, -19516, -12878, -19600, -12872, -19705, -12836, -19659, -12826, -19563,

/* 376 */
5, 2,
  8205,  29338,   8417,  29312,   8737,  29372,   8625,  29415,   8348,  29368,

/* 377 */
5, 1,
-20673,  10764, -20666,  10703, -20615,  10600, -20612,  10653, -20649,  10737,

/* 378 */
5, 1,
-23749,  19513, -23722,  19458, -23650,  19373, -23632,  19417, -23694,  19490,

/* 379 */
5, 1,
 21927,  -2102,  21921,  -2159,  21925,  -2298,  21937,  -2260,  21937,  -2155,

/* 380 */
5, 1,
 25325,  -6099,  25350,  -6078,  25407,  -6010,  25374,  -5986,  25332,  -6043,

/* 381 */
5, 2,
-16592, -26410, -16653, -26473, -16631, -26581, -16569, -26581, -16534, -26480,

/* 382 */
5, 2,
-18346, -26459, -18242, -26489, -18061, -26484, -18100, -26428, -18279, -26421,

/* 383 */
5, -1,
  5894,    583,   5914,    597,   5984,    654,   5950,    647,   5901,    609,

/* 384 */
5, 1,
-14640,  10138, -14631,  10085, -14604,   9951, -14609,   9988, -14628,  10087,

/* 385 */
5, 1,
 22059,  11569,  22084,  11522,  22152,  11468,  22141,  11506,  22091,  11565,

/* 386 */
5, -1,
-13930,  17358, -13966,  17300, -13937,  17180, -13916,  17221, -13936,  17306,

/* 387 */
5, 1,
 27292,   -903,  27316,   -940,  27365,   -969,  27369,   -898,  27316,   -882,

/* 388 */
5, 1,
-28751,   7900, -28781,   7868, -28787,   7792, -28727,   7771, -28734,   7852,

/* 389 */
5, 1,
-14154,   8822, -14172,   8760, -14139,   8663, -14113,   8699, -14135,   8790,

/* 390 */
5, -1,
-21427,  18472, -21460,  18424, -21453,  18289, -21450,  18324, -21448,  18429,

/* 391 */
5, 1,
 27446,  -3569,  27474,  -3650,  27523,  -3675,  27502,  -3631,  27460,  -3571,

/* 392 */
5, 1,
 29116,  -4187,  29141,  -4229,  29198,  -4283,  29194,  -4250,  29146,  -4200,

/* 393 */
5, 1,
 22460,  -3012,  22450,  -3064,  22471,  -3116,  22524,  -3028,  22490,  -3019,

/* 394 */
5, 1,
-14105,  23026, -14140,  23075, -14252,  23100, -14251,  23029, -14154,  22987,

/* 395 */
4, 1,
 -1138,  20985,  -1194,  20925,  -1109,  20825,  -1117,  20899,

/* 396 */
5, 1,
-17664,  10132, -17687,  10080, -17717,   9965, -17708,   9992, -17680,  10084,

/* 397 */
4, 1,
 22595,   5098,  22589,   4968,  22633,   4974,  22627,   5071,

/* 398 */
4, 1,
 -2863,  10125,  -2811,  10128,  -2810,  10229,  -2863,  10219,

/* 399 */
5, -1,
-15946,  12668, -15900,  12658, -15843,  12612, -15841,  12625, -15898,  12670,

/* 400 */
5, 1,
  7873,  -4159,   7870,  -4234,   7889,  -4318,   7908,  -4292,   7894,  -4178,

/* 401 */
5, 1,
-31674,  18969, -31624,  18947, -31525,  18950, -31548,  18967, -31628,  18973,

/* 402 */
5, 1,
-13781,  12809, -13748,  12843, -13738,  12947, -13737,  12970, -13754,  12844,

/* 403 */
5, 1,
-23164,  19081, -23209,  19045, -23268,  18962, -23236,  18956, -23173,  19034,

/* 404 */
5, 1,
-24236,  20103, -24234,  20042, -24181,  19935, -24172,  19966, -24210,  20056,

/* 405 */
4, 2,
 16618,  29079,  16850,  29020,  16980,  29103,  16664,  29139,

/* 406 */
5, 1,
 27882,  -4134,  27905,  -4185,  27958,  -4225,  27957,  -4187,  27907,  -4144,

/* 407 */
4, 1,
-15992,  17258, -16033,  17277, -16099,  17171, -16042,  17194,

/* 408 */
5, 1,
  7230,  -1982,   7245,  -1944,   7253,  -1840,   7232,  -1817,   7225,  -1921,

/* 409 */
4, 2,
 -3804,  27092,  -3964,  27059,  -3892,  26982,  -3716,  27013,

/* 410 */
5, 1,
 25208,  13944,  25182,  13906,  25165,  13805,  25197,  13789,  25206,  13874,

/* 411 */
5, -1,
-16255,   5594, -16226,   5614, -16184,   5701, -16197,   5700, -16252,   5643,

/* 412 */
5, -1,
  5553,  18642,   5532,  18587,   5539,  18467,   5559,  18488,   5563,  18595,

/* 413 */
5, 1,
 18773,    329,  18747,    382,  18698,    407,  18703,    368,  18752,    320,

/* 414 */
5, 1,
-15751,  11065, -15785,  11066, -15856,  11047, -15844,  11047, -15784,  11062,

/* 415 */
5, 1,
-16104,  17535, -16143,  17512, -16218,  17451, -16194,  17436, -16129,  17493,

/* 416 */
4, 2,
  -475, -25849,   -415, -25775,   -581, -25728,   -566, -25828,

/* 417 */
4, 2,
  4041,  28526,   3914,  28603,   3733,  28537,   3854,  28472,

/* 418 */
4, 1,
-29019,   8089, -29069,   8042, -29036,   7973, -28998,   8022,

/* 419 */
4, 1,
 18512,    747,  18467,    739,  18469,    647,  18511,    661,

/* 420 */
5, 1,
-31257,  -5116, -31222,  -5111, -31228,  -5063, -31291,  -5038, -31282,  -5095,

/* 421 */
4, 1,
 24222,  -1963,  24192,  -2114,  24210,  -2071,  24234,  -1979,

/* 422 */
4, 2,
-16588,  28223, -16498,  28124, -16337,  28150, -16429,  28243,

/* 423 */
4, 2,
-13715, -25538, -13597, -25501, -13689, -25424, -13786, -25482,

/* 424 */
4, 1,
 30449,  -7584,  30418,  -7561,  30417,  -7652,  30466,  -7678,

/* 425 */
5, 1,
 10721,   7532,  10706,   7486,  10677,   7400,  10694,   7388,  10721,   7477,

/* 426 */
4, 1,
-14322,  25221, -14416,  25107, -14334,  25107, -14263,  25209,

/* 427 */
4, -1,
-28523,  21104, -28428,  21019, -28395,  21045, -28448,  21115,

/* 428 */
4, 1,
  2013,  19970,   2048,  19905,   2134,  19914,   2091,  19973,

/* 429 */
5, 1,
-11177,  17341, -11214,  17319, -11271,  17232, -11248,  17247, -11201,  17317,

/* 430 */
4, 1,
-20470,  10611, -20476,  10531, -20436,  10496, -20436,  10616,

/* 431 */
5, 1,
  2981,  15722,   3017,  15704,   3093,  15696,   3088,  15706,   3017,  15724,

/* 432 */
4, 1,
 22215,   2451,  22183,   2412,  22211,   2339,  22245,   2408,

/* 433 */
5, 1,
 22381,   4777,  22392,   4727,  22435,   4657,  22438,   4668,  22403,   4747,

/* 434 */
4, 1,
 14060,  26315,  14216,  26357,  14173,  26424,  14040,  26370,

/* 435 */
4, 1,
-13565, -17702, -13592, -17584, -13624, -17633, -13617, -17705,

/* 436 */
4, 1,
-13768,   8945, -13731,   8813, -13718,   8832, -13754,   8924,

/* 437 */
4, 2,
-18753,  27772, -18941,  27743, -18912,  27682, -18701,  27716,

/* 438 */
4, 2,
-19008,  27448, -19069,  27368, -18931,  27325, -18898,  27417,

/* 439 */
4, 2,
 10038,  29463,  10360,  29402,  10358,  29450,  10046,  29503,

/* 440 */
5, -1,
 -8480,  -7503,  -8497,  -7463,  -8541,  -7402,  -8543,  -7426,  -8513,  -7471,

/* 441 */
4, 2,
-11075, -22802, -10955, -22813, -10953, -22762, -11081, -22766,

/* 442 */
4, 2,
-17848,  26969, -18026,  26921, -17990,  26876, -17813,  26924,

/* 443 */
4, 1,
-13458,   8236, -13493,   8118, -13470,   8135, -13443,   8230,

/* 444 */
4, 1,
-11135,   5362, -11096,   5277, -11082,   5337, -11111,   5395,

/* 445 */
4, 1,
  -254,  22004,   -260,  21914,   -221,  21875,   -205,  21990,

/* 446 */
4, 1,
 -4685,  13755,  -4618,  13731,  -4601,  13771,  -4675,  13783,

/* 447 */
4, 2,
-19005,  27897, -19012,  27825, -18831,  27795, -18881,  27873,

/* 448 */
4, 1,
-27216,  -6460, -27169,  -6477, -27174,  -6425, -27220,  -6395,

/* 449 */
3, 1,
-15334,  24042, -15233,  23923, -15241,  23979,

/* 450 */
4, 2,
 18293, -23906,  18362, -23901,  18396, -23824,  18272, -23856,

/* 451 */
3, 2,
 11476,  29389,  11793,  29477,  11510,  29463,

/* 452 */
4, 1,
-24097,  20510, -24137,  20456, -24076,  20385, -24084,  20460,

/* 453 */
4, 1,
  2399,  19762,   2464,  19765,   2447,  19860,   2407,  19827,

/* 454 */
4, 2,
 10537,  29163,  10654,  29221,  10524,  29287,  10430,  29204,

/* 455 */
4, 1,
-13695, -18358, -13640, -18285, -13683, -18247, -13713, -18315,

/* 456 */
4, -1,
  1139,  16854,   1224,  16894,   1200,  16925,   1137,  16876,

/* 457 */
4, 1,
 23583,  10353,  23529,  10304,  23541,  10264,  23591,  10332,

/* 458 */
4, 1,
-13069, -19625, -13126, -19641, -13099, -19732, -13067, -19684,

/* 459 */
4, 1,
 -1045,  20558,  -1116,  20597,  -1127,  20523,  -1059,  20511,

/* 460 */
4, 1,
-32116, -16033, -32103, -15949, -32110, -15919, -32154, -15959,

/* 461 */
3, 1,
-11717,   4007, -11645,   4000, -11683,   4021,

/* 462 */
3, 1,
-15783,  24827, -15788,  24701, -15725,  24760,

/* 463 */
4, 2,
  2937, -25536,   2959, -25480,   2843, -25450,   2854, -25531,

/* 464 */
3, 1,
 23076,   1644,  23071,   1519,  23094,   1576,

/* 465 */
3, 1,
 18619,    478,  18618,    373,  18647,    386,

/* 466 */
3, 2,
-11295, -25369, -11294, -25234, -11315, -25308,

/* 467 */
4, 1,
-14663,  25377, -14610,  25328, -14500,  25361, -14569,  25396,

/* 468 */
3, 1,
 18654,    533,  18597,    562,  18638,    495,

/* 469 */
4, 1,
  5334,  22615,   5290,  22593,   5283,  22510,   5349,  22556,

/* 470 */
3, 1,
 26201, -14599,  26213, -14477,  26184, -14549,

/* 471 */
3, -1,
  6311,   4141,   6264,   4234,   6282,   4175,

/* 472 */
3, 1,
 27760,  -3278,  27815,  -3328,  27794,  -3268,

/* 473 */
3, 1,
 31424,  19254,  31519,  19235,  31468,  19290,

/* 474 */
3, 1,
  4031,  25651,   4179,  25722,   4067,  25710,

/* 475 */
3, 1,
 22016,   2174,  22075,   2156,  22060,   2197,

/* 476 */
3, 1,
 17059,   2610,  17071,   2502,  17090,   2565,

/* 477 */
3, 1,
 22227,   4608,  22204,   4487,  22226,   4560,

/* 478 */
3, -1,
-15738,   4505, -15695,   4445, -15687,   4496,

/* 479 */
3, 1,
 -2450,  10629,  -2500,  10553,  -2460,  10559,

/* 480 */
3, 1,
-28619,   7700, -28553,   7683, -28577,   7713,

/* 481 */
3, 1,
 19041,    410,  18994,    407,  19022,    341,

/* 482 */
3, 1,
 22867,   3802,  22859,   3677,  22871,   3739,

/* 483 */
4, 2,
 24731,  27464,  24733,  27565,  24680,  27565,  24662,  27475,

/* 484 */
4, 1,
-13628, -18587, -13587, -18581, -13559, -18513, -13612, -18537,

/* 485 */
3, 1,
 30647,  -6395,  30624,  -6457,  30672,  -6464,

/* 486 */
3, 2,
-11382, -23467, -11321, -23360, -11377, -23400,

/* 487 */
3, 1,
-11780,  22431, -11869,  22435, -11810,  22362,

/* 488 */
3, 1,
 30617,  -5804,  30611,  -5684,  30601,  -5733,

/* 489 */
4, 1,
  3739,  13998,   3720,  13945,   3746,  13887,   3756,  13949,

/* 490 */
3, 1,
  2606,  16441,   2620,  16320,   2623,  16388,

/* 491 */
4, 1,
-12819, -19985, -12890, -20011, -12856, -20063, -12822, -20035,

/* 492 */
3, -1,
  7115,  21786,   7200,  21697,   7167,  21745,

/* 493 */
3, 1,
-15486,  24023, -15447,  23911, -15430,  23977,

/* 494 */
3, 1,
  2682,  16269,   2738,  16177,   2710,  16234,

/* 495 */
3, -1,
  1753,  17299,   1684,  17370,   1695,  17327,

/* 496 */
3, 1,
-16453,   -188, -16463,   -260, -16420,   -229,

/* 497 */
3, 1,
 -2350,   2756,  -2295,   2732,  -2319,   2776,

/* 498 */
3, 1,
 26063,  -3068,  26114,  -3134,  26090,  -3091,

/* 499 */
3, 1,
 26896,  -2020,  26930,  -2099,  26931,  -2027,

/* 500 */
3, 1,
  4728,  14038,   4726,  13936,   4758,  13978,

/* 501 */
3, 1,
-13340,   6888, -13284,   6842, -13313,   6894,

/* 502 */
3, 2,
-18169,  29171, -18089,  29067, -18029,  29143,

/* 503 */
3, 1,
 30795,  -6822,  30759,  -6827,  30800,  -6894,

/* 504 */
3, 1,
 27681,  17130,  27652,  17069,  27711,  17157,

/* 505 */
3, 1,
  3591,  14482,   3622,  14379,   3621,  14446,

/* 506 */
3, 1,
-11218,   5830, -11215,   5925, -11244,   5894,

/* 507 */
3, 1,
-15838,  16485, -15881,  16386, -15846,  16435,

/* 508 */
3, 1,
 22917,   -720,  22927,   -836,  22929,   -769,

/* 509 */
3, 1,
 -8996,     26,  -9042,    -10,  -8997,    -24,

/* 510 */
3, 2,
 25623,  26921,  25608,  27013,  25523,  26934,

/* 511 */
3, 2,
-21123, -26904, -21277, -26962, -21168, -26974,

/* 512 */
3, 1,
 22174,   4898,  22205,   4833,  22208,   4912,

/* 513 */
3, 1,
 -9224,     -4,  -9267,    -61,  -9227,    -51,

/* 514 */
3, 2,
 -3359,  27426,  -3286,  27322,  -3276,  27393,

/* 515 */
3, 1,
 -7325,  23466,  -7383,  23568,  -7379,  23518,

/* 516 */
3, 1,
 21874,   1944,  21832,   1881,  21870,   1892,

/* 517 */
3, 1,
-13933,  23100, -14032,  23151, -13990,  23086,

/* 518 */
3, 1,
 23853,  11224,  23832,  11117,  23853,  11169,

/* 519 */
3, 1,
 22186,  -1857,  22190,  -1953,  22210,  -1896,

/* 520 */
3, 1,
-12587,   4506, -12547,   4423, -12566,   4471,

/* 521 */
3, 1,
-13019, -19689, -12967, -19754, -12947, -19704,

/* 522 */
3, 1,
  9659,  25834,   9614,  25944,   9615,  25881,

/* 523 */
3, 1,
-32149,  18916, -32180,  18829, -32127,  18862,

/* 524 */
3, 1,
 21819,   4479,  21862,   4403,  21845,   4453,

/* 525 */
3, 1,
-28606,    630, -28651,    693, -28633,    638,

/* 526 */
3, 1,
  1210,    147,   1190,     62,   1224,     97,

/* 527 */
3, 1,
  2725,  24967,   2774,  25059,   2692,  25021,

/* 528 */
3, 1,
-13503, -18505, -13544, -18412, -13538, -18483,

/* 529 */
3, 1,
  1061,  19134,    986,  19084,   1044,  19086,

/* 530 */
3, 1,
 24569,  12583,  24531,  12494,  24558,  12522,

/* 531 */
3, 1,
-12383,  22049, -12424,  21968, -12356,  21990,

/* 532 */
3, 1,
-22314,  17566, -22302,  17504, -22317,  17616,

/* 533 */
3, 1,
-13645, -18962, -13622, -18854, -13645, -18899,

/* 534 */
3, -1,
-17704,  20103, -17783,  20046, -17736,  20050,

/* 535 */
3, 1,
-14557,   -979, -14598,  -1050, -14570,  -1034,

/* 536 */
3, 1,
 -3230,  10437,  -3261,  10464,  -3246,  10372,

/* 537 */
3, 1,
  7324,   5687,   7296,   5755,   7278,   5729,

/* 538 */
3, 1,
 24846,  -4166,  24878,  -4074,  24860,  -4114,

/* 539 */
3, 1,
 29366,  -3403,  29386,  -3505,  29384,  -3444,

/* 540 */
3, 1,
 28486,  -2781,  28514,  -2855,  28517,  -2785,

/* 541 */
3, 1,
  7621,   6108,   7647,   6080,   7599,   6143,

/* 542 */
3, 1,
-11188,   5687, -11170,   5594, -11163,   5661,

/* 543 */
3, 1,
-32226,  18896, -32295,  18840, -32251,  18836,

/* 544 */
3, 1,
-13420, -16442, -13482, -16401, -13465, -16457,

/* 545 */
3, 2,
 -9347,  29843,  -9565,  29924,  -9570,  29868,

/* 546 */
3, 1,
 16829,   3946,  16813,   3866,  16842,   3872,

/* 547 */
3, 1,
 30594,  -5881,  30581,  -5937,  30624,  -5932,

/* 548 */
3, 1,
 14307,  26515,  14396,  26480,  14420,  26557,

/* 549 */
3, 2,
 18823, -23827,  18760, -23737,  18760, -23792,

/* 550 */
3, 1,
 26367,   4968,  26339,   4879,  26367,   4918,

/* 551 */
3, 1,
  9186,   9548,   9195,   9449,   9207,   9517,

/* 552 */
3, 1,
 -9168,    222,  -9176,    115,  -9163,    168,

/* 553 */
3, 1,
 17226,   5911,  17193,   5827,  17221,   5856,

/* 554 */
3, -1,
-21496,  18063, -21489,  18010, -21495,  18120,

/* 555 */
3, 1,
 22572,  -3084,  22615,  -3027,  22588,  -3028,

/* 556 */
3, 2,
-20891,  28387, -20805,  28308, -20749,  28371,

/* 557 */
3, 1,
 17890,   2975,  17893,   2875,  17908,   2927,

/* 558 */
3, -1,
-18045,   9667, -18068,   9767, -18062,   9706,

/* 559 */
3, 1,
 -4585,   6173,  -4570,   6239,  -4612,   6208,

/* 560 */
3, 1,
 32413,  -6956,  32460,  -6926,  32454,  -6900,

/* 561 */
3, 1,
 30582,  -7801,  30553,  -7832,  30590,  -7874,

/* 562 */
3, 1,
-12595, -19999, -12686, -19998, -12632, -20016,

/* 563 */
3, 1,
 22182,   5471,  22190,   5378,  22205,   5436,

/* 564 */
3, 1,
 -4291,   5476,  -4324,   5532,  -4319,   5460,

/* 565 */
3, -1,
-17447,  20486, -17531,  20446, -17485,  20440,

/* 566 */
3, 1,
-13701,  25007, -13663,  24912, -13644,  24973,

/* 567 */
3, 1,
-17546,  10335, -17595,  10271, -17565,  10296,

/* 568 */
3, 1,
-16284,   -285, -16286,   -330, -16250,   -263,

/* 569 */
3, 1,
  -794,  19806,   -842,  19725,   -796,  19751,

/* 570 */
3, 1,
 18915,   3782,  18924,   3695,  18940,   3752,

/* 571 */
3, 1,
  2812,  25075,   2888,  25162,   2830,  25135,

/* 572 */
3, 1,
 -8221, -22106,  -8311, -22049,  -8277, -22083,

/* 573 */
3, 1,
-14057,  25272, -14047,  25189, -13982,  25236,

/* 574 */
3, 1,
  2588,  24809,   2691,  24874,   2620,  24861,

/* 575 */
3, 2,
-27139, -28065, -27294, -28003, -27274, -28059,

/* 576 */
3, 1,
-14608,   9225, -14643,   9140, -14623,   9173,

/* 577 */
3, 1,
  -818,  19440,   -815,  19371,   -764,  19401,

/* 578 */
3, 1,
 30605,  -5589,  30603,  -5485,  30598,  -5519,

/* 579 */
3, 1,
 23814,   -281,  23766,   -309,  23806,   -309,

/* 580 */
3, 1,
-32413,  18893, -32400,  18823, -32358,  18851,

/* 581 */
3, 1,
 -6903,  23889,  -6826,  23905,  -6862,  23962,

/* 582 */
3, 1,
  3311,  25310,   3411,  25377,   3334,  25361,

/* 583 */
3, 1,
-31485,  22042, -31404,  21976, -31443,  22011,

/* 584 */
3, 1,
  3491,  25406,   3541,  25474,   3449,  25468,

/* 585 */
3, 1,
-13636, -17615, -13651, -17530, -13675, -17580,

/* 586 */
3, 1,
  6030,   -768,   5999,   -711,   5989,   -747,

/* 587 */
3, 1,
 25265,  -2972,  25233,  -3007,  25264,  -3038,

/* 588 */
3, 1,
-13713,  13792, -13682,  13884, -13693,  13853,

/* 589 */
3, 1,
-24090,  20558, -24054,  20470, -24050,  20523,

/* 590 */
3, 2,
-23803, -27100, -23946, -27064, -23914, -27121,

/* 591 */
3, 1,
 27328,  -3368,  27342,  -3443,  27360,  -3399,

/* 592 */
3, 1,
 23563,  12626,  23538,  12535,  23562,  12581,

/* 593 */
3, 1,
-14479,  20572, -14538,  20499, -14498,  20517,

/* 594 */
3, 1,
  1988,  20074,   1952,  19982,   1976,  20021,

/* 595 */
3, 1,
-13530, -17464, -13467, -17449, -13519, -17423,

/* 596 */
3, 1,
  2139,  20000,   2156,  19918,   2185,  19961,

/* 597 */
3, 2,
-16433,  27960, -16410,  27873, -16342,  27921,

/* 598 */
3, 1,
-22686,  18120, -22630,  18053, -22646,  18095,

/* 599 */
3, 1,
 16577,   8066,  16586,   8157,  16570,   8140,

/* 600 */
3, 1,
-24188,  20675, -24189,  20602, -24146,  20608,

/* 601 */
3, 1,
 28577,  -2868,  28580,  -2941,  28606,  -2903,

/* 602 */
3, 1,
 28139,  -1828,  28139,  -1920,  28154,  -1870,

/* 603 */
3, 1,
-11197,   5941, -11160,   5910, -11177,   5974,

/* 604 */
3, 1,
-11091,   4993, -11087,   5079, -11108,   5035,

/* 605 */
3, 1,
 27531,  -8647,  27511,  -8565,  27503,  -8611,

/* 606 */
3, 1,
-23367,  19217, -23369,  19120, -23355,  19165,

/* 607 */
3, 1,
 30247, -18398,  30217, -18482,  30249, -18455,

/* 608 */
3, 1,
 30832,  -7087,  30804,  -7079,  30832,  -7147,

/* 609 */
3, 2,
-27037, -28102, -26891, -28143, -26936, -28074,

/* 610 */
3, 1,
  8046,  -4427,   8086,  -4464,   8076,  -4419,

/* 611 */
3, 2,
-12030, -23979, -11971, -23899, -12023, -23925,

/* 612 */
3, 2,
-18579,  27650, -18744,  27610, -18651,  27602,

/* 613 */
3, 1,
  4954,  13040,   4940,  12945,   4949,  12983,

/* 614 */
3, -1,
-21501,  17668, -21509,  17622, -21493,  17717,

/* 615 */
3, 1,
 23307,  -1349,  23347,  -1325,  23327,  -1297,

/* 616 */
3, 2,
-23128, -27121, -23222, -27056, -23224, -27118,

/* 617 */
3, 1,
  4174,  21946,   4109,  21884,   4157,  21895,

/* 618 */
3, 1,
-13895,  12674, -13911,  12643, -13871,  12715,

/* 619 */
3, 1,
 -9306,    -53,  -9337,   -120,  -9314,   -103,

/* 620 */
3, 1,
 30175,  -3936,  30218,  -3920,  30195,  -3896,

/* 621 */
3, -1,
  2826,  -1506,   2795,  -1520,   2811,  -1571,

/* 622 */
3, 1,
-13413, -19011, -13458, -18932, -13443, -18971,

/* 623 */
3, 1,
  9070,  -6224,   9092,  -6138,   9079,  -6171,

/* 624 */
3, 1,
  4630,  14569,   4581,  14534,   4604,  14512,

/* 625 */
3, 1,
 23588,  -2843,  23597,  -2903,  23621,  -2867,

/* 626 */
3, 1,
-23526,  19225, -23495,  19142, -23491,  19187,

/* 627 */
3, 1,
  2685,  20115,   2714,  20041,   2731,  20091,

/* 628 */
3, 1,
-13653, -18737, -13593, -18683, -13631, -18690,

/* 629 */
3, 1,
 17046,   7102,  17076,   7041,  17076,   7094,

/* 630 */
3, 1,
-13520, -16308, -13474, -16277, -13520, -16258,

/* 631 */
3, 1,
  4216,  25581,   4274,  25653,   4208,  25641,

/* 632 */
3, 1,
-13692, -18151, -13721, -18079, -13735, -18119,

/* 633 */
3, 1,
   281,  14243,    243,  14187,    281,  14194,

/* 634 */
3, 1,
  8762,  10913,   8767,  10834,   8787,  10871,

/* 635 */
3, 1,
-15767,   5927, -15722,   5963, -15744,   5960,

/* 636 */
3, 1,
 -7507,  23026,  -7562,  23086,  -7586,  23064,

/* 637 */
3, 1,
 -1147,  20339,  -1158,  20274,  -1108,  20297,

/* 638 */
3, 1,
 -7974,  21826,  -7907,  21843,  -7975,  21872,

/* 639 */
3, 1,
 -1309,  22676,  -1265,  22596,  -1266,  22636,

/* 640 */
3, -1,
-17254,  20526, -17333,  20541, -17303,  20512,

/* 641 */
3, 1,
 -9169,    795,  -9184,    727,  -9157,    741,

/* 642 */
3, -1,
-22847,  24317, -22768,  24285, -22789,  24347,

/* 643 */
3, 1,
 32747,  -6189, -32743,  -6125,  32751,  -6142,

/* 644 */
3, 1,
-29098,  20124, -29137,  20047, -29105,  20070,

/* 645 */
3, 2,
-14364,  27708, -14457,  27639, -14384,  27641,

/* 646 */
3, 2,
 13126, -25693,  13105, -25620,  13057, -25630,

/* 647 */
3, 1,
-18288,  25123, -18302,  25051, -18243,  25061,

/* 648 */
3, 1,
 -9114,    236,  -9141,    180,  -9113,    184,

/* 649 */
3, -1,
 17766,  12728,  17786,  12671,  17799,  12731,

/* 650 */
3, 1,
 -9302,  25450,  -9317,  25377,  -9252,  25408,

/* 651 */
3, 1,
-13314,   8148, -13268,   8132, -13287,   8160,

/* 652 */
3, 1,
 17899,   4492,  17911,   4572,  17894,   4551,

/* 653 */
3, 1,
 -4425,   6030,  -4402,   6050,  -4445,   6063,

/* 654 */
3, 1,
-13661, -16781, -13616, -16728, -13647, -16726,

/* 655 */
3, 1,
 24503,   2812,  24489,   2730,  24505,   2754,

/* 656 */
3, 1,
  2702,  16071,   2745,  16006,   2731,  16039,

/* 657 */
3, 1,
-16669,   -154, -16648,   -120, -16683,   -104,

/* 658 */
3, 1,
  3614,  21984,   3608,  21916,   3653,  21930,

/* 659 */
3, 1,
   768,  14573,    728,  14576,    763,  14527,

/* 660 */
3, 1,
  1662,  23140,   1570,  23136,   1611,  23111,

/* 661 */
3, 1,
  4926,  13750,   4874,  13745,   4899,  13719,

/* 662 */
3, 2,
-10072, -22294, -10001, -22266, -10058, -22246,

/* 663 */
3, 1,
-13708, -18489, -13699, -18407, -13726, -18445,

/* 664 */
3, 1,
-24713,  20865, -24712,  20790, -24678,  20817,

/* 665 */
3, 1,
  3035,  15636,   3094,  15623,   3079,  15641,

/* 666 */
3, 1,
 18926,    504,  18886,    506,  18904,    475,

/* 667 */
3, 1,
-16523,   -106, -16495,    -90, -16524,    -54,

/* 668 */
3, 1,
-15787,   7491, -15823,   7438, -15803,   7441,

/* 669 */
3, 1,
  4978,  13422,   4925,  13395,   4948,  13395,

/* 670 */
3, 1,
 22870,   1248,  22847,   1318,  22849,   1270,

/* 671 */
3, 1,
  2012,  12304,   1973,  12321,   1983,  12272,

/* 672 */
3, 1,
 24132,  -4122,  24130,  -4040,  24118,  -4067,

/* 673 */
3, 1,
-13692, -17854, -13730, -17793, -13733, -17834,

/* 674 */
3, -1,
-15488,  11652, -15492,  11566, -15485,  11583,

/* 675 */
3, 1,
 23848,  -2943,  23820,  -2998,  23850,  -2981,

/* 676 */
3, 1,
-14226,  25390, -14295,  25331, -14223,  25337,

/* 677 */
3, 1,
  -489,  21460,   -562,  21485,   -545,  21452,

/* 678 */
3, 1,
 21820,   4351,  21830,   4284,  21845,   4311,

/* 679 */
3, 1,
-13703, -18792, -13673, -18717, -13696, -18737,

/* 680 */
3, 1,
  3758,  13787,   3790,  13728,   3792,  13768,

/* 681 */
3, 1,
-14323,  20543, -14351,  20474, -14322,  20476,

/* 682 */
3, 1,
-14890,   2757, -14875,   2685, -14868,   2726,

/* 683 */
3, 1,
 27499,  -3067,  27496,  -3151,  27504,  -3120,

/* 684 */
3, 1,
-13547, -16661, -13521, -16598, -13553, -16605,

/* 685 */
3, 1,
 13329, -19288,  13385, -19335,  13368, -19298,

/* 686 */
3, 1,
  2990,  15777,   3041,  15754,   3033,  15786,

/* 687 */
3, 2,
-16442, -26598, -16332, -26572, -16394, -26546,

/* 688 */
3, 1,
-29248,  21406, -29306,  21360, -29273,  21351,

/* 689 */
3, 1,
 23256,  -2956,  23293,  -2988,  23284,  -2958,

/* 690 */
3, 1,
-12847,  22849, -12911,  22875, -12866,  22817,

/* 691 */
3, 1,
 27923, -10093,  27934, -10015,  27920, -10037,

/* 692 */
3, 1,
  4500,  13821,   4522,  13757,   4535,  13785,

/* 693 */
3, 1,
-23302,  18948, -23326,  18880, -23294,  18893,

/* 694 */
3, 1,
-13471, -19056, -13506, -18986, -13506, -19017,

/* 695 */
3, 1,
 22152,  -3850,  22188,  -3842,  22177,  -3811,

/* 696 */
3, 1,
-11701, -19920, -11747, -19940, -11678, -19942,

/* 697 */
3, 1,
-23095,  18142, -23087,  18088, -23053,  18113,

/* 698 */
3, 1,
-24259,  20436, -24317,  20401, -24286,  20386,

/* 699 */
3, 1,
  2649,  16462,   2651,  16397,   2676,  16408,

/* 700 */
3, -1,
 18992,  19014,  19031,  18945,  19024,  18975,

/* 701 */
3, 1,
  7230,  -2903,   7252,  -2841,   7228,  -2863,

/* 702 */
3, 1,
-23447,  19551, -23497,  19495, -23470,  19504,

/* 703 */
3, 2,
 17473,  28071,  17459,  28037,  17568,  28099,

/* 704 */
3, 1,
-11016,   4129, -11051,   4092, -11031,   4090,

/* 705 */
3, 1,
-13695, -17486, -13638, -17460, -13660, -17457,

/* 706 */
3, 1,
 -9252,   -206,  -9282,   -248,  -9260,   -255,

/* 707 */
3, 1,
-23729,  19687, -23772,  19647, -23741,  19628,

/* 708 */
3, 1,
 21740,  -3068,  21732,  -3138,  21750,  -3119,

/* 709 */
3, 1,
-20387,   8928, -20351,   8888, -20357,   8920,

/* 710 */
3, 1,
-26596,  21990, -26670,  21982, -26636,  21961,

/* 711 */
3, 1,
 30524,  -5635,  30558,  -5607,  30535,  -5594,

/* 712 */
3, 1,
-15416,  10830, -15457,  10793, -15442,  10799,

/* 713 */
3, 2,
-18252,  27930, -18409,  27906, -18342,  27897,

/* 714 */
3, 1,
  -964,  20279,   -966,  20213,   -934,  20234,

/* 715 */
3, -1,
-16849,  16235, -16801,  16195, -16810,  16213,

/* 716 */
3, 1,
-29251,  20167, -29270,  20117, -29231,  20111,

/* 717 */
3, 1,
-13837,   8617, -13804,   8563, -13813,   8592,

/* 718 */
3, 1,
-14186,   8044, -14153,   8003, -14158,   8036,

/* 719 */
3, 1,
-13405, -16655, -13400, -16589, -13424, -16605,

/* 720 */
3, 1,
 27924,  -9956,  27924,  -9880,  27914,  -9902,

/* 721 */
3, 1,
-13757, -17725, -13720, -17675, -13750, -17676,

/* 722 */
3, 1,
  -195,  18451,   -245,  18463,   -234,  18427,

/* 723 */
3, 1,
  4797,  13717,   4753,  13688,   4773,  13681,

/* 724 */
3, 1,
-11187,  20721, -11205,  20650, -11182,  20669,

/* 725 */
3, 1,
-13627, -18979, -13598, -18911, -13619, -18929,

/* 726 */
3, 1,
 27221,   -494,  27235,   -556,  27244,   -523,

/* 727 */
3, 1,
-10825,   4760, -10835,   4818, -10850,   4786,

/* 728 */
3, 1,
 23156,    -95,  23137,   -136,  23159,   -150,

/* 729 */
3, 1,
-10258,  17146, -10258,  17074, -10244,  17084,

/* 730 */
3, 1,
 28638,  -3062,  28628,  -3132,  28641,  -3116,

/* 731 */
3, 1,
-23299,  18825, -23308,  18760, -23282,  18773,

/* 732 */
3, 1,
  8206,  -4665,   8221,  -4680,   8208,  -4614,

/* 733 */
3, 1,
-12448,   4478, -12433,   4422, -12422,   4440,

/* 734 */
3, 1,
  3766,  14140,   3747,  14090,   3764,  14075,

/* 735 */
3, 1,
 26085,  -3049,  26113,  -3079,  26116,  -3051,

/* 736 */
3, 2,
 17472,  27763,  17417,  27734,  17554,  27737,

/* 737 */
3, 1,
 24785,  -4253,  24818,  -4214,  24806,  -4218,

/* 738 */
3, 2,
-12329, -24672, -12259, -24659, -12299, -24626,

/* 739 */
3, 1,
-21820,  12394, -21780,  12373, -21784,  12395,

/* 740 */
3, 1,
-20963,  10249, -20981,  10282, -20986,  10225,

/* 741 */
3, 1,
  1509,  19926,   1534,  19989,   1512,  19981,

/* 742 */
3, 1,
 24264,  -1496,  24293,  -1542,  24287,  -1522,

/* 743 */
3, 2,
-10459, -23490, -10385, -23466, -10421, -23453,

/* 744 */
3, 1,
-13531,   8309, -13501,   8266, -13503,   8291,

/* 745 */
3, -1,
-18417,  10728, -18382,  10741, -18414,  10758,

/* 746 */
3, 1,
-22512,  17871, -22476,  17815, -22483,  17829,

/* 747 */
3, 1,
-22803,  18357, -22795,  18299, -22773,  18309,

/* 748 */
3, 1,
  2456,  24768,   2514,  24803,   2479,  24824,

/* 749 */
3, -1,
  5884,  11065,   5907,  11012,   5912,  11029,

/* 750 */
3, 1,
 17870,   4167,  17886,   4230,  17874,   4215,

/* 751 */
3, -1,
-18821,  19527, -18873,  19501, -18850,  19492,

/* 752 */
3, 2,
 14886,  27439,  14941,  27423,  14952,  27481,

/* 753 */
3, -1,
 -8087,  -7835,  -8094,  -7787,  -8109,  -7781,

/* 754 */
3, 1,
-13744, -17935, -13720, -17882, -13747, -17887,

/* 755 */
3, 1,
 27764,  -3870,  27797,  -3889,  27792,  -3873,

/* 756 */
3, -1,
-20328,  16980, -20308,  16920, -20300,  16932,

/* 757 */
3, 1,
-13958,  12631, -14002,  12625, -13991,  12626,

/* 758 */
3, 1,
-17256,  10684, -17284,  10635, -17267,  10648,

/* 759 */
3, 1,
-11809,   6450, -11776,   6448, -11779,   6467,

/* 760 */
3, -1,
-20817,  12562, -20787,  12512, -20792,  12526,

/* 761 */
3, 1,
  5863,   -179,   5862,   -113,   5855,   -143,

/* 762 */
3, 1,
-26530,  22059, -26590,  22037, -26578,  22022,

/* 763 */
3, 1,
-13525, -16389, -13485, -16377, -13499, -16353,

/* 764 */
3, 1,
-22803,  18303, -22798,  18240, -22785,  18256,

/* 765 */
3, 1,
-16660,   6839, -16692,   6812, -16679,   6811,

/* 766 */
3, 1,
  9480,   4450,   9512,   4430,   9507,   4446,

/* 767 */
3, -1,
-15273,  12522, -15291,  12474, -15267,  12486,

/* 768 */
3, -1,
  4500, -10913,   4523, -10965,   4524, -10948,

/* 769 */
3, 1,
-14493,   8299, -14463,   8263, -14469,   8278,

/* 770 */
3, 1,
-17628,  10238, -17649,  10186, -17640,  10188,

/* 771 */
3, 1,
  2384,  24785,   2349,  24731,   2372,  24734,

/* 772 */
3, 1,
-14253,   8155, -14227,   8129, -14224,   8150,

/* 773 */
3, 1,
 17888,   3905,  17879,   3956,  17870,   3943,

/* 774 */
3, 1,
 17716,    748,  17700,    795,  17697,    774,

/* 775 */
3, -1,
  -790,  20888,   -824,  20841,   -818,  20843,

/* 776 */
3, 1,
-16015,   6516, -15998,   6563, -16004,   6563,

13, -1,
 21703, -10851,
 21805, -10851,
 21908, -10851,
 22010, -10851,
 22113, -10647,
 22113, -10442,
 22010, -10237,
 21908, -10442,
 21805, -10442,
 21805, -10237,
 21703, -10237,
 21601, -10442,
 21601, -10647,

8, 1,
 32452,  18632,
 32555,  18632,
 32555,  18837,
 32452,  18837,
 32350,  18837,
 32248,  18837,
 32248,  19041,
 32200,  18837,

3, 1,
-26515,  -6142,
-26412,  -6142,
-26452,  -6112,

3, 1,
-26207,  -5733,
-26207,  -5937,
-26157,  -5827,

3, 1,
-26003,  -5733,
-26105,  -5937,
-26105,  -6142,

8, -1,
 24877, -10647,
 24979, -10647,
 25081, -10442,
 25081, -10237,
 24979, -10032,
 24877, -10032,
 24877, -10237,
 24877, -10442,

7, -1,
  2764,  -6756,
  2866,  -6961,
  2968,  -6756,
  3071,  -6756,
  3071,  -6552,
  2968,  -6552,
  2866,  -6552,

6, 1,
 -1740,  26003,
 -1638,  26003,
 -1535,  26003,
 -1433,  26003,
 -1433,  26208,
 -1535,  26208,

6, -1,
 23648,  -9009,
 23751,  -9009,
 23853,  -9009,
 23853,  -8804,
 23751,  -8804,
 23648,  -8804,

6, -1,
 21805,  -9418,
 21908,  -9418,
 22010,  -9418,
 22010,  -9213,
 21908,  -9213,
 21805,  -9213,

5, 1,
 13104,   3890,
 13206,   3890,
 13206,   4095,
 13206,   4299,
 13104,   4095,

5, -1,
 25389, -11261,
 25491, -11261,
 25491, -11056,
 25491, -10851,
 25389, -11056,

5, -1,
 21294, -11056,
 21396, -10851,
 21396, -10647,
 21294, -10647,
 21294, -10851,

4, 1,
-31019,  20679,
-30917,  20679,
-31122,  20884,
-31019,  20884,

4, -1,
 24672,  18018,
 24774,  18018,
 24774,  18222,
 24672,  18222,

4, -1,
 24800,  18427,
 24877,  18427,
 24877,  18632,
 24800,  18632,

4, 1,
 -3173,  11875,
 -3071,  11875,
 -3071,  12285,
 -3173,  12080,

4, -1,
  9725,  10647,
  9725,  10851,
  9623,  10851,
  9520,  10851,

4, 1,
-20270,   6961,
-20167,   6961,
-20167,   7166,
-20270,   7166,

4, 1,
 -4197,   5937,
 -4299,   5937,
 -4402,   5733,
 -4402,   5528,

4, 1,
 26208,   4914,
 26310,   4914,
 26310,   5118,
 26208,   5118,

4, 1,
 30917,   3480,
 30917,   3685,
 30814,   3685,
 30712,   3685,

4, 1,
 31838,   -409,
 31736,   -204,
 31633,   -204,
 31736,   -409,

4, 1,
 26617,  -5118,
 26719,  -5118,
 26719,  -4914,
 26617,  -4914,

4, 1,
-28869,  -7985,
-28767,  -7985,
-28767,  -7780,
-28869,  -7780,

4, -1,
 22317,  -8599,
 22420,  -8599,
 22420,  -8394,
 22317,  -8394,

4, -1,
 21396, -10237,
 21396, -10032,
 21294,  -9828,
 21294, -10032,

4, -1,
 25389, -10647,
 25491, -10647,
 25389, -10442,
 25286, -10442,

4, 1,
  6756, -16994,
  6859, -16994,
  6859, -16789,
  6756, -16789,

4, 2,
 32452, -24365,
 32555, -24365,
 32555, -24160,
 32452, -24160,

3, 2,
 27129,  28050,
 27231,  28050,
 27180,  28100,

3, 2,
 28562,  28050,
 28665,  28050,
 28614,  28100,

3, 2,
 28869,  28050,
 28869,  27846,
 28922,  27898,

3, 1,
-31941,  26003,
-31838,  26003,
-31890,  26055,

3, 1,
 28153,  21908,
 28200,  21908,
 28180,  21950,

3, 1,
 27846,  21703,
 27948,  21703,
 27897,  21755,

3, 1,
 31941,  19041,
 32043,  19041,
 31992,  19090,

3, 1,
 -5425,  14127,
 -5221,  14127,
 -5323,  14187,

3, -1,
   716,  12899,
   819,  12899,
   770,  12960,

3, 1,
 -2968,  12080,
 -2930,  12140,
 -2968,  12285,

3, -1,
  -409,  12285,
  -307,  12285,
  -357,  12320,

3, 1,
-11875,  11875,
-11977,  11670,
-11875,  11670,

3, 1,
-32452,  10442,
-32350,  10442,
-32400,  10482,

3, 1,
-32043,  10442,
-31941,  10442,
-31981,  10482,

3, 1,
-31531,   9418,
-31531,   9623,
-31580,   9500,

3, 1,
-14946,   6961,
-14844,   6961,
-14900,   6991,

3, 1,
-10954,   4914,
-10851,   4914,
-10901,   4944,

3, 1,
-14946,   4504,
-14844,   4504,
-14844,   4709,

3, 1,
 13001,   4504,
 13001,   4709,
 12960,   4600,

3, 1,
-19963,   3685,
-19963,   3890,
-20001,   3791,

3, 1,
 19656,   1433,
 19656,   1638,
 19553,   1638,

3, 1,
-28767,    819,
-28665,    819,
-28705,    849,

3, -1,
  5301,    110,
  5323,      0,
  5323,    204,

3, -1,
  5221,   -614,
  5261,   -614,
  5240,   -583,

3, 1,
 32043,   -819, 
 32043,  -1023,
 32002,  -1020,

3, 1,
 32043,  -2252,
 32145,  -2252,
 32100,  -2212,

3, 1,
 13001,  -2661,
 13104,  -2661,
 13104,  -2457,

3, 1,
-25696,  -2866,
-25593,  -2866,
-25643,  -2826,

3, 1,
 -2661,  -3071,
 -2661,  -2866,
 -2691,  -2866,

3, 1,
-28869,  -3276,
-28767,  -3276,
-28807,  -3238,

3, 1,
-25389,  -3685,
-25286,  -3685,
-25389,  -3480,

3, 1,
-26924,  -5528,
-27027,  -5528,
-26984,  -5558,

3, 1,
 -1126,  -5733,
 -1023,  -5733,
 -1063,  -5701,

3, -1,
-12285,  -6961, -12285,  -6756, -12387,  -6756,

3, 1,
-28869,  -7166, -28869,  -6961, -28972,  -6961,

3, 1,
-23853,  -9213, -23853,  -9009, -23881,  -9109,

3, -1,
 22113, -11670,  22113, -11466,  22083, -11500,

3, 1,
 30200, -18222,  30200, -18427,  30230, -18300,

3, 1,
   716, -19656,    716, -19860,    741, -19711,

3, 2,
-16687, -24570, -16584, -24570, -16623, -24534,

/* the end */
0

};

char *
salloc(nbytes)
register int			nbytes;
{
	register char *		p;

	p = malloc((unsigned)nbytes);
	if (p == (char *)NULL) {
		fprintf(stderr, "%s: out of memory\n", ProgName);
		exit(1);
	}
	return (p);
}

void
plotdata(u, v, s)
int u, v, s;
{
  int c, w;

  c = u;
  if (c<0) c+=Earthmap.width;
  if (c>=Earthmap.width) c-=Earthmap.width;

  if (fill_mode==0) {
    grid(c,v) = 1;
    return;
  }

  grid(c,v) |= 32*abs(s);

  if (u>uu)
     for (w=0; w<=v; w++) grid(c,w) -= s;
  if (u<uu)
     for (w=0; w<=vv; w++) grid(uc,w) += s;
  if (u==uu && v>vv)
     for (w=vv+1; w<=v; w++) grid(c,w) -= s;
  if (u==uu && v<vv)
     for (w=v+1; w<=vv; w++) grid(c,w) += s;

  uu = u;
  uc = c;
  vv = v;
}

int check(i,j, which)
int i, j, which;
{
   if ((grid((i+Earthmap.width-1)%Earthmap.width,j)&3)!=which) return 1;
   if ((grid((i+1)%Earthmap.width,j)&3)!=which) return 1;
   if (j>1 && (grid(i,j-1)&3)!=which) return 1;
   if (j<Earthmap.height-1 && (grid(i,j+1)&3)!=which) return 1;
   if (full) {
     if (j>1 && (grid((i+Earthmap.width-1)%Earthmap.width,j-1)&3)!=which) return 1;
     if (j>1 && (grid((i+1)%Earthmap.width,j-1)&3)!=which) return 1;
     if (j<Earthmap.height-1 && (grid((i+Earthmap.width-1)%Earthmap.width,j+1)&3)!=which) return 1;
     if (j<Earthmap.height-1 && (grid((i+1)%Earthmap.width,j+1)&3)!=which) return 1;
   }
   return 0;
}

void
filter_data()
{
int i, j, t;

    if (fill_mode==0) return;
 
    if (fill_mode==1) {

      /* replace arctic color by land */
      for (j=0; j<Earthmap.height; j++)
        for (i=0; i<Earthmap.width; i++) {
	    if (grid(i,j)<=0) grid(i,j) = 1;
	    grid(i,j) &= 253;
	}

      for (j=0; j<Earthmap.height; j++)
        for (i=0; i<Earthmap.width; i++) {
	    t = grid(i,j)&3;
	    full=1;
	    if (check(i,j,0)) grid(i,j) &= 31;
	    if ((t==0) && !check(i,j,0)) grid(i,j) |= 128; 
	    full=0;
	    if ((t==1) && !check(i,j,1)) grid(i,j) |= 128;
        }

      for (j=0; j<Earthmap.height; j++)
        for (i=0; i<Earthmap.width; i++) {
	    t = grid(i,j);
	    if (t&96) grid(i,j) = 1;
	      else
	    if (t&128) grid(i,j) = 0;
	      else grid(i,j) = t&3;
        }
      return;
    }

    /* only remains fill_mode = 2 */
    full = 1;

    for (j=0; j<Earthmap.height; j++)
      for (i=0; i<Earthmap.width; i++)
	  if (check(i,j,2)) grid(i,j) &= 31;

    for (j=0; j<Earthmap.height; j++)
      for (i=0; i<Earthmap.width; i++) {
	  t = grid(i,j);
	  if (t&32) grid(i,j) = 1;
	    else
	  if (t&64) grid(i,j) = 0;
	    else {
	      t &= 3; 
              if (t==3) t=1;
              grid(i,j) = t;
	    }
      }
}

void
create_xpm()
{
  int i, j, k;
  char *line;

  sprintf(Earthmap.data[0], "%d %d %d 1", 
        Earthmap.width, Earthmap.height, 2+(fill_mode==2));
  Earthmap.data[1] = Earthmap.data[0] + 20;
  sprintf(Earthmap.data[1], "0 c %s", 
     (fill_mode==2)?ArcticColor.name:WaterColor.name);
  Earthmap.data[2] = Earthmap.data[1] + 60;
  sprintf(Earthmap.data[2], "1 c %s", LandColor.name);
  line = Earthmap.data[3] = Earthmap.data[2] + 60;
  if (fill_mode==2) {
     sprintf(Earthmap.data[3], "2 c %s", WaterColor.name);
     line = Earthmap.data[3] + 60;
     k = 4;
  } else
     k = 3;

  for (j=0; j<Earthmap.height; j++) {
    for (i=0; i<Earthmap.width; i++)
         line[i] = '0'+ grid(i,j);
    line[Earthmap.width] = '\0';
    Earthmap.data[j+k] = line;
    line += Earthmap.width+1;
  }
}

void
create_xbm()
{
  int i, j, k, l, u, t;

  k = 0;
  if (fill_mode==2) t=2; else t=1;
  for (j=0; j<Earthmap.height; j++) {
    l = 1;
    u = 0;
    for (i=0; i<Earthmap.width; i++) {
      if (grid(i,j)>=t) u = u+l;
      l = l+l;
      if (l==256 || i==Earthmap.width-1) {
        Earthmap.bits[k] = u;
	u = 0;
	l = 1;
        ++k;
      }
    }
  }
}

void
freeData()
{
    free(GRID);
    free(line);
}

void
makePixmap()
{
  int sign, i, j, num, count, u=0, v=0, up, vp;
  int m, min, max, addumin, addvmin, addumax, addvmax, diffu, diffv, sum;
  int ix, iy;
  double theta, phi;

  if (Earthmap.width <=10) return;
  if (Earthmap.height<= 5) return;

  GRID = (short *) salloc(Earthmap.width*Earthmap.height*sizeof(short));
  line = (char *) salloc((Earthmap.width+20)*sizeof(char));

  if (invert) {
    Earthmap.bits = (char *)
        salloc((1+Earthmap.width/8)*Earthmap.height*sizeof(char));
  } else {
    Earthmap.data = (char **)
        salloc((5+Earthmap.height)*sizeof(char *));
    Earthmap.data[0] = (char *)
        salloc((250+(Earthmap.width+1)*Earthmap.height)*sizeof(char));
  }

  for (i=0; i<Earthmap.width; i++) 
    for (j=0; j<Earthmap.height; j++) grid(i,j) = 0;

  i = 0;
  count = 0;

  while(map_data[i]) {
    num = map_data[i];
    sign = map_data[i+1];
    i += 2;
    ix = map_data[i];
    iy = map_data[i+1];
    /*
    if (debug)
       fprintf(stderr, "Loop %d, num %d, sign %d\n", count, num, sign);
    */
    for (j=0; j<=num; j++) {
      if (j<num) {
        theta = 0.5 + map_data[i] / 65520.0;
        phi = 0.5 - map_data[i+1] / 65520.0;
        i += 2;
      } else {
        theta = 0.5 + ix / 65520.0;
        phi = 0.5 - iy / 65520.0;
      }
      uu = uc = up = u;
      if (uc<0) uc+=Earthmap.width;
      if (uc>=Earthmap.width) uc-=Earthmap.width;
      vv = vp = v;
      u = (int) (theta * (Earthmap.width-1));
      v = (int) (phi * (Earthmap.height-1));
      if (j) {
	/*
	if (debug)
           fprintf(stderr, "Point %d/%d, Segment %d %d %d %d\n", 
                 j, num, up, vp, u, v);
	*/
        diffu = abs(u-up);
        if (diffu>Earthmap.width/2) {
	   if (u>up) 
              u -= Earthmap.width;
	   else
	      u += Earthmap.width;
           diffu = abs(u-up);
	}
        diffv = abs(v-vp);
        addumin = (u>up)? 1:-1;
        addvmin = (v>vp)? 1:-1;
        if (diffu>diffv) {
	  max = diffu ; 
          min = diffv;
	  addumax = addumin;
	  addvmax = 0;
	} else {
          max = diffv ; 
          min = diffu;
	  addumax = 0;
	  addvmax = addvmin;
	}
	sum = max/2-max;
	for (m=0; m<max; m++) {
          sum = sum + min;
          if (sum>=max/2) {
	      sum -= max;
	      up += addumin;
              vp += addvmin;
	    } else {
	      up += addumax; 
              vp += addvmax;
	    }
          plotdata(up, vp, sign);
	}
        /* if (debug && (up!=u || vp!=v)) 
	   fprintf(stderr, "Ending up with %d %d !!!\n", up, vp); */
      }
    }
    ++count;
  }

  filter_data();
  
  if (invert)
     create_xbm();
  else
     create_xpm();

  if (free_data)
     freeData();
}

