.TH SUNCLOCK 1 "Nov 18, 2000"
.SH NAME
sunclock \- a fancy clock for the X Window system, providing time and
geographical data through point and click actions.
.SH SYNOPSIS
.B sunclock
[
.I options
]
.SH DESCRIPTION
.I sunclock
is an X11 application that displays a map of the Earth and indicates
the illuminated portion of the globe by drawing sunlit areas dark on
light, night areas as light on dark.  In addition to providing local
time for the default timezone, it also displays GMT time, legal and
solar time of major cities, their latitude and longitude, and the
mutual distances of arbitrary locations on Earth. Sunclock can display
meridians, parallels, tropics and arctic circles. It has builtin
functions that accelerate the speed of time and show the evolution of
seasons. Sunclock can be internationalized for various western languages.
It is possible to customize the app-default file and add new entries
for additional cities. 

Sunclock can commute between two states, the "clock window" and
the "map window". The clock window displays a small map of the Earth
and therefore occupies little space on the screen, while the "map window" 
displays a large map and offers more advanced functions. Sunclock
includes a builtin resizable and zoomable vector map. External
Earth maps can also be loaded (however, only .xpm and .xpm.gz formats 
are available at the moment).

The map window can work in five different modes:
.PP
- "Legal time" mode: legal time of default time zone and GMT time are 
displayed.
.PP
- "Coordinate" mode: by clicking on a city, users get coordinates 
(latitude, longitude) of that city, legal time and sunrise/sunset.
.PP
- "Solar" mode: by clicking on a point of the map (either a city or 
another point), solar time and day length are shown.
.PP
- "Hour Extension" mode: displays solar times from 00:00 to 23:00 in bottom
strip, according to the Sun position.
.PP
- "Distance" mode: shows distances in km and miles between two arbitrary
locations.
.PP
- "Progress" mode: allows to speed up the evolution of time, so as to
observe the evolution of day/night periods and seasons.
.PP
Depending on the mode chosen, the bottom line shows a short text
displaying the required information. The bottom line can be scrolled to
the right or to the left by pressing the horizontal key arrows.
.SH OPTIONS
The program does not use the X Toolkit, and hence only those
options explicitly enumerated below may be used.  The only
needed resource is the list of coordinates and timezones of 
cities to be displayed. Users will possibly have to customize
the prepackaged app-default file Sunclock.ad.
.TP
.BI "\-help "
Show brief help and exit.
.TP
.BI "\-listmenu "
Explanations on the actions available from the builtin menu.
.TP
.BI "\-version "
Show program version and exit.
.TP
.B "\-display " dispname
Give the name of the X server to contact.
.TP
.B "\-language " name
Select language to be used in the sunclock menu and help.
.TP
.B "\-bigfont " name
Select the big font (used in the bottom line of the map window, in the 
menu and file selection windows). Default is 6x13
.TP
.B "\-smallfont " name (used in the bottom line of the clock window).
Default is 6x10.
.TP
.B "\-rcfile " filename
Select a configuration file that is possibly different than the system 
wide app-default Sunclock or the user default ~/.sunclockrc. The rcfile
(or user default) has a higher priority than the system wide app-default, 
but it can be overriden by the command line options which still have 
a higher priority.
.TP
.B "\-sharedir " directory
Set the directory where system wide shared Earthmaps are located.
Default is /usr/share/sunclock/earthmaps.
.TP
.B "\-mapimage " file.xpm.(gz)
Start sunclock with an Earth map image loaded in the map window.
.TP
.B "\-clockimage " file.xpm.(gz)
Start sunclock with an Earth map image loaded in the clock window. Those
maps are supposed to be somewhat smaller than for the map window, but 
sunclock will still accept large ones in the clock window...
.TP
.B "\-mono "
Use monochrome settings (recommended only for monochrome screens!).
.TP
.B "\-invert "
Instead of using the builtin color vector map of Earth, show a black and 
white frame and use inversion of colors to generate the night area. This
considerably reduces both memory and CPU usage, and could be useful on
more modest machines.
.TP
.B "\-private "
Allocate a private colormap. This has no effect on truecolor displays. 
On pseudocolor displays (depth <= 8), this option allows sunclock to run
even when the environment makes intensive use of colors. Thanks to the 
-private option, Pixmap earthmaps can also be loaded if they do not
use more than about 100 colors. Otherwise, a color quantization will
be necessary before the map can be loaded.
.TP
.B "\-usememory "
With this option, sunclock stores formerly loaded pixmap files in memory.
This allows a slightly shorter commuting time between clock and map windows,
at the expense of a larger memory usage. Use of this option is discouraged,
since sunclock is anyway quite fast at loading files, at least on
reasonably recent machines...
.TP
.B \-clock
Start in the clock state. This is the default and thus need not be
specified.
.TP
.BI "\-date "
Start the clock in "Date" mode. This is the default.
.TP
.BI "\-seconds "
Start the clock in "Seconds" mode (default is "date" mode).
.TP
.BI "\-map "
Start in the map state.  Useful to start right away with advanced 
functionalities.
.TP
.BI "\-decimal "
Initializes coordinate values of geographical data in decimal degrees.
However, this can still be switched at runtime.
.TP
.BI "\-dms "
Initializes coordinate values of geographical data in degrees, minutes
and seconds. However, this can still be switched at runtime.
.TP
.B "\-menu "
Raise the menu window along with the map window. This has no effect unless
the -map option is also set.
.TP
.B "\-nomenu "
Don't raise the menu window along with the map window. This has no effect 
if the clock is raised first.
.TP
.BI "\-mapmode * (single character = C, D, E, L or S)"
Start the map functions in mode (C)oordinates, (D)istances, hour (E)xtension,
(L)egal time or (S)olar time respectively. Any other specification is 
ignored. Default is legal time mode.
.TP
.BI "\-clockgeom " +x+y
Specify the position of the clock window.  Only the position is used; any 
size information given is ignored.
.TP
.BI "\-mapgeom " +x+y
Specify the position of the map window.  Only the position is used; any 
size information given is ignored.
.TP
.BI "\-placement " <choice>\ (random, fixed, center, NW, NE, SW, SE)
Specify whether commuting between clock and map windows should proceed
with letting the the window centers, respectively, the NW, NE, SW, SE 
corners fixed, or rather whether it should operate randomly, or through 
user defined placement. Default is NW placement.
.TP
.BI "\-horizshift " w
Specify number of pixels which should separate the central bottom points
of map and menu windows. The default is 0 and may need to be adjusted 
according to the window manager used.
.TP
.BI "\-vertshift " h
Specify number of pixels which should separate the map and menu windows.
The default is 12 and may need to be adjusted according to the window
manager used.
.TP
.BI "\-spotsize " size
Define size=0 [=no spots] or 1,2,3 to use either thin circles, medium
size spots or big spots and circles to represent cities. Size=3
can be useful for monochrome displays on which cities are hardly
visible, otherwise small color spots of size 1 or 2 are better).
Default is 2 for color mode and 3 for monochrome mode.
.TP
.BI "\-coastlines "
In the builtin vector map, generate coast lines without filling the
land areas.
.TP
.BI "\-contour "
As before, but use a smart algorithm which eliminates \"redundant\" coast
lines, especially at lower resolutions (in case the coasts are very
irregular, some parts may disappear but the overall picture looks sharper).
.TP
.BI "\-landfill "
In the builtin vector map, fill the land areas without generating coast 
lines.
.TP
.BI "\-fillmode " 0,1,2
Fillmode=0 is equivalent to -coastlines, fillmode=1 is equivalent to 
-contour, and fillmode=2 is equivalent to -landfill.
.TP
.BI "\-dottedlines "
Use dotted lines to represent meridians and parallels.
.TP
.BI "\-plainlines "
Use plain lines to represent meridians and parallels.
.TP
.BI "\-command " string
Specify an external action or program that will be called by keyboard 
shortcut 'x'. Default is empty command.
.TP
.BI "\-jump " number[unit] (where unit=s,m,h,d,M,Y)
Number of seconds (respectively minutes, hour, days, Months, Years) 
by which the current date and time should be shifted. No blank space
should separate the number and its unit. If the unit is absent, the 
number is understood to be expressed by default in seconds. Useful to get 
sunclock display information on earlier or later epochs.
.TP
.BI "\-progress " number[unit] (where unit=s,m,h,d,M,Y)
Number of seconds (respectively minutes, hour, days, Months, Years) 
by which the time progression should operate. No blank space
should separate the number and its unit. If the unit is absent, the number
is understood to be expressed by default in seconds. Useful to get sunclock 
progress by other steps than the predefined ones (by default the steps 
cycle between the values 1 mn, 1 hour, 1 day, 7 days, 30 days).
.TP
.BI "\-city " name
Initialize program so as to display data of city 'name'. This becomes
effective only if the above mentioned city is listed in the app-default 
or rc file. The operating mode is set to Coordinates mode.
.TP
.BI "\-position " latitude longitude
Initialize program so as to display data of the position specified by 
two coordinates (in degrees). The operating mode is set to Solar time mode.
.TP
.BI "\-shading " mode=0,1,2,3,4
Start sunclock with the specified shading mode. Mode 0 means that the night
area is not displayed. In higher modes, the night area is displayed, with
increasingly sophisticated shading algorithms. Mode 1 stans for no shading
(i.e. just bright and dark colors). Mode 2 shades the area in which the
sun is partially hidden by the horizon. Mode 3 shades the region in which
there is still substantial luminosity left after sunset (depending on
the diffusion parameter below). Mode 4 additionally represents the 
luminosity in the full illuminated area.
.TP
.BI "\-night "
Start sunclock with the night region displayed in mode 1 (it's the default).
.TP
.BI "\-terminator \-twilight \-luminosity " 
Start sunclock with the night region displayed in mode 2, 3, 4 respectively.
.TP
.BI "\-diffusion " value (degrees)
Sets the amplitude of the area in which diffusion of light in the
atmosphere is still sufficient to keep some luminosity after sunset.
Default is 3 degrees.
.TP
.BI "\-refraction " value (degrees)
Sets the value of the refraction angle for tangential sun rays at sunset.
This is related to the fact that the sun sometimes looks bigger at sunset.
Changing the refraction degree slightly affects the computation of sunrise
and sunset times. Default is 0.1 degree.
.TP
.BI "\-cities "
Start sunclock with the cities displayed (by default, they are).
.TP
.BI "\-sun "
Start sunclock with the Sun position displayed (by default, it is).
.TP
.BI "\-meridians "
Start sunclock with meridians displayed (by default, they aren't).
.TP
.BI "\-parallels "
Start sunclock with parallels displayed (by default, they aren't).
.TP
.BI "\-tropics "
Start sunclock with tropics and arctic circles displayed (by default, 
they aren't).
.TP
.BI "\-nonight \-nocities \-nosun \-nomeridians \-noparallels \-notropics"
These options just negate the above ones.
.TP
.BI "\-landcolor " color
Specifies the color of land areas produced by the builtin vector map. 
Default is Chartreuse2. This option has no effect on external image
earthmaps being loaded.
.TP
.BI "\-watercolor " color
Specifies the color of water (sea) areas. Default is RoyalBlue.
.TP
.BI "\-arcticcolor " color
Specifies the color of arctic areas. Default is LemonChiffon.
.TP
.BI "\-textbgcolor " color
Specifies the bottom text background color. Default is Grey92.
.TP
.BI "\-textfgcolor " color
Specifies the bottom text foreground color. Default is Black.
.TP
.BI "\-dircolor " color
Specifies the color used for representing dircetories in the file selection
window. Default is Blue.
.TP
.BI "\-citycolor0 " color
Specifies the color of cities (as described in ~/.sunclockrc or in
the systemwide app-default file), when they have not yet been clicked 
on with the mouse. Default is Orange.
.TP
.BI "\-citycolor1 " color
Specifies the color to be applied to the city which has been selected just
before the last selection, during the process of calculating distances.
Default is Red.
.TP
.BI "\-citycolor2 " color
Specifies the color to be applied to the last selected city. The name and
coordinates of this city are displayed in the bottom line. Default is 
Red3 (darker red).
.TP
.BI "\-markcolor1 " color
Specifies the color to be applied to the first marked position
(any location on Earth other than one of the cities). Default is Pink1.
.TP
.BI "\-markcolor2 " color
Specifies the color to be applied to the second marked position.
Default is Pink2.
.TP
.BI "\-linecolor " color
Specifies the color to be applied to meridian and parallel lines.
Default is White.
.TP
.BI "\-tropiccolor " color
Specifies the color to be applied to Equator/Tropics/Arctic circles.
Default is White.
.BI "\-suncolor " color
Specifies the color to be applied to Sun.
Default is Yellow.
.PP
Users may keep a file in their home directory called ~/.sunclockrc. This
file can contain lines of the following format:
.PP
name: latitude longtitude timezone
.PP
where name is the ascii name of the place to be shown on the map. 
Latitude and longitude are floating point numbers representing the
geographical location of the place. Western longitudes and southern latitudes
should be entered as negative numbers. timezone is the name of the timezone
that the place is in. This should be the name of a file under /lib/zoneinfo,
incorrect timezones cause the clock to display GMT. It is also possible to 
reference a file in a directory relative to /lib/zoneinfo for example
Canada/Eastern instead of EST5EDT.
.PP
The user may click on the dot on the map associated with a place
defined in the .sunclockrc
file. When this is done, the city name and its corresponding local time 
and time zone will be displayed in the bottomline.
.SH "HOW IT WORKS"
.I sunclock
calculates the position of the Sun using the algorithm in chapter 18 of:
.PP
.I "Astronomical Formulae for Calculators"
by Jean Meeus, Third Edition, Richmond: Willmann-Bell, 1985.
.PP
and Mercator projects the illuminated area onto map image.  The
Sun's position is calculated to better than one arc-second
in accuracy.
.SH BUGS
The maps are not rescaled if you resize the open window or icon.  (I don't want
to have to store a vector database for the map.)  The program contravenes
section 4.1.9 of the ICCCM in that its icon window is a fixed size, and any
WM_ICON_SIZE property of the root window is ignored.
.PP
The illuminated area shown is the area which would be sunlit
if the Earth had no atmosphere.  The actual illuminated area is
larger because of atmospheric refraction and twilight.
.SH AUTHORS
John Walker, Autodesk, Inc., <kelvin@acad.uu.NET>, wrote the original
Suntools program from which sunclock is derived.
.PP
John Mackin, Basser Department of Computer Science, University of Sydney,
Sydney, Australia, <john@cs.su.oz.AU>, wrote the X11 version out of Suntools.
.PP
Stephen Martin, Fujitsu Systems Business of Canada, smartin@fujitsu.ca,
added support for interactive map.
.PP
Jean-Pierre Demailly, Universit de Grenoble I, 
demailly@fourier.ujf-grenoble.fr added support for numerous new options and
functions in the interface, and made them available through the GUI.


