/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

void cb_cmdline_keypress(GtkWidget *widget,GdkEventKey *event, gpointer data)
{
	if (event->state & GDK_CONTROL_MASK)
	{
		switch (event->keyval)
		{
			case '1':
				gtk_entry_append_text(GTK_ENTRY(widget),app.left.workingdir);
				break;
			case '2':
				gtk_entry_append_text(GTK_ENTRY(widget),app.right.workingdir);	
				break;
			case 'u':
				gtk_entry_set_text(GTK_ENTRY(widget),"");
				break;
			case GDK_Tab:
				event->keyval = 0;
				break;
		}
		
	}
	else
	if (event->keyval == GDK_Page_Up || event->keyval == GDK_Page_Down)
	{
		gtk_widget_grab_focus(GTK_WIDGET(notfocused->clist));
		gtk_widget_grab_focus(GTK_WIDGET(widget));
	}
	/*else
	if (event->keyval == GDK_Insert)
	{
		gint a;
		gint count;
		struct dirent **files;
		gchar *pattern = gtk_entry_get_text(GTK_ENTRY(widget));
		
		count = scandir(focused->workingdir,&files,fselect,alphasort);
		for (a = 0; a < count; a++ )
		{
			if (fnmatch(pattern,files[a]->d_name,0) == 0)
			{
				gtk_entry_set_text(GTK_ENTRY(widget),files[a]->d_name);
			}
		}
	}*/
}

void cb_cmdline_activate(GtkWidget *widget)
{
	gchar *buf = 0;
	gchar *cmd = 0;
	gchar *arg = 0;
	gchar *workingdir = 0;
	gchar *tmpbuf = 0;
	gchar *strip = 0;

	gint a;
	gint height = 90;
	gint *button;
	gint count = 0;
	gint rows = 0;
	
	buf = gtk_entry_get_text(GTK_ENTRY(widget));
	if ((arg = strchr(buf,' ')))
		cmd = substr(buf,1,strlen(buf)-strlen(arg));
	else
	{
		arg = NULL;
		cmd = buf;
	}
	
	/* cd */
	if (strcmp(cmd,"cd") == 0)
	{
		if (arg)
		{
			gchar *dir = 0;
		
			if (arg[1] == '/')
				dir = arg+1;
			else
			if (arg[1] == '~')
				dir = expandpath(arg+1);
			else
			{
				workingdir = focused->workingdir;
				dir = malloc(strlen(workingdir)+strlen(arg+1)+2);
				if (strcmp(workingdir,"/") == 0)
					sprintf(dir,"%s%s",workingdir,arg+1);
				else
					sprintf(dir,"%s/%s",workingdir,arg+1);
			}
			update_filelist(dir,focused);
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
		}
		return;
	}
	
	/* delete */
	if (strcmp(cmd,"rm") == 0 || strcmp(cmd,"del") == 0)
	{	
		struct dirent **files;
		struct stat tmp;
		gchar *pattern = 0;
		gchar *dir = 0;
		gchar *strip = 0;
		gchar *fullpath = 0;
		gint i;
		gint count;
		gint fcount = 0;
		GString *msg = g_string_new("Are you want to remove the file(s):\n");
		
		if (arg)
		{	
			if (arg[1] == '/' || arg[1] == '~')
			{
				strip = strrchr(arg,'/');
				dir = substr(arg,2,strlen(arg)-strlen(strip)+1);
				pattern = strip+1;
				dir = parsepath(strdup(dir));
			}
			else
			{
				dir = focused->workingdir;
				pattern = arg+1;
			}
			
			if ((count = scandir(dir,&files,fselect,alphasort)) == -1)
			{
				statusbar_print(" Error opening: %s - %s",dir,strerror(errno));
				return;
			}
			
			for (i = 0; i < count; i++ )
			{
				if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
				{
					if (fnmatch(pattern,files[i]->d_name,0) == 0)
					{
						if (strcmp(dir,"/") == 0)
							g_string_sprintfa(msg,"/%s\n", files[i]->d_name);
						else
							g_string_sprintfa(msg,"%s/%s\n", dir,files[i]->d_name);
						if (height < 250)
							height += 15;
						fcount++;
					}
				}
			}
			if (fcount > 0)
			{
				if (config.confirmation_del_cmdline == TRUE)
				{
					create_dialog("Delete","",msg->str,height,&button);
					gtk_main();
				}
				else (int)button = 1;
			}
			else
			{
				statusbar_print(" Found no files matching in %s matching pattern: %s",dir,pattern);
				gtk_entry_select_region(GTK_ENTRY(widget),strlen(cmd+1)+2,strlen(arg+1)+strlen(cmd+1)+2);
				return;
			}
			
			if ((int)button == 1)
			{
				for (i = 0; i < count; i++ )
				{
					if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
					{
						if (fnmatch(pattern,files[i]->d_name,0) == 0)
						{
							fullpath = malloc(strlen(dir)+strlen(files[i]->d_name)+2);
							sprintf(fullpath,"%s/%s",dir,files[i]->d_name);
							stat(fullpath,&tmp);
							if (S_ISDIR (tmp.st_mode))
								del_dir(fullpath);
							else
								del_file(fullpath);
							free(fullpath);
						}
					}
				}
				if (strcmp(dir,focused->workingdir) == 0)
					refresh_filelist(focused,0);
				if (strcmp(dir,notfocused->workingdir) == 0)
					refresh_filelist(notfocused,0);
				add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
				gtk_entry_set_text(GTK_ENTRY(widget),"");
				return;
			}
		}
		else
		{
			cb_file_delete();
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			return;
		}
	}
	/* select */
	else if (strcmp(cmd,"sel") == 0 || strcmp(cmd,"select") == 0)
	{
		if (arg)
		{
			rows = GTK_CLIST(focused->clist)->rows;
			for (a = 1; a < rows; a++) 
			{
				gtk_clist_unselect_row(GTK_CLIST(focused->clist),a,0);
				gtk_clist_get_text(GTK_CLIST(focused->clist),a,5,&tmpbuf);
				strip = (char *)strrchr(tmpbuf,'/');
				strip++;
				if (fnmatch(arg+1,strip,0) == 0)
				{
					gtk_clist_select_row(GTK_CLIST(focused->clist),a,0);
					count++;
				}
			}
			if (count < 1)
			{
				statusbar_print(" Found no files matching pattern: %s",arg+1);
				gtk_entry_select_region(GTK_ENTRY(widget),strlen(cmd+1)+2,strlen(arg+1)+strlen(cmd+1)+2);
			}
			else
			{
				statusbar_print(" Selected %d files",count);
				gtk_entry_set_text(GTK_ENTRY(widget),"");
			}
			return;
		}
		else
		{
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			cb_pattern_select();
			return;
		}
	}
	
	/* mkdir */
	else if (strcmp(cmd,"mkdir") == 0)
	{
		gchar *dir = 0;
		gchar *workingdir = 0;
		if (arg)
		{
			workingdir = focused->workingdir;
			if (arg[1] == '/')
			{
				dir = arg+1;
				make_dir(dir);
			}
			else
			{
				dir = malloc(strlen(arg+1)+strlen(workingdir)+1);
				sprintf(dir,"%s/%s",workingdir,arg+1);
				make_dir(dir);
				if (strcmp(focused->workingdir,notfocused->workingdir) == 0)
				{
					refresh_filelist(focused,1);
					refresh_filelist(notfocused,1);
				}
				else
					refresh_filelist(focused,1);
			}
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			return;
		}
		else
		{
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			cb_file_mkdir();
			return;
		}
	}
	/* preferences */
	else if (strcmp(cmd,"prefs") == 0 || strcmp(cmd,"preferences") == 0 || strcmp(cmd,"setup") == 0)
	{
		add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
		gtk_entry_set_text(GTK_ENTRY(widget),"");
		cb_preferences();
		return;
	}
	/* copy 
	else if (strcmp(cmd,"cp") == 0 || strcmp(cmd,"copy") == 0 )
	{
		struct dirent **files;
		gchar *pattern = 0;
		gchar *dir = 0;
		gchar *strip = 0;
		gchar *fullpath = 0;
		gint i;
		gint count;
		gint fcount = 0;
		gchar *src, *dest;

		if (arg)
		{
			src = strtok(arg," ");
			dest = strtok(NULL," ");
			
			if (!dest) 
				dest = notfocused->workingdir;
			if (src[0] == '/')
			{
				strip = strrchr(arg,'/');
				dir = substr(arg,2,strlen(arg)-strlen(strip)+1);
				dir = parsepath(strdup(dir));
			}
			else
			{
				dir = focused->workingdir;
				pattern = arg+1;
			}

			if ((count = scandir(dir,&files,fselect,alphasort)) == -1)
			{
				statusbar_print(" Error opening: %s - %s",dir,strerror(errno));
				return;
			}
			
			for (i = 0; i < count; i++ )
			{
				if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
				{
					if (fnmatch(pattern,files[i]->d_name,0) == 0)
					{
						fcount++;
					}
				}
			}

			if (fcount == 0)
			{
				statusbar_print(" Found no files in: %s matching pattern: %s",dir,pattern);
				gtk_entry_select_region(GTK_ENTRY(widget),strlen(cmd+1)+2,strlen(arg+1)+strlen(cmd+1)+2);
				return;
			}
			
			for (i = 0; i < count; i++ )
			{
				if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
				{
					if (fnmatch(pattern,files[i]->d_name,0) == 0)
					{
						fullpath = malloc(strlen(dir)+strlen(files[i]->d_name)+2);
						sprintf(fullpath,"%s/%s",dir,files[i]->d_name);
						file_copy(fullpath,dest);
						free(fullpath);
					}
				}
			}

			if (strcmp(dest,focused->workingdir) == 0)
				refresh_filelist(focused,0);
			if (strcmp(dest,notfocused->workingdir) == 0)
				refresh_filelist(notfocused,0);
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			return;
		}
	}*/
	/* move */
	else if (strcmp(cmd,"mv") == 0 || strcmp(cmd,"move") == 0 )
	{
		struct dirent **files;
		struct stat tmp;
		gchar *pattern = 0;
		gchar *dir = 0;
		gchar *strip = 0;
		gchar *fullpath = 0;
		gint i;
		gint count;
		gint fcount = 0;
		gchar *src, *dest;
		gchar *fulldest = 0;
		
		if (arg)
		{
			src = strtok(arg," ");
			dest = strtok(NULL," ");
			
			/* no destination given, use workingdir of not focused filelist */
			if (!dest) 
				fulldest = notfocused->workingdir;
			/* destination begins with / so it's not a relative path */
			else if (dest[0] != '/')
			{
				fulldest = malloc(strlen(dest)+strlen(dest)+1);
				if (strcmp("/",focused->workingdir) == 0) 
					sprintf(fulldest,"/%s",focused->workingdir);
				else
					sprintf(fulldest,"%s/%s",focused->workingdir,dest);
			}
			else if (dest[0] == '/')
				fulldest = dest;
			
			/* source is not a relative path */
			if (src[0] == '/')
			{
				strip = strrchr(arg,'/');
				dir = substr(arg,2,strlen(arg)-strlen(strip)+1);
				pattern = strip+1;
				dir = parsepath(strdup(dir));
			}
			else
			{
				dir = focused->workingdir;
				pattern = arg+1;
			}
		
			if ((count = scandir(dir,&files,fselect,alphasort)) == -1)
			{
				statusbar_print(" Error opening: %s - %s",dir,strerror(errno));
				return;
			}
			return;
			/* multiple files and destination is not a directory, which means user is stupid or knows
			 * about the nifty little ask-if-wanna-create-dir feature */
			if (count > 1)
			{
				stat(fulldest,&tmp);
				if (!S_ISDIR (tmp.st_mode))
				{
					gint *button;
					GString *mkdir_msg = g_string_new("");

					g_string_sprintf(mkdir_msg,"Directory: %s does not exist. Create it?",fulldest);
					create_dialog("MkDir","",mkdir_msg->str,40,&button);
					gtk_main();
					if ((int)button == 0)
						make_dir(fulldest);
					else
						return;
				}
			}

			for (i = 0; i < count; i++ )
			{
				if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
				{
					if (fnmatch(pattern,files[i]->d_name,0) == 0)
					{
						fcount++;
					}
				}
			}
			if (fcount == 0)
			{
				statusbar_print(" Found no files in: %s matching pattern: %s",dir,pattern);
				gtk_entry_select_region(GTK_ENTRY(widget),strlen(cmd+1)+2,strlen(arg+1)+strlen(cmd+1)+2);
				return;
			}
			
			for (i = 0; i < count; i++ )
			{
				if (strcmp(files[i]->d_name,".") != 0 && strcmp(files[i]->d_name,"..") != 0)
				{
					if (fnmatch(pattern,files[i]->d_name,0) == 0)
					{
						fullpath = malloc(strlen(dir)+strlen(files[i]->d_name)+2);
						sprintf(fullpath,"%s/%s",dir,files[i]->d_name);
						file_move(fullpath,fulldest);
						free(fullpath);
					}
				}
			}
			if (strcmp(fulldest,focused->workingdir) == 0)
				refresh_filelist(focused,0);
			if (strcmp(fulldest,notfocused->workingdir) == 0)
				refresh_filelist(notfocused,0);
			if (strcmp(dir,focused->workingdir) == 0)
				refresh_filelist(focused,0);
			if (strcmp(dir,notfocused->workingdir) == 0)
				refresh_filelist(notfocused,0);
			add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
			gtk_entry_set_text(GTK_ENTRY(widget),"");
			return;
		}
	}
	
	/* add association */
	else if (strcmp(cmd,"ass") == 0)
	{

		cb_associate();
		
		/*FILE *fp;
		gchar *ext,*desc,*command;
		gint def; 

		if ((fp = fopen(get_file_extensions_filename(),"a")))
		{
			ext = strchr(arg,' ');
			desc = strchr(ext, ',');
			command = strchr(desc+1, ',');
			def = atoi(strchr(command+1, ','));
		
			printf("%d\n",strlen(arg)-strlen(desc));
			ext[strlen(arg)-strlen(desc)] = '\0';
	
			
			printf("%s - %s - %s\n",ext,desc,command);
			return;
			
			if (!ext)
			{
				create_dialog_with_entry("Associatie","Extension: ","",&ext);
				gtk_main ();
				if (!ext)
					return;
			}
			if (!desc)
			{
				create_dialog_with_entry("Associate","Description: ","",&desc);
				gtk_main ();
				if (!desc)
					return;
			}
			if (!command)
			{
				create_dialog_with_entry("Associate","Command: ","",&command);
				gtk_main ();
				if (!command)
					return;
			}
			if (def)
				fprintf(fp,"%s;%s;%s\n",ext,desc,command);
			else
				fprintf(fp,"%s;%s;%s;default\n",ext,desc,command);
			fclose(fp);
		}*/
	}
	/* exe */
	else if (strcmp(cmd,"quit") == 0 || strcmp(cmd,"exit") == 0)
	{
		gtk_main_quit();
		return;
	}
	else 
	{
		execute_program(gtk_entry_get_text(GTK_ENTRY(widget)));
		add_commandhistory(gtk_entry_get_text(GTK_ENTRY(widget)));
		gtk_entry_set_text(GTK_ENTRY(widget),"");
	}
}
