/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

Config config;

void read_config()
{
	FILE *fp;
	gchar buf[256];
	gchar *strip;
	gchar *config_file;
	
	config_file = get_config_filename();
	set_config_defaults();
	if (!(fp = fopen(config_file,"r")))
	{
		if (configdir_exists() == 0)
		{
			make_dir((char *)get_config_dir());
			create_dialog_ok_only("Error!\n","config",100,"Couldn't find $HOME/.linuxcmd/\nAttempting to create it...");		
			gtk_main();
			set_config_defaults();
			write_config_file();
			cb_preferences();
			return;
		}
		else
		{
			set_config_defaults();
			write_config_file();
			cb_preferences();
		}
		return;
	}

	while (fgets(buf,256,fp))
	{
		if ((strip = (char *)strchr(buf,'\n')))
			*strip = 0;
		strip = (char *)strchr(buf,'=');
		strip++;
		
		if (strstr(buf,"XTERM"))
			strcpy(config.xterm,strdup(strip));
		if (strstr(buf,"SELECT_BUTTON"))
			config.select_button = atoi(strip);
		if (strstr(buf,"POPUP_BUTTON"))
			config.popup_button = atoi(strip);
		if (strstr(buf,"COL1_VISIBLE"))
			config.col1_visible = atoi(strip);
		if (strstr(buf,"COL2_VISIBLE"))
			config.col2_visible = atoi(strip);
		if (strstr(buf,"COL3_VISIBLE"))
			config.col3_visible = atoi(strip);
		if (strstr(buf,"COL4_VISIBLE"))
			config.col4_visible = atoi(strip);
		if (strstr(buf,"COL5_VISIBLE"))
			config.col5_visible = atoi(strip);
		if (strstr(buf,"COL1_WIDTH"))
			config.col1_width = atoi(strip);
		if (strstr(buf,"COL2_WIDTH"))
			config.col2_width = atoi(strip);
		if (strstr(buf,"COL3_WIDTH"))
			config.col3_width = atoi(strip);
		if (strstr(buf,"COL4_WIDTH"))
			config.col4_width = atoi(strip);
		if (strstr(buf,"COL5_WIDTH"))
			config.col5_width = atoi(strip);
		if (strstr(buf,"EXPAND_LINKS"))
			config.expand_links = atoi(strip);
		if (strstr(buf,"CONFIRMATION_DEL_NORMAL"))
			config.confirmation_del_normal = atoi(strip);	
		if (strstr(buf,"CONFIRMATION_DEL_CMDLINE"))
			config.confirmation_del_cmdline = atoi(strip);	
		if (strstr(buf,"STARTUPDIR_LEFT"))
			strcpy(config.startupdir_left,strdup(strip));
		if (strstr(buf,"STARTUPDIR_RIGHT"))
			strcpy(config.startupdir_right,strdup(strip));
		if (strstr(buf,"LYNXLIKE_MOTION"))
			config.lynxlike_motion = atoi(strip);
		if (strstr(buf,"COLOR_REG"))
		{
			unsigned int r,g,b;
	  		sscanf (strip, "%04X,%04X,%04X", &r, &g, &b);
	  		color_reg.red = r;
	  		color_reg.green = g;
	  		color_reg.blue = b;
		}
		if (strstr(buf,"COLOR_LNK"))
		{
			unsigned int r,g,b;
	  		sscanf (strip, "%04X,%04X,%04X", &r, &g, &b);
	  		color_lnk.red = r;
	  		color_lnk.green = g;
	  		color_lnk.blue = b;
		}
		if (strstr(buf,"COLOR_EXE"))
		{
			unsigned int r,g,b;	
	  		sscanf (strip, "%04X,%04X,%04X", &r, &g, &b);
	  		color_exe.red = r;
	  		color_exe.green = g;
	  		color_exe.blue = b;
		}
		if (strstr(buf,"COLOR_DIR"))
		{
			unsigned int r,g,b;
	  		sscanf (strip, "%04X,%04X,%04X", &r, &g, &b);
	  		color_dir.red = r;
	  		color_dir.green = g;
	  		color_dir.blue = b;
		}

	}
	fclose(fp);
}

gchar *get_file_extensions_filename()
{
	gchar *tmpbuf = malloc(256);
	struct passwd *pwd;
	pwd = getpwuid(getuid());
	snprintf(tmpbuf,256,"%s/.linuxcmd/filetypes",pwd->pw_dir);
	return tmpbuf;
}

gchar *get_config_filename()
{
	gchar *tmpbuf = malloc(256);
	struct passwd *pwd;
	pwd = getpwuid(getuid());
	snprintf(tmpbuf,256,"%s/.linuxcmd/general",pwd->pw_dir);
	return tmpbuf;
}

gchar *get_config_dir()
{
	gchar *tmpbuf = malloc(256);
	struct passwd *pwd;
	pwd = getpwuid(getuid());
	snprintf(tmpbuf,256,"%s/.linuxcmd",pwd->pw_dir);
	return tmpbuf;
}

/* returns 1 if $HOME/.config exists, -1 if it's not a dir and 0 if it doesn't exists */
int configdir_exists()
{
	struct stat tmp;
	struct passwd *pwd;
	gchar *tmpbuf = malloc(256);
	pwd = getpwuid(getuid());
	snprintf(tmpbuf,256,"%s/.linuxcmd",pwd->pw_dir);
	if (stat(tmpbuf,&tmp) == -1)
		return 0;
	if (S_ISDIR (tmp.st_mode))
		return 1;
	else 
		return -1;
}

void write_config_file()
{
	FILE *fp;
	gchar *config_file;
	gchar *config_dir;
	int exists;
	
	exists = configdir_exists();
	
	if (exists == 0)
	{
		config_dir = get_config_dir();
		create_dialog_ok_only("Error!\n","config",100,"Couldn't find $HOME/.config/\nCreating it.");
		gtk_main();
		make_dir(config_dir);
	}
	config_file = get_config_filename();
	if (!(fp = fopen(config_file,"w")))
	{
		create_dialog_ok_only("Error!\n","config",100,"Can't create config file!\nHave you created the dir $HOME/.config?\n");
		gtk_main();
		return;
	}
	fprintf(fp,"COLOR_REG=%04X,%04X,%04X\n",color_reg.red,color_reg.green,color_reg.blue);
	fprintf(fp,"COLOR_EXE=%04X,%04X,%04X\n",color_exe.red,color_exe.green,color_exe.blue);
	fprintf(fp,"COLOR_DIR=%04X,%04X,%04X\n",color_dir.red,color_dir.green,color_dir.blue);
	fprintf(fp,"COLOR_LNK=%04X,%04X,%04X\n",color_lnk.red,color_lnk.green,color_lnk.blue);
	fprintf(fp,"EXPAND_LINKS=%d\n",config.expand_links);
	fprintf(fp,"COL1_VISIBLE=%d\n",config.col1_visible);
	fprintf(fp,"COL2_VISIBLE=%d\n",config.col2_visible);
	fprintf(fp,"COL3_VISIBLE=%d\n",config.col3_visible);
	fprintf(fp,"COL4_VISIBLE=%d\n",config.col4_visible);
	fprintf(fp,"COL5_VISIBLE=%d\n",config.col5_visible);
	fprintf(fp,"STARTUPDIR_LEFT=%s\n",config.startupdir_left);
	fprintf(fp,"STARTUPDIR_RIGHT=%s\n",config.startupdir_right);
	fprintf(fp,"XTERM=%s\n",config.xterm);
	fprintf(fp,"CONFIRMATION_DEL_NORMAL=%d\n",config.confirmation_del_normal);
	fprintf(fp,"CONFIRMATION_DEL_CMDLINE=%d\n",config.confirmation_del_cmdline);
	fprintf(fp,"SELECT_BUTTON=%d\n",config.select_button);
	fprintf(fp,"POPUP_BUTTON=%d\n",config.popup_button);
	fprintf(fp,"LYNXLIKE_MOTION=%d\n",config.lynxlike_motion);
	fclose(fp);
}

void set_config_defaults()
{
	/* lynxlike */
	config.lynxlike_motion = 0;
	/* popup menu */
	config.addfilenametopopup = 0;
	/* startup dirs */
	strcpy(config.startupdir_left,"HOME");
	strcpy(config.startupdir_right,"/");
	/* xterm command */
	strcpy(config.xterm,"wterm");
	/* confirmation */
	config.confirmation_del_cmdline = 1;
	config.confirmation_del_normal = 1;
	/* visible columns */
	config.col1_visible = 1;
	config.col2_visible = 1;
	config.col3_visible = 0;
	config.col4_visible = 0;
	config.col5_visible = 0;
	config.expand_links = 1;
	/* mouse */ 
	config.select_button = 2;
	config.popup_button = 3;
	/* colors */
	gdk_color_parse("red",&color_exe);
	gdk_color_parse("blue",&color_dir);
	gdk_color_parse("lightblue",&color_lnk);
	gdk_color_parse("black",&color_reg);
}
