/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

void file_chmod(const char *filename, const char *user, const char *group,const char *others)
{
	char *args[4];
	args[0] = "chmod";
	args[1] = (char *)strdup(user);
	args[2] = (char *)strdup(filename);
	args[3] = NULL;
	execute_cmd(args);
	args[1] = strdup(group);
	execute_cmd(args);
	args[1] = strdup(others);
	execute_cmd(args);
}

gint execute_cmd(gchar ** args)
{
	int file_pipes[2];
	int pid;
	int nread;
	char buf[1024];
	char *strip;
	
	if (pipe (file_pipes) != 0) 
	{
    	perror("pipe");
      	return -1;
    }

  	if ((pid = fork ()) == -1) 
	{
		perror("fork");
      	return -1;
    }

    if (pid == 0) 
	{
    	close (1);
      	close (2);
      	dup (file_pipes[1]);
      	dup (file_pipes[1]);
      	close (file_pipes[0]);
      	close (file_pipes[1]);
      	execvp (args[0], args);
      	exit (127);
    }
  	else 
	{
     	close (file_pipes[1]);
      	while ((nread = read (file_pipes[0], buf, sizeof (buf) - 1)) > 0)
	 	{
	  		buf[nread] = '\0';
			if ((strip = (char *)strchr(buf,'\n')))
				*strip = 0;
	     	statusbar_print(" %s",buf);
		}
      	close (file_pipes[0]);
    }
	return 0;
}

gint execute (gchar ** args)
{
  	gint pid;

  	if ((pid = fork ()) == 0)
    {
      	execvp (args[0], args);
      	exit (127);
    }
  	return pid;
}

gint execute_program (const gchar *arg)
{
	gchar *args[4];
  	pid_t pid;

	args[0] = "sh";
	args[1] = "-c";
  	args[2] = strdup(arg);
	args[3] = NULL;

  	pid = execute (args);
  	return pid;
}

gint xterm_exec (gchar * command)
{
  gchar *args[6];

  args[0] = config.xterm;
  args[1] = "-e";
  args[2] = "sh";
  args[3] = "-c";
  args[4] = command;
  args[5] = NULL;

  return execute (args);
}

gchar *get_file_type(const gchar *filename)
{
	FILE *fp;
	
	gchar *cmd = malloc(strlen(filename)+11);
	gchar *buf = malloc(256);
	gchar *strip;
	sprintf(cmd,"file -b \"%s\"",filename);
	fp = popen (cmd,"r");
	/*{
		printf("Error!\n");
		return;
	}*/
	fgets(buf,256,fp);
	if ((strip = strchr(buf,'\n')))
		*strip = 0;
	pclose(fp);
	return buf;
}
