/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include "linuxcmd.h"

#include "folder.xpm"
#include "file.xpm"

gint filecount;

int fselect(const struct dirent *bla)
{
	if (strcmp(bla->d_name,".") == 0 || strcmp(bla->d_name,".") == 0 )
        return 0;
	else 
		return 1;
}

/* Refreshes selected filelist & keeps scrollbar position + selection if keep_selection == TRUE */
void refresh_filelist(FileList *list, gboolean keep_selection)
{
	GtkAdjustment *adj;
    gfloat scrollbar_position;
	GList *selection = NULL;
	
	gtk_clist_freeze(GTK_CLIST(list->clist));
	adj = gtk_clist_get_vadjustment(GTK_CLIST(list->clist));
    scrollbar_position = adj->value;
	if (keep_selection == TRUE)
		selection = g_list_copy(GTK_CLIST(list->clist)->selection);
	update_filelist(list->workingdir,list);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj), scrollbar_position);
	
	if (keep_selection == TRUE)
	{
		for (; selection != NULL; selection = selection->next)
		{
			gtk_clist_select_row(GTK_CLIST(list->clist),(gint)selection->data,0);
		}
	}
	gtk_clist_thaw(GTK_CLIST(list->clist));

}
void *duplicate (void *stuff, int size)
{
  	void *new_stuff = (void *) malloc (size);
  	memcpy (new_stuff, stuff, size);
  	return new_stuff;
}

void update_filelist(const gchar *path, FileList *list)
{
	FileInfo info;
	DIR *dirh;
	struct dirent *dirp;
	struct passwd *pwd;
	struct group *grp;
	gchar *dir;
	gchar *buf;
	gint length;
	gchar buffer[256];
	gchar *row[6];
	gint rownr;
	gint count = 0;
	GdkPixmap *pixmapfile,*pixmapfolder;
    GdkBitmap *mask;
	GString *fullpath = g_string_new("");
	GString *filename = g_string_new("");
	GString *size = g_string_new("");
	
	pixmapfolder = gdk_pixmap_create_from_xpm_d(app.main_window->window,&mask,0,folder_xpm);
	pixmapfile = gdk_pixmap_create_from_xpm_d(app.main_window->window, &mask,0,file_xpm);
	dir = parsepath(path);
	chdir(dir);

	if ((dirh = opendir(dir)) == NULL)
	{
		statusbar_print(" Error opening: %s - %s",dir,strerror(errno));
		return;
	}
	gtk_clist_freeze(GTK_CLIST(list->clist));
	gtk_clist_unselect_all (GTK_CLIST (list->clist));
  	gtk_clist_clear (GTK_CLIST (list->clist));

	/* Add all files/dirs */
	while ((dirp = readdir (dirh)) != NULL)
	{
		
		FileInfo *info2;

		if (STREQ (dirp->d_name, "."))
			continue;
		if (strcmp(dir,"/"))
			g_string_sprintf(fullpath,"%s/%s",dir,dirp->d_name);
		else
			g_string_sprintf(fullpath,"/%s",dirp->d_name);
		
		lstat(fullpath->str, &(info.statbuf));
		info.filename = malloc(strlen(dirp->d_name)+5);
		sprintf(info.filename,"%s",dirp->d_name);
		if (IS_DIR (&info))
			strcat (info.filename, "/");

		info2 = duplicate (&info, sizeof (FileInfo));
		
		if (info.statbuf.st_size > 1024 * 1024)
			g_string_sprintf(size,"%.2f Mb",(float)info.statbuf.st_size / 1024 / 1024);
		else if (info.statbuf.st_size > 10240)
			g_string_sprintf(size,"%.2f Kb",(float)info.statbuf.st_size / 1024);
		else
			g_string_sprintf(size,"%d bytes",(int)info.statbuf.st_size);
		
			g_string_sprintf(filename,"%s",info.filename);
		
		if ((pwd = getpwuid(info.statbuf.st_uid)) == NULL)
			row[2] = "Unavailable";
		else
			row[2] = pwd->pw_name;

		if ((grp = getgrgid(info.statbuf.st_gid)) == NULL)
			row[3] = "Unavailable";
		else
			row[3] = grp->gr_name;
		switch (info.statbuf.st_mode & S_IFMT)
		{
			case S_IFLNK:
				if (config.expand_links == 1)
				{
					gchar *buffer = malloc(256);
					readlink(dirp->d_name,buffer,256);
					buffer[strlen(buffer)] = '\0';
					g_string_sprintf(filename,"%s -> %s",info.filename,buffer);
				}
				break;
		}

		row[0] = filename->str;
		row[1] = size->str;
		row[4] = get_perms(info2->statbuf.st_mode);
		row[5] = fullpath->str;

		rownr = gtk_clist_append(GTK_CLIST(list->clist),row);
		gtk_clist_set_row_data_full(GTK_CLIST (list->clist), rownr,info2,free_clist_row_data);
		switch (info2->statbuf.st_mode & S_IFMT)
		{
		case S_IFLNK:
			gtk_clist_set_foreground( GTK_CLIST(list->clist),count, &color_lnk);
			gtk_clist_set_pixtext(GTK_CLIST(list->clist),count,0,filename->str,5,pixmapfolder,mask);
			break;
		case S_IFDIR:
			gtk_clist_set_pixtext(GTK_CLIST(list->clist),count,0,filename->str,5,pixmapfolder,mask);
			gtk_clist_set_foreground( GTK_CLIST(list->clist),count, &color_dir);
			break;
		case S_IFREG:
			gtk_clist_set_pixtext(GTK_CLIST(list->clist),count,0,filename->str,5,pixmapfile,mask);
			gtk_clist_set_foreground( GTK_CLIST(list->clist),count, &color_reg);
			if (S_ISEXE (info2->statbuf.st_mode))
				gtk_clist_set_foreground( GTK_CLIST(list->clist),count,&color_exe);
			break;
		}
		count++;
	}
	gtk_clist_set_selectable(GTK_CLIST(list->clist),0,0);
	gtk_clist_get_text(GTK_CLIST(list->clist),0,5,&buf);
	list->selectedfile = buf;
	list->workingdir = strdup(dir);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(list->cmb_dir)->entry),dir);
	gtk_clist_sort(GTK_CLIST(list->clist));
	gtk_clist_set_column_width(GTK_CLIST(list->clist),1,gtk_clist_optimal_column_width(GTK_CLIST(list->clist),1));
	gtk_clist_set_column_width(GTK_CLIST(list->clist),2,gtk_clist_optimal_column_width(GTK_CLIST(list->clist),2));
	gtk_clist_set_column_width(GTK_CLIST(list->clist),3,gtk_clist_optimal_column_width(GTK_CLIST(list->clist),3));
	gtk_clist_set_column_width(GTK_CLIST(list->clist),4,gtk_clist_optimal_column_width(GTK_CLIST(list->clist),4));
	gtk_clist_thaw(GTK_CLIST(list->clist));
	
}

gchar *parsepath(const gchar *path)
{
	gchar *temp = malloc(strlen(path));
	gchar *parse;
	gchar *parse2;
	gchar *strip;
	gint count = 0;
	gint a;
	
	temp = strdup(path);

	if (temp[0] == '~')
		temp = expandpath(strdup(temp));

	for (a = strlen(temp)-1; a >= 0; a--)
	{
		if (temp[a] == '/')
		{
			temp[a] = 0;
		}
		else break;
	}

	if ((parse2 = strstr(temp,"..")))
	{
		while ((parse = strstr(parse2+1,"..")))
		{
			parse2 = strdup(parse);
			count++;
		}

		for (a = 0; a<count+1; a++)
		{
			if ((strip = strrchr(temp,'/')))
				*strip = 0;
			if ((strip = strrchr(temp,'/')))
				*strip = 0;
		}
	}
	if (strcmp(temp,"") == 0)
			strcpy(temp,"/");
	return temp;
}

gchar *expandpath(const gchar *path)
{
	char *tmp;
	char *homedir;
	tmp = strdup(path);

	tmp++;

	/* no ~ in string */
    if (strlen(path) == 0 || path[0] != '~')
       return (char *)tmp;

	/* string is only a ~, return homedir */
	if (strlen(path) == 1) {
		if (!(homedir = getenv("HOME"))) {
			struct passwd *pwd;
			if ((pwd = getpwuid(getuid()))) {
				homedir = pwd->pw_dir;
			}
		}
		return homedir;
	}
	/* string is a ~ followed by a dir, return homedir + that dir */
	else if (path[1] == '/') {
		char *tmp2 = malloc(strlen(path)+strlen(getenv("HOME"))+5);
		if (!(homedir = getenv("HOME"))) {
			struct passwd *pwd;
			if ((pwd = getpwuid(getuid()))) {
				homedir = pwd->pw_dir;
			}
		}
		strcpy(tmp2,homedir);
		strcat(tmp2,tmp++);
		return tmp2;

	} else {
		/* string is a ~ followed by a username, return that users homedir */
		struct passwd *pwd;
		if ((pwd = getpwnam(tmp))) {
			return(pwd->pw_dir);
		}
	}
	return 0;
}

void statusbar_print(char *fmt,...)
{
	va_list va;
	char buf[1024];
	va_start(va,fmt);
    vsnprintf(buf,sizeof(buf),fmt,va);
    va_end(va);
	gtk_statusbar_push(GTK_STATUSBAR(app.statusbar),1,buf);
}

void handle_file(const gchar *filename, FileList *list)
{
	struct stat tmp;
	gchar *ext,*program;

	stat(filename,&tmp);

	if (S_ISDIR (tmp.st_mode))
	{
		update_filelist(filename,list);
		return;
	}
	
	/*if (S_ISEXE (tmp.st_mode))
	{
		execute_program(filename);
		return;
	}*/
	ext = strrchr(filename,'.');
	if (!ext)
		ext = "";
	program = get_doubleclick_action(++ext);
	if (program)
		execute_program(program);
	else
	{
		create_fileinfo_window(filename,200,200);
		gtk_main();
	}
}
gchar *get_doubleclick_action(gchar *extension)
{
	FILE *fp;
	gchar *strip,*name,*desc,*program,*def;
	gchar buf[256];

	if ((fp = fopen(get_file_extensions_filename(),"r")))
	{
		gchar *parse;
		
		while (fgets(buf,256,fp))
		{
			if ((strip = strchr(buf,'\n')))
				*strip = 0;
			name = strtok(buf,";");
			desc = strtok(NULL,";");
			program = strtok(NULL,";");
			def = strtok(NULL,";");
			
			if (def)
			{
				parse = strtok(name,",");
				if (strcmp(parse,extension) == 0 || strcmp(parse,"*") == 0)
						return parse_program_string(program);
				else
				{
					while ((parse = strtok(NULL,",")))
					{
						if (strcmp(parse,extension) == 0)
							return parse_program_string(program);
					}
				}
			}
		}
		fclose (fp);
	}
	return NULL;

	
}
GList *get_selection(FileList *list, gint row) 
{	
	GList *tmp;
	GList *row_data = NULL;
	gchar *tmpbuf;
	
	for (tmp = GTK_CLIST (list->clist)->selection; tmp != NULL; tmp = tmp->next) 
	{
		gtk_clist_get_text(GTK_CLIST(list->clist),(int)tmp->data,row,&tmpbuf);
		row_data = g_list_append (row_data, tmpbuf);
	}
	return row_data;
}

gchar *get_perms(mode_t mode)
{
	gchar *perm_sets[] =
    { "---", "--x", "-w-", "-wx", "r--", "r-x", "rw-", "rwx" };
  	gint u;
	gint g;
	gint o;
	gchar *buf = malloc(11);

	u = (mode & S_IRWXU) >> 6;
 	g = (mode & S_IRWXG) >> 3;
  	o = (mode & S_IRWXO);
	sprintf (buf, "-%s%s%s", perm_sets[u], perm_sets[g], perm_sets[o]);
	
	if (mode & S_ISVTX)
    	buf[9] = (buf[9] == '-') ? 'T' : 't';
  	if (mode & S_ISGID)
    	buf[6] = (buf[6] == '-') ? 'S' : 's';
  	if (mode & S_ISUID)
    	buf[3] = (buf[3] == '-') ? 'S' : 's';

	if (S_ISLNK (mode))
    	buf[0] = 'l';
  	else if (S_ISDIR (mode))
    	buf[0] = 'd';
  	else if (S_ISBLK (mode))
    	buf[0] = 'b';
  	else if (S_ISCHR (mode))
    	buf[0] = 'c';
  	else if (S_ISFIFO (mode))
    	buf[0] = 'f';
  	else if (S_ISSOCK (mode))
    	buf[0] = 's';
	return buf;
}

char *substr(const char *str, int index, int len)
{
	char *tmpstr = (char *)malloc(len+1);
	int a,b = 0;
	
	for (a = index-1; a<len; a++)
	{
		tmpstr[b] = str[a];
		b++;	
	}
	tmpstr[b] = '\0';
	return tmpstr;	
}

int IS_DIR(FileInfo *info)
{
	if (S_ISDIR (info->statbuf.st_mode))
		return 1;
	if (S_ISLNK (info->statbuf.st_mode))
    {
    	struct stat statbuf;
      	stat (info->filename, &statbuf);
      	if (S_ISDIR (statbuf.st_mode))
			return 1;
    }
  	return 0;
}

int S_ISEXE (mode_t mode)
{
  if ((S_IXUSR & mode) || (S_IXGRP & mode) || (S_IXOTH & mode))
    return 1;
  return 0;
}


void free_clist_row_data (gpointer data)
{
  if (data != NULL)
    free (data);
}

ExtFileInfo get_ext_fileinfo(const char *filename)
{
	ExtFileInfo file;
	struct stat tmp;
	struct passwd *pwd;
	struct group *grp;

	stat(filename,&tmp);
	pwd = getpwuid(tmp.st_uid);
	grp = getgrgid(tmp.st_gid);

	file.owner = pwd->pw_name;
	file.group = grp->gr_name;
	file.size = tmp.st_size;
	file.perms = get_perms(tmp.st_mode);
	
	return file;
}

void recreate_filelists()
{
	gtk_clist_set_column_visibility(GTK_CLIST(app.left.clist),0,config.col1_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.left.clist),1,config.col2_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.left.clist),2,config.col3_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.left.clist),3,config.col4_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.left.clist),4,config.col5_visible);

	gtk_clist_set_column_visibility(GTK_CLIST(app.right.clist),0,config.col1_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.right.clist),1,config.col2_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.right.clist),2,config.col3_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.right.clist),3,config.col4_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(app.right.clist),4,config.col5_visible);
	
	refresh_filelist(focused,TRUE);
	refresh_filelist(notfocused,TRUE);
}

void add_commandhistory(const gchar *text)
{
	app.cmdhistory = g_list_prepend(app.cmdhistory,g_strdup(text));
	gtk_combo_set_popdown_strings(GTK_COMBO(app.cmdline),app.cmdhistory);
}

gchar *parse_program_string(const gchar *program)
{
	gchar *temp,*bla,*bla2,*buf;
	GString *cmd = g_string_new("");
	GList *tmp;
	gint position = 1;
	gint last = 1;
	
	bla2 = strdup(program);
	
	while (1)
	{
		if ((bla = strchr(bla2,'%')))
		{
			temp = substr(program,position,strlen(program)-strlen(bla));
			g_string_append(cmd,temp);
	
			switch ((char)bla[1])
			{
				case 'f':
					create_dialog_with_entry("Argument","Argument: ","",&buf);
					gtk_main ();
					if (!buf)
						return NULL;
					g_string_sprintfa(cmd,"\"%s\"",buf);
					break;
				case '1':
					g_string_sprintfa(cmd,"%s",focused->selectedfile);
					break;
				case 'a':
					tmp = get_selection(focused,5);
					for (; tmp != NULL; tmp = tmp->next) 
					{
						g_string_sprintfa(cmd,"\"%s\" ",(gchar *)tmp->data);
					}
					break;
				case 'w':
					g_string_append(cmd,focused->workingdir);
					break;
				case 'x':
					g_string_append(cmd,config.xterm);
					break;
				default:
					return strdup(program);
					break;
			}
			position = strlen(program)-strlen(bla)+3;
			bla2 = strdup(bla+1);
			last = strlen(bla);
		}
		else
		{
			g_string_append(cmd,substr(program,position,strlen(program)));
			return cmd->str;
		}
	}
}

gint recursive_fcount( gchar *path )
{
    DIR *dirh;
    struct dirent *dirp;
	struct stat tmp;
	gchar *fullp;
	gint count = 0;

	if ((dirh = opendir(path)) == NULL)
		return;
	while ((dirp = readdir(dirh)) != NULL)
	{
		fullp = malloc(strlen(dirp->d_name) + strlen(path) + 2);
		sprintf(fullp,"%s/%s",path,dirp->d_name);
		if (strcmp(dirp->d_name,".") != 0 && strcmp(dirp->d_name,"..") != 0 )
		{
			count++;
		}
		free(fullp);
	}
	closedir(dirh);
	return count;
}

