/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

App app;
GdkColor color_exe;
GdkColor color_dir;
GdkColor color_lnk;
GdkColor color_reg;

int main( int argc, char ** argv )
{
	struct passwd *pwd;
	gchar *dir;
	
	gtk_init(&argc, &argv);
	read_config();
	create_main_window();
	/* Set up startup directories */
	if (strcmp(config.startupdir_left,"CURRENT") == 0) 
		dir = get_current_dir_name();
	else if (strcmp(config.startupdir_left,"HOME") == 0) 
	{
		pwd = getpwuid(getuid());
		dir = pwd->pw_dir;
	}else dir = config.startupdir_left;
	update_filelist(dir,&app.left);
	if (strcmp(config.startupdir_right,"CURRENT") == 0) 
		dir = get_current_dir_name();
	else if (strcmp(config.startupdir_right,"HOME") == 0) 
	{
		pwd = getpwuid(getuid());
		dir = pwd->pw_dir;
	}else dir = config.startupdir_right;
	update_filelist(dir,&app.right);
	
	focused = &app.left;
	sort_list (&app.left, name_sort, GTK_SORT_ASCENDING, 0);
	sort_list (&app.right, name_sort, GTK_SORT_ASCENDING, 0);

	gtk_main();
	return(0);
}

