/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

int filemove( FileList *src, gchar *dest )
{
	struct stat s,d,stmp;
	GList *tmp;
	GString *destination = g_string_new("");
	gint fcount = 0;
	gfloat new_val;
	GtkAdjustment *adj;

	/* 2. Kolla antalet filer i fokuserade kataloger */
	tmp = get_selection(src,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		stat(tmp->data,&stmp);
		if (S_ISDIR (stmp.st_mode))
			fcount += recursive_fcount(tmp->data);
		else
			fcount++;
	}
	/* 3. Skapa progressbar dialog */
	create_fileops_window( "Move" );
	create_fileops_sum_pbar( fcount );
	
	tmp = get_selection(src,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		stat(tmp->data,&s);
		stat(dest,&d);
		if (S_ISDIR (d.st_mode))
			g_string_sprintf(destination,"%s/%s",dest,strrchr(tmp->data,'/')+1);
		else
			g_string_sprintf(destination,"%s",dest);
		
		if ((rename(tmp->data,destination->str)) == -1 )
		{
			if (errno == EXDEV)
			{	
				if (S_ISDIR (s.st_mode))
				{
					if ((dircopy(tmp->data,destination->str)) != -1)		
						/*del(tmp->data);*/
						printf("dir\n");
				}
				else
				{
					if ((filecopy(tmp->data,destination->str)) != -1)
						del(tmp->data);
				}
			}
			else
			{
				statusbar_print(" Error moving %s - %s",tmp->data,strerror(errno));
			}
		}
		else
		{
			new_val = gtk_progress_get_value( GTK_PROGRESS(win.sumpbar)) + 1;
			adj = GTK_PROGRESS (win.sumpbar)->adjustment;
			if (new_val > adj->upper)
    	   		new_val = adj->lower;
			gtk_progress_set_value (GTK_PROGRESS (win.sumpbar), new_val);
		}
	}
	refresh_filelist(focused,FALSE);
	refresh_filelist(notfocused,FALSE);
	destroy_fileops_window();
}
