/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"
#define PDA	1

GtkWidget *perms_window;

GtkWidget *btn_user_read;
GtkWidget *btn_user_write;
GtkWidget *btn_user_exec;

GtkWidget *btn_group_read;
GtkWidget *btn_group_write;
GtkWidget *btn_group_exec;

GtkWidget *btn_others_read;
GtkWidget *btn_others_write;
GtkWidget *btn_others_exec;

GtkWidget *btn_suid;
GtkWidget *btn_sgid;
GtkWidget *btn_sticky;
gint s = 0;

void close_perms_window(GtkWidget *widget);
void set_perms(const gchar *filename);

void set_perms(const gchar *filename)
{
	ExtFileInfo file;
	file = get_ext_fileinfo(strdup(filename));

	if (file.perms[1] == 'r') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_user_read)->child),"r");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_user_read),1);
	}
	if (file.perms[2] == 'w') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_user_write)->child),"w");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_user_write),1);
	}
	if (file.perms[3] == 'x' || file.perms[3] == 's') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_user_exec)->child),"x");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_user_exec),1);
	}

	if (file.perms[4] == 'r') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_group_read)->child),"r");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_group_read),1);
	}
	if (file.perms[5] == 'w') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_group_write)->child),"w");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_group_write),1);
	}
	if (file.perms[6] == 'x' || file.perms[6] == 's') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_group_exec)->child),"x");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_group_exec),1);
	}

	if (file.perms[7] == 'r') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_others_read)->child),"r");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_others_read),1);
	}
	if (file.perms[8] == 'w') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_others_write)->child),"w");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_others_write),1);
	}
	if (file.perms[9] == 'x') {
		gtk_label_set_text(GTK_LABEL(GTK_BIN(btn_others_exec)->child),"x");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_others_exec),1);
	}

	if (file.perms[3] == 's' || file.perms[3] == 'S')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_suid),1);
	if (file.perms[6] == 's' || file.perms[6] == 'S')
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn_sgid),1);
}

void cb_perms_ok(GtkWidget *widget, gpointer data)
{
	gchar *user = malloc(9);
	gchar *group = malloc(9);
	gchar *others = malloc(9);
	gint temp;
	
	/* user */
	strcpy(user,"u");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_user_read));
	if (temp)
		strcat(user,"+r");
	else
		strcat(user,"-r");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_user_write));
	if (temp)
		strcat(user,"+w");
	else
		strcat(user,"-w");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_user_exec));
	if (temp)
		strcat(user,"+x");
	else
		strcat(user,"-x");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_suid));
	if (temp)
		strcat(user,"+s");
	else
		strcat(user,"-s");

	/* group */
	strcpy(group,"g");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_group_read));
	if (temp)
		strcat(group,"+r");
	else
		strcat(group,"-r");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_group_write));
	if (temp)
		strcat(group,"+w");
	else
		strcat(group,"-w");

	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_group_exec));
	if (temp)
		strcat(group,"+x");
	else
		strcat(group,"-x");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_sgid));
	if (temp)
		strcat(group,"+s");
	else
		strcat(group,"-s");
	
	/* others */
	strcpy(others,"o");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_others_read));
	if (temp)
		strcat(others,"+r");
	else
		strcat(others,"-r");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_others_write));
	if (temp)
		strcat(others,"+w");
	else
		strcat(others,"-w");
	temp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(btn_others_exec));
	if (temp)
		strcat(others,"+x");
	else
		strcat(others,"-x");
	file_chmod(data,user,group,others);
	close_perms_window(widget);
}

void close_perms_window(GtkWidget *widget)
{
	gtk_grab_remove (perms_window);
  	gtk_widget_destroy (perms_window);
	gtk_main_quit ();
}

void cb_perms_button(GtkWidget *widget, gpointer data)
{
	gint toggled;
	toggled = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	if (toggled == 1)
		gtk_label_set_text(GTK_LABEL(GTK_BIN(widget)->child),data);
	else 
		gtk_label_set_text(GTK_LABEL(GTK_BIN(widget)->child),"-");
}

void create_perms_window(const gchar *filename, gint xsize, gint ysize)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GtkWidget *frame;
	GtkWidget *button;
	gint policy[3] = {0,0,0};
	ExtFileInfo file;
	file = get_ext_fileinfo((char *)strdup(filename));
	
#ifdef PDA
	perms_window = create_window("Permissions",240,300,policy);
#else
	perms_window = create_window("Permissions",400,260,policy);
#endif
	gtk_signal_connect(GTK_OBJECT(perms_window),"delete-event",
						GTK_SIGNAL_FUNC(close_perms_window),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(perms_window),5);
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(perms_window),vbox);
	gtk_widget_show(vbox);

	/* filename */
	
	frame = create_frame("Filename",vbox,87,40,0,0,5);
	hbox = create_label(strdup(filename),frame);

	hbox2 = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox2,0,0,0);
	gtk_widget_show(hbox2);

	/* owner */
	frame = create_frame("Owner",hbox2,87,40,1,1,0);
	hbox = create_label(file.owner,frame);

	/* group owner */
	frame = create_frame("Group",hbox2,87,40,1,1,0);
	hbox = create_label(file.group,frame);

	hbox2 = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox2,0,0,0);
	gtk_widget_show(hbox2);

	/* user buttons */
	frame = gtk_frame_new("User");
	gtk_box_pack_start(GTK_BOX(hbox2),frame,1,1,0);
	gtk_widget_set_usize(GTK_WIDGET(frame),87,50);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_widget_show(hbox);
	
	btn_user_read = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_user_read),"clicked",
						cb_perms_button,"r");
	gtk_box_pack_start(GTK_BOX(hbox),btn_user_read,1,1,0);
	gtk_widget_show(btn_user_read);

	btn_user_write = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_user_write),"clicked",
						cb_perms_button,"w");
	gtk_widget_show(btn_user_write);
	gtk_box_pack_start(GTK_BOX(hbox),btn_user_write,1,1,0);

	btn_user_exec = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_user_exec),"clicked",
						cb_perms_button,"x");
	gtk_box_pack_start(GTK_BOX(hbox),btn_user_exec,1,1,0);
	gtk_widget_show(btn_user_exec);

	/* group buttons */
	frame = gtk_frame_new("Group");
	gtk_box_pack_start(GTK_BOX(hbox2),frame,1,1,0);
	gtk_widget_set_usize(GTK_WIDGET(frame),87,40);
	gtk_widget_show(frame);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_widget_show(hbox);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	
	btn_group_read = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_group_read),"clicked",
						cb_perms_button,"r");

	gtk_box_pack_start(GTK_BOX(hbox),btn_group_read,1,1,0);
	gtk_widget_show(btn_group_read);

	btn_group_write = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_group_write),"clicked",
						cb_perms_button,"w");

	gtk_box_pack_start(GTK_BOX(hbox),btn_group_write,1,1,0);
	gtk_widget_show(btn_group_write);
	
	btn_group_exec = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_group_exec),"clicked",
						cb_perms_button,"x");
	gtk_box_pack_start(GTK_BOX(hbox),btn_group_exec,1,1,0);
	gtk_widget_show(btn_group_exec);

	/* others buttons */
	frame = gtk_frame_new("Others");
	gtk_box_pack_start(GTK_BOX(hbox2),frame,1,1,0);
	gtk_widget_set_usize(GTK_WIDGET(frame),87,40);
	gtk_widget_show(frame);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_widget_show(hbox);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);

	btn_others_read = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_others_read),"clicked",
						cb_perms_button,"r");
	gtk_box_pack_start(GTK_BOX(hbox),btn_others_read,1,1,0);
	gtk_widget_show(btn_others_read);

	btn_others_write = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_others_write),"clicked",
						cb_perms_button,"w");
	gtk_box_pack_start(GTK_BOX(hbox),btn_others_write,1,1,0);
	gtk_widget_show(btn_others_write);
	
	btn_others_exec = gtk_toggle_button_new_with_label("-");
	gtk_signal_connect(GTK_OBJECT(btn_others_exec),"clicked",
						cb_perms_button,"x");
	gtk_box_pack_start(GTK_BOX(hbox),btn_others_exec,1,1,0);
	gtk_widget_show(btn_others_exec);

	/* Special */
	frame = gtk_frame_new("Special");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
	gtk_widget_set_usize(GTK_WIDGET(frame),87,50);
	gtk_widget_show(frame);
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame),hbox);

	btn_suid = gtk_toggle_button_new_with_label("SUID");
	gtk_box_pack_start(GTK_BOX(hbox),btn_suid,1,1,5);
	gtk_widget_show(btn_suid);

	btn_sgid = gtk_toggle_button_new_with_label("SGID");
	gtk_box_pack_start(GTK_BOX(hbox),btn_sgid,1,1,5);
	gtk_widget_show(btn_sgid);

	btn_sticky = gtk_toggle_button_new_with_label("Sticky");
	gtk_box_pack_start(GTK_BOX(hbox),btn_sticky,1,1,5);
	gtk_widget_show(btn_sticky);

	/* ok,cancel buttons */
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	button = create_button("Cancel",close_perms_window,NULL);
	gtk_widget_set_usize(GTK_WIDGET(button),90,35);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,0);

	button = create_button("OK",cb_perms_ok,strdup(filename));
	gtk_widget_set_usize(GTK_WIDGET(button),90,35);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(button);

	set_perms(filename);
	
	gtk_window_set_position (GTK_WINDOW (perms_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(perms_window);
	gtk_grab_add(perms_window);
	gtk_window_set_transient_for (GTK_WINDOW (perms_window),GTK_WINDOW (app.main_window));

}

