/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

#define PDA 1

FileList *focused;
FileList *notfocused;

static GtkItemFactoryEntry menu_items[] = {
	{ "/_File",         NULL,         NULL, 0, "<Branch>" },
#ifdef PDA
    { "/File/_Info",    NULL, cb_fileinfo, 0, NULL },
	{ "/File/_Permissions",  NULL, cb_perms, 0, NULL },
    { "/File/_Copy",    NULL, cb_file_copy, 0, NULL },
    { "/File/_Move",    NULL, cb_file_move, 0, NULL },
	{ "/File/_MkDir",   NULL, cb_file_mkdir, 0, NULL },
	{ "/File/_Delete",  NULL, cb_file_delete, 0, NULL },
	{ "/File/_Rename",  NULL, cb_file_rename, 0, NULL },
	{ "/File/_Execute", NULL ,cb_file_execute,0,NULL }, 
    { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
    { "/File/Quit",     NULL, gtk_main_quit, 0, NULL },
	{ "/_Select",         NULL,         NULL, 0, "<Branch>" },
	{ "/Select/_All",    NULL, cb_clist_select_all, 0, NULL },
	{ "/Select/_None",   NULL, cb_clist_select_none, 0, NULL },
	{ "/Select/_Invert", NULL, NULL, 0, NULL },
#else
    { "/File/_Info",    "F1", cb_fileinfo, 0, NULL },
	{ "/File/_Permissions",  "F2", cb_perms, 0, NULL },
    { "/File/_Copy",    "F5", cb_file_copy, 0, NULL },
    { "/File/_Move",    "F6", cb_file_move, 0, NULL },
	{ "/File/_MkDir",   "F7", cb_file_mkdir, 0, NULL },
	{ "/File/_Delete",  "F8", cb_file_delete, 0, NULL },
	{ "/File/_Rename",  "F9", cb_file_rename, 0, NULL },
	{ "/File/_Execute", "F3" ,cb_file_execute,0,NULL }, 
    { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
    { "/File/Quit Linux Commander",     "F10", gtk_main_quit, 0, NULL },
	{ "/_Select",         NULL,         NULL, 0, "<Branch>" },
	{ "/Select/_All",    "<control>A", cb_clist_select_all, 0, NULL },
	{ "/Select/_None",   "<control>N", cb_clist_select_none, 0, NULL },
	{ "/Select/_Invert", "<control>I", NULL, 0, NULL },

#endif
	{ "/Select/_Based on pattern", NULL, cb_pattern_select, 0, NULL },
#ifndef PDA
	{ "/_Tools",         NULL,         NULL, 0, "<Branch>" },
	{ "/_Tools/Filesystems info",         NULL,  cb_diskfree, 0, NULL },
	{ "/_Options",      NULL,         NULL, 0, "<Branch>" },
    { "/Options/Preferences",  "<control>P",cb_preferences, 0, NULL },
	{ "/Options/Edit associations",  "<control>E",cb_associate, 0, NULL },
    { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
	{ "/_Help/Help",         NULL,  NULL, 0, NULL },
    { "/_Help/About Linux Commander",   NULL,create_about_window, 0, NULL },
#endif
};

GtkWidget *create_window(gchar *title, int xsize,int ysize, gint policy[3])
{
	GtkWidget *window;
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize(GTK_WIDGET(window), xsize, ysize);
    gtk_window_set_title(GTK_WINDOW(window), title);
	gtk_window_set_policy(GTK_WINDOW(window),policy[0],policy[1],policy[2]);
	return window;
}

void create_main_window()
{
	GtkWidget *scrolled_window;
	GtkWidget *paned = gtk_hpaned_new();
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *menu;
	GtkWidget *btn;
	gchar title[100];
	
	gint policy[3] = { 1,1,1 };
	snprintf(title,99,"Linux Commander %s",VERSION);
#ifdef PDA
	app.main_window = create_window(title,240,300,policy);
#else
	app.main_window = create_window(title,700,600,policy);
#endif	
	
	gtk_signal_connect(GTK_OBJECT(app.main_window),"delete_event",
						GTK_SIGNAL_FUNC(gtk_main_quit),NULL);
	gtk_signal_connect(GTK_OBJECT(app.main_window),"size-allocate",
						cb_window_resize,paned);
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(app.main_window),vbox);
	gtk_widget_show(vbox);

	create_menu (app.main_window, &menu);
	gtk_box_pack_start (GTK_BOX (vbox), menu, 0, 0, 0);
	gtk_widget_show(menu);

	gtk_box_pack_start(GTK_BOX(vbox),paned,1,1,0);
	gtk_widget_show(paned);

	scrolled_window = create_filelist(&app.left,&app.right);
	gtk_paned_add1(GTK_PANED(paned),scrolled_window);
	gtk_widget_show(scrolled_window);

	scrolled_window = create_filelist(&app.right,&app.left);
	gtk_paned_add2(GTK_PANED(paned),scrolled_window);
	gtk_widget_show(scrolled_window);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	app.cmdline = gtk_combo_new();
	gtk_combo_set_use_arrows_always (GTK_COMBO(app.cmdline),1);
	gtk_combo_disable_activate(GTK_COMBO(app.cmdline));
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(app.cmdline)->entry),"activate",
						cb_cmdline_activate,NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(app.cmdline)->entry),"key-press-event",
						cb_cmdline_keypress,NULL);
	gtk_widget_show(app.cmdline);
	gtk_box_pack_start(GTK_BOX(hbox),app.cmdline,1,1,0);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	app.statusbar = gtk_statusbar_new();
	gtk_box_pack_start(GTK_BOX(hbox),app.statusbar,1,1,0);
	gtk_widget_show(app.statusbar);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);
	
#ifdef PDA
	btn = create_button("info",cb_fileinfo,NULL);
#else
	btn = create_button(" F1  Fileinfo ",cb_fileinfo,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif
#ifdef PDA
	btn = create_button("ChMod",cb_perms,NULL);
#else
	btn = create_button(" F2  ChMod ",cb_perms,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif
#ifdef PDA
	btn = create_button("Copy",cb_file_copy,NULL);
#else
	btn = create_button(" F5  Copy ",cb_file_copy,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif
#ifdef PDA	
	btn = create_button("Move",cb_file_move,NULL);
#else
	btn = create_button(" F6  Move ",cb_file_move,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif

#ifdef PDA
	btn = create_button("MkDir",cb_file_mkdir,NULL);
#else
	btn = create_button(" F7  MkDir ",cb_file_mkdir,NULL);
#endif

	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif

#ifdef PDA
	btn = create_button("Delete",cb_file_delete,NULL);
#else
	btn = create_button(" F8  Delete ",cb_file_delete,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif
#ifdef PDA	
	btn = create_button("Rename",cb_file_rename,NULL);
#else
	btn = create_button(" F9  Rename ",cb_file_rename,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif

#ifdef PDA
	btn = create_button("Quit",gtk_main_quit,NULL);
#else
	btn = create_button(" F10  Quit ",gtk_main_quit,NULL);
#endif
	GTK_WIDGET_UNSET_FLAGS(btn, GTK_CAN_DEFAULT);
#ifndef PDA
	gtk_box_pack_start(GTK_BOX(hbox),btn,1,1,0);
#endif

	gtk_widget_show(app.main_window);
	gtk_widget_grab_focus(GTK_WIDGET(app.left.clist));
}

void cb_clist_focus()
{
	gtk_widget_grab_focus(GTK_WIDGET(app.cmdline));
}

GtkWidget *create_filelist( FileList *list, FileList *other )
{
#ifdef PDA
	gchar *titles[6] = { "Filename", "Size", "Owner", "Group", "Perms", "Fullpath" };
#else
	gchar *titles[6] = { "Filename", "Size", "Owner", "Group", "Perms", "Fullpath" };
#endif
	GtkWidget *scrolled_window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	
	list->other = other;
	vbox = gtk_vbox_new(FALSE, 0);
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox),5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,1,0);
	list->cmb_dir = gtk_combo_new();
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(list->cmb_dir)->entry),"activate",
						cb_cmbdir_activate, list);
	gtk_combo_disable_activate(GTK_COMBO(list->cmb_dir));
	gtk_box_pack_start(GTK_BOX(hbox), list->cmb_dir, 1,1,0);
	gtk_widget_show(hbox);
	gtk_widget_show(list->cmb_dir);
	gtk_widget_show(vbox);

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
#ifdef PDA
                                    GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
#else
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
#endif
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,1,1,5);
#ifdef PDA
	list->clist = gtk_clist_new_with_titles( 6, titles);
#else
	list->clist = gtk_clist_new_with_titles( 6, titles);
#endif
	
	gtk_signal_connect (GTK_OBJECT (list->clist), "grab_focus",
						GTK_SIGNAL_FUNC (cb_clist_grab_focus), list); 
	gtk_signal_connect (GTK_OBJECT (list->clist),"key_press_event",
						GTK_SIGNAL_FUNC (cb_clist_keypress),list);
	gtk_signal_connect(GTK_OBJECT(list->clist), "select_row",
	                   	GTK_SIGNAL_FUNC(cb_clist_select_row),list);
	gtk_signal_connect (GTK_OBJECT (list->clist), "button_press_event",
						GTK_SIGNAL_FUNC (cb_clist_button_press), list); 

	gtk_clist_set_row_height (GTK_CLIST(list->clist),16);
#ifdef PDA
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),0,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),1,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),2,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),3,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),4,TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(list->clist),5,TRUE);
#else

	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),0,config.col1_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),1,config.col2_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),2,config.col3_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),3,config.col4_visible);
	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),4,config.col5_visible);

#endif
	gtk_clist_column_titles_passive(GTK_CLIST(list->clist));
#ifndef PDA
	gtk_clist_set_column_visibility(GTK_CLIST(list->clist),5,0);
#endif
    gtk_container_add(GTK_CONTAINER(scrolled_window), list->clist);
	gtk_clist_set_selection_mode(GTK_CLIST(list->clist),GTK_SELECTION_EXTENDED);
    gtk_widget_show(list->clist);
	gtk_widget_show(scrolled_window);
	return(vbox);
}

/* Creates the menubar at the top */
void create_menu( GtkWidget *window, GtkWidget **menubar )
{
	GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;
    gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

    accel_group = gtk_accel_group_new ();
    item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
                                           accel_group);
    gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);

    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

    if (menubar) {
    	*menubar = gtk_item_factory_get_widget (item_factory, "<main>");
	}
}

void sort_list (FileList *list, GtkCListCompareFunc compare_func, GtkSortType direction, gint col)
{
	gtk_clist_set_compare_func (GTK_CLIST (list->clist), compare_func);
  	gtk_clist_set_sort_type (GTK_CLIST (list->clist), direction);
  	gtk_clist_set_sort_column (GTK_CLIST (list->clist), col);
  	gtk_clist_sort (GTK_CLIST (list->clist));
}

gint name_sort (GtkCList *clist, gconstpointer row1, gconstpointer row2)
{
	FileInfo *info1, *info2;
	info1 = ((GtkCListRow *) row1)->data;
	info2 = ((GtkCListRow *) row2)->data;
	if (STREQ (info1->filename, "../"))
    	return (clist->sort_type == GTK_SORT_ASCENDING ? -1 : 1);
  	if (STREQ (info2->filename, "../"))
    	return (clist->sort_type == GTK_SORT_ASCENDING ? 1 : -1);

 	if (IS_DIR (info1))
    {
    	if (IS_DIR (info2))
			return strcmp (info1->filename, info2->filename);
      	else
			return (clist->sort_type == GTK_SORT_ASCENDING ? -1 : 1);
    }

  	if (IS_DIR (info2))
    	return (clist->sort_type == GTK_SORT_ASCENDING ? 1 : -1);
  	return strcmp (info1->filename, info2->filename);
}

/* Creates popup menu based on extension of selected filename */
GtkWidget *create_popup( GtkWidget  *window) 
{
	GtkWidget *menu, *menu_select,*menu_programs;
	GtkWidget *menu_item;
	struct stat tmp;
	gchar buf[256];
	FILE *fp;
	gchar *ext;
	gchar *name,*desc,*program,*strip;

	stat(focused->selectedfile,&tmp);
	
	menu = gtk_menu_new();
	if (config.addfilenametopopup == 1) 
	{
		add_menu_item(menu, focused->selectedfile, NULL, NULL);
		add_menu_separator(menu);
	}
	menu_select = gtk_menu_new();
	add_menu_item(menu_select, "All", cb_clist_select_all, NULL);
	add_menu_item(menu_select, "None", cb_clist_select_none, NULL);
	add_menu_item(menu_select, "Invert", cb_clist_select_invert, NULL);
	add_menu_item(menu_select, "Based on pattern", cb_pattern_select, NULL);
	menu_item = add_menu_item(menu, "Select", NULL, NULL);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu_select);

	menu_programs = gtk_menu_new();
	add_menu_item(menu_programs,"Edit associations",cb_associate,NULL);
	add_menu_separator(menu_programs);
	ext = strrchr(focused->selectedfile,'.');
	if (!ext)
		ext = "";
	ext++;
	if ((fp = fopen(get_file_extensions_filename(),"r")))
	{
		gchar *parse;
		
		while (fgets(buf,256,fp))
		{
			if ((strip = strchr(buf,'\n')))
				*strip = 0;
			name = strtok(buf,";");
			desc = strtok(NULL,";");
			program = strtok(NULL,";");

			parse = strtok(name,",");
			if (strcmp(parse,ext) == 0 || strcmp(parse,"*") == 0)
			{
				menu_item =	add_menu_item(menu_programs,desc,NULL,NULL);
				gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate",
       		    							GTK_SIGNAL_FUNC (cb_popup_execute_program), 
											(gpointer) g_strdup(program));		
			}
			else
			{
				while ((parse = strtok(NULL,",")))
				{
					if (strcmp(parse,ext) == 0)
					{
						menu_item =	add_menu_item(menu_programs,desc,NULL,NULL);
						gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate",
       		    									GTK_SIGNAL_FUNC (cb_popup_execute_program), 
													(gpointer) g_strdup(program));		
					}
				}
			}
		}
		fclose (fp);
	}

	menu_item = add_menu_item(menu, "User-defined", NULL, NULL);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu_programs);

	add_menu_separator(menu);
	add_menu_item(menu, "Open with...", cb_openwith, NULL);
	add_menu_item(menu, "File info", cb_fileinfo, NULL);
	add_menu_item(menu, "Permissions", cb_perms, NULL);
	add_menu_separator(menu);
	if (S_ISEXE (tmp.st_mode) && !S_ISDIR (tmp.st_mode))
	{
		add_menu_item(menu, "Execute", cb_file_execute, NULL);
		add_menu_item(menu, "Execute in xterm", cb_file_execute_in_xterm, NULL);
	}
	add_menu_item(menu, "Copy", cb_file_copy, NULL);
	add_menu_item(menu, "Move", cb_file_move, NULL);
	add_menu_item(menu, "Delete", cb_file_delete, NULL);
	add_menu_item(menu, "Rename", cb_file_rename, NULL);
	add_menu_separator(menu);
	add_menu_item(menu, "Make directory", cb_file_mkdir, NULL);
	add_menu_item(menu, "Create tar.gz archive", cb_create_tar_archive, NULL);

	add_menu_separator(menu);
	add_menu_item(menu, "Quit Linux Commander", gtk_main_quit, NULL);
	return menu;
}

GtkWidget *add_menu_separator (GtkWidget *menu)
{
  	GtkWidget *menu_item;
  	menu_item = gtk_menu_item_new ();
  	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
  	gtk_widget_set_sensitive (GTK_WIDGET (menu_item), FALSE);

  	return menu_item;
}

GtkWidget *add_menu_item (GtkWidget *menu,gchar *label, GtkSignalFunc func, gpointer data)
{
	GtkWidget *menu_item;
  	menu_item = gtk_menu_item_new_with_label (label);
  	gtk_signal_connect (GTK_OBJECT (menu_item), "activate", func, data);
  	gtk_menu_append (GTK_MENU (menu), menu_item);
  	gtk_widget_show (menu_item);
  	return menu_item;
}

/* General button-creation function */
/* connects signal "clicked" with func */
GtkWidget *create_button(gchar *title,GtkSignalFunc func, gpointer data)
{
	GtkWidget *button;
	button = gtk_button_new_with_label(title);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",func,data);
	gtk_widget_show(button);
	return button;
}

/* General entry-creation function */
/* connects signal "activate" with func */
GtkWidget *create_entry(gchar *text,gint maxlen,GtkSignalFunc func, gpointer data)
{
	GtkWidget *entry;
	entry = gtk_entry_new_with_max_length(maxlen);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	gtk_signal_connect(GTK_OBJECT(entry),"activate",func,data);
	gtk_widget_show(entry);
	return entry;
}
