/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "image.h"
#include "xsoldier.h"
#include "manage.h"
#include "opening.h"
#include "game.h"
#include "ending.h"
#include "player.h"
#include "boss.h"
#include "enemy.h"
#include "key.h"
#include "star.h"
#include "score.h"

#ifdef JSTK
#include "joystick.h"
#endif

#define EXTERN_DEF /*** ѿ ***/
#include "extern.h"

/*** ؿ ***/
static void arginit(int argc, char *argv[]);
static void usage(void);

static void init(void);
static void clean(void);
static void sig_handle(void);

/*** դ뤰Ф ***/
static char command[32];
static char display[32] = {'\0'};
static int scoreOK = True;
static int putscore = False;
static int colormap = True;
static int w_time = -1;

int main(int argc, char *argv[])
{
    arginit(argc,argv);

    player = NewPlayerData();
    if (putscore == True)
    {
	int i;
	printf("      --- top 10 soldiers ---\n");
	printf("Name                 Stage Score\n",command);
	for (i=1; i<=10; i++)
	    printf("%-20s %02d-%02d %08d\n",
		   player->Rec[i].name,
		   player->Rec[i].loop,player->Rec[i].stage,
		   player->Rec[i].score);

	exit(0);
    }
    if (scoreOK == False)
	fprintf(stderr,"caution: no ranking mode!\n");

    init();
    manage = NewManage(64,256);

    XMapWindow(dpy,win);
    XMapWindow(dpy,root);

    XFlush(dpy);

    while (1)
    {
	keymask = 0;

	player->Rec[0].score = 0;
#ifdef PDA
	player->Ships = 8;
#else
	player->Ships = 5;
#endif
	player->Next = FIRST1UP;
	manage->Loop = 1;

	if (Opening() == -1)
	    break;

	while (1)
	{
	    keymask = 0;
	    ResetManage(manage);

	    if (mainLoop() == 0)
		break;/*** ४С ***/
	    Ending();
	    manage->Loop++;
	}

	if (scoreOK == True)
	{
	    if (ReadHiscore(player) > 0)
		WriteHiscore(player);
	}
    }

    DeleteManage(manage);
    clean();
    return 0;
}

static void arginit(int argc, char *argv[])
{
    char *argv0;
    int i;

    if ((argv0=strrchr(argv[0],'/')) != NULL)
        argv0++;
    else
        argv0 = argv[0];
    strcpy(command,argv0); /*** ޥ̾ȥԡ ***/

    for (i=1; i<argc; i++)
    {
	if ((strcmp(argv[i],"-display")==0) || (strcmp(argv[i],"-d")==0))
	{
	    if (i < argc-1)
		strcpy(display,argv[i+1]);
	}
        else if ((strcmp(argv[i],"-wait")==0) || (strcmp(argv[i],"-w")==0))
	{
	    if (i < argc-1)
	    {
		w_time = atoi(argv[i+1]);
		scoreOK = False;
	    }
	}
        else if ((strcmp(argv[i],"-cmap")==0) || (strcmp(argv[i],"-c")==0))
	    colormap = False;
        else if ((strcmp(argv[i],"-score")==0) || (strcmp(argv[i],"-s")==0))
	    putscore = True;
        else if ((strcmp(argv[i],"-help")==0) || (strcmp(argv[i],"-h")==0))
            usage();
    }
}

static void usage(void)
{
    fprintf(stderr,"Usage: %s [-display <name>] [-wait <n>] [-cmap] [-score] [-help]\n",command);
    fprintf(stderr,"\t display <name>   ... name of the X server to play game.\n");
    fprintf(stderr,"\t wait <n>         ... set wait time. (no ranking) <default is %d>\n",WAIT);
    fprintf(stderr,"\t cmap             ... use default colormap.\n");
    fprintf(stderr,"\t score            ... print top 10 soldiers.\n");
    fprintf(stderr,"\t help             ... this message.\n");
    exit(0);
}

static void init(void)
{/*** ѿ ***/
    struct itimerval value, ovalue;
    struct sigaction sig_act;

    XColor blackTrue;
    XColor whiteTrue;
    XSizeHints sh;

#ifdef JSTK
    initJS();
    /*** 祤ƥå ***/
#endif

    /***  ***/
    signal_delivered = 1;
    if (w_time < 0)
	waittime = WAIT;
    else
	waittime = w_time;

    memset(&sig_act, 0, sizeof(sig_act));
    sig_act.sa_handler = sig_handle;
    sigaction(SIGALRM, &sig_act, 0);
    value.it_interval.tv_sec = 0;
    value.it_interval.tv_usec = waittime;
    value.it_value.tv_sec = 0;
    value.it_value.tv_usec = waittime;
    setitimer(ITIMER_REAL, &value, &ovalue);

    keymask = 0;
#ifdef PDA
    FieldW = 228;
    FieldH = 292;
#else
    FieldW = 500;
    FieldH = 650;
#endif

#ifdef DEBUG
    fprintf(stderr,"xinit: initializing X Window ...\n");
#endif
    /*** X  ***/
    dpy        = XOpenDisplay(display);
    if (dpy == NULL)
    {
	fprintf(stderr,"init: [%s] can't open display.\n",display);
	exit(1);
    }

    if (colormap == False)
	cmap = XDefaultColormap(dpy,0);
    else
	cmap       = XCreateColormap(dpy,RootWindow(dpy,0),DefaultVisual(dpy,0),AllocNone);

    XAllocNamedColor(dpy,cmap,"black",&black,&blackTrue);
    XAllocNamedColor(dpy,cmap,"white",&white,&whiteTrue);

#ifdef PDA
    root       = XCreateSimpleWindow(dpy,RootWindow(dpy,0),0,0,FieldW+8,FieldH+8,0,white.pixel,black.pixel);
#else
    root       = XCreateSimpleWindow(dpy,RootWindow(dpy,0),0,0,FieldW+20,FieldH+20,0,white.pixel,black.pixel);
#endif

    if (colormap == False)
	XSetWindowColormap(dpy,root,cmap);

    XSetWindowColormap(dpy,root,cmap);
    XSelectInput(dpy,root,ExposureMask|EnterWindowMask|LeaveWindowMask|KeyPressMask|KeyReleaseMask);
    XStoreName(dpy,root,"xsoldier");
    sh.flags = (PMaxSize | PMinSize);
#ifdef PDA
    sh.min_width = FieldW + 8;
    sh.min_height = FieldH + 8;
    sh.max_width = FieldW + 8;
    sh.max_height = FieldH + 8;
#else
    sh.min_width = FieldW + 20;
    sh.min_height = FieldH + 20;
    sh.max_width = FieldW + 20;
    sh.max_height = FieldH + 20;
#endif
    XSetWMNormalHints(dpy,root,&sh);

#ifdef PDA
    win        = XCreateSimpleWindow(dpy,root,3,3,FieldW,FieldH,1,white.pixel,black.pixel);
#else
    win        = XCreateSimpleWindow(dpy,root,10,10,FieldW,FieldH,1,white.pixel,black.pixel);
#endif
    XSelectInput(dpy,win,ExposureMask|EnterWindowMask|KeyPressMask|KeyReleaseMask);

    WorkPixmap = XCreatePixmap(dpy,win,FieldW,FieldH,DefaultDepth(dpy,0));

#ifdef PDA
    font       = XLoadFont(dpy,"-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1");
#else
    font       = XLoadFont(dpy,"-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1");
#endif
    FontGC     = XCreateGC(dpy,root,0,0);
    XSetGraphicsExposures(dpy,FontGC,False);
    XSetForeground(dpy,FontGC,white.pixel);
    XSetFont(dpy,FontGC,font);

    BackGC       = XCreateGC(dpy,WorkPixmap,0,0);
    XSetGraphicsExposures(dpy,BackGC,False);
    XSetForeground(dpy,BackGC,black.pixel);

    FillGC       = XCreateGC(dpy,WorkPixmap,0,0);
    XSetGraphicsExposures(dpy,FillGC,False);
    XSetForeground(dpy,FillGC,white.pixel);

    upKey    = XKeysymToString(UpKey);
    downKey  = XKeysymToString(DownKey);
    leftKey  = XKeysymToString(LeftKey);
    rightKey = XKeysymToString(RightKey);
    shotKey  = XKeysymToString(ShotKey);
    spdupKey = XKeysymToString(SpeedUPKey);
    spdwnKey = XKeysymToString(SpeedDOWNKey);
    pauseKey = XKeysymToString(PauseKey);
    quitKey  = XKeysymToString(QuitKey);

#ifdef DEBUG
    fprintf(stderr,"done.\n");
    fprintf(stderr,"xinit: initializing Image ...\n");
#endif
    /*** ᡼ ***/
    PlayerImage = ImageInit(PIXMAP "/Player.xpm" GZ,6);
    PShot1Image  = ImageInit(PIXMAP "/PlayerShot1.xpm" GZ,2);
    PShot2Image  = ImageInit(PIXMAP "/PlayerShot2.xpm" GZ,2);
    PShot3Image  = ImageInit(PIXMAP "/PlayerShot3.xpm" GZ,3);

    EShotImage  = ImageInit(PIXMAP "/EnemyShot.xpm" GZ,4);
    ELaserImage  = ImageInit(PIXMAP "/EnemyLaser.xpm" GZ,1);
    EMissileImage  = ImageInit(PIXMAP "/EnemyMiss.xpm" GZ,8);
    EBoundImage = ImageInit(PIXMAP "/EnemyBound.xpm" GZ,8);
    ERingImage = ImageInit(PIXMAP "/EnemyRing.xpm" GZ,4);

    BombImage   = ImageInit(PIXMAP "/ExpSmall.xpm" GZ,5);
    LargeBombImage= ImageInit(PIXMAP "/ExpLarge.xpm" GZ,5);

    Enemy1Image = ImageInit(PIXMAP "/Enemy1.xpm" GZ,8);
    Enemy2Image = ImageInit(PIXMAP "/Enemy2.xpm" GZ,8);
    Enemy3Image = ImageInit(PIXMAP "/Enemy3.xpm" GZ,8);
    Enemy4Image = ImageInit(PIXMAP "/Enemy4.xpm" GZ,8);
    Enemy5Image = ImageInit(PIXMAP "/Enemy5.xpm" GZ,4);
    Enemy6Image = ImageInit(PIXMAP "/Enemy6.xpm" GZ,6);
    Enemy7Image = ImageInit(PIXMAP "/Enemy7.xpm" GZ,1);

    Boss1Image = ImageInit(PIXMAP "/Boss1.xpm" GZ,1);
    Boss2Image = ImageInit(PIXMAP "/Boss2.xpm" GZ,1);
    Boss3Image = ImageInit(PIXMAP "/Boss3.xpm" GZ,1);
    Boss4Image = ImageInit(PIXMAP "/Boss4.xpm" GZ,1);
    Boss5Image = ImageInit(PIXMAP "/Boss5.xpm" GZ,1);
    Boss6Image = ImageInit(PIXMAP "/Boss6.xpm" GZ,2);
    Boss7Image = ImageInit(PIXMAP "/Boss7.xpm" GZ,1);

    ItemImage = ImageInit(PIXMAP "/Item.xpm" GZ,4);
    
    /*** Ͽ ***/
    InitStarModule(FieldW,FieldH);
    StarPtn1 = CreateStar(PIXMAP "/Star1.xpm" GZ,4,5,5);
    StarPtn2 = CreateStar(PIXMAP "/Star2.xpm" GZ,4,10,10);

#ifdef DEBUG
    fprintf(stderr,"done.\n");
#endif

    srandom((unsigned)time(NULL));
}

static void clean(void)
{/*** ѿ ***/
    FreeImages(PlayerImage,6);
    FreeImages(PShot1Image,2);
    FreeImages(PShot2Image,2);
    FreeImages(PShot3Image,3);

    FreeImages(EShotImage,4);
    FreeImages(ELaserImage,1);
    FreeImages(EMissileImage,8);
    FreeImages(EBoundImage,8);
    FreeImages(ERingImage,4);

    FreeImages(BombImage,5);
    FreeImages(LargeBombImage,5);

    FreeImages(Enemy1Image,8);
    FreeImages(Enemy2Image,8);
    FreeImages(Enemy3Image,8);
    FreeImages(Enemy4Image,8);
    FreeImages(Enemy5Image,4);
    FreeImages(Enemy6Image,6);
    FreeImages(Enemy7Image,1);

    FreeImages(Boss1Image,1);
    FreeImages(Boss2Image,1);
    FreeImages(Boss3Image,1);
    FreeImages(Boss4Image,1);
    FreeImages(Boss5Image,1);
    FreeImages(Boss6Image,2);
    FreeImages(Boss7Image,1);

    FreeImages(ItemImage,4);

    XAutoRepeatOn(dpy);
    XFlush(dpy);
    XCloseDisplay(dpy);
#ifdef DEBUG
    fprintf(stderr,"xclean: clean up\n");
#endif
}

static void sig_handle(void)
{
    signal_delivered = 1;
}
