/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "image.h"
#include "xsoldier.h"
#include "extern.h"
#include "key.h"
#include "star.h"
#include "version.h"

#ifdef JSTK
#include "joystick.h"
#endif

int Opening(void)
{
    Image **Title;
    int count = 0;

    Title = ImageInit(PIXMAP "/Title.xpm" GZ,1);

    while(1)
    {
        if (waittime && (signal_delivered==0))
	    pause();
        signal_delivered = 0;

	if (count < 500)
	    count++;
	else
	    count = 0;

	while(XPending(dpy))
	{
	    XNextEvent(dpy,&event);
	    switch(event.type)
	    {
	      case Expose:
		/***
		  if (e.xexpose.count == 0)
		  ;
		  ***/
		break;
	      case EnterNotify:
		XAutoRepeatOff(dpy);
		break;
	      case LeaveNotify:
		XAutoRepeatOn(dpy);
		break;
	      case KeyPress:
                if (XLookupKeysym(&(event.xkey),0) == XK_space)
		{
		    FreeImages(Title,1);
		    return 1;
		}
                if (XLookupKeysym(&(event.xkey),0) == QuitKey)
		{
		    FreeImages(Title,1);
		    return -1;
		}
	    }
	}
	
#ifdef JSTK
	readJS();
	if ((joymask&Shot) || (joymask&SpeedUP))	
	{
	    FreeImages(Title,1);
	    return 1;
	}
#endif

	XFillRectangle(dpy,WorkPixmap,BackGC,0,0,FieldW,FieldH);
	DrawStar(StarPtn1);
	DrawStar(StarPtn2);

#ifdef PDA
	PutImage(Title[0],18,25);

	XDrawString(dpy,WorkPixmap,FontGC,162,115,"Ver. " VERSION,strlen("Ver. " VERSION));
	XDrawString(dpy,WorkPixmap,FontGC,156,130,UPDATE,strlen(UPDATE));

	if (count%30 < 15)
	{
	    XDrawString(dpy,WorkPixmap,FontGC,45,288,"Press [SPACE KEY] to start",strlen("Press [SPACE KEY] to start"));
#ifdef JSTK
	    XDrawString(dpy,WorkPixmap,FontGC,45,288,"Press [Joystick BUTTON] to start",strlen("Press [Joystick BUTTON] to start"));
#endif
	}

	if (count < 250)
	{
	    char buff[64];
	    int i;
	    XDrawString(dpy,WorkPixmap,FontGC,70,150,"Top 5 Soldiers",strlen("Top 5 Soldiers"));

	    XDrawString(dpy,WorkPixmap,FontGC,20,170,"Name",strlen("Name"));
	    XDrawString(dpy,WorkPixmap,FontGC,100,170,"Stage",strlen("Stage"));
	    XDrawString(dpy,WorkPixmap,FontGC,160,170,"Score",strlen("Score"));
	    for (i=1; i<=5; i++)
	    {
		XDrawString(dpy,WorkPixmap,FontGC,20,172+i*18,player->Rec[i].name,strlen(player->Rec[i].name));
		sprintf(buff,"%02d-%02d",player->Rec[i].loop,player->Rec[i].stage);
		XDrawString(dpy,WorkPixmap,FontGC,100,172+i*18,buff,strlen(buff));
		sprintf(buff,"%08d",player->Rec[i].score);
		XDrawString(dpy,WorkPixmap,FontGC,160,172+i*18,buff,strlen(buff));
	    }
	}
	else
	{
	    XDrawString(dpy,WorkPixmap,FontGC,80,140,"How To Play",strlen("How To Play"));

	    XDrawString(dpy,WorkPixmap,FontGC,40,155,"Up",strlen("Up"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,155," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,155,upKey,strlen(upKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,170,"Down",strlen("Down"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,170," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,170,downKey,strlen(downKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,185,"Left",strlen("Left"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,185," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,185,leftKey,strlen(leftKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,200,"Right",strlen("Right"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,200," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,200,rightKey,strlen(rightKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,215,"Shot",strlen("Shot"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,215," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,215,shotKey,strlen(shotKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,230,"Speed up",strlen("Speed up"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,230," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,230,spdupKey,strlen(spdupKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,245,"Speed down",strlen("Speed down"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,245," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,245,spdwnKey,strlen(spdwnKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,260,"Pause",strlen("Pause"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,260," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,260,pauseKey,strlen(pauseKey));

	    XDrawString(dpy,WorkPixmap,FontGC,40,275,"Quit",strlen("Quit"));
	    XDrawString(dpy,WorkPixmap,FontGC,120,275," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,160,275,quitKey,strlen(quitKey));
	}
#else
	PutImage(Title[0],50,50);

	XDrawString(dpy,WorkPixmap,FontGC,410,210,"Ver. " VERSION,strlen("Ver. " VERSION));
	XDrawString(dpy,WorkPixmap,FontGC,410,225,UPDATE,strlen(UPDATE));

	if (count%30 < 15)
	{
	    XDrawString(dpy,WorkPixmap,FontGC,170,630,"Press [SPACE KEY] to start",strlen("Press [SPACE KEY] to start"));
#ifdef JSTK
	    XDrawString(dpy,WorkPixmap,FontGC,155,610,"Press [Joystick BUTTON] to start",strlen("Press [Joystick BUTTON] to start"));
#endif
	}

	if (count < 250)
	{
	    char buff[64];
	    int i;
	    XDrawString(dpy,WorkPixmap,FontGC,210,270,"Top 10 Soldiers",strlen("Top 10 Soldiers"));

	    XDrawString(dpy,WorkPixmap,FontGC,120,320,"Name",strlen("Name"));
	    XDrawString(dpy,WorkPixmap,FontGC,270,320,"Stage",strlen("Stage"));
	    XDrawString(dpy,WorkPixmap,FontGC,350,320,"Score",strlen("Score"));
	    for (i=1; i<=10; i++)
	    {
		XDrawString(dpy,WorkPixmap,FontGC,120,330+i*25,player->Rec[i].name,strlen(player->Rec[i].name));
		sprintf(buff,"%02d-%02d",player->Rec[i].loop,player->Rec[i].stage);
		XDrawString(dpy,WorkPixmap,FontGC,270,330+i*25,buff,strlen(buff));
		sprintf(buff,"%08d",player->Rec[i].score);
		XDrawString(dpy,WorkPixmap,FontGC,350,330+i*25,buff,strlen(buff));
	    }
	}
	else
	{
	    XDrawString(dpy,WorkPixmap,FontGC,220,270,"How To Play",strlen("How To Play"));

	    XDrawString(dpy,WorkPixmap,FontGC,180,330,"Up",strlen("Up"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,330," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,330,upKey,strlen(upKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,355,"Down",strlen("Down"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,355," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,355,downKey,strlen(downKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,380,"Left",strlen("Left"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,380," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,380,leftKey,strlen(leftKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,405,"Right",strlen("Right"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,405," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,405,rightKey,strlen(rightKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,430,"Shot",strlen("Shot"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,430," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,430,shotKey,strlen(shotKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,455,"Speed up",strlen("Speed up"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,455," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,455,spdupKey,strlen(spdupKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,480,"Speed down",strlen("Speed down"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,480," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,480,spdwnKey,strlen(spdwnKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,505,"Pause",strlen("Pause"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,505," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,505,pauseKey,strlen(pauseKey));

	    XDrawString(dpy,WorkPixmap,FontGC,180,530,"Quit",strlen("Quit"));
	    XDrawString(dpy,WorkPixmap,FontGC,260,530," .... ",strlen(" .... "));
	    XDrawString(dpy,WorkPixmap,FontGC,300,530,quitKey,strlen(quitKey));
	}
#endif

	XCopyArea(dpy,WorkPixmap,win,BackGC,0,0,FieldW,FieldH,0,0);
	
	XFlush(dpy);
	XSync(dpy,False);
    }
}
