#ifndef _MBMENU_H_
#define _MBMENU_H_

/* libmb
 * Copyright (C) 2002 Matthew Allum
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "mbpixbuf.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif
#include <X11/xpm.h>
#include <X11/Xresource.h>
#include <X11/extensions/shape.h>
#include <X11/Xatom.h>
#include <X11/keysymdef.h>
#include <X11/keysym.h>
#include <X11/Xmd.h>


#define MAX(x,y) ((x>y)?(x):(y))

#ifdef DEBUG
#define MENUDBG(txt, args... ) fprintf(stderr, "MENU DEBUG: " txt , ##args )
#else
#define MENUDBG(txt, args... ) /* nothing */
#endif

#define WPAD 3  /* Window padding */

#define SCROLL_BUTT_H 10

#define WBW(a) ((a)->border_width) 	/* Window border width */

enum {
  BG_COL,
  FG_COL,
  HL_COL,
  BD_COL,
};

/* flags for adding menus */
#define MBMENU_NO_SORT         (1<<1)
#define MBMENU_PREPEND         (1<<2)


/* for mb_menu_new */
#define MBMENU_FG_COL         (1<<1)
#define MBMENU_BG_COL         (1<<2)
#define MBMENU_HL_COL         (1<<3)
#define MBMENU_BD_COL         (1<<4)
#define MBMENU_FONT           (1<<5)
#define MBMENU_BD_SZ          (1<<6)
#define MBMENU_ICON_SZ        (1<<7)
#define MBMENU_ICON_FN        (1<<8)
#define MBMENU_ICON_FOLDER_FN (1<<9)
#define MBMENU_TRANS          (1<<10)
#define MBMENU_BG_FN          (1<<11)
#define MBMENU_BEVEL          (1<<12)

typedef struct _menu_options
{
  char *fontname;
  char *foreground_col_spec;
  char *background_col_spec;
  char *highlight_col_spec;
  char *border_col_spec;
  int   border_size;
  int   icon_dimention;
  char *default_icon_filename;
  char *default_folder_icon_filename;
  char *bg_img_filename;
  int  transparency_level;
  int  bevel_size;

} MBMenuOptions;

typedef struct _menu
{
#ifdef USE_XFT
  XftDraw *xftdraw;
  XftDraw *shadow_xftdraw;
  XftDraw *active_xftdraw;
  int expose_cnt;
#endif

  char *title;
  struct _menuitem *items;
  struct _menuitem *active_item;
  struct _menuitem *too_big_start_item;
  struct _menuitem *too_big_end_item;
  struct _menuitem *parent_item;
  
  int x;
  int y;
  int width;
  int height;
  int depth;
  
  Window win;
  Pixmap backing; 

  GC mask_gc;
  Bool too_big;

  Pixmap active_item_pxm;
   
} Menu;

enum {
  MBMENU_ITEM_APP,
  MBMENU_ITEM_FOLDER,
  MBMENU_ITEM_SEPERATOR,
};

typedef struct _menuitem
{
  int type;

  char *title;
  void (* cb)( struct _menuitem *item );
  void *cb_data;
  char *info;
  char *icon_fn;
  
  MBPixbufImage *img;
  
  Menu *child;
  struct _menuitem *next_item;
  
  int y;
  int h;
   
} MenuItem;


typedef struct _mbmemu
{
   Display *dpy;
   Window root;
   int screen;
   
#ifdef USE_XFT
   XftFont *xftfont;
   XftColor fg_xftcol;
   XftColor bg_xftcol;
   XftColor hl_xftcol;
   XftColor bd_xftcol;
   XftColor shadow_xftcol; 	/* TOGO */
#else
   XFontStruct* font;
#endif
   XColor   fg_xcol;
   XColor   bg_xcol;
   XColor   hl_xcol;
   XColor   bd_xcol;
  GC gc;
  
  int options;

  int border_width;		/* X window border */
  int inner_border_width; 	/* Non X border */
  XColor border_cols[3];
  int trans;

  int icon_dimention;  /* 0 - no icons, else icon size after scale */
  
  MBPixbuf    *pb;
  MBPixbufImage *img_default_folder;
  MBPixbufImage *img_default_app;
  MBPixbufImage *img_bg;

  
  Pixmap arrow_icon, arrow_mask; /* XXX Togo */
  Pixmap bg_pixmap, bg_pixmap_mask;

  struct _menu *rootmenu;
  Bool xmenu_is_active;
  struct _menu *active[10];
  int active_depth;

  struct _menu *keyboard_focus_menu;

} MBMenu;


typedef void (*MBMenuActivateCB)( MenuItem *item ) ;

MBMenu *
mb_menu_new(Display *dpy, int Screen, 
	    int values_mask, MBMenuOptions *values);

Bool
mb_menu_set_font (MBMenu *mbmenu, 
		  char   *font_desc);

Bool
mb_menu_set_default_icons(MBMenu *mbmenu, char *folder, char *app);

void
mb_menu_set_col(MBMenu *mbmenu, int element, char *col_spec);

void
mb_menu_set_trans(MBMenu *mbmenu, int trans);

void
mb_menu_item_icon_set(MBMenu *mb, MenuItem *item, MBPixbufImage *img);

MenuItem *
mb_menu_add_item_to_menu(MBMenu *mb, 
			 Menu *menu, 
			 char *title, 
			 char *icon, 
			 char *info,
			 void (* cmd)( MenuItem *item ),
			 void *cb_data,
			 int flags);

void mb_menu_item_remove(MBMenu   *mb, Menu *menu, MenuItem *item);

void mb_menu_add_seperator_to_menu(MBMenu *mb, Menu *menu, int flags);


Menu *mb_menu_add_path(MBMenu *mb, char *path, char *icon_path, int flags);

void mb_menu_remove_menu(MBMenu *mb, Menu *menu);

void mb_menu_free(MBMenu *mb);

Bool mb_menu_is_active(MBMenu *mb);

void mb_menu_dump(MBMenu *mb, Menu *menu);

void mb_menu_activate(MBMenu *mb, int x, int y);

void mb_menu_deactivate(MBMenu *mb);

void mb_menu_handle_xevent(MBMenu *mb, XEvent *an_event);



#endif
