#ifndef _PANEL_APP_H_
#define _PANEL_APP_H_

#include "dock.h"

MBPanelApp* panel_app_list_get_prev(MBPanel *panel, MBPanelApp *papp);

MBPanelApp* panel_app_list_get_last(MBPanel *panel);

void panel_app_list_prepend(MBPanel *panel, MBPanelApp *papp_new);

void panel_app_list_append(MBPanel *panel, MBPanelApp *new_client);

void panel_app_list_insert_after(MBPanel *panel, MBPanelApp *papp, 
				 MBPanelApp *new_papp);

void panel_app_list_remove(MBPanel *panel, MBPanelApp *papp);

void panel_app_list_add(MBPanel *panel, MBPanelApp *papp_new);

void panel_app_name_get(MBPanel *panel, MBPanelApp *papp);

Window panel_app_get_client_leader_win(MBPanel *panel, MBPanelApp *papp);

int* panel_app_icon_prop_data_get(MBPanel *d, MBPanelApp *papp);

void panel_app_command_prop_get(MBPanel *panel, MBPanelApp *papp);

Bool panel_app_get_command_str(MBPanel *panel, MBPanelApp *papp, 
			       char **result);

MBPanelApp* panel_app_get_from_window(MBPanel *panel, Window win);

MBPanelApp* panel_app_new(MBPanel *panel, Window win, char *cmd, int x_offset);

void panel_app_handle_configure_request(MBPanel *panel, 
					XConfigureRequestEvent *ev);

void panel_app_deliver_config_event(MBPanel *panel, MBPanelApp *papp);

void panel_app_move_to(MBPanel *panel, MBPanelApp *papp, int origin_offset);

void panel_app_destroy(MBPanel *panel, MBPanelApp *papp);


#if 0 				/* OLD ! */

Client *client_new(Dock *dock, Window win);
void   client_destroy(Dock *dock, Client *c);
Client *client_find(Dock *dock, Window win_to_find);
int client_get_init_x_pos(Dock *d, Client *c);
int client_get_init_y_pos(Dock *d, Client *c);
void client_deliver_config(Dock *dock, Client *c);
void client_handle_configure(Dock *dock, Client *c, XConfigureRequestEvent *ev);
Bool client_get_command_str(Dock *d, Client *c, char *cmd);



Client *client_get_closest_right(Dock *dock, Client *c, int pos);
Client *client_get_furthest_right(Dock *dock);
void client_update(Dock *dock, Client *c);

#endif

#endif
