
#define _GNU_SOURCE 		/* For strndup - probs on BSD ? */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "hash.h"

typedef struct _dotdesktopitem
{
  char *filename;
  char *lang;
  char *lang_country;
  struct hash *h;

} MBDotDesktop;

enum {
  DD_SUCCESS,
  DD_ERROR_FILE_OPEN_FAILED,
  DD_ERROR_NOT_DESKTOP_FILE
};

MBDotDesktop *
mb_dotdesktop_new_from_file(const char *filename);

unsigned char *
mb_dotdesktop_get(MBDotDesktop *dd, char *field);

void
mb_dotdesktop_set(MBDotDesktop        *dd, 
		  const char          *field, 
		  const unsigned char *value);

void
mb_dotdesktop_free(MBDotDesktop *dd);

char*
mb_dot_desktop_icon_get_full_path (char* theme_name, 
				   int   size_wanted, 
				   char* icon_name);


typedef struct _mbdotdesktopfolderentry
{
  unsigned char *name;
  unsigned char *icon;
  unsigned char *match; 	/* XXX regexp  */
  
  struct _mbdotdesktopfolderentry *parent;

} MBDotDesktopFolderEntry;

typedef struct _mbdotdesktopfolders
{

  struct _mbdotdesktopfolderentry **entries;
  int n_entries;

} MBDotDesktopFolders;

#define mb_dot_desktop_folder_entry_get_name(f)  (f)->name 
#define mb_dot_desktop_folder_entry_get_icon(f)  (f)->icon
#define mb_dot_desktop_folder_entry_get_match(f) (f)->match
#define mb_dot_desktop_folders_get_cnt(f)        (f)->n_entries
#define mb_dot_desktop_folders_get_entry(f, n)   (f)->entries[(n)]

MBDotDesktopFolders *mb_dot_desktop_folders_new(const char *vfolder_path);
void mb_dot_desktop_folders_free(MBDotDesktopFolders* folders);

