/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _STRUCTS_H_
#define _STRUCTS_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "mbpixbuf.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#include <locale.h>
#include <langinfo.h>
#endif

#ifdef USE_XSETTINGS
#include <xsettings-client.h>
#endif 

#ifdef USE_LIBSN
#define SN_API_NOT_YET_FROZEN 1
#define MB_SN_APP_TIMEOUT 30 	/* 30 second timeout for app startup */
#include <libsn/sn.h>
#endif


#define TRUE  1
#define FALSE 0

#define APPLY_GRAVITY 1
#define REMOVE_GRAVITY -1

				/* Never Eat Shredded Wheat ;-) */
#define NORTH  1
#define EAST   2
#define SOUTH  3
#define WEST   4


#define DOCK_HEIGHT 16
#define DOCK_MIN_HEIGHT 4

#define STACK_REMOVE 1
#define STACK_ADD   -1

#define BUTTON_NEXT_PRESSED 1
#define BUTTON_PREV_PRESSED 2
#define BUTTON_CLOSE_PRESSED 3

#define MENU_FLAG           (1<<1)
#define SINGLE_FLAG         (1<<2) /* when only a single client */
#define DBL_CLICK_FLAG      (1<<3)
#define TITLE_HIDDEN_FLAG   (1<<4)
#define DESKTOP_RAISED_FLAG (1<<5)
#define STARTUP_FLAG        (1<<6)
#define THEME_SWITCH_FLAG   (1<<7)

#define CLIENT_FULLSCREEN_FLAG    (1<<1)
#define CLIENT_TITLE_HIDDEN_FLAG  (1<<2)
#define CLIENT_SHRUNK_FOR_TB_FLAG (1<<3) /* Set if dialog cover toolbar */
#define CLIENT_HELP_BUTTON_FLAG   (1<<4)
#define CLIENT_ACCEPT_BUTTON_FLAG (1<<5)
#define CLIENT_DOCK_NORTH         (1<<6)
#define CLIENT_DOCK_SOUTH         (1<<7)
#define CLIENT_DOCK_EAST          (1<<8)
#define CLIENT_DOCK_WEST          (1<<9)
#define CLIENT_WANTS_MASK_FLAG    (1<<10)
#define CLIENT_IS_MODAL_FLAG      (1<<11)
#define CLIENT_BORDERS_ONLY_FLAG  (1<<12)

#define ACTIVE   1
#define INACTIVE 2

#define MB_CMD_SET_THEME 1
#define MB_CMD_EXIT      2
#define MB_CMD_DESKTOP   3
#define MB_CMD_NEXT   4
#define MB_CMD_PREV   5

#define Wm wm       /* tmp to avoid breakage */
#define Client client

#define START_CLIENT_LOOP(w,c) (c) = (w)->head_client; do {
#define END_CLIENT_LOOP(w,c)   } while (((c) = (c)->next) \
				        && ((c) != (w)->head_client) );

#define WBW(c) ((c)->wm->mbtheme->wbw)

#ifdef DEBUG
#define dbg(txt, args... ) fprintf(stderr, "DEBUG: " txt "\n", ##args )
#else
#define dbg(txt, args... ) /* nothing */
#endif

#define MAX(x,y) ((x>y)?(x):(y))

enum {
  WINDOW_TYPE_TOOLBAR = 1,
  WINDOW_TYPE_DOCK,
  WINDOW_TYPE_DIALOG,
  WINDOW_TYPE_SPLASH,
  WINDOW_TYPE_DESKTOP,
  
  MB_DOCK_ALIGN,
  MB_DOCK_ALIGN_EAST,
  MB_DOCK_ALIGN_WEST,
  MB_COMMAND,

  MB_CLIENT_EXEC_MAP,
  MB_CLIENT_STARTUP_LIST,
  
  WINDOW_STATE,
  WINDOW_STATE_FULLSCREEN,
  WINDOW_STATE_MODAL,
  
  _NET_SUPPORTED,
  _NET_CLIENT_LIST,
  _NET_NUMBER_OF_DESKTOPS,
  _NET_ACTIVE_WINDOW,
  _NET_SUPPORTING_WM_CHECK,
  
  _NET_CLOSE_WINDOW,
  
  _NET_WM_NAME,
  UTF8_STRING,
  _NET_CLIENT_LIST_STACKING,
  _NET_CURRENT_DESKTOP,
  _NET_WM_DESKTOP,
  _NET_WM_ICON,
  _NET_DESKTOP_GEOMETRY,
  _NET_WORKAREA,
  
  _NET_SHOW_DESKTOP,
  
  _MOTIF_WM_HINTS,

  _NET_WM_CONTEXT_HELP,
  _NET_WM_CONTEXT_ACCEPT,

  _NET_STARTUP_ID,

  _WIN_SUPPORTING_WM_CHECK,
  
  ATOM_COUNT
};

typedef enum { dialog,
	       toolbar,
	       detached, 
	       override,
	       dock,
	       menu,
	       mainwin,
	       desktop  } Client_type;

typedef struct _mb_client_button
{
  Window win;
  int    x;
  int    y;
  int    w;
  int    h;
  void*  data;

} MBClientButton;

typedef struct _client
{
#ifdef USE_XFT
  unsigned char *name;
#else
   char	*name;
#endif
  Bool name_is_utf8;

  unsigned char *startup_id; 		/* for startup notification */
  char *bin_name; 		/* XXX TMP! */

  XSizeHints	*size;
  Window	window, frame, title_frame;
  struct _client *trans;
  Colormap	cmap;
  int		x, y, width, height;
  int		ignore_unmap;

  Pixmap       icon, icon_mask;
#ifndef REDUCE_BLOAT
  int *icon_rgba_data;
#endif

  struct list_item* buttons; 
  
  int flags;
  
  XID          win_group;
  
  Client_type type;
  
#ifdef USE_XFT
    XftDraw     *xftdraw;
#endif

   void (* reparent)( struct _client* c );
   void (* redraw)( struct _client* c, Bool use_cache );
   void (* button_press) (struct _client *c, XButtonEvent *e);
   void (* move_resize)( struct _client* c );
   void (* configure)( struct _client* c );
   void (* get_coverage)( struct _client* c, int* x, int* y, int* h, int* w );
   void (* hide)( struct _client* c );
   void (* show)( struct _client* c );
   void (* iconize)( struct _client* c );
   void (* destroy)( struct _client* c );

  Bool mapped;
  
  struct _client *next;
  struct _client *prev;

  Pixmap backing, backing_mask;
  Bool have_cache, have_set_bg;
   
  void* xtra;
  struct _wm *wm;
  
   
} client;

/* Keyboard config structs */

enum {
  KEY_ACTN_EXEC = 1,
  KEY_ACTN_EXEC_SINGLE,
  KEY_ACTN_EXEC_SN, 		/* Exec with startup notification */
  KEY_ACTN_NEXT_CLIENT,
  KEY_ACTN_PREV_CLIENT,
  KEY_ACTN_CLOSE_CLIENT,
  KEY_ACTN_TOGGLE_DESKTOP,
  KEY_ACTN_TASK_MENU_ACTIVATE,
};

typedef struct _kbdconfig_entry
{
  int    action;
  KeySym key;
  int    ModifierMask;
  char   *sdata;
  int    idata;
  struct _kbdconfig_entry *next_entry;

} MBConfigKbdEntry;

typedef struct _kbdconfig
{
  struct _kbdconfig_entry *entrys;

  int MetaMask, HyperMask, SuperMask, AltMask, ModeMask, 
    NumLockMask, ScrollLockMask;

} MBConfigKbd;

/* main config struct  */

typedef struct _wm_config
{
  Bool use_title;
  Bool no_cursor;
   
  MBConfigKbd *kb;

  Bool dialog_shade;   /* if set dialogs parent app is shaded out  */
  int lowlight_params[4];

  char *theme;
  char display_name[128];
  
  Time dbl_click_time;
  
  int use_icons;

} Wm_config;


#ifdef USE_LIBSN

typedef struct _sncycles 
{
  char             *bin_name;
  Window           xid;
  struct _sncycles *next;
} SnCycle;

typedef struct _sn_execmapping_item
{
  char   *bin_name;
  Window  xid;
} SnExecMappingItem;

#endif

/* Main wm structure */

typedef struct _wm
{
  Display*     dpy;
  Atom         atoms[ATOM_COUNT];
  Window       root;
  int          screen;
  
  client*      head_client;    /* For ptr to beginning of list   */
  client*      focused_client; /* currently focused client       */
  client*      main_client;    /* currently viewable main client */
  XFontStruct* font;
  
  int dpy_width;
  int dpy_height;

  int flags;
   
  Cursor curs, curs_busy, curs_drag;

#ifdef USE_LIBSN

  SnDisplay        *sn_display;
  SnMonitorContext *sn_context;
  int               sn_busy_cnt;
  time_t            sn_init_time;
  SnCycle          *sn_cycles;

  struct list_item *sn_mapping_list;

#endif

   /* XXX To do, set in an array */
   Atom wm_state, wm_change_state, wm_protos, wm_delete, wm_cmapwins,
      mb_theme, mb_command;

   /* Theme* theme; */
   struct _mbtheme* mbtheme;
   Wm_config *config;

   Window last_click_window;
   Time   last_click_time;
   Bool   next_click_is_not_double;

  MBPixbufImage* img_generic_icon;
  Pixmap generic_icon, generic_icon_mask; /* XXX togo */

  MBPixbuf *pb;

#ifdef USE_XSETTINGS
  XSettingsClient *xsettings_client;
#endif 




} wm;

/* New Theme structs */


typedef enum 
{ 
  ALIGN_LEFT, 
  ALIGN_CENTER, 
  ALIGN_RIGHT 

} Alignment;  

/* XXX TEMPORARY 
enum {
  ACTION_CLOSE = 1,
  ACTION_NEXT,
  ACTION_PREV,
  ACTION_MIN,
  ACTION_MAX,
  ACTION_MENU,
  ACTION_HIDE,
  ACTION_MENU_EXTRA,
  ACTION_MAX_EXTRA,
  ACTION_MIN_EXTRA,
  ACTION_HELP,
  ACTION_ACCEPT
};
*/

enum {
  BUTTON_ACTION_CLOSE = 1,
  BUTTON_ACTION_NEXT,
  BUTTON_ACTION_PREV,
  BUTTON_ACTION_MIN,
  BUTTON_ACTION_MAX,
  BUTTON_ACTION_MENU,
  BUTTON_ACTION_HIDE,
  BUTTON_ACTION_MENU_EXTRA,
  BUTTON_ACTION_MAX_EXTRA,
  BUTTON_ACTION_MIN_EXTRA,
  BUTTON_ACTION_HELP,
  BUTTON_ACTION_ACCEPT,
  BUTTON_ACTION_DESKTOP
};

enum {
  FRAME_MAIN = 1,
  FRAME_MAIN_EAST,
  FRAME_MAIN_WEST,
  FRAME_MAIN_SOUTH,
  FRAME_DIALOG,
  FRAME_UTILITY_MAX,
  FRAME_UTILITY_MIN,
  FRAME_MENU,
  FRAME_DIALOG_EAST,
  FRAME_DIALOG_WEST,
  FRAME_DIALOG_SOUTH,
  N_FRAME_TYPES
};


#define VERTICAL   1
#define HORIZONTAL 2

#define ERROR_MISSING_PARAMS   -1
#define ERROR_INCORRECT_PARAMS -2
#define ERROR_LOADING_RESOURCE -3


#define VERTICAL   1
#define HORIZONTAL 2
#define TMP_WIDTH 240


#endif
