#include "panel_menu.h"



void panel_menu_exec_cb(MBMenuItem *item)
{
  char *cmd = strdup(item->info);

  util_fork_exec(cmd);
  free(cmd);
}

void panel_menu_exit_cb(MBMenuItem *item)
{
  util_cleanup_children(0);
}

void panel_menu_hide_cb(MBMenuItem *item)
{
  MBPanel *panel = (MBPanel *)item->cb_data;
  panel_toggle_visibilty(panel);
}

void panel_menu_move_app_cb(MBMenuItem *item)
{

  MBPanel *panel = (MBPanel *)item->cb_data;
  XEvent ev;
  MBPanelApp *papp = NULL;
  int done = 0;
  Bool grabbed = False;
  int old_cx = 0, x1, y1, box_x, box_y, old_mx = 0;
  
  if (XGrabPointer(panel->dpy, panel->win, False,
		   (ButtonPressMask|ButtonReleaseMask|PointerMotionMask),
		   GrabModeAsync,
		   GrabModeAsync, None, None,
		   CurrentTime)
      != GrabSuccess)
    return;
  
  XDefineCursor(panel->dpy, panel->win_root, panel->cursors[CURS_SLIDER]);

  DBG("%s() called\n", __func__);

  while (!done) {
    XCheckMaskEvent(panel->dpy, ButtonPressMask|ButtonReleaseMask|PointerMotionMask, &ev);
    
    switch (ev.type) 
      {
      case ButtonPress:
	papp = panel_app_get_from_window(panel, ev.xbutton.subwindow);

	if (papp == NULL )
	{  /* Check again by actual positions */
	  int ev_offset = 0, papp_offset = 0, papp_sz = 0;

	  if (panel->orientation == East || panel->orientation == West)
	    {
	      ev_offset = ev.xbutton.y;
	      papp_offset = papp->y;
	      papp_sz     = papp->h;
	    }
	  else
	    {
	      ev_offset = ev.xbutton.x;
	      papp_offset = papp->x;
	      papp_sz     = papp->w;
	    }

	   papp = panel->panel_app_head;
	   while( papp != NULL)
	     {
	       if (panel->orientation == East || panel->orientation == West)
		 {
		   if (ev.xbutton.y >= papp->y 
		       && ev.xbutton.y <= (papp->y+papp->h))
		     break;
		 } else {
		   if (ev.xbutton.x >= papp->x 
		       && ev.xbutton.x <= (papp->x+papp->w))
		     break;
		 }
	       papp = papp->next;
	     }
	}
      
      if (papp != NULL && !papp->ignore)
	{
	  grabbed = True;

	  DBG("%s() got app %s\n", __func__, papp->name);

	  util_get_mouse_position(panel, &x1, &y1);
	  if (panel->orientation == East || panel->orientation == West)
	    {
	      old_cx = papp->y;
	      box_x = papp->y; box_y = papp->x;
	    } else {
	      old_cx = papp->x;
	      box_x = papp->x; box_y = papp->y;
	    }
	} else {
	  DBG("%s() failed to find app for click\n", __func__);
	  XDefineCursor(panel->dpy, panel->win_root, panel->cursors[CURS_ORIG] );
	  XUngrabPointer(panel->dpy, CurrentTime);
	  XUngrabServer(panel->dpy);
	  return;
	}
      break;
    case MotionNotify:

      if (grabbed)
	{
	  MBPanelApp *p;
	  int found = 0, mx = 0;

	  if (panel->orientation == East || panel->orientation == West)
	    {

	      mx = old_cx + (ev.xmotion.y - y1);

	      DBG("%s()  mx is %i. old_mx is %i\n", __func__, mx, old_mx);

	      if (!old_mx)
		{
		  old_mx = mx;
		  break;
		}

	      if (mx+papp->h >= panel->h) mx = panel->h - papp->h; 
	      
	      for (p = panel->panel_app_head; p != NULL; p = p->next)
		if ( p != papp )
		  {
		    DBG("%s() checking %s: x:%i y:%i w:%i h:%i\n",
			__func__, p->name, p->x, p->y, p->w, p->h);
		    if ( (mx >= p->y && mx <= (p->y+p->h) )
			 || ( p->y > mx && p->y < (mx+papp->h)))
		      {
			found = 1;
			DBG("%s() found!\n", __func__);
		      } 
		  }

	    } else {

	      mx = old_cx + (ev.xmotion.x - x1);

	      if (!old_mx)
		{
		  old_mx = mx;
		  break;
		}

	      if (mx+papp->w >= panel->w) mx = panel->w - papp->w; 
	      
	      for (p = panel->panel_app_head; p != NULL; p = p->next)
		if ( p != papp )
		  {
		    if ( (mx >= p->x && mx <= (p->x+p->w) )
			 || ( p->x > mx && p->x < (mx+papp->w)))
		      {
			found =1;
		      } 
		  }
	    }

	  if (!found)
	    {
	      panel_app_move_to(panel, papp, mx);
	    }
	  
	  old_mx = mx;
	}
      break;
    case ButtonRelease:
      if (grabbed)
	{
	  grabbed = False;
	  XDefineCursor(panel->dpy, panel->win_root, panel->cursors[CURS_ORIG] );
	  panel_app_list_remove(panel, papp);
	  panel_app_list_add(panel, papp);

	  if (panel->orientation == East || panel->orientation == West)
	    panel_app_move_to(panel, papp, papp->y);
	  else
	    panel_app_move_to(panel, papp, papp->x);

	  panel_app_deliver_config_event(panel, papp);

	  if (panel->use_session) session_save(panel);
	  XUngrabPointer(panel->dpy, CurrentTime);
	  done = 1;
	  return;
	}
      break;
    }
    usleep(0);
  }

}

void panel_menu_kill_cb(MenuItem *item)
{
  MBPanelApp *papp = (MBPanelApp *)item->cb_data;
  /* XKillClient(c->panel->dpy, c->win); */

  XGrabServer(papp->panel->dpy);
  XKillClient(papp->panel->dpy, papp->win);
  // XXX panel_app_destroy(papp->panel, papp);
  session_save(papp->panel);
  XUngrabServer(papp->panel->dpy);
}

void
panel_menu_add_remove_item(MBPanel *panel, MBPanelApp *papp)
{
  int *icon_data = NULL;
  MenuItem *menu_item; /* XXX MenuItem -> MBMenuItem */

  if (panel->remove_menu == NULL)
    panel->remove_menu = mb_menu_add_path(panel->mbmenu, "Remove", 
					  PANELDATADIR "/remove.xpm", 
					  MBMENU_PREPEND); 

  menu_item = mb_menu_add_item_to_menu(panel->mbmenu, 
				       panel->remove_menu, 
				       papp->name, NULL, 
				       papp->name, 
				       panel_menu_kill_cb, 
				       (void *)papp, 0);
  
  if ((icon_data = panel_app_icon_prop_data_get(panel, papp)) != NULL )
    {
      MBPixbufImage *img;
      char *p;
      int i;
      
      DBG("%s() Got icon data\n", __func__ );
      
      img = mb_pixbuf_img_new(panel->pb, icon_data[0], icon_data[1] ); 
      p = img->rgba;
      
      for (i =0 ; i < (icon_data[0]*icon_data[1]); i++)
	{
	  *p++ = (icon_data[i+2] >> 16) & 0xff;  
	  *p++ = (icon_data[i+2] >> 8) & 0xff;  
	  *p++ = icon_data[i+2] & 0xff;  
	  *p++ = icon_data[i+2] >> 24; 
	}

      mb_menu_item_icon_set(panel->mbmenu, menu_item, img);

      mb_pixbuf_img_free(panel->pb, img);
      XFree(icon_data);
    }
  else
    {
      DBG("%s() failed to get icon data\n", __func__ );
    }
}

void 
panel_menu_init(MBPanel *panel)
{
  Menu *m, *menu_launchers;
  char orig_wd[256] = { 0 };
  struct dirent *dir_entry;
  DIR *dp;

  MBMenuOptions mbmenu_ops;
  int           mbmenu_mask = MBMENU_FG_COL|MBMENU_BG_COL|MBMENU_HL_COL
                               |MBMENU_FONT|MBMENU_ICON_SZ|MBMENU_BD_COL;

  if (panel->mbmenu == NULL)
    {
#ifdef USE_XFT
      mbmenu_ops.fontname = "verdana,sans-7";
#else
      mbmenu_ops.fontname = "fixed";
#endif
      mbmenu_ops.foreground_col_spec = "black";
      mbmenu_ops.background_col_spec = "white";
      mbmenu_ops.highlight_col_spec  = "blue";
      mbmenu_ops.border_col_spec     = "black";
      mbmenu_ops.border_size         = 1;
      mbmenu_ops.icon_dimention      = 16;

      panel->mbmenu = mb_menu_new(panel->dpy, panel->screen, 
				  mbmenu_mask, &mbmenu_ops );
    }

  m = mb_menu_add_path(panel->mbmenu, "Add", PANELDATADIR "/add.xpm", 
		       MBMENU_NO_SORT );

#ifdef USE_PNG
#define FOLDER_IMG  DATADIR "/matchbox/mbmenu/folder.png"
#else
#define FOLDER_IMG  DATADIR "/matchbox/mbmenu/folder.xpm"
#endif

  menu_launchers = mb_menu_add_path(panel->mbmenu, "Add/Launchers", 
				    FOLDER_IMG, MBMENU_NO_SORT );

  if (getcwd(orig_wd, 255) == (char *)NULL)
    {
      printf("Cant get current directory\n");
      exit(0);
    }

  if ((dp = opendir(DATADIR "/applications")) != NULL)
    {
  
      chdir(DATADIR "/applications");
      
      while((dir_entry = readdir(dp)) != NULL)
	{
	  struct stat stat_info;
	  stat(dir_entry->d_name, &stat_info);
	  if (!(stat_info.st_mode & S_IFDIR))
	    {
	      MBDotDesktop *ddentry  = NULL;
	      ddentry = mb_dotdesktop_new_from_file(dir_entry->d_name);
	      if (ddentry
		  && mb_dotdesktop_get(ddentry, "Type")
		  && mb_dotdesktop_get(ddentry, "Name")
		  && mb_dotdesktop_get(ddentry, "Exec")
		  )
		{

		  char png_path[256] = "";
		  unsigned char *icon_str = mb_dotdesktop_get(ddentry, "Icon");
		  
		  if (icon_str && icon_str[0] == '/')
		    strcpy(png_path, icon_str);
		  else
		    sprintf(png_path, "%s/%s", 
			    DATADIR "/pixmaps", 
			    mb_dotdesktop_get(ddentry, "Icon"));

		  if (!strcmp(mb_dotdesktop_get(ddentry, "Type"), "PanelApp"))
		    {
		      mb_menu_add_item_to_menu(panel->mbmenu, 
					       m, 
					       mb_dotdesktop_get(ddentry, 
								 "Name"), 
					       png_path, 
					       mb_dotdesktop_get(ddentry, 
								 "Exec"), 
					       panel_menu_exec_cb, 
					       (void *)panel, 0);
		    } else {
		      char launcher_exec_str[256] = { 0 };
		      snprintf(launcher_exec_str, 256, 
			       "monolaunch --desktop %s/%s",
			       DATADIR "/applications", dir_entry->d_name);
		      mb_menu_add_item_to_menu(panel->mbmenu, 
					       menu_launchers, 
					       mb_dotdesktop_get(ddentry, 
								 "Name"), 
					       png_path, 
					       launcher_exec_str,
					       panel_menu_exec_cb, 
					       (void *)panel, 0);

		    }
		  mb_dotdesktop_free(ddentry);
		}
	    }
	}
      
    }
  else fprintf(stderr, "failed to open %s\n", PANELDATADIR);

  chdir(orig_wd);

  panel->remove_menu = NULL;

  /*
  panel->remove_menu = mb_menu_add_path(panel->mbmenu, "Remove", 
  PANELDATADIR "/remove.xpm", MBMENU_NO_SORT); */

  mb_menu_add_item_to_menu(panel->mbmenu, panel->mbmenu->rootmenu, "Move", 
			  PANELDATADIR "/move.xpm", NULL , 
			  panel_menu_move_app_cb, (void *)panel, MBMENU_NO_SORT); 

  mb_menu_add_item_to_menu(panel->mbmenu, panel->mbmenu->rootmenu, "Hide", 
			  PANELDATADIR "/down.xpm", NULL , 
			  panel_menu_hide_cb, (void *)panel, MBMENU_NO_SORT); 

  return;
}

