#include "session.h"

void 
session_init(MBPanel *panel)
{
  char sessionfile[256] = { 0 };

  DBG("%s() called\n", __func__);

  panel->session_preexisting_lock = False;

  if (!panel->use_session) return;
 
  if (panel->system_tray_id)
    snprintf(sessionfile, 255, "%s%s.%i", getenv("HOME"), PANELFILE, 
	     panel->system_tray_id );   
  else
    snprintf(sessionfile, 255, "%s%s", getenv("HOME"), PANELFILE );   

  if ((panel->session_fp = fopen(sessionfile, "r")) == NULL)
    {
      fprintf(stderr,"mbpanel: Session file does not exist ( tryed %s )\n", 
	      sessionfile);
      return;
    }

  panel->session_preexisting_lock = True;  /* we are loading session data  */
  panel->session_entry_cur[0] = 0; 

  session_preexisting_start_next(panel);
   
}

void session_save(MBPanel *panel)
{
  char *sessionfile = alloca(sizeof(char)*255);

  MBPanelApp *papp = panel->panel_app_head;
  
  DBG("%s() called\n", __func__);

  if (!panel->use_session 
      || session_preexisting_restarting(panel)
      || papp == NULL ) 
    return;

  if (getenv("HOME") == NULL)
    {
      fprintf(stderr, "mbdock: unable to get home directory, is HOME set?\n");
      return;
    }

  if (panel->system_tray_id)
    snprintf(sessionfile, 255, "%s%s.%i", getenv("HOME"), PANELFILE, 
	     panel->system_tray_id );   
  else
    snprintf(sessionfile, 255, "%s%s", getenv("HOME"), PANELFILE );   
  
  if ((panel->session_fp = fopen(sessionfile, "w")) == NULL)
    { 
      fprintf(stderr,"mbpanel: Unable to create Session file ( %s )\n", 
	      sessionfile); 
      return; 
    }
  
  while( papp != NULL )
    {
      if (papp->cmd_str)
	{
	  fprintf(panel->session_fp, "%s\t\t%i\n", papp->cmd_str,  
		  papp->offset - panel->scroll_offset  );
	  
	}
      papp = papp->next;
    }
  
  fclose(panel->session_fp);
}

Bool 
session_preexisting_restarting(MBPanel *panel)
{
  return panel->session_preexisting_lock;
}

Bool
session_preexisting_start_next(MBPanel *panel)
{
  if (!session_preexisting_restarting(panel)) return False;

  if (panel->session_entry_cur[0] == '\0' 
      && session_preexisting_get_next(panel))
    {
      DBG("%s() starting %s\n", __func__, panel->session_entry_cur);
      panel->session_needed_pid = util_fork_exec(panel->session_entry_cur);
      return True;
    }
  return False;
}

Bool 
session_preexisting_win_matches_wanted(MBPanel *panel, Window win, 
				       char *win_cmd)
{
  pid_t win_pid = 0;
  if (!session_preexisting_restarting(panel)) return False;

  DBG("%s() called\n", __func__);

  if (panel->session_entry_cur) /* what were waiting on */
    {
      /* Check if its got the pid we expect */
      win_pid = util_get_window_pid_from_prop(panel, win);

      DBG("%s() win pid is %i\n", __func__, win_pid);

      if (win_pid && win_pid == panel->session_needed_pid)
	return True;

      DBG("%s() pid failed, comparing '%s' vs '%s'\n", __func__, 
	  win_cmd, panel->session_entry_cur );

      /* check cmd str */
      if (win_cmd && !strncmp(win_cmd, panel->session_entry_cur, 
			      strlen(win_cmd)))
	return True;
    }

  return False;
}

void
session_preexisting_clear_current(MBPanel *panel)
{
  panel->session_entry_cur[0] = '\0';
}

Bool 
session_preexisting_handle_timeouts(MBPanel *panel)
{
  if (!session_preexisting_restarting(panel)) return False;

  DBG("%s() called\n", __func__);

  /* catch session timeouts */
  if (panel->session_entry_cur[0] != '\0')
    {
      if ( (time(NULL)-panel->session_start_time) > SESSION_TIMEOUT)
	{
	  fprintf(stderr, "Session timeout on %s\n", panel->session_entry_cur);
	  session_preexisting_clear_current(panel);
	  session_preexisting_start_next(panel);
	}
    }
  return True;
}

Bool 
session_preexisting_get_next(MBPanel *panel) /* session_restarting_get_next  */
{
  char *tmp;

  if (!session_preexisting_restarting(panel)) return False;

  panel->session_init_offset = 10;

  if (fgets(panel->session_entry_cur, 512, panel->session_fp) == NULL)
    {
      fclose(panel->session_fp); /* All sessions done */
      panel->session_preexisting_lock = False;
      session_save(panel);
      return False;
    }

  if ( panel->session_entry_cur[strlen(panel->session_entry_cur)-1] == '\n')
    panel->session_entry_cur[strlen(panel->session_entry_cur)-1] = '\0';

  if ( (tmp = strstr(panel->session_entry_cur, "\t\t")) != NULL )
    {
      panel->session_init_offset = atoi(tmp);
      *tmp = '\0';
    }

  panel->session_start_time = time(NULL);
  return True;
}
