/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _CLIENT_COMMON_H_
#define _CLIENT_COMMON_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmd.h>
#include <X11/cursorfont.h>

#include "structs.h"
#include "main_client.h"
#include "toolbar_client.h"
#include "dockbar_client.h"
#include "dialog_client.h"
#include "misc.h"

void client_set_state(Client *c, int state);
long client_get_state(Client *c);
void client_deliver_config(client *c);
void client_deleiver_wm_protocol(Client *c, Atom delivery);
void client_deliver_delete(client *c);
int client_want_focus(Client *c);
Client *client_get_next(Client* c, Client_type wanted);
Client *client_get_prev(Client* c, Client_type wanted);
void client_init_backing(Client* c, int width, int height);

void client_init_backing_mask(Client *c, int width, int height);

struct list_item* client_get_button_list_item_from_event(Client *c, XButtonEvent *e);

int client_do_button_ops(Client *c, int frame_id, XButtonEvent *e);

int client_button_do_ops(Client *c, XButtonEvent *e, int frame_type,
			 int w, int h);

MBClientButton *client_button_new(Client *c, Window win_parent, 
				  int x, int y, int w, int h,
				  Bool want_inputonly, void *data );

void client_button_remove(Client *c, int button_action);

void client_buttons_delete_all(Client *c);


#endif 
