/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _DOCKBAR_CLIENT_H_
#define _DOCKBAR_CLIENT_H_

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "structs.h"
#include "base_client.h"
#include "client_common.h"
#include "toolbar_client.h"
#include "wm.h"
#include "misc.h"

client* dockbar_client_new(wm *w, Window win);

void dockbar_client_show(Client *c);
void dockbar_client_hide(Client *c);
void dockbar_client_configure(client *c);
void dockbar_client_get_coverage(Client *c, int *x, int *y, int *w, int *h);
void dockbar_client_move_resize(Client *c);
void dockbar_client_destroy(Client *c);

#endif



