/****************************************************************************
** COPYRIGHT (C) 1994-1997 INTEL CORPORATION                               **
** DEVELOPED FOR MICROSOFT BY INTEL CORP., HILLSBORO, OREGON               **
** HTTP://WWW.INTEL.COM/                                                   **
** THIS FILE IS PART OF THE INTEL ETHEREXPRESS PRO/100B(TM) AND            **
** ETHEREXPRESS PRO/100+(TM) NDIS 5.0 MINIPORT SAMPLE DRIVER               **
****************************************************************************/

/****************************************************************************
Module Name:
    equates.h

This driver runs on the following hardware:
    - 82557/82558 based PCI 10/100Mb ethernet adapters
    (aka Intel EtherExpress(TM) PRO Adapters)

Environment:
    Kernel Mode - Or whatever is the equivalent on WinNT

Revision History
    - JCB 8/14/97 Example Driver Created
*****************************************************************************/

#ifndef _EQUATES_H
#define _EQUATES_H

//-------------------------------------------------------------------------
// Ethernet Frame Sizes
//-------------------------------------------------------------------------
#define ETHERNET_ADDRESS_LENGTH         6
#define ETHERNET_HEADER_SIZE            14
#define MINIMUM_ETHERNET_PACKET_SIZE    60
#define MAXIMUM_ETHERNET_PACKET_SIZE    1514

#define MAX_MULTICAST_ADDRESSES         32
#define ETH_MAX_COPY_LENGTH             0x80 // 128

// Make receive area 1536 for 16 bit alignment.
//#define RCB_BUFFER_SIZE       MAXIMUM_ETHERNET_PACKET_SIZE
#define RCB_BUFFER_SIZE                 1520 // 0x5F0

//- Area reserved for all Non Transmit command blocks
#define MAX_NON_TX_CB_AREA              512

//-------------------------------------------------------------------------
// Ndis/Adapter driver constants
//-------------------------------------------------------------------------
#define MAX_PHYS_DESC               16
#define MAX_RECEIVE_DESCRIPTORS     1024 // 0x400
#define NUM_RMD                     10


//--------------------------------------------------------------------------
//    Equates Added for NDIS 4
//--------------------------------------------------------------------------
#define  NUM_BYTES_PROTOCOL_RESERVED_SECTION    16
#define  MAX_NUM_ALLOCATED_RFDS                 64
#define  MIN_NUM_RFD                            4
#define  MAX_ARRAY_SEND_PACKETS                 8
// limit our receive routine to indicating this many at a time
#define  MAX_ARRAY_RECEIVE_PACKETS              16
#define  MAC_RESERVED_SWRFDPTR                  0
#define  MAX_PACKETS_TO_ADD                     32

//-------------------------------------------------------------------------
//- Miscellaneous Equates
//-------------------------------------------------------------------------
#define CR      0x0D        // Carriage Return
#define LF      0x0A        // Line Feed

#ifndef FALSE
#define FALSE       0
#define TRUE        1
#endif

#define DRIVER_NULL ((ULONG)0xffffffff)
#define DRIVER_ZERO 0


#endif      // _EQUATES_H

