/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

/****************************************************************************
Module Name:
    ItsyEthCommon.h

Contains common definitions used by both the WDM specific and NDIS parts of
the driver.

Environment:
    Kernel Mode - Or whatever is the equivalent on WinNT

Revision History

*****************************************************************************/


#ifndef _ITSYETHCOMMON_
#define _ITSYETHCOMMON_

// must declare this typedef in both the wdm and NDIS sections of the driver since
typedef PVOID PITSYETH_WDM_HANDLE;
typedef PVOID PITSYETH_FRAME_HANDLE;

void
ItsyEth_GetFrame(IN  PITSYETH_WDM_HANDLE WdmHandle,
				 OUT PITSYETH_FRAME_HANDLE *handle,
				 OUT PVOID *va);

void 
ItsyEth_SetFrameLength(IN PITSYETH_FRAME_HANDLE handle,
					   IN int length);

void
ItsyEth_FreeFrame(IN PITSYETH_WDM_HANDLE WdmHandle,
			      IN PITSYETH_FRAME_HANDLE Handle);

void
ItsyEth_Recv(PITSYETH_WDM_HANDLE WdmHandle,
			   PITSYETH_FRAME_HANDLE FrameHandle,
			   void (* Callback)(PVOID ,PVOID, int),
			   PVOID Adapter,
			   PVOID Packet);

void
AdjustBufferLength(PVOID PacketArg, int Length);

#endif
