/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

/*++

Copyright (c) 1997-1998  Microsoft Corporation

Module Name:

    ItsyEthDbg.c 

Abstract:

    Debug output logic .
	This entire module is a noop in the free build

Environment:

    kernel mode only

Notes:

  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
  PURPOSE.

  Copyright (c) 1997-1998 Microsoft Corporation.  All Rights Reserved.


Revision History:

    1/27/98: created

--*/


#if DBG


#include "wdm.h"
#include "stdarg.h"
#include "stdio.h"

#include "usbdi.h"
#include "usbdlib.h"

#include "itsyethdbg.h"

// begin, data/code  used only in DBG build

//  may be overridden  in registry in DBG buils only
// higher == more verbose, default is 1, 0 turns off all
int gDebugLevel = DBGLVL_DEFAULT ; 

// count outstanding allocations via ExAllocatePool
int gExAllocCount =0;

//BULKUSB_DBGDATA gDbgBuf = { 0, 0, 0, 0 }; 

// ptr to global debug data struct; txt buffer is only allocated in DBG builds
//PBULKUSB_DBGDATA gpDbg = &gDbgBuf; 

PVOID 
ITSYETH_ExAllocatePool(
        IN POOL_TYPE PoolType,
        IN ULONG NumberOfBytes
        )
{
	gExAllocCount++;
    ItsyEth_KdPrint( DBGLVL_HIGH,("BULKUSB_ExAllocatePool() gExAllocCount = dec %d\n", gExAllocCount ));
	return ExAllocatePool(  PoolType, NumberOfBytes );

}


VOID 
ITSYETH_ExFreePool(
        IN PVOID p
        )
{
	gExAllocCount--;
    ItsyEth_KdPrint( DBGLVL_HIGH,("BULKUSB_ExFreePool() gExAllocCount = dec %d\n", gExAllocCount ));
	ExFreePool(  p );

}


#endif // end , if DBG

