/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

#ifndef _ITSYETH_WDM_
#define _ITSYETH_WDM_

#include "itsyethcom.h"

typedef struct _ITSYETH_FRAME
{
	LIST_ENTRY node;

	PCHAR va;
	int  length;

	PURB  urb;

	VOID  (* callback)(PVOID, PVOID, int);
	PVOID Adapter;
	PVOID Packet;
	PITSYETH_WDM_HANDLE WdmHandle;
} ITSYETH_FRAME, *PITSYETH_FRAME;

//
// A structure representing the instance information associated with
// this particular device.
//
typedef struct _ITSYETH_DEVICE_EXTENSION 
{
    // Device object we call when submitting Urbs
    PDEVICE_OBJECT TopOfStackDeviceObject;

	// The bus driver object
    PDEVICE_OBJECT PhysicalDeviceObject;

    // USB configuration handle and ptr for the configuration the
    // device is currently in
    USBD_CONFIGURATION_HANDLE UsbConfigurationHandle;
	PUSB_CONFIGURATION_DESCRIPTOR UsbConfigurationDescriptor;


    // ptr to the USB device descriptor
    // for this device
    PUSB_DEVICE_DESCRIPTOR UsbDeviceDescriptor;

    // we support one interface
    // this is a copy of the info structure
    // returned from select_configuration or
    // select_interface
    PUSBD_INTERFACE_INFORMATION UsbInterface;

	// device state
	ULONG OutPipeState;
	// Itsy always has two pipes, an out pipe and an in interrupt pipe
	PUSBD_PIPE_INFORMATION InPipe;
	PUSBD_PIPE_INFORMATION OutPipe;
	PWORK_QUEUE_ITEM ResetWork;

	// free and used lists of frame memory
	LIST_ENTRY FreeFrames;
	LIST_ENTRY QueuedFrames;
	KSPIN_LOCK FrameListLock;

	// set when PendingIoCount goes to 0; flags device can be removed
    KEVENT RemoveEvent;

	// set when PendingIoCount goes to 1 ( 1st increment was on add device )
	// this indicates no IO requests outstanding, either user, system, or self-staged
    KEVENT NoPendingIoEvent;

	// set to signal driver-generated power request is finished
    KEVENT SelfRequestedPowerIrpEvent;

	// spinlock used to protect inc/dec iocount logic
	KSPIN_LOCK	IoCountSpinLock;

	// spinlock used to protect test of deviceExtension->BaseIrp in
	// BulkUsb_StagedReadWrite()
	PKSPIN_LOCK FastCompleteSpinlock;

	// incremented when device is added and any IO request is received;
	// decremented when any io request is completed or passed on, and when device is removed
    ULONG PendingOutIoCount;

	// flag set when driver has answered success to IRP_MN_QUERY_STOP_DEVICE
    BOOLEAN StopDeviceRequested;
	BOOLEAN DeviceStalled;

	// flag set when device has been successfully started
	BOOLEAN DeviceStarted;

    // flag set when IRP_MN_WAIT_WAKE is received and we're in a power state
    // where we can signal a wait
    BOOLEAN EnabledForWakeup;

	// default power state to power down to on self-suspend 
	ULONG PowerDownLevel; 

} ITSYETH_DEVICE_EXTENSION, *PITSYETH_DEVICE_EXTENSION;

#define OUTPIPE_RUNNING    0
#define OUTPIPE_ABORTING   1
#define OUTPIPE_RESETING  2

NTSTATUS
ItsyEth_Create(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
ItsyEth_ProcessPnPIrp(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP           Irp
    );

NTSTATUS
ItsyEth_PnPAddDevice(
    IN PDRIVER_OBJECT DriverObject,
    IN PDEVICE_OBJECT PhysicalDeviceObject
    );

NTSTATUS
ItsyEth_CallUSBD(IN PDEVICE_OBJECT DeviceObject,
				 IN PDEVICE_OBJECT NextDeviceObject,
                 IN PURB Urb);

NTSTATUS
ItsyEth_SelectInterface(IN PITSYETH_DEVICE_EXTENSION deviceExtension,
                        IN PUSB_CONFIGURATION_DESCRIPTOR ConfigurationDescriptor);
NTSTATUS
ItsyEth_ConfigureDevice(IN PITSYETH_DEVICE_EXTENSION deviceExtension);


NTSTATUS
ItsyEth_ProcessPowerIrp(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP           Irp
    );

NTSTATUS
ItsyEth_PoRequestCompletion(
    IN PDEVICE_OBJECT       DeviceObject,
    IN UCHAR                MinorFunction,
    IN POWER_STATE          PowerState,
    IN PVOID                Context,
    IN PIO_STATUS_BLOCK     IoStatus
    );

NTSTATUS
ItsyEth_PowerIrp_Complete(
    IN PDEVICE_OBJECT NullDeviceObject,
    IN PIRP Irp,
    IN PVOID Context
    );

NTSTATUS
ItsyEth_SelfSuspendOrActivate(
    IN PDEVICE_OBJECT DeviceObject,
    IN BOOLEAN fSuspend
    );

NTSTATUS
ItsyEth_SelfRequestPowerIrp(
    IN PDEVICE_OBJECT DeviceObject,
    IN POWER_STATE PowerState
    );

NTSTATUS
ItsyEth_PoSelfRequestCompletion(
    IN PDEVICE_OBJECT       DeviceObject,
    IN UCHAR                MinorFunction,
    IN POWER_STATE          PowerState,
    IN PVOID                Context,
    IN PIO_STATUS_BLOCK     IoStatus
    );

BOOLEAN
ItsyEth_SetDevicePowerState(
    IN PDEVICE_OBJECT DeviceObject,
    IN DEVICE_POWER_STATE DeviceState
    );

NTSTATUS
ItsyEth_QueryCapabilities(
    IN PDEVICE_OBJECT PdoDeviceObject,
    IN PDEVICE_CAPABILITIES DeviceCapabilities
    );

long
ItsyEth_DecrementIoCount(
    IN PITSYETH_DEVICE_EXTENSION deviceExtension,
	IN int Direction
    );

void
ItsyEth_IncrementIoCount(
    IN PITSYETH_DEVICE_EXTENSION deviceExtension,
	IN int Direction
    );


void
ItsyEth_InitFrameList(PITSYETH_DEVICE_EXTENSION deviceExtension);

NTSTATUS
ItsyEth_AbortPipes(
    IN PITSYETH_DEVICE_EXTENSION deviceExtension
    );

int
GetAddress(PITSYETH_DEVICE_EXTENSION deviceExtension);

#endif
