/****************************************************************************/
/* Copyright 1999 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

/****************************************************************************
** COPYRIGHT (C) 1994-1997 INTEL CORPORATION                               **
** DEVELOPED FOR MICROSOFT BY INTEL CORP., HILLSBORO, OREGON               **
** HTTP://WWW.INTEL.COM/                                                   **
** THIS FILE IS PART OF THE INTEL ETHEREXPRESS PRO/100B(TM) AND            **
** ETHEREXPRESS PRO/100+(TM) NDIS 5.0 MINIPORT SAMPLE DRIVER               **
****************************************************************************/

/****************************************************************************
Module Name:
    send.c

This driver runs on the following hardware:
    - 82557/82558 based PCI 10/100Mb ethernet adapters
    (aka Intel EtherExpress(TM) PRO Adapters)

Environment:
    Kernel Mode - Or whatever is the equivalent on WinNT

Abstract:
    This module contains the send routines and send interrupt handling code

Revision History
    - JCB 8/14/97 Example Driver Created
*****************************************************************************/

#include <ndis.h>
#include <efilter.h>

#include "equates.h"
#include "itsyethdbg.h"
#include "itsyethsw.h"
#include "itsyethpr.h"
#include "itsyethcom.h"

void
SendCleanup(PVOID, PVOID, int);

//-----------------------------------------------------------------------------
// Procedure: ItsyEthMultipleSend
//
// Description:This function takes an array from NDIS and puts as many as it can
//             in our list to be immediately transferred. Each packet has its
//             status set (NDIS_STATUS_RESOURCES, NDIS_STATUS_PENDED,
//             or NDIS_STATUS_SUCCESS) in the PacketArray individually.
//
//
// Arguments: MiniportAdapterContext (Adapter Structure pointer)
//            PacketArray - an array of pointers to NDIS_PACKET structs
//            PacketCount - number of packets in PacketArray
//
// Returns: nothing
//
//-----------------------------------------------------------------------------
VOID
ItsyEthMultipleSend(NDIS_HANDLE MiniportAdapterContext,
                    PPNDIS_PACKET PacketArray,
                    UINT NumberOfPackets)
{
    PItsyEth_ADAPTER       Adapter;
    NDIS_STATUS         Status;
    UINT                PacketCount;

    ItsyEth_KdPrint(DBGLVL_MAXIMUM, ("ItsyEthMultipleSend %d\n", NumberOfPackets));

    Adapter = PITSYETH_ADAPTER_FROM_CONTEXT_HANDLE(MiniportAdapterContext);

    // take each packet in the array and return a status for it
    // if we return one packet with a NDIS_STATUS_RESOURCES,
    // the MiniPort layer assumes the rest of the packets have the same status
    // its up to the protocol to check those statuses after we return
    for(PacketCount=0;PacketCount < NumberOfPackets; PacketCount++)
    {
        // check for a zero pointer
        ITSYETH_ASSERT(PacketArray[PacketCount]);
        Status = SetupNextSend(Adapter, PacketArray[PacketCount]);
    }
    return;
}



//-----------------------------------------------------------------------------
// Procedure:   SetupNextSend
//
// Description: This routine is called by ItsyEthSend.  It will setup all of the
//              necessary structures (TCBs, TBDs, etc.) to send a packet.  If
//              the device has the necessary resources, the packet will be
//              sent out on the active chain.  If the device doesn't have the
//              resources to send the packet, then the routine will return
//              NDIS_STATUS_RESOURCES.
//
//              The intention is to have this routine run only on a 82557
//              or a 82558 in compatibility mode (indicated by Enhanced = FALSE
//              in the registry)
// Arguments:
//      Adapter - ptr to Adapter object instance
//      Packet - A pointer to a descriptor for the packet that is to be
//               transmitted.
// Returns:
//      NDIS_STATUS_SUCCESS - We copied the entire packet into a host buffer,
//                            (either it was a short frame, or we coalesced
//                            the packet into a host buffer), so we can
//                            immediately return the buffer back to the upper
//                            layers.
//      NDIS_STATUS_PENDING - If we were able to acquire the necessary TBD's
//                            or Coalesce buffer for the packet.  This means
//                            that the device will send this packet soon.
//                            Eventually we'll return the packet back to the
//                            protocol stack by using the "SendComplete" call.
//      NDIS_STATUS_RESOURCES - We didn't have the resouces (TCBs or TBDs) to
//                              accept this packet. The NDIS packet should
//                              queue this packet, and give it back to us at a
//                              later time.
//-----------------------------------------------------------------------------

NDIS_STATUS
SetupNextSend(PItsyEth_ADAPTER Adapter,
              PNDIS_PACKET Packet)
{
    NDIS_STATUS         Status = NDIS_STATUS_SUCCESS;
    PNDIS_BUFFER                CurrBuff;
    UINT                        i;
    UINT                        BytesCopied;

	UINT NumPhysDesc;
	UINT BufferCount;
	PNDIS_BUFFER FirstBuffer;
	UINT PacketLength;

	PCHAR BufferVA;
	UINT  BufferLength;

	PITSYETH_FRAME_HANDLE FrameHandle;
	PCHAR FrameVA;

    ItsyEth_KdPrint(DBGLVL_HIGH, ("SetupNextSend %p %p\n", Adapter, Packet));

	if (!Packet || !Adapter)
	{
		ItsyEth_KdPrint(DBGLVL_DEFAULT, ("SetupNextSend %p %p\n", Adapter, Packet));
	}
    // Get a virtual buffer count and packet length.
    NdisQueryPacket(Packet,
                    &NumPhysDesc,
                    &BufferCount,
                    &FirstBuffer,
                    &PacketLength);
#if 0
    ITSYETH_ASSERT(FirstBuffer);
    ITSYETH_ASSERT(BufferCount);
    ITSYETH_ASSERT(NumPhysDesc);
    ITSYETH_ASSERT(PacketLength);
    ITSYETH_ASSERT(PacketLength <= 1514);
    ITSYETH_ASSERT(BufferCount <= 512);
    ITSYETH_ASSERT(NumPhysDesc <= 512);
#endif
    // if the packet is not a valid length, then error out
    if ((!PacketLength) || (PacketLength > MAXIMUM_ETHERNET_PACKET_SIZE))
	{
        return NDIS_STATUS_FAILURE;
	}

    // start with the first buffer
    CurrBuff = FirstBuffer;
	ItsyEth_GetFrame(Adapter->WdmHandle, &FrameHandle, &FrameVA);

	if (FrameHandle && FrameVA)
	{
		for (i=0; CurrBuff; i++)
		{
			NdisQueryBuffer(CurrBuff, &BufferVA, &BufferLength);
			if (!(BufferVA) || (BufferLength == 0))
			{
				ItsyEth_KdPrint(DBGLVL_DEFAULT, ("no buffer !! %p %d\n", BufferVA, BufferLength));
			}
			else
			{
				// if this is the first buffer remove the source and destination 
				// addresses and add the packet length instead.
				if (i==0)
				{
					BufferVA += 12;  // 12 bytes for address
					PacketLength = PacketLength - 10;  // 12 bytes address - 2 byte length we send
					BufferLength = BufferLength - 12;
					// copy the length into the frame....
					*(FrameVA++) = PacketLength & 0x00FF;
					*(FrameVA++) = (PacketLength & 0xFF00) >> 8;
				}
				NdisMoveMemory(FrameVA, BufferVA, BufferLength);
				FrameVA += BufferLength;
				// point to the next buffer
			}
			NdisGetNextBuffer(CurrBuff, &CurrBuff);
		}

		if (PacketLength > 0)
		{
			ItsyEth_SetFrameLength(FrameHandle, PacketLength);
			// pass the buffer for USB send
			ItsyEth_KdPrint(DBGLVL_HIGH, ("SetupNextSend Length %d\n", PacketLength));
			ItsyEth_Send(Adapter->WdmHandle, FrameHandle, SendCleanup, Adapter, Packet);
		}
		else
		{
			ItsyEth_KdPrint(DBGLVL_DEFAULT, ("SetupNextSend freeing frame...\n"));
			ItsyEth_FreeFrame(Adapter->WdmHandle, FrameHandle);
		}
	}
	else
	{
		ItsyEth_KdPrint(DBGLVL_DEFAULT, ("SetupNextSend out of Frames\n"));
//		NdisMSendComplete(Adapter->ItsyEthAdapterHandle, Packet, NDIS_STATUS_SUCCESS);
	}
	ItsyEth_KdPrint(DBGLVL_HIGH, ("SetupNextSend exit\n"));
    return NDIS_STATUS_PENDING;
}


//-----------------------------------------------------------------------------
// Procedure:   SendCleanup
//
// Description: This routine will clean up after a transmitted frame.  It will
//              update the transmit statistic counters, free up TCBs and map
//              regs, and issue a send complete which will unlock the pages.
//
// Arguments:
//      Adapter - ptr to Adapter object instance
//
// Returns:
//      TRUE - If we indicated any loopback packets during this function call
//      FALSE - If we didn't indicate any loopaback packets
//-----------------------------------------------------------------------------
void
SendCleanup(PVOID AdapterArg, 
			PVOID PacketArg,
			int Status)
{
	PNDIS_PACKET Packet = (PNDIS_PACKET) PacketArg;
	PItsyEth_ADAPTER Adapter = AdapterArg;

	ItsyEth_KdPrint(DBGLVL_HIGH, ("SendCleanup %p %p\n", Adapter, Packet));

	if (!Adapter || ! Packet)
	{
		ItsyEth_KdPrint(DBGLVL_DEFAULT, ("send cleanup %p %p\n", Adapter, Packet));
	}
	NDIS_SET_PACKET_STATUS(Packet, NDIS_STATUS_SUCCESS);
	NdisMSendComplete(Adapter->ItsyEthAdapterHandle,
		              Packet,
					  NDIS_STATUS_SUCCESS);
	return;
}

