#!/bin/sh
# hwclock.sh	Set and adjust the CMOS clock, according to the UTC
#		setting in /etc/default/rcS (see also rcS(5)).
#
# Version:	@(#)hwclock.sh  2.00  14-Dec-1998  miquels@cistron.nl
#		Hacked for Familiar -- a7r@andern.org
#
echo "hwclock.sh"

# . /etc/default/rcS
[ "$GMT" = "-u" ] && UTC="yes"
case "$UTC" in
       no|"") GMT="--localtime"	;;
       yes)   GMT="--utc" 	;;
       *)     echo "$0: unknown UTC setting: \"$UTC\"" >&2 ;;
esac

case "$1" in
	start)
		echo "Setting the System Clock using the Hardware Clock as reference..."

		hwclock --hctosys $GMT
		;;

	stop|restart|reload|force-reload)
		echo "Saving the System Clock time to the Hardware Clock..."

		[ "$GMT" = "-u" ] && GMT="--utc"
		hwclock --systohc $GMT 
		;;
	show)
		hwclock --show $GMT $BADYEAR
		;;
	*)
		echo "Usage: $0 {start|stop|reload|force-reload|show}" >&2
		echo "       start sets kernel (system) clock from hardware (RTC) clock" >&2
		echo "       stop and reload set hardware (RTC) clock from kernel (system) clock" >&2
		exit 1
		;;
esac

