#!/bin/sh
#
# wrapper for generating gcov stats from matchbox source 
#
#

if [ -z "$1" ] || [ -z "$2" ]; then
   echo
   echo "usage: $0 <matchbox wm src path> <libmatchbox src path> [test]"
   echo
   echo "      'test' defaults to testrun.sh               " 
   echo "       Set GCOV_FLAGS to any required gcov swicthes" 
   echo
   exit
fi

MBWMSRC="$1"
LIBMBSRC="$2"

PATH="$MBWMSRC/src:$PATH"
LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$LIBMBSRC/libmb/.libs"

echo
echo "** gcov wrapper enabled, make sure you built wm & libmb with --enable-gcov **" 
echo 
echo $MBWMSRC
echo $LIBMBSRC

if [ -z "$3" ]; then
   ./testrun.sh
else
   $3
fi

pushd ./

cd $MBWMSRC/src/

echo 
echo "matchbox-window-manager gcov data:"
echo


for srcfile in *.c; do 
  gcov $GCOV_FLAGS $srcfile | grep -v '/usr/include' | grep executed; 
done

echo 
echo "libmatchbox gcov data:"
echo

cd $LIBMBSRC/libmb

for srcfile in *.c; do 
  gcov $GCOV_FLAGS -o .libs $srcfile | grep -v '/usr/include' | grep executed; 
done

echo
echo

popd