#!/bin/sh
# matchbox-panel test
#
#

if [ -z $(which matchbox-panel|grep "/matchbox-panel") ]; then
   echo "$0: 'matchbox-panel' missing! Have you installed Matchbox properly?"
   exit 2 # 2 indicates mis-setup 
fi
if [ -z $(which mb-applet-system-monitor|grep "/mb-applet-system-monitor") ]; then
   echo "$0: matchbox panel applet(s) needed for testing are missing!"
   exit 2
fi

## have a client showing to check window decoration resizing is ok.
./winspew -t normal,normal &
WINPID=$!

# remove the old session info
rm -f ~/.matchbox/mbdock.session*123456
rm -f ~/.matchbox/mbdock.session*123457

## panel in titlebar

$VALGRIND matchbox-panel --id 123457 --titlebar &
TITLEDOCKPID=$!

SYSTEM_TRAY_ID=123457 mb-applet-clock &
TITLEAPPPID=$!

## now each standard panel

$VALGRIND matchbox-panel --id 123456 &
DOCKPID=$!

sleep 5

# launch some apps
SYSTEM_TRAY_ID=123456 mb-applet-system-monitor &
APPPID=$!

sleep 2

# remove it
kill $APPPID

sleep 5

#remove the panel
kill $DOCKPID

# relaunch at top with session 
$VALGRIND matchbox-panel --orientation north --size 40 --id 123456 &

DOCKPID=$!

sleep 5

# launch some apps
SYSTEM_TRAY_ID=123456 mb-applet-system-monitor &
APPPID=$!

sleep 2

# remove it
kill $APPPID
kill $DOCKPID

## east panel

# relaunch at top with session 
$VALGRIND matchbox-panel --orientation east --size 60 --id 123456 &

DOCKPID=$!

sleep 5

# launch some apps
SYSTEM_TRAY_ID=123456 mb-applet-system-monitor &
APPPID=$!

sleep 2

# remove it
kill $APPPID
kill $DOCKPID

# kill winspew
kill $WINPID

# kill titlebar panel

kill $TITLEDOCKPID
kill $TITLEAPPPID

exit 0

