#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <regex.h>

#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>


#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>

#include <libmb/mb.h>
#include <mbdesktop_module.h>

#include <xine.h>
#include <xine/xineutils.h>

#ifndef XShmGetEventBase
extern int XShmGetEventBase(Display *);
#endif

enum {
  WINDOW_STATE = 0,
  WINDOW_STATE_FULLSCREEN,
  WINDOW_STATE_MODAL,
  WINDOW_TYPE_DIALOG,
  WINDOW_TYPE,    
  _NET_WM_NAME,
  UTF8_STRING,
  ATOM_CNT
};

/* XXX add MBX prefix */
enum {
  MBX_MODE_UNKNOWN        = 0,
  MBX_MODE_MUSIC_FILE     = (1<<1),
  MBX_MODE_MUSIC_CD       = (1<<2),
  MBX_MODE_MUSIC_RADIO    = (1<<3),
  MBX_MODE_MUSIC_PLAYLIST = (1<<6),
  MBX_MODE_MOVIE_FILE     = (1<<4),
  MBX_MODE_MOVIE_DVD      = (1<<5),
};

#define MBX_MODE_MOVIE (MBX_MODE_MOVIE_FILE|MBX_MODE_MOVIE_DVD)
#define MBX_MODE_MUSIC (MBX_MODE_MUSIC_FILE|MBX_MODE_MUSIC_CD|MBX_MODE_MUSIC_RADIO|MBX_MODE_MUSIC_PLAYLIST)


/* XXX add MBX prefix */
enum {
  PLAY_STATE_NORMAL,
  PLAY_STATE_FFORWARD,
  PLAY_STATE_REWIND,
  PLAY_STATE_PAUSED,
};

enum {
  CD_TYPE_ERROR = -1,
  CD_TYPE_NO_DISC = 0,
  CD_TYPE_UNKNOWN,
  CD_TYPE_AUDIO,
  CD_TYPE_DATA,
  CD_TYPE_VCD,
  CD_TYPE_DVD,
} ;

enum {
  MBX_INFO_DPY_TIME = (1<<1),
  MBX_INFO_TIMEOUT  = (1<<2),
};

enum {
  MBX_VOLUME_INC,
  MBX_VOLUME_DEC,
  MBX_VOLUME_TOGGLE_MUTE,
};

typedef struct BrowserData 
{ 
  char                *BrowserCurrentPath;
  char                *BrowserFolderName;
  char                *BrowserPath;
  char                *BrowserMusicPath;
  char                *BrowserMusicFolderName;
  char                *BrowserDrivePath;
  char                *BrowserVizPlugin;
  char                *BrowserVideoDriver;
  char                *BrowserAudioDriver;
  char                *BrowserRadioPath ;
  char                *BrowserRadioFolderName;
  char                *BrowserPlaylistsPath;

  Bool                 use_xshm_for_vis_hack;
  Bool                 use_video_thumbnails;
  Bool                 use_osd_locked_for_music;

  /* various state stuff */
  int                  current_mode;
  int                  play_state;
  MBDesktopItem       *current_item;
  Bool                 showing_info;
  int                  last_osd_show_time;
  int                  running;
  int                  volume;
  int                  is_muted;

  /* For CD's */
  char               **cd_mrls;
  int                  cd_num_mrls;
  int                  cd_idx;

  Window               win;
  Atom                 atoms[ATOM_CNT];
  Display             *display;
  MBDesktop           *mb;  /* for xine callbacks  */
  int                  display_width;

  /* Xine */
  xine_t              *xine;
  xine_stream_t       *stream;
  xine_video_port_t   *vo_port;
  xine_audio_port_t   *ao_port;
  xine_event_queue_t  *event_queue;
  xine_osd_t          *osd;
  xine_post_t         *vis;

  int                  completion_event;
  int                  xpos, ypos, width, height, fullscreen;
  double               pixel_aspect;


} BrowserData;

void
xinebrowser_win_open (MBDesktop *mb, BrowserData *data, Bool force_shm);

void
xinebrowser_win_close (MBDesktop *mb, BrowserData *data);

void
xinebrowser_win_event_loop (MBDesktop *mb, BrowserData *data);

void
xinebrowser_show_info (MBDesktop   *mb, 
		       BrowserData *data,
		       int          info_flags);

Bool
xinebrowser_play(MBDesktop     *mb, 
		 BrowserData   *data, 
		 char          *mrl);

MBPixbufImage *
xinebrowser_make_thumbnail (MBDesktop   *mb, 
			    BrowserData *data, 
			    char        *mrl);




/* xinebrowser callbacks */

void
xinebrowser_file_activate_cb (void *data1, void *data2);

void
xinebrowser_radio_activate_cb (void *data1, void *data2);

void 			
xinebrowser_movie_open_cb (void *data1, void *data2);

void 			
xinebrowser_music_open_cb (void *data1, void *data2);

void
xinebrowser_playlists_open_cb (void *data1, void *data2);

void 			
xinebrowser_radio_open_cb (void *data1, void *data2);

void
xinebrowser_disc_activate_cb (void *data1, void *data2);


/* Utils */

int
error_handler (Display     *display,
               XErrorEvent *error);

void
trap_errors (void);
 
int
untrap_errors (void);

Bool 
file_exists (char *filename);

int
xinebrowser_cd_get_disc_type(char *device);

void 
yuy2toyv12 (unsigned char *y, 
	    unsigned char *u, 
	    unsigned char *v, 
	    unsigned char *input,
	    int            width, 
	    int            height);

unsigned char* 
yv12torgb (unsigned char *src_y, 
	   unsigned char *src_u, 
	   unsigned char *src_v,
	   int            width, 
	   int            height);
