#!/bin/sh
#
# To run once built. 
#
# Xnest :1 -ac
# export LD_LIBRARY_PATH=/tmp/mb/lib
# export PATH="/tmp/mb/bin:$PATH"
# export DISPLAY=:1
# matchbox-session &
#
# ( Substitute /tmp/mb for your DEST var - see below )
#

# TODO
# add +cvs20040129 etc to ipkg VERSION from CVS builds
#


######################### Configuration ###################################

## install destination
DEST="/tmp/mb"

## Set to 'sudo' if you need root to make install 
SUDO=

## Optional compile time deps and features

WANT_DEBUG="n"
WANT_PNG="y"
WANT_JPEG="y"
WANT_XSETTINGS="n"
WANT_XFT="y"
WANT_STARTUP_NOTIFICATION="n"
WANT_EXPAT="n"
WANT_DNOTIFY="n"
WANT_PANGO="n"
WANT_GCONF="n"
WANT_COMPOSITE="n"
WANT_NLS="y"
WANT_MSG_WINS="n"
WANT_PDA_FOLDERS="n"
WANT_PDA_ICONS="n"

## build from cvs

BUILD_CVS="y" 

## do you want ipkgs built ?

BUILD_IPKS="n"

## Names of bits to build
## Only change versions for noncvs build, set names to "" to avoid building

MBLIB="libmatchbox"
MBLIB_V="1.2"
MBCMN="matchbox-common"
MBCMN_V="0.8"
MBCMN_MV=
MBWM="matchbox-window-manager"
MBWM_V="0.8"
MBWM_MV=".2"
MBPANEL="matchbox-panel"
MBPANEL_V="0.8"
MBPANEL_MV=".2"
MBDSKTP="matchbox-desktop"
MBDSKTP_V="0.8"
MBDSKTP_MV=".1"

SRC_URL='http://matchbox.handhelds.org/sources/'


##############################################################################




SEP="-"

if [ "$1" = '-h' ]; then
   echo "See source for usage instructions."
   exit 0
fi 

if [ -r matchbox-autobuild.config ] 
then
  echo
  echo "** using matchbox-autobuild.config **"
  echo
  cat matchbox-autobuild.config 
  echo
  echo "*************************************"
  echo
  source ./matchbox-autobuild.config
fi

## IF we want ipkgs, check autoipkg is in PATH
if [ $BUILD_IPKS = 'y' ]; then
   which autoipkg > /dev/null || ( echo "autoipkg script not found in PATH"; exit );
fi 

## XXX Check autotool versions 

# for gentoo ? 
export WANT_AUTOCONF=2.5
export WANT_AUTOMAKE=1.7

## translate options into ipk deps and configure switches

PNG_CONF_ARG=
PNG_IPK_DEPS=
if [ "$WANT_PNG" != 'y' ]; then
   PNG_CONF_ARG="--disable-png"
   PNG_IPK_DEPS="libpng12,"
fi

XFT_CONF_ARG=
XFT_IPK_DEPS=
if [ "$WANT_XFT" != 'y' ]; then
   XFT_CONF_ARG="--disable-xft"
   XFT_IPK_DEPS="libxft2,"
fi

PANGO_CONF_ARG=
PANGO_IPK_DEPS=
if [ "$WANT_PANGO" != 'n' ]; then
   PANGO_CONF_ARG="--enable-pango"
   PANGO_IPK_DEPS=""
fi

GCONF_CONF_ARG=
GCONF_IPK_DEPS=
if [ "$WANT_GCONF" != 'n' ]; then
   GCONF_CONF_ARG="--enable-gconf"
   GCONF_IPK_DEPS=""
fi

DEBUG_CONF_ARG=
if [ "$WANT_DEBUG" != 'n' ]; then
   DEBUG_CONF_ARG="--enable-debug"
fi

JPEG_CONF_ARG=
JPEG_IPK_DEPS=
if [ "$WANT_JPEG" != 'n' ]; then
   JPEG_CONF_ARG="--enable-jpeg"
   JPEG_IPK_DEPS="libjpeg62,"
fi

XSET_CONF_ARG=
XSET_IPK_DEPS=
if [ "$WANT_XSETTINGS" != 'n' ]; then
   XSET_CONF_ARG="--enable-xsettings"
   XSET_IPK_DEPS="libxsettings-client0,"
fi

SN_CONF_ARG=
SN_IPK_DEPS=
if [ "$WANT_STARTUP_NOTIFICATION" != 'n' ]; then
   SN_CONF_ARG="--enable-startup-notification"
   SN_IPK_DEPS="startup-notification,"
fi

EXPAT_CONF_ARG=
EXPAT_IPK_DEPS=
if [ "$WANT_EXPAT" != 'n' ]; then
   EXPAT_CONF_ARG="--enable-expat"
   EXPAT_IPK_DEPS="libexpat1,"
fi

COMP_CONF_ARG=
COMP_IPK_DEPS=
if [ "$WANT_COMPOSITE" != 'n' ]; then
   COMP_CONF_ARG="--enable-composite"
   COMP_IPK_DEPS="libxcomposite1, libxfixes0, libxdamage0,"
fi

NLS_CONF_ARG=
if [ "$WANT_NLS" != 'n' ]; then
   NLS_CONF_ARG="--enable-nls"
fi

DNOTIFY_CONF_ARG=
if [ "$WANT_DNOTIFY" != 'n' ]; then
   DNOTIFY_CONF_ARG="--enable-dnotify"
fi

MSG_CONF_ARG=
if [ "$WANT_MSG_WINS" != 'n' ]; then
   MSG_CONF_ARG="--enable-message-wins"
fi

FOLDERS_CONF_ARG=
if [ "$WANT_PDA_FOLDERS" != 'n' ]; then
   FOLDERS_CONF_ARG="--enable-pda-folders"
fi

ICONS_CONF_ARG=
if [ "$WANT_PDA_ICONS" != 'n' ]; then
   ICONS_CONF_ARG="--enable-small-icons"
fi

if [ "$BUILD_CVS" = 'y' ]; then
  echo "Getting matchbox source via CVS..."
  echo
  echo "   # ENTER 'anoncvs' AND PRESS [enter]"
  cvs -d :pserver:anoncvs@cvs.handhelds.org:/cvs login
  cvs -d :pserver:anoncvs@cvs.handhelds.org:/cvs co apps/matchbox

  SRC_PREFIX="apps/matchbox/"

  # dont need versions..
  
  MBLIB_V=""
  MBCMN_V=""
  MBWM_V=""
  MBPANEL_V=""
  MBDSKTP_V=""
  SEP=""

else

  # download releases

  wget "${SRC_URL}${MBLIB}/${MBLIB_V}/${MBLIB}-${MBLIB_V}.tar.gz" || exit
  tar xvzf ${MBLIB}-${MBLIB_V}.tar.gz

  wget "${SRC_URL}${MBPANEL}/${MBPANEL_V}/${MBPANEL}-${MBPANEL_V}${MBPANEL_MV}.tar.gz" || exit
  tar xvzf ${MBPANEL}-${MBPANEL_V}${MBPANEL_MV}.tar.gz

  wget "${SRC_URL}${MBWM}/${MBWM_V}/${MBWM}-${MBWM_V}${MBWM_MV}.tar.gz" || exit
  tar xvzf ${MBWM}-${MBWM_V}${MBWM_V}.tar.gz

  wget "${SRC_URL}${MBCMN}/${MBCMN_V}/${MBCMN}-${MBCMN_V}${MBCMN_MV}.tar.gz" || exit
  tar xvzf ${MBCMN}-${MBCMN_V}${MBCMN_MV}.tar.gz

  wget "${SRC_URL}${MBDSKTP}/${MBDSKTP_V}/${MBDSKTP}-${MBDSKTP_V}${MBDSKTP_MV}.tar.gz" || exit
  tar xvzf ${MBDSKTP}-${MBDSKTP_V}${MBDSKTP_MV}.tar.gz

  SRC_PREFIX=

fi

# XXX download xsettings

#mv apps/matchbox .
#rm -fr apps

build_source()
{
   sdir=$1
   extra=$2
   ipk_raw=$3	

   ## strip the trailing ',' 
   if [ -z "$ipk_raw" ]; then
      ipk_deps=""
   else
      ipk_deps=${ipk_raw:0:(${#ipk_raw})-1}
      echo "ipkg deps are $ipk_deps"
   fi

   if [ ! -x ${sdir} ]; then
      echo "Unable to cd to ${sdir}"
      exit
   fi
   pushd $sdir

   if [ "$BUILD_CVS" = 'y' ]; then	
      ./autogen.sh --prefix=$DEST $2 || exit
   else
      ./configure --prefix=$DEST $2 || exit
   fi

   make  || exit
   $SUDO make install || exit

   if [ "$BUILD_IPKS" = 'y' ]; then
      INTERACTIVE='n' DEPS="${ipk_deps}" MAINTAINER="${EMAIL_ADDRESS}" SOURCE='http://matchbox.handhelds.org' autoipkg || exit
   fi 

   popd
}

export PKG_CONFIG_PATH="${DEST}/lib/pkgconfig:$PKG_CONFIG_PATH"

#
# Lots of env vars are needed here to pass options of to autoipkg
# for created ipkg as well as workround various ipkg problems and
# naming issues :(
# Fortunatly you can ignore most of em if not building ipks
#
# build_source <src location> <configure args> <ipkg deps>
#
# really need to clean this up 
#

# messy epoc damn ipkg problems means we need versions as 1:0.8 ...  
export EPOCH='1:'

## Matchbox lib ##

if [ ! -z "$MBLIB" ]; then

export PACKAGE="libmb1" # hack for correct ipk name
export CONFIGURE_ARGS="$PNG_CONF_ARG $XFT_CONF_ARG $PANGO_CONF_ARG $JPEG_CONF_ARG $XSET_CONF_ARG $DEBUG_CONF_ARG" 

# xxx also need to up version
build_source "${SRC_PREFIX}${MBLIB}${SEP}${MBLIB_V}" \
	     "$CONFIGURE_ARGS" \
	     "xlibs,${PNG_IPK_DEPS}${XFT_IPK_DEPS}${PANGO_IPK_DEPS}${JPEG_IPK_DEPS}${XSET_IPK_DEPS}" 
unset PACKAGE
unset CONFIGURE_ARGS

fi

### Matchbox Common ###

if [ ! -z "$MBCMN" ]; then

export CONFIGURE_ARGS="$DEBUG_CONF_ARG $FOLDERS_CONF_ARG" 
build_source "${SRC_PREFIX}${MBCMN}${SEP}${MBCMN_V}${MBCMN_MV}" \
	     "$CONFIGURE_ARGS"
unset CONFIGURE_ARGS

fi

### Matchbox-window-manager ###

if [ ! -z "$MBWM" ]; then

export CONFIGURE_ARGS="$DEBUG_CONF_ARG $COMP_CONF_ARG $EXPAT_CONF_ARG $MSG_CONF_ARG $SN_CONF_ARG $GCONF_CONF_ARG" 

export PACKAGE="matchbox-wm" # hack for correct ipk name
export POSTINST="postinst"
cat <<STOP  > "${SRC_PREFIX}${MBWM}${SEP}${MBWM_V}${MBWM_MV}/postinst"
update-alternatives --install /usr/bin/x-window-manager x-window-manager /usr/bin/matchbox-session 10010
STOP
chmod a+x ."${SRC_PREFIX}${MBWM}${SEP}${MBWM_V}${MBWM_MV}/postinst"
build_source "${SRC_PREFIX}${MBWM}${SEP}${MBWM_V}${MBWM_MV}" \
	     "$CONFIGURE_ARGS" \
	     "xlibs,libmb1,${SN_IPK_DEPS}${EXPAT_IPK_DEPS}${COMP_IPK_DEPS}" 
unset CONFIGURE_ARGS
unset PACKAGE
unset POSTINST

fi


## matchbox panel ##

if [ ! -z "$MBPANEL" ]; then

export CONFIGURE_ARGS="$DEBUG_CONF_ARG $NLS_CONF_ARG $ICONS_CONF_ARG $SN_CONF_ARG $DNOTIFY_CONF_ARG" 

build_source "${SRC_PREFIX}${MBPANEL}${SEP}${MBPANEL_V}${MBPANEL_MV}" \
	     "$CONFIGURE_ARGS" \
	     "xlibs,libmb1,matchbox-common,${SN_IPK_DEPS}" 
unset CONFIGURE_ARGS

fi


## matchbox desktop ##

if [ ! -z "$MBDSKTP" ]; then

export CONFIGURE_ARGS="$DEBUG_CONF_ARG $SN_CONF_ARG $DNOTIFY_CONF_ARG" 

build_source "${SRC_PREFIX}${MBDSKTP}${SEP}${MBDSKTP_V}${MBDSKTP_MV}" \
	     "$CONFIGURE_ARGS" \
	     "xlibs,libmb1,matchbox-common,${SN_IPK_DEPS}" 
unset CONFIGURE_ARGS

fi

