#!/bin/sh
#set -x

prog_pid=$$
sleep_time=30

bindir=`echo $0 | sed 's![^/]*$!!'`
old=`pwd`
cd $bindir
bindir=`pwd`
cd $old || fatal "Could not return to orignal dir >$old<"

. $bindir/reflash-utils.sh

progname=`basename $0`

using_rz=
#
# this name must match what is in the cat-pipe shell script.
#
. $bindir/wrdir-def.h

origIFS="$IFS"
NOISY='echo'
NOISY2='emsg'
mytty=''
rz_log_file=

ok_procs='
init
\[keventd]
\[kswapd]
\[kreclaimd]
\[bdflush]
\[kupdated]
\[mtdblockd]
\[jffs2_gcd_mtd4]
/sbin/cardmgr
/sbin/pump
\[rpciod]
'
#
# parsess options...
#
while [ -n "$*" ]
do
    case "$1" in
	-rzlog)
	    rz_log_file=$2
	    shift
	    ;;
	-wrdir)
	    wrdir=$2
	    shift
	    ;;
	-rz)
	    using_rz=y
	    ;;
	*)
	    fatal "Unsupported option >$1<"
	    ;;
    esac
    shift
done

data_pipe="$wrdir/re-data-pipe"
cmd_pipe="$wrdir/re-cmd-pipe"
rz_cmd="$wrdir/cat-pipe"

[ -z "$rz_log_file" ] && rz_log_file=$wrdir/rz.log

arch=`uname -m`
case $arch in
    *86)
	# for testing on x86
	KILL=echo
	MOUNT=echo
	INSMOD=echo
	;;
    arm*)
	KILL=kill
	MOUNT=mount
	INSMOD=insmod
	;;
    *)
	fatal "Unknown arch >$arch<"
	;;
esac

ok_proc_pat=''
sep=''
for p in $ok_procs
do
    ok_proc_pat="$ok_proc_pat$sep$p"
    sep='|'
done
# echo "ok_pat>$ok_proc_pat<"

get_proc_list()
{
    proc_list=''
    sep=''
    raw_list=`ps augxwwh`

    IFS='
'
    for psline in $raw_list
    do
	IFS="$origIFS"
	set -- $psline
	#echo "*>$*<"
	#echo "1>$1<"
	#echo "2>$2<"
	pid=$2
	tty=$7
	shift
	shift
	name=$9
	proc_list="$proc_list$sep$pid $name $tty"
	sep='`'
    done

    echo "$proc_list"
}

bad_pids()
{
    pidlist=''
    proc_list=`get_proc_list`
    IFS='`'
    #echo "proc_list>$proc_list<"
    case "$1" in
	"-q")
	    eko=:
	    ;;
	*)
	    eko=emsg
    esac

    for l in $proc_list
    do
	IFS=$origIFS
	set -- $l
	pid=$1
	name=$2
	tty=$3
	if [ "$tty" = "$mytty" ]
	then
	    $eko "OK(tty) $name"
	elif echo "$name" | egrep -e "$ok_proc_pat" >/dev/null
	then
	    $eko "OK      $name"
	else
	    $eko "KILL $signal   $name"
	    pidlist="$pidlist $pid"
	fi
    done

    echo "$pidlist"
}

kill_procs()
{
    signal=$1
    ret=0

    pids=`bad_pids`
    [ -z "$pids" ] || {
	echo "cmd>$KILL $signal $pids<"
	$KILL $signal $pids
    }

    pids=`bad_pids -q`
    [ -z "$pids" ] && return 0
    return 1
}

mytty=`get_my_tty $prog_pid`
[ x"$mytty" = "x" ] && {
    echo 1>&2 "Could not find this console's tty"
    exit 1
}
# DEBUG "mytty>$mytty<"

echo 'Killing procs nicely (-TERM)...'
kill_procs || {
    echo "sleeping $sleep_time sec to let procs die..."
    sleep $sleep_time

    echo 'Killing procs rudely (-KILL)...'
    kill_procs -KILL || {
	emsg "Some procs would not die.  "
	emsg "  Enter ``ok'' if you wish to continue."
	emsg "  Any other response will cause an exit."
	emsg "  You can kill the procs and restart."
	emsg -n "Response> "
	read ans
	case $ans in
	    [oO][kK])
		;;
	    *)
		exit 2
		;;
	esac
    }
}

if [ "$using_rz" = "y" ]
then
    mkdir -p $wrdir || fatal "Cannot make working dir >$wrdir<"

    #
    # All of this works *much* better *before* we make the file systems RO
    #
    
    # create the file to cat rz data to our data pipe
    echo "Create cat-pipe shell script..."
    [ -f "$rz_cmd" ] && {
	rm $rz_cmd || fatal "Could not rm $rz_cmd"
    }

    cat > $rz_cmd <<EOF
#!/bin/sh

logfile="${rz_log_file:-/dev/null}"

echo '-----' >> \$logfile
date         >> \$logfile
filename=\$1
echo "filename>\$filename<" >> \$logfile

okname=\`cat $cmd_pipe\`
echo "okname>\$okname<" >> \$logfile
if [ "\$okname" = "*" -o "\$okname" = "\$filename" ]
then
    echo "catting..." >> \$logfile
    cat > $data_pipe
    echo "...catted" >> \$logfile
    echo "+OK" > $cmd_pipe
else
    echo "Bad filename >\$filename<, expecting >\$okname<" >> \$logfile
    # let the driving program get an eof.
    echo "ackppphhhtttt!" > $data_pipe
    echo 1>&2 "Bad filename >\$filename<, expecting >\$okname<"
    echo "-BADNAME" > $cmd_pipe
    exit 22
fi
exit 0
EOF

    chmod +x $rz_cmd || fatal "Couldn't chmod +x $rz_cmd"
    ls -l $rz_cmd
    echo ''

    rz_bin=/bin/rz
    rz_link="$wrdir/rzcat-pipe"
    echo ''
    echo 'Ensure existence of symlink to rz...'
    [ -L $rz_link ] || {
	echo "Making link to rz for download..."
	ln -s $rz_bin $rz_link || {
	    emsg "Could not create link from $rz_link to $rz_bin"
	    exit 1
	}
    }
    ls -l $rz_link
    echo

    echo ''
    echo 'Ensure existence of named pipes...'
    for p in $data_pipe $cmd_pipe
    do
	[ -p $p ] || {
	    echo "Making pipe node $p"
	    mknod $p p || {
		emsg "Could not create named pipe file ''$p''"
		exit 1
	    }
	}
	ls -l $p
    done
    echo ''
fi

echo ''
echo 'Remount mtd devs READONLY...'

# list all mounts
# remount all mtdblock users RO
mount_list=`mount | fgrep mtdblock`
IFS='
'
for m in $mount_list
do
    IFS="$origIFS"
    set -- $m
    dev=$1
    mp=$3
    case $dev in
    *mtdblock*) 
	echo "mount -oremount,ro $mp"
	$MOUNT -oremount,ro $mp || {
	    echo 1>&2 "Remount in RO mode failed for dev $dev on $mp"
	    exit 1
	}
	;;
    *)
	emsg "Unrecognized line from mount>$m<"
	exit 1
	;;
    esac
done

kmod='reflash-mod'
echo ''
echo "Making sure $kmod is loaded..."

if lsmod | grep "^$kmod" >/dev/null
then
    echo "$kmod is already loaded."
else
    echo "loading $kmod..."
    $INSMOD $bindir/$kmod.o || fatal "Cannot load $kmod.o"
fi

exit 0
