#!/bin/sh
#set -x

bindir=`echo $0 | sed 's![^/]*$!!'`
old=`pwd`
cd $bindir
bindir=`pwd`
cd $old || fatal "Could not return to orignal dir >$old<"

PATH="$bindir:$PATH"
. $bindir/reflash-utils.sh

progname=`basename $0`
default_wince_image_files="flash_00000000.bin flash_00400000.bin flash_00800000.bin flash_00c00000.bin"
image_dir=.

option_help=`cat <<EOF
Options:

-d        Directory where image files reside [default: $image_dir]
-n        Do not actually change flash, just show what would be done.
-B        Bad image sizes are OK (Use with CAUTION!)
-z        Get files with zmodem (run rewince-z.sh)
-R        Do not reboot after successful reflashing.
-k        Do not kill processes.
EOF
`
usage_msg2=`cat <<EOF
$progname [-options] [4-wince-image-file|1-concatenated-wince-image]

No arguments are necessary if you just wish to restore wince using
the default binary image files that were created with the 
OSLoader's Tools->Flash->Save command.

These files are named:
$default_wince_image_files


If desired you may specify the file names yourself.
You must specify either the names of all four of the image files 
(IN ORDER of increasing address)
or
you may specify the name of a single file that is the concatenation 
of all of the image files.

$option_help

EOF
`
usage_msg=`cat <<EOF
$progname [-options]

No arguments are necessary to restore wince using
the default binary image files that were created with the 
OSLoader's Tools->Flash->Save command:
$default_wince_image_files

$option_help

EOF
`
exe=`getexe`
just_show='-P-'
y_opt=
override_allow_file_names=
pre_opts=
R_opt=

while [ -n "$*" ]
do
    case $1 in
	-o) 
	    opt=`echo $2 | sed 's/,/ /g'`
	    pre_opts="$pre_opts $opt"
	    shift
	    ;;
	-d) image_dir=$2
	    shift
	    ;;
	-z)
	    shift
	    exec "$bindir/rewince-z.sh" "$@"
	    ;;
	-n)
	    just_show='-x'	# exit before executing queue
	    ;;
	-B)
	    bad_size_ok=y
	    ;;
	-doit)
	    just_show='-P-'
	    ;;
	-y)
	    y_opt='-y'
	    ;;
	-yogi)
	    override_allow_file_names=y
	    usage_msg="$usage_msg2"
	    ;;
	-h|-help|--help)
	    usage
	    ;;
	-R)
	    R_opt='-R'
	    ;;
	-k)
	    no_kill_I="-k"
	    ;;
	-kmod)
	    kmod_opt="-kmod $2"
	    shift
	    ;;
	-*)
	    emsg "Unknown option >$1<"
	    usage
	    ;;
	*)
	    break
	    ;;
    esac
    shift
done

if [ $# = 0 ]
then
    set -- $default_wince_image_files
    emsg "Using default flash image names"
else
    [ "$override_allow_file_names" = 'y' ] || {
	fatal "No arguments allowed.  Flash save files must be named:
$default_wince_image_files."
    }

    if [ "$#" != "4" ]
    then
	emsg "Wrong number of arguments."
	usage
	exit 1
    fi
fi

for f in $*
do
    files="$files $image_dir/$f"
done

#echo "files>$files<"

verify_image_files $files

arch=`uname -m`
case $arch in
    arm*)
	prep $no_kill_I $kmod_opt
	;;
esac

cat $files | $exe $y_opt $pre_opts $R_opt -o 0 -i - -c $bindir/rewince.ref $just_show

