#!/bin/sh
#set -x

bindir=`echo $0 | sed 's![^/]*$!!'`
old=`pwd`
cd $bindir
bindir=`pwd`
cd $old || fatal "Could not return to orignal dir >$old<"

. $bindir/reflash-utils.sh
. $bindir/reflash-defs.h

PATH="$bindir:$PATH"

just_show="-P-"

progname=`basename $0`
bindir=`dirname $0`
exe=`getexe`
wrdiropt=
f_opt=
y_opt=
wrdir=

b_off=0x000000
b_len=1s
b_args="-O0 -o \$b_off -u \$b_len -e \$b_len -i \$bfile -wl"
b_prompt_rz='-m "" -m "Please send bootdlr file" -m ""'
b_prompt=

p_off=0x040000
p_len=1s
p_args="-o \$p_off -e \$p_len -i \$pfile -wl"
p_prompt_rz='-m "" -m "Please send params/parts file" -m ""'
p_prompt=

k_off=0x080000
k_len=0x0c0000
k_args="-o \$k_off -e \$k_len -i \$kfile -wl"
k_prompt_rz='-m "" -m "Please send kernel file" -m ""'
k_prompt=

j_off=0x140000
j_len="\$REST_OF_FLASH"
j_args="-o \$j_off -e \$j_len -i \$jfile -wl"
j_prompt_rz='-m "" -m "Please send jffs file" -m ""'
j_prompt=

usage_msg=`cat <<EOF
$progname [-b <file>] [-k <file>] [-j <file>] [-other-options]

Upgrade the specified components.
You must separate the option character from its argument with a space.

The options are:

Option        Region       reflash commands
--------- ---------------  ----------------
-b <file> --> bootldr -->  $b_args
-p <file> --> params  -->  $p_args
-k <file> --> kernel  -->  $k_args
-j <file> --> jff2 fs -->  $j_args

<file> is the name of the file you wish to program into
the indicated region.  If file == "@rz" then the file
will be downloaded with zmodem.  Use your terminal
program's zmodem command to transfer the file.

Other options: 

-bo --> change bootldr offset
-bl --> change bootldr len
-po --> change params offset
-pl --> change params len
-ko --> change kernel offset
-kl --> change kernel len
-jo --> change jffs2 fs offset
-jl --> change jffs2 fs len


defaults:
b_off == $b_off; b_len == $b_len
p_off == $p_off; p_len == $p_len
k_off == $k_off; k_len == $k_len
j_off == $j_off; j_len == $j_len

Note: rz is smart enough to understand 
both Y and Z modem protocols.

EOF
`

argv=$*

[ "$#" = "0" ] && usage
reflash_args="-E0"
b_add=
p_add=
k_add=
j_add=

b_done=
p_done=
k_done=
j_done=
meg32=
j_len_set=
y_opt=
rz_opt=

# check for any rz files in argses...
if echo "$*" | egrep '@rz' >/dev/null
then
    rz_opt="-rz"
    . $bindir/wrdir-def.h
fi

# echo "args>$*<"
while [ -n "$*" ]
do
    # echo "\$1>$1<"
    case $1 in
    -b)
	[ -z "$b_done" ] || fatal "$1 option already specified."
	[ -z "$2" ] && fatal "Argument required for $1 option"
	bfile=$2
	b_add="$b_args"
	b_done=y
	case "$bfile" in
	*@rz*)
	    b_add="$b_prompt_rz $b_add"
	    ;;
	esac
	shift
	;;
    -bo|-ob)
	b_off=$2
	shift
	;;
    -bl|-lb)
	b_len=$2
	shift
	;;
    -p)
	[ -z "$p_done" ] || fatal "$1 option already specified."
	[ -z "$2" ] && fatal "Argument required for $1 option"
	pfile=$2
	p_add="$p_args"
	p_done=y
	case "$pfile" in
	*@rz*)
	    p_add="$p_prompt_rz $p_add"
	    ;;
	esac
	shift
	;;
    -po|-op)
	p_off=$2
	shift
	;;
    -pl|-lp)
	p_len=$2
	shift
	;;
    -k)
	[ -z "$k_done" ] || fatal "$1 option already specified."
	[ "$2" = "" ] && fatal "Argument required for $1 option"
	kfile=$2
	k_add="$k_args"
	k_done=y
	case "$kfile" in
	*@rz*)
	    k_add="$k_prompt_rz $k_add"
	    ;;
	esac
	shift
	;;
    -ko|-ok)
	k_off=$2
	shift
	;;
    -kl|-lk)
	k_len=$2
	shift
	;;
    -j)
	[ -z "$j_done" ] || fatal "$1 option already specified."
    	[ "$2" = "" ] && fatal "Argument required for $1 option"
	jfile=$2
	j_add="$j_args"
	j_done=y
	case "$jfile" in
	*@rz*)
	    j_add="$j_prompt_rz $j_add"
	    ;;
	esac
	shift
	;;
    -jo|-oj)
	j_off=$2
	shift
	;;
    -jl|-lj)
	j_len=$2
	j_len_set=y
	shift
	;;
    -n)
	just_show="-x"
	;;

    -y)
	y_opt='-y'
	;;

    -doit)
	just_show="-P-"
	;;
    -wrdir)
	wrdir=$2
	wrdiropt="-wrdir $2"
	f_opt="-F $2"
	shift
	;;
    -h|-help|--help)
	usage
	;;
    *)
	fatal "Unrecognized argument >$1<"
	;;
    esac
    shift
done

[ -n "$wrdir" ] && PATH="$wrdir:$PATH"

reflash_args="$reflash_args $y_opt $p_add $k_add $j_add $b_add"
#echo "reflash_args, before>$reflash_args<"

#
# get the values of our vars
#
eval j_len=\"$j_len\"
eval 'reflash_args="$reflash_args"'
#echo "reflash_args>$reflash_args<"

arch=`uname -m`
case $arch in
    arm*)
	prep $rz_opt $wrdiropt
	;;
esac
eval exec $exe $f_opt $reflash_args -q $just_show
