#ifndef __STROKE_H__
#define __STROKE_H__

/*
   libstroke - an X11 stroke interface library
   Copyright (c) 1996,1997,1998,1999  Mark F. Willey, ETLA Technical

   See the files COPYRIGHT and LICENSE for distribution information.
*/

/* largest number of points allowed to be sampled */
#define MAX_POINTS 10000

/* maximum number of numbers in stroke */
#define MAX_SEQUENCE 20

/* threshold of size of smaller axis needed for it to define its own bin size
*/
#define SCALE_RATIO 4

/* minimum percentage of points in bin needed to add to sequence */
#define BIN_COUNT_PERCENT 0.05

/* translate stroke to sequence */
int stroke_trans (char *sequence);

/* record point in stroke */
void stroke_record (int x, int y); 

/* initialize stroke functions */
#ifdef MOUSE_DROPPINGS
#include <X11/Xlib.h>
void stroke_init (Display *display, Window window);
#else
void stroke_init (void);
#endif

/* structure for holding point data */
typedef struct s_point *p_point;

struct s_point {
  int x;
  int y;
  p_point next;
} point;

/* point list head and tail */
extern p_point point_list_head;
extern p_point point_list_tail;

#endif
