/* include_stack.h -- simple stack to help the lexer include files

   Copyright 2001 Carl Worth

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "include_stack.h"

include_stack_t *include_stack_pop(include_stack_t *stack);

int include_stack_init(include_stack_t *stack, char *filename)
{
    stack->filename = strdup(filename);

    stack->line_num = 0;
    stack->priv = NULL;
    stack->prev = NULL;

    stack->file = fopen(filename, "r");
    if (stack->file == NULL) {
	fprintf(stderr, "%s: failed to open file %s: %s\n",
		__FUNCTION__, filename, strerror(errno));
	return EINVAL;
    }

    return 0;
}

