/*
 * $Id: MinScr.c,v 1.1 2001/01/23 19:58:47 cworth Exp $
 *
 * Copyright  1999 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/xpm.h>
#include <X11/extensions/XTest.h>
#include "stroke_rec.h"

#include "MinScrP.h"

static XtResource resources[] = {
#define offset(field) XtOffsetOf(MinScrRec, minscr.field)
    { 
        XtNforeground, 
        XtCForeground, 
        XtRPixel, 
        sizeof (unsigned long),
	offset (foreground), 
        XtRString, 
        XtDefaultForeground 
    },
    { 
        XtNthickness, 
        XtCThickness, 
        XtRDimension, 
        sizeof (Dimension),
	offset (thickness), 
        XtRImmediate, (XtPointer) 3 
    },
#undef offset
};

static void	Initialize(), Destroy (), Redisplay ();
static Boolean	SetValues ();

static char defaultTranslations[] = {
    "<BtnDown>: strokeStart()\n"
    "<BtnMotion>: strokeMove()\n"
    "<BtnUp>: strokeEnd()"
};

static void ActionStart ();
static void ActionMove ();
static void ActionEnd ();

static void
Recognize (MinScrWidget w);
    
static XtActionsRec actions[] = {
    { "strokeStart", ActionStart },
    { "strokeMove", ActionMove },
    { "strokeEnd", ActionEnd }
};

MinScrClassRec minscrClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"MinScr",
    /* widget_size		*/	sizeof(MinScrRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	FALSE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* simple fields */
    /* empty			*/	0
  },
  { /* minscr fields */
    /* empty			*/	0
  }
};

WidgetClass minscrWidgetClass = (WidgetClass)&minscrClassRec;

static void
ResetStroke (MinScrWidget w)
{
    int count = 0;
    int npt = w->minscr.num_pts - 2;

    /* get this done later.. still in progress */
    w->minscr.num_pts = 0;

    if(npt >= 0) {
    XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)), 
            w->minscr.foregroundGC, 
            w->minscr.pt, 2, CoordModeOrigin);
    }

    while(count < npt) { 
        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)), 
                w->minscr.foregroundGC, 
                w->minscr.pt + count, 2, CoordModeOrigin);

        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)), 
                w->minscr.foregroundGC, 
                w->minscr.pt + count++, 3, CoordModeOrigin); 
    }

#if 0
    if (XtIsRealized ((Widget) w))
	XClearArea (XtDisplay ((Widget) w), DefaultRootWindow(XtDisplay(w)), 
                0, 0, 0, 0, False);
                */
#endif
}

static void
DisplayStroke (MinScrWidget w)
{
    int count = 0;
    int npt = w->minscr.num_pts;

    if(npt > 0) {
    XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)),
            w->minscr.foregroundGC, w->minscr.pt, 2, CoordModeOrigin);
    }

    while(count < npt) {
        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)),
                w->minscr.foregroundGC, 
                w->minscr.pt + count, 2, CoordModeOrigin);

        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay(w)),
                w->minscr.foregroundGC, 
                w->minscr.pt + count++, 3, CoordModeOrigin);
    }
#if 0
    XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay (w)), 
            w->minscr.foregroundGC,
            w->minscr.pt,
            w->minscr.num_pts,
            CoordModeOrigin);
#endif
}

static void
DisplayLast (MinScrWidget w)
{
    if (w->minscr.num_pts > 2) {
        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay (w)),
                w->minscr.foregroundGC, 
                w->minscr.pt + w->minscr.num_pts - 3, 2, CoordModeOrigin);
        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay (w)),
                w->minscr.foregroundGC, 
                w->minscr.pt + w->minscr.num_pts - 3, 3, CoordModeOrigin);
    } else {
        /* only two points, just draw it */
        XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay (w)),
                w->minscr.foregroundGC, 
                w->minscr.pt, w->minscr.num_pts, CoordModeOrigin);
    }

#if 0 
    npt = w->minscr.num_pts;
    if (npt > 2)
	npt = 2;
    XDrawLines (XtDisplay (w), DefaultRootWindow(XtDisplay (w)), 
            w->minscr.foregroundGC,
            w->minscr.pt + (w->minscr.num_pts - npt),
            npt,
            CoordModeOrigin);
#endif
}

static void
AddPoint (MinScrWidget    w,
	  int		    x,
	  int		    y)
{
    XPoint	*pt;
    int		ppasize;
    
    if (w->minscr.num_pts == w->minscr.ppasize)
    {
	ppasize = w->minscr.ppasize + 100;
	pt = (XPoint *) malloc (sizeof (XPoint) * ppasize);
	if (!pt)
	    return;
	memcpy (pt, w->minscr.pt,
		w->minscr.ppasize * sizeof (XPoint));
	free (w->minscr.pt);
	w->minscr.pt = pt;
	w->minscr.ppasize = ppasize;
    }
    
    pt = &w->minscr.pt[w->minscr.num_pts];
    pt->x = x;
    pt->y = y;
    
    w->minscr.num_pts++;
    
    DisplayLast (w);
}

static void
GetGC (MinScrWidget	w)
{
    XGCValues		gcv;
    
    gcv.foreground = w->minscr.foreground;
    gcv.function = GXorReverse;
    gcv.subwindow_mode = IncludeInferiors;
    gcv.line_width = w->minscr.thickness;
    gcv.join_style = JoinRound;
    gcv.cap_style = CapRound;
    w->minscr.foregroundGC = XCreateGC(XtDisplay(w),
                                DefaultRootWindow(XtDisplay(w)),
                                GCForeground|
                                GCFunction|
                                GCSubwindowMode|
                                GCLineWidth|
                                GCJoinStyle|
                                GCCapStyle,
                                &gcv);
    w->minscr.pixmapGC = XCreateGC(XtDisplay(w),
                                DefaultRootWindow(XtDisplay(w)),
                                GCForeground,
                                &gcv);
}

static void
Initialize (greq, gw)
    Widget  greq, gw;
{
    MinScrWidget	req = (MinScrWidget) greq,
			new = (MinScrWidget) gw;
    KeySym* table_pointer;
    int min_key_code;
    int max_key_code;
    int keysyms_per_keycode;
    Pixmap image_buff;
    char skinpath[128];
    char *homedir;
    int usingDefault;

    fprintf(stderr, "Initializing ");
    fflush(stderr);

    /* initialize recogniser */
    /* need to pass the keysym - keycode mapping as well
     * TABLE MUST NOT BE CHANGED */
    XDisplayKeycodes(XtDisplay(new), &min_key_code, &max_key_code);
    fprintf(stderr, ".");fflush(stderr);
    table_pointer = XGetKeyboardMapping(XtDisplay(new),
            min_key_code, (max_key_code - min_key_code) + 1,
            &keysyms_per_keycode);
    fprintf(stderr, ".");fflush(stderr);
    XDisplayKeycodes(XtDisplay(new), &min_key_code, &max_key_code);
    fprintf(stderr, ".");fflush(stderr);
    new->minscr.graf = rec_alloc();
    fprintf(stderr, ".");fflush(stderr);
    rec_load_configuration(new->minscr.graf, "recrc",
            table_pointer, min_key_code, max_key_code, keysyms_per_keycode);
    fprintf(stderr, ".");fflush(stderr);

    GetGC (new);
    fprintf(stderr, ".");fflush(stderr);

    if (new->core.width < 1) new->core.width = 73; /* later will need to be 
                                                      more flexible */
    if (new->core.height < 1) new->core.height = 15;

    /* load pixmaps from skin.xpm */
    /* TODO finding of the file will need fixing, change to
     * use .fscribrc/classifiers... ./fscribrc/skin, may
     * need to be resource that is gotten from command line */

     if ( (homedir = (char*)getenv("HOME")) == NULL) {
         strcpy(skinpath, REC_DEFAULT_USER_DIR);
         strcat(skinpath, "/skin.xpm");
         usingDefault = 1;
     } else { 
         strcpy(skinpath, homedir);
         strcat(skinpath, "/");
         strcat(skinpath, CLASSIFIER_DIR);
         strcat(skinpath, "/skin.xpm");
         usingDefault = 0;
     }

    /* passing Default Root Window as drawable.. since XtWindow(new)
     * generates bad drawable (why?) */
    if(XpmReadFileToPixmap(XtDisplay(new), 
                DefaultRootWindow(XtDisplay(new)),
                skinpath,
                &image_buff, /* image return */
                NULL, /* mask return .. may use this in future */
                NULL) /* Attributes... will need if widget size
                        dictated by image sizes */
            ) {
        if(!usingDefault) {
            fprintf(stderr, "Couldn't read custom skin.xpm (%s)\n"
                    "Trying default instead\n", skinpath);
            if(XpmReadFileToPixmap(XtDisplay(new), 
                        DefaultRootWindow(XtDisplay(new)),
                        skinpath,
                        &image_buff, /* image return */
                        NULL, /* mask return .. may use this in future */
                        NULL) /* Attributes... will need if widget size 
                                 dictated by image sizes */
                    ) {

                fprintf(stderr, "Couldn't read default skin.xpm (%s)\n",
                        skinpath);
                exit;
            }
        } else {
            fprintf(stderr, "Couldn't read default skin.xpm (%s)\n", skinpath);
            exit;
        }
    }

    /* copy from image_buff into the relevant pixmaps */
    /* close PM */
    new->minscr.closePM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            13,15, req->core.depth);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.closePM,
                new->minscr.pixmapGC,
                226,0,13,15, /* from where in buff */
                0,0);
    /* move PM */
    new->minscr.movePM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            15,15, 16);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.movePM,
                new->minscr.pixmapGC,
                203,0,15,15, /* from where in buff */
                0,0);
    /* mouse on PM */
    new->minscr.mouseOnPM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            16,15, 16);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.mouseOnPM,
                new->minscr.pixmapGC,
                164,0,16,15, /* from where in buff */
                0,0);
    /* mouse off PM */
    new->minscr.mouseOffPM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            16,15, 16);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.mouseOffPM,
                new->minscr.pixmapGC,
                148,0,16,15, /* from where in buff */
                0,0);
    /* key on PM */
    new->minscr.keyOnPM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            29,15, 16);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.keyOnPM,
                new->minscr.pixmapGC,
                119,0,29,15, /* from where in buff */
                0,0);
    /* key off PM */
    new->minscr.keyOffPM = XCreatePixmap(XtDisplay(new), 
            DefaultRootWindow(XtDisplay(new)),
            29,15, 16);
    XCopyArea(XtDisplay(new), image_buff, new->minscr.keyOffPM,
                new->minscr.pixmapGC,
                90,0,29,15, /* from where in buff */
                0,0);
    fprintf(stderr, ".");fflush(stderr);
   
    new->minscr.ppasize = 0;
    new->minscr.num_pts = 0;
    new->minscr.pt = 0;
    new->minscr.pointer_mode = MS_None;
    new->minscr.recognition_mode = 0;

    fprintf(stderr, ".");fflush(stderr);
    
    ResetStroke (new);
    fprintf(stderr, "Done\n");
}

static void
Destroy (gw)
    Widget  gw;
{
    MinScrWidget  w = (MinScrWidget) gw;

    XtReleaseGC (gw, w->minscr.foregroundGC);
    XtReleaseGC (gw, w->minscr.pixmapGC);
}

static void
DisplayButtons(Widget gw) 
{
    MinScrWidget  w = (MinScrWidget) gw;
    /* show bitmaps */
    XCopyArea(XtDisplay(gw), w->minscr.movePM, XtWindow(gw), 
                w->minscr.pixmapGC,
                0,0,15,15, /* from where in buff */
                0,0);
    XCopyArea(XtDisplay(gw), w->minscr.closePM, XtWindow(gw), 
                w->minscr.pixmapGC,
                0,0,13,15, /* from where in buff */
                60,0);
    /* now, depending on the mode */
    if (w->minscr.recognition_mode) {
        XCopyArea(XtDisplay(gw), w->minscr.keyOnPM, XtWindow(gw), 
                    w->minscr.pixmapGC,
                    0,0,29,15, /* from where in buff */
                    15,0);
        XCopyArea(XtDisplay(gw), w->minscr.mouseOffPM, XtWindow(gw), 
                    w->minscr.pixmapGC,
                    0,0,16,15, /* from where in buff */
                    44,0);
    } else {
        XCopyArea(XtDisplay(gw), w->minscr.keyOffPM, XtWindow(gw), 
                    w->minscr.pixmapGC,
                    0,0,29,15, /* from where in buff */
                    15,0);
        XCopyArea(XtDisplay(gw), w->minscr.mouseOnPM, XtWindow(gw), 
                    w->minscr.pixmapGC,
                    0,0,16,15, /* from where in buff */
                    44,0);
    }
}

static void
Redisplay (gw, event, region)
    Widget  gw;
    XEvent  *event;
    Region  region;
{
    MinScrWidget  w = (MinScrWidget) gw;

    DisplayButtons(gw);

    /* TODO Elaborate this to also do storing and redrawing of pixmaps if 
     * needed */
    DisplayStroke (w);
}

static Boolean
SetValues (gcur, greq, gw)
    Widget  gcur, greq, gw;
{
    MinScrWidget  cur = (MinScrWidget) gcur,
		    req = (MinScrWidget) greq,
		    new = (MinScrWidget) gw;
    Boolean	    redraw = FALSE;

    if (req->minscr.foreground != cur->minscr.foreground ||
	req->minscr.thickness != cur->minscr.thickness)
    {
	XtReleaseGC (gcur, cur->minscr.foregroundGC);
	XtReleaseGC (gcur, cur->minscr.pixmapGC);
	GetGC (new);
	redraw = TRUE;
    }
    return redraw;
}

/* TODO Set up the Action methods to do full screen pointing and
 * backing up of old screen into buffers */
static void
ActionStart (Widget gw, XEvent *event, String *params, Cardinal *num_params)
{
    MinScrWidget  w = (MinScrWidget) gw;
    int x, y;
  
    /* unless starting on a button, should not interfere with
     * how recognition is occuring */
    w->minscr.pointer_mode = MS_None;
    x = event->xbutton.x;
    y = event->xbutton.y;
    w->minscr.xstart = x;
    w->minscr.ystart = y;
    w->minscr.xmin = w->minscr.xmax = event->xbutton.x_root;
    w->minscr.ymin = w->minscr.ymax = event->xbutton.y_root;
    w->minscr.ptstart = event->xbutton.time;
    w->minscr.held = 0;

    if ((event->xbutton.x > 0) &&
        (event->xbutton.y > 0) &&
        (event->xbutton.x < 73) &&
        (event->xbutton.y < 15))
    {
        /* is on the widget.. we set a button mode */
        if((0 < x) && (x < 14)) 
            w->minscr.pointer_mode = MS_MoveIcon;
        if((15 < x) && (x < 43)) 
            w->minscr.pointer_mode = MS_KeyIcon;
        if((44 < x) && (x < 59)) 
            w->minscr.pointer_mode = MS_MouseIcon;
        if((60 < x) && (x < 72)) 
            w->minscr.pointer_mode = MS_CloseIcon;
    } else {
        /* is off the widget.. we release a button mode */
        if(w->minscr.recognition_mode) { 
            XGrabServer(XtDisplay(gw));
            AddPoint (w, event->xbutton.x_root, event->xbutton.y_root);
        }
    }
}

static void
ActionMove (Widget gw, XEvent *event, String *params, Cardinal *num_params)
{
    MinScrWidget  w = (MinScrWidget) gw;
    int x, y;
    int xdiff, ydiff, timediff;
    x = event->xmotion.x_root;
    y = event->xmotion.y_root;

    if(w->minscr.xmin >  x) 
        w->minscr.xmin = x;
    if(w->minscr.xmax <  x) 
        w->minscr.xmax = x;
    if(w->minscr.ymin >  y) 
        w->minscr.ymin = y;
    if(w->minscr.ymax <  y) 
        w->minscr.ymax = y;

    if(!w->minscr.held) {
        xdiff = w->minscr.xmax - w->minscr.xmin;
        ydiff = w->minscr.ymax - w->minscr.ymin;
        timediff = event->xmotion.time - w->minscr.ptstart;

        if((xdiff < 6) && (ydiff < 6) && (timediff > 150)) 
            w->minscr.held = 1;
    } 
        
    /* if didn't start on a button and we are recognizing */
    if((w->minscr.pointer_mode == MS_None) && 
        w->minscr.recognition_mode)
    { 
        AddPoint (w, event->xmotion.x_root, event->xmotion.y_root);
    }
}

extern void MyXMoveWindow(int, int);

static void
ActionEnd (Widget gw, XEvent *event, String *params, Cardinal *num_params)
{
    int x, y, height_range, xr, yr;
    MinScrWidget  w = (MinScrWidget) gw;
    /* Ok, now, the options are,
     *  - started on a button, ignore rec and check if ended on same button
     *  - started off a button, check if rec on */
  
    x = event->xbutton.x;
    y = event->xbutton.y;
    xr = event->xbutton.x_root;
    yr = event->xbutton.y_root;
    height_range = 0;
    if (0 < y < 15) 
        height_range = 1;

    if(w->minscr.xmin >  xr) 
        w->minscr.xmin = xr;
    if(w->minscr.xmax <  xr) 
        w->minscr.xmax = xr;
    if(w->minscr.ymin >  yr) 
        w->minscr.ymin = yr;
    if(w->minscr.ymax <  yr) 
        w->minscr.ymax = yr;
    w->minscr.ptend = event->xbutton.time;

    switch(w->minscr.pointer_mode) 
    {
        case MS_None:
            if (w->minscr.recognition_mode) {
                AddPoint (w, event->xbutton.x_root, event->xbutton.y_root);
                Recognize (w);
                ResetStroke(w);
                XUngrabServer(XtDisplay(gw));
            }
            /* if not rec and didn't start on button, then done */
            break;
        case MS_MoveIcon:
            /* move icon doesn't end where it started */
                MyXMoveWindow(
                        event->xbutton.x - w->minscr.xstart, 
                        event->xbutton.y - w->minscr.ystart);
            break;
        case MS_CloseIcon:
            if(((60 < x) && (x < 72)) && height_range) {
                exit(0); /* this surely can't be right */
            }
            break;
        case MS_MouseIcon:
            if(((44 < x) && (x < 59)) && height_range) {
                /* if recognizing, not now */
                w->minscr.pointer_mode = MS_None;
                w->minscr.recognition_mode = 0;
                XtUngrabPointer(gw, CurrentTime);
                ResetStroke(w);
                DisplayButtons(gw);
                XUngrabServer(XtDisplay(gw));
            }
            break;
        case MS_KeyIcon:
            if(((15 < x) && (x < 43)) && height_range) {
                /* if wasn't recognizing, are now */
                XtGrabPointer(gw, False, 
                    ButtonPressMask | ButtonReleaseMask | ButtonMotionMask,
                    GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
                w->minscr.pointer_mode = MS_None;
                w->minscr.recognition_mode = 1;
                DisplayButtons(gw);
            }
            break;
        default:
            /* invarably means error */
    }
}

/*
static void
Notify (MinScrWidget	w, KeySym keysym)
{
}
*/

/* Assumption, when we get in here, 'w' has a pointer grab */
static void
Recognize (MinScrWidget w)
{
    int xdiff, ydiff, timediff;
    action_list *results;
    action* ta;
    keycode_action_data* kcad;
    Display *dpy = XtDisplay(w);

    if(!w->minscr.graf)
        return;

    /* OK, we want to circumvent recognition if they just did a tap, no hold */
    /* so we check the min, max and times of the button... */

    /* if max-min < 4 then dot, if time < X then dot quick */
    /* TODO add the check above, for now (testing, just assume left click)
     */
    xdiff = w->minscr.xmax - w->minscr.xmin;
    ydiff = w->minscr.ymax - w->minscr.ymin;
    timediff = w->minscr.ptend - w->minscr.ptstart;

    /*
    if (w->minscr.held) {
        if ((xdiff > 5) && (ydiff > 5)) {
            if (xdiff > ydiff) {
                XtUngrabPointer((Widget)w, CurrentTime);
                XTestFakeButtonEvent(dpy, 3, True, CurrentTime);
                XTestFakeButtonEvent(dpy, 3, False, CurrentTime);
                XtGrabPointer((Widget)w, False, 
                        ButtonPressMask | ButtonReleaseMask | ButtonMotionMask,
                        GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
            } else {
                XtUngrabPointer((Widget)w, CurrentTime);
                XTestFakeButtonEvent(dpy, 2, True, CurrentTime);
                XTestFakeButtonEvent(dpy, 2, False, CurrentTime);
                XtGrabPointer((Widget)w, False, 
                        ButtonPressMask | ButtonReleaseMask | ButtonMotionMask,
                        GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
            }
            return;
        }
    }
    */
  
    if((xdiff < 6) && (ydiff < 6) && (timediff < 150)) {
        /* we have a quick, tap */
    
        XtUngrabPointer((Widget)w, CurrentTime);
        XTestFakeButtonEvent(dpy, 1, True, CurrentTime);
        XTestFakeButtonEvent(dpy, 1, False, CurrentTime);
        XtGrabPointer((Widget)w, False, 
                ButtonPressMask | ButtonReleaseMask | ButtonMotionMask,
                GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
    } else {
        /* not a quick tap, send to recognizer */

        /* TODO, change the following to not user call back but to do
         * the work in this widget */
        if((results = rec_recognize_gesture(
					    w->minscr.graf, 
					    w->minscr.pt, 
					    w->minscr.num_pts)) != NULL) 
        {
            /* process the results */
	    int i;
	    for (i=0, ta = results->actions; i < results->num_actions; i++, ta++) {
		if (ta == NULL) {
		    fprintf(stderr, "Error: received null action data from the recognizer.");
		} else {
		    if(ta->type == KEYCODE_ACTION) {
			kcad = ta->data;
			XTestFakeKeyEvent(dpy, kcad->keycode, kcad->press, CurrentTime);
		    }
		}
            }
        }
    }
}
