/*
 * $Id: MinScrP.h,v 1.1 2001/01/23 19:58:47 cworth Exp $
 *
 * Copyright  1999 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _MinScrP_h
#define _MinScrP_h

#include "MinScr.h"
#include "stroke_rec.h"
#include "rec-interface.h"
/* include superclass private header file */
#include <X11/Xaw/SimpleP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRMinScrResource "MinScrResource"

typedef enum _command_mode {
    MS_None,
    MS_MoveIcon,
    MS_CloseIcon,
    MS_MouseIcon,
    MS_KeyIcon
} command_mode;


typedef struct {
    int empty;
} MinScrClassPart;

typedef struct _MinScrClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    MinScrClassPart	minscr_class;
} MinScrClassRec;

extern MinScrClassRec minscrClassRec;

typedef struct {
    /* resources */
    /* line */
    unsigned long   foreground;
    unsigned long   background;
    Dimension	    thickness;

    /* What follows is the Pixmaps for the graphics.  Ideally this would later
     * be replaced with structs for each button, each struct holding the
     * location of the button in the widget, the location of the button on
     * the source xpm, the on and off Pixmaps and perhaps even a mask if 
     * the shape extension is used. These structs would then be placed into an
     * array which would be checked through on click-in-widget and might even
     * have function pointers for the buttons actions */

    /* Graphics/Pixmaps */
    Pixmap          closePM;
    Pixmap          movePM;
    Pixmap          mouseOnPM;
    Pixmap          mouseOffPM;
    Pixmap          keyOnPM;
    Pixmap          keyOffPM;
    /* will add more as needed */
    
    /* private state */
    GC		    foregroundGC;
    GC		    backgroundGC;
    GC		    pixmapGC;
    XPoint	    *pt;	    /* X points */
    int		    ppasize;
    int             num_pts;
    RecInterface    graf;
    command_mode    pointer_mode;
    int             xstart; /* for events like move window */
    int             ystart;
    int             xmin; /* for checking the press and hold */
    int             xmax;
    int             ymin; /* for checking the press and hold */
    int             ymax;
    Time            ptstart; /* for checking the press and hold */
    Time            ptend; /* for checking the press and hold */
    int             held;  /* set in ActionMotion, indicates stroke 
                              started with a 'hold' */
    int             recognition_mode; /* separate... since it overrides above
                                         in some cases */
} MinScrPart;

typedef struct _MinScrRec {
    CorePart		core;
    SimplePart		simple;
    MinScrPart	        minscr;
} MinScrRec;

typedef MinScrRec *MinScrWidget;

#endif /* _MinScrP_h */
