/*
 * $Id: fscrib.c,v 1.1 2001/01/23 19:58:47 cworth Exp $
 *
 * Copyright  1999 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/keysym.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/CommandP.h>
#include <stdio.h>
#include "MinScr.h"
#include "stroke_rec.h"
#include "rec-interface.h"

Widget  toplevel;
Widget  scribble;

/* turn the relative into abs */
void MyXMoveWindow(int x, int y) 
{
    int xs, ys;

    xs = toplevel->core.x;
    ys = toplevel->core.y;
    XMoveWindow(XtDisplay(toplevel), XtWindow(toplevel), xs + x, ys + y);
}

/* ok, now this function could be real bad if two windows use it to 
 * stay on top, as they would generate notify and raise to each other 
 * continously */
static void                        /* ARGSUSED */
KeepOnTopAP(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    if((event->xvisibility.state == VisibilityFullyObscured) ||
            (event->xvisibility.state == VisibilityPartiallyObscured))
    {
        XRaiseWindow(XtDisplay(w), XtWindow(w));
    }
}

static void                        /* ARGSUSED */
CloseAP(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    exit (0);
}

static XtActionsRec actions_table[] = {
    { "close", CloseAP},
    { "visable", KeepOnTopAP},
};

XrmOptionDescRec options[] = {
{"-fg",                "*Foreground",                XrmoptionSepArg,        NULL},
{"-bg",                "*Background",                XrmoptionSepArg,        NULL},
{"-foreground",        "*Foreground",                XrmoptionSepArg,        NULL},
{"-background",        "*Background",                XrmoptionSepArg,        NULL},
{"-thickness",        "*thickness",                XrmoptionSepArg,        NULL},
};

int
main (int argc, char **argv)
{
    Arg                    args[2];
    XtAppContext    app_context;
    Atom            wm_delete_window;

    XtSetArg (args[0], XtNinput, FALSE);
    toplevel = XtAppInitialize (&app_context, "Scribble", 
                                options, XtNumber (options),
                                &argc, argv, 
                                0,
                                args, 1);

//    pane1 = XtCreateManagedWidget ("pane1", panedWidgetClass, 
//            toplevel, args, 1);
    
    XtSetArg (args[0], XtNshowGrip, FALSE);
    //XtSetArg (args[1], XtNlabel, "abc");
 //   state = XtCreateManagedWidget ("state", labelWidgetClass, 
  //          pane1, args, 2);
    
    //XtSetArg (args[0], XtNshowGrip, FALSE);
    //XtSetArg (args[1], XtNlabel, "");

    //symbol = XtCreateManagedWidget ("symbol", labelWidgetClass, 
            //pane1, args, 2);

    scribble = XtCreateManagedWidget ("scribble", minscrWidgetClass,
            toplevel, args, 1);

    XtAppAddActions(app_context, actions_table, 
            XtNumber(actions_table));
    
    XtOverrideTranslations (toplevel,
                            XtParseTranslationTable (
                                "<Message>WM_PROTOCOLS: close()\n"
                                "<Visible>: visable()"));

    XtRealizeWidget (toplevel);
    
    wm_delete_window = XInternAtom(XtDisplay (toplevel), 
            "WM_DELETE_WINDOW", False);
    (void) XSetWMProtocols (XtDisplay (toplevel), XtWindow(toplevel), 
                            &wm_delete_window, 1);

    XtAppMainLoop (app_context);


    /* Should never get here */
    return -1;
}





