#ifndef __REC_INTERFACE_H__
#define __REC_INTERFACE_H__

#include <X11/Intrinsic.h>

typedef enum _action_type {
    KEYSYM_ACTION, 
    KEYCODE_ACTION, 
    MODE_ACTION 
} action_type;

typedef struct _action {
    action_type type;
    void* data; 
} action;
    
typedef struct _action_list {
    char* label;
    int num_actions;
    action *actions;
} action_list;

typedef struct _keysym_action_data {
    KeySym keysym;
    Boolean press;
} keysym_action_data;

typedef struct _keycode_action_data {
    KeyCode keycode;
    Boolean press;
} keycode_action_data;

typedef struct _mode_action_data {
    char *mode_info;
} mode_action_data;

#endif
