/* xmalloc.c -- malloc with error checking

   Copyright (C) 2000 Carl Worth

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/
#include <stdio.h>
#include <stdlib.h>

#include "xmalloc.h"

extern char *progname;

void *xmalloc(size_t size) {
  void *ptr = malloc(size);
  if (! ptr) {
    fprintf(stderr, "%s: memory exhausted\n", progname);
      exit(1);   
  }
  return ptr;
}

void *xcalloc(size_t nmemb, size_t size) {
  void *ptr = calloc(nmemb, size);
  if (! ptr) {
    fprintf(stderr, "%s: memory exhausted\n", progname);
      exit(1);   
  }
  return ptr;
}

void *xrealloc(void *p, size_t size) {
  void *ptr = realloc(p, size);
  if (! ptr) {
    fprintf(stderr, "%s: memory exhausted\n", progname);
      exit(1);   
  }
  return ptr;
}
