/* rec_node.h -- declarations for functions to store a datbase of recognition sequences

   Copyright (C) 2000 Carl Worth

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef REC_NODE_H__
#define REC_NODE_H__

/*
#define DEBUG
*/

#ifdef DEBUG
#define DEBUG_REMEMBER_NODE_DIGITS
#define DEBUG_VERIFY_BRANCH_BOUNDS
#define DEBUG_NODE_CREATION
#define DEBUG_TREE_CREATION
#define DEBUG_TREE_SEARCH
#endif /* DEBUG */

struct rec_node {
#ifdef DEBUG_REMEMBER_NODE_DIGITS
  int digit;
#endif
  struct rec_node **next;
  void *data;
};

/* Error codes */
#define INVALID_SEQUENCE 1

/* Public functions */
struct rec_node *new_rec_tree();
void free_rec_tree(struct rec_node *root);
int add_sequence(struct rec_node *root, char *seq_to_add, void *data, size_t size);
void *lookup_sequence(struct rec_node *root, char *seq);
void print_rec_tree(struct rec_node *root);
void print_node_stats(void);

#endif /* REC_NODE_H__ */
