/*
  xstroke - X based gesture recognition program based on libstroke.
  
  Copyright (C) 2000 Carl Worth
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef STROKE_REC_H__
#define STROKE_REC_H__

#include "rec-interface.h"
#include "stroke.h"

#define REC_DEFAULT_USER_DIR    "/mnt/ramfs/root/.classifiers"
#define CLASSIFIER_DIR          ".classifiers"

typedef struct _RecInterfacePrivate {
  struct rec_node *rec_tree_root;
  char sequence[MAX_SEQUENCE+1];
} RecInterfacePrivate;

typedef RecInterfacePrivate *RecInterface;

RecInterface rec_alloc();

/* This functions purpose is to take the location of a configuration
 * File, and with it load any configurations needed for character
 * recognition. 
 * file_name -- location of primary config file
 * returns 0 on success, non 0 on failure;
 */
int rec_load_configuration(Display *display, RecInterface rec, char *file_name);

action_list *rec_recognize_gesture(RecInterface rec,
				   XPoint* points, int num_points);

void rec_free(RecInterface rec);

#endif
