/*
 * FILE: DataTypes.h
 *
 * DESCRIPTION: These are the common types and definitions.
 *
 * HISTORY:
 *   Nov 15, 2000 Created by Dmitry Kaloshin
 */
#ifndef __DATATYPES_H__
#define __DATATYPES_H__

// Public definitions

#define ELEM_SPIDER_MOVE 3 // Size of the Spider's step (in pixels)

#define MAX_COLS 43 // Playfield length (in CELL_SIZE)
#define MAX_ROWS 28 // Playfield height (in CELL_SIZE)

#define SPIDER_SIZE 7 // Size of square Spider's bitmap
#define KILLER_SIZE 5 // Size of square Killer's bitmap
#define CELL_SIZE 3  // Size of the field's cell

#define MAX_KILLERS 6 // Maximum number of Killers per game

#define GAME_PERIOD 130 // Time allowed to redraw the game

#define SPIDER_LIFES 3 // Spider's lives at the start of the game

// Percentage of field the Spider must
// cut for the Easy level
#define LEVEL_PERCENT 80

// Percentage of field the Spider must
// cut for the Expert level
#define MAX_LEVEL_PERCENT 97

#define CRITICAL_TIME 15000L // Critical time till Spider must cut

#define TRUE 1
#define FALSE 0

typedef enum // Current game status
{
  gsPlay = 0,

  gsKilling = 1,

  gsMenu = 2
}
game_status_type;

// Direction of the Spider's movements on the playfield
// sdLeft + sdRight == sdDown + sdUp == 5
// Use in the function game_process
typedef enum
{
  sdUnknown = 0,

  sdUp = 1,

  sdRight = 2,

  sdDown = 4,

  sdLeft = 3
}
spider_direction_type;

// Direction of the Killer's movements on the playfield
typedef enum
{
  kdLeftUp = 0,

  kdRightUp = 1,

  kdRightDown = 2,

  kdLeftDown = 3
}
killer_direction_type;

// The priority direction along which the Killer should move
typedef enum
{
  kaX_Y = 0, // x:y=1:1

  ka2X_Y = 1, // x:y=2:1

  kaX_2Y = 2  // x:y=1:2
}
killer_angle_type;

// Killer's status on the playfiled
typedef enum
{
  ktActive = 0,

  ktReserve = 1
}
killer_type;

// Type of playfield cell
typedef enum
{
  ctUnknown = 0, // Out of playfield area

  ctActiveBorder = 1, // The Spider's trace on the play field

  ctBorder = 2, // Border

  ctFree = 3, // Spider's territory

  ctBusy = 4, // Killer's territory

  ctNextBorder = 5, // Use to fill the field after a cut

  ctNextBusy = 6 // Use to fill the field after a cut
}
cell_type;

// Struct of  point
typedef struct _PointType
{
  int x;

  int y;
}
PointType;

// Struct of Spider
typedef struct _TSpider
{
  PointType coord; // Spider's coordinates on the playfield (in pixels)

  PointType beginCoord; // Upper left Spider coordinate

  spider_direction_type dir; // Spider's current direction
}
TSpider;

// Struct of Killer
typedef struct _TKiller
{
  PointType coord; // Killer's coordinates on the playfield (in cells)

  killer_direction_type dir; // Killer's current direction

  killer_angle_type angle; // Killer's current angle

  killer_type type; // Killer's current type
}
TKiller;

// Struct of game
typedef struct _TGame
{
  TSpider Spider;

  PointType OriginKiller;

  TKiller Killer[ MAX_KILLERS ];

  // Spider's last coordinate inside
  // the Killer's territory
  PointType LastCoordCell;

  int Lifes; // Current number of Spider's lives

  // Percentage of field that must be cut
  // in the current level
  long PercentLeft;

  long NumCellMustCut; // Number of cells the Spider must cut

  long CurCellOnField; // Current number of cells

  int CurLevel; // Current level

  game_status_type Status; // Current game status

  int Paused; // TRUE - if game paused

  cell_type Field[ MAX_ROWS + 2][ MAX_COLS + 2 ];

  long Score;
}
TGame;

#endif