/*
 * FILE: Spider.c
 *
 * DESCRIPTION:
 *   This module contains routines that describe the Spider's moves.
 *
 * HISTORY:
 *   Nov 15, 2000 Created by Dmitry Kaloshin
 */
#include "Spider.h"
#include "utilsound.h"

int xFieldSize = MAX_COLS * 3 + SPIDER_SIZE; // Field height ( in pixels )
int yFieldSize = MAX_ROWS * 3 + SPIDER_SIZE; // Field width ( in pixels )

/*
 * FUNCTION: spider_move
 *
 * DESCRIPTION: Moves the Spider.
 *
 * PARAMETERS:
 *   pGame     - pointer to a game struct
 *   dir       - direction the Spider should move
 *   coordCell - pointer to struct of previous cell,
 *               to draw the line of the Spider's path
 *
 * RETURNS: the Spider's current position on the field
 */
cell_type spider_move( TGame *pGame, 
  spider_direction_type dir, PointType *coordCell )
{
  PointType new_coord;  // Possible coordinate after a step

  cell_type  CurPosition; // The Spider's current position on the field 

  int i;

  static int move_index_sound = 0;

  new_coord.x = pGame->Spider.coord.x;

  new_coord.y = pGame->Spider.coord.y;

  switch( dir ) // Calculate new coordinate
  {
    case sdUp:

      new_coord.y -= ELEM_SPIDER_MOVE;

      break;

    case sdRight:

      new_coord.x += ELEM_SPIDER_MOVE;

      break;

    case sdDown:

      new_coord.y += ELEM_SPIDER_MOVE;

      break;

    case sdLeft:

      new_coord.x -= ELEM_SPIDER_MOVE;

      break;

    default:
      return pGame->Field[ ( new_coord.y - pGame->Spider.beginCoord.y +
        SPIDER_SIZE / 2 - 1 ) / CELL_SIZE ]
          [ ( new_coord.x - pGame->Spider.beginCoord.x +
            SPIDER_SIZE / 2 - 1 ) / CELL_SIZE ];
  }
  play_sound( SOUND_SPIDER_MOVE_1 + move_index_sound );

  move_index_sound = ( move_index_sound + 1 ) % 2;

  // Is the Spider in or out of the field?
  if( new_coord.x < 0 || new_coord.x > xFieldSize || 
    new_coord.y < 0 || new_coord.y > yFieldSize ) 
  {                                             
     return ctUnknown;
  }
  for( i = 0; i < MAX_KILLERS; i++ )
  {
    if( pGame->Killer[ i ].type == ktActive )
    {
      if( ( new_coord.y - pGame->Spider.beginCoord.y +
        SPIDER_SIZE / 2 - 1 ) / CELL_SIZE == pGame->Killer[ i ].coord.y &&
          ( new_coord.x - pGame->Spider.beginCoord.x +
            SPIDER_SIZE / 2 - 1 ) / CELL_SIZE == pGame->Killer[ i ].coord.x )
      {
        pGame->Status = gsKilling;

        play_sound( SOUND_FLY );

        return ctBusy;
      }         
    }
  }
  CurPosition = pGame->Field[ ( new_coord.y - pGame->Spider.beginCoord.y +
    SPIDER_SIZE / 2 - 1 ) / CELL_SIZE ]
      [ ( new_coord.x - pGame->Spider.beginCoord.x +
        SPIDER_SIZE / 2 - 1 ) / CELL_SIZE ];
  
  // The Spider is moving in on the Killer's area
  if( CurPosition != ctActiveBorder ) 
  {                                    
    pGame->Spider.coord.x = new_coord.x;

    pGame->Spider.coord.y = new_coord.y;

    if( pGame->Field[ pGame->LastCoordCell.y ]
      [ pGame->LastCoordCell.x ] == ctBusy )
    {
      pGame->Field[ pGame->LastCoordCell.y ]
        [ pGame->LastCoordCell.x ] = ctActiveBorder;

      coordCell->x = pGame->LastCoordCell.x;

      coordCell->y = pGame->LastCoordCell.y;
    }   
    pGame->LastCoordCell.y = ( new_coord.y - pGame->Spider.beginCoord.y +
      SPIDER_SIZE / 2 - 1 ) / CELL_SIZE;
 
    pGame->LastCoordCell.x = ( new_coord.x - pGame->Spider.beginCoord.x +
      SPIDER_SIZE / 2 - 1 ) / CELL_SIZE;

    CurPosition = pGame->Field[ pGame->LastCoordCell.y ]
      [ pGame->LastCoordCell.x ];
  }
  else 
  {
    // The Spider crushes himself
    CurPosition = ctBusy;

    pGame->Status = gsKilling;

    play_sound( SOUND_TAIL );
  }
  return CurPosition;
}
