/*
 * FILE: utilanimate.c
 *
 * DESCRIPTION: This module describes routines for working with animations.
 *
 * HISTORY:
 *   Dec 29, 2000 Created by Dmitry Kaloshin
 */
#include "utilanimate.h"

/*
 * FUNCTION: get_next_period
 *
 * DESCRIPTION: Get the remaining time until the next period
 *
 * PARAMETERS:
 *   nextTime - time of next event
 *
 * RETURNS: the amount of time remaining until the nextTime
 */
clock_t get_next_period ( clock_t nextTime )
{
  clock_t timeRemaining;
 
  timeRemaining = nextTime - clock();

  if( timeRemaining <= 0 )
  {
    timeRemaining = 0;
  }
  return timeRemaining;
}
