/*
 * FILE: utilsound.c
 *
 * DESCRIPTION:
 *   This module describes routines for working with music and sound.
 *
 * HISTORY:
 *   Dec 28, 2000 Created by Dmitry Kaloshin
 */
#include "utilsound.h"

// Names of sound files
static const char* sz_sound_files[ NUM_OF_SOUND ] = 
{
  "title.mus",
  "newlevel.mus",
  "stepspider1.mus",
  "stepspider2.mus",
  "tail.mus",
  "fly.mus",
  "end_time.mus",
  "cut.mus"
};

struct MSequence game_sounds[ NUM_OF_SOUND ]; // Sound effects for the game.

/*
 * FUNCTION: load_sound
 *
 * DESCRIPTION: Loads sound effects from the application archive.
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void load_sound( void )
{
  int index;

  for( index = 0; index < NUM_OF_SOUND; index++ )
  {
    MSequence_ctor( game_sounds + index, sz_sound_files[ index ] );
  }
}

/*
 * FUNCTION: release_sound
 *
 * DESCRIPTION: Releases resources allocated for sound effects.
 *
 * PARAMETERS: none 
 *
 * RETURNS: nothing
 */
void release_sound( void )
{
  int index;

  for( index = 0; index < NUM_OF_SOUND; index++ )
  {
    MSequence_dtor( game_sounds + index, LEAVE_MEMORY );
  }
}

/*
 * FUNCTION: play_sound
 *
 * DESCRIPTION: Plays a specified sound effect or melody.
 *
 * PARAMETERS:
 *   sound_id - an index sound in the global array of sounds
 *
 * RETURNS: nothing
 */
void play_sound( int sound_id )
{
  switch( sound_id )
  {
    case SOUND_SPIDER_MOVE_1:
    case SOUND_SPIDER_MOVE_2:
    case SOUND_TAIL:

      MSequence_play( game_sounds + sound_id );

      break;

    default:

      if( !MSequence_is_playing( game_sounds + sound_id ))
      {
        MSequence_play_background( game_sounds + sound_id );    
      }
  }
}
